/*********************************************************************
*                         COPYRIGHT NOTICE                           *
**********************************************************************
*        This software is copyright (C) 1982 by Pavel Curtis         *
*                                                                    *
*        Permission is granted to reproduce and distribute           *
*        this file by any means so long as no fee is charged         *
*        above a nominal handling fee and so long as this            *
*        notice is always included in the copies.                    *
*                                                                    *
*        Other rights are reserved except as explicitly granted      *
*        by written permission of the author.                        *
*                Pavel Curtis                                        *
*                Computer Science Dept.                              *
*                405 Upson Hall                                      *
*                Cornell University                                  *
*                Ithaca, NY 14853                                    *
*                                                                    *
*                Ph- (607) 256-4934                                  *
*                                                                    *
*                Pavel.Cornell@Udel-Relay   (ARPAnet)                *
*                decvax!cornell!pavel       (UUCPnet)                *
*********************************************************************/

/*
**	lib_clreol.c
**
**	The routine wclrtoeol().
**
** $Log:	RCS/lib_clreol.v $
 * Revision 2.1  82/10/25  14:46:42  pavel
 * Added Copyright Notice
 * 
 * Revision 2.0  82/10/24  15:20:38  pavel
 * Beta-one Test Release
 * 
**
*/

static char RCSid[] =
	"$Header:   RCS/lib_clreol.v  Revision 2.1  82/10/25  14:46:42  pavel  Exp$";

#include "curses.h"
#include "curses.priv.h"


wclrtoeol(win)
WINDOW	*win;
{
	chtype	*maxx, *ptr, *end;
	int	y, x, minx;
	chtype	blank = ' ' | win->_attrs;

#ifdef TRACE
	if (_tracing)
	    _tracef("wclrtoeol(%o) called", win);
#endif

	y = win->_cury;
	x = win->_curx;

	end = &win->_line[y][win->_maxx];
	minx = _NOCHANGE;
	maxx = &win->_line[y][x];

	for (ptr = maxx; ptr < end; ptr++)
	{
	    if (*ptr != blank)
	    {
		maxx = ptr;
		if (minx == _NOCHANGE)
		    minx = ptr - win->_line[y];
		*ptr = blank;
		win->_numchngd[y] += 1;
	    }
	}

	if (minx != _NOCHANGE)
	{
	    if (win->_firstchar[y] > minx || win->_firstchar[y] == _NOCHANGE)
		win->_firstchar[y] = minx;

	    if (win->_lastchar[y] < maxx - win->_line[y])
		win->_lastchar[y] = maxx - win->_line[y];
	}
}
