.po +.5i
.TL
New Features in Curses and Terminfo
.AU
Pavel Curtis
.NH
Introduction
.PP
This document describes new features that are being added to the
Berkeley \fBcurses\fP subroutine package.
It also describes the new \fBterminfo\fP database, which
replaces the Berkeley \fBtermcap\fP database.  The emphasis is on the
new features.
.NH
New Features in Curses
.PP
This section describes the enhancements to curses.  Briefly, the
enhancements are:
.de Np
.IP \\n+(l%.
..
.nr l% 0 1
.af l% a
.Np
Curses is smarter.  It can take advantage of insert/delete
line/character.  (By default, it will not use insert/delete
line.  See \fIidlok()\fR.)
.Np  
Curses uses the new \fBterminfo\fP data base, as described in the
next section.
.Np  
Curses works on more terminals.
.Np  
It is possible to use more than one terminal at a time.
.Np  
Video attributes can be displayed in any combination.
.Np  
Curses handles terminals with the ``magic cookie'' video
attribute glitch.
.Np  
The function and arrow keys on terminals can be input as
though they were a single character.
.Np  
There is a user accessible scrolling region, like the DEC
VT100.
.Np  
If the programmer restricts his code to a subset of the full
curses, the \fBMINICURSES\fP version can be used, which is smaller
and faster.
.Np  
Two routines are provided for setting the tty bits to the
proper state for shell escapes and control-Z suspensions.
.Np  
On systems that support it (currently only 4.1BSD), if the
user types something during an update, the update will stop,
pending a future update.  This is useful when the user hits
several keys, each of which causes a good deal of output.
.Np  
The routine \fBgetstr()\fP is smarter - it handles the users erase
and kill characters, and echos its input.
.Np  
The function \fBlongname()\fP is now useful and actually works.
.Np  
Nodelay mode allows ``real time'' programs to be written
with the same interface on both systems.  Setting the flag
causes \fBgetch\fP to return -1 if no input is waiting.
.Np  
Several useful routines are provided to enhance portability.
.NH 2
Curses is Smarter
.PP
The algorithm used by curses has been replaced with an algorithm
that takes into account insert and delete line and character
functions, if available, in the terminal.  By default, curses
will not use insert/delete line.  This was not done for
performance reasons, since there is no speed penalty involved.  Rather,
it was found that some programs do not need this facility, and
that if curses uses insert/delete line, the result on the screen
can be visually annoying.  Since most simple programs using
curses do not need this, and since the old curses did not use it,
the default is to avoid insert/delete line.  Call the routine
.DS
\fBidlok(stdscr, TRUE);\fP
.DE
to enable insert/delete line, if your application needs it.
Insert/delete character is always considered.
.NH 2
Additional Terminals
.PP
Curses works on a larger class of terminals than the previous
version.  Terminfo is able to address the cursor on more kinds of
terminals.  Curses will work even if absolute cursor addressing
is not possible, as long as the cursor can be moved from any
location to any other location.  It considers local motions,
parameterized motions, home, and carriage return.
.PP
Curses is still aimed at full duplex, alphanumeric, video
terminals.  No attempt is made to handle half-duplex, synchronous,
hard copy, or bitmapped terminals.
.PP
Curses handles terminals with the ``magic cookie glitch'' in
their video attributes.\u*\d
.FS
\u*\dThis feature is not supported in the current test release.  It will
be implemented in the official distribution.
.FE
This glitch means that a change in video
attributes is implemented by storing a ``magic cookie'' in a
location on the screen.  This ``cookie'' takes up a space,
preventing an exact implementation of what the programmer wanted.
Curses takes the extra space into account, and moves part of the
line to the right, as necessary.  In some cases, this will
unavoidably result in losing text from the right hand edge of the
screen.  Existing spaces are taken advantage of.
.NH 2
Multiple Terminals
.PP
Some applications need to display text on more than one terminal,
controlled by the same process.  Even if the terminals are
different, the new curses can handle this.
.PP
All information about the current terminal is kept in a global
variable
.DS
\fBstruct screen\fP *SP;
.DE
Although the screen structure is hidden from the user, the C
compiler will accept declarations of variables which are pointers.
The user program should declare one screen pointer variable for
each terminal it wishes to handle.  The routine
.DS
\fBstruct screen *
\fInewterm\fR(type, fd)
\fBchar\fP *type;
FILE *fp;
.DE
will set up a new terminal of the given terminal type which does
output on file pointer fp.  A call to \fIinitscr()\fP is essentially
\fInewterm\fP(\fIgetenv\fP(``TERM''), \fBstdout\fR).
A program wishing to use more
than one terminal should use \fInewterm()\fP for each terminal and save
the value returned as a reference to that terminal.
.PP
To switch to a different terminal, call
.DS
\fBstruct screen\fP *
\fIset_term\fP(term)
\fBstruct screen\fP *term;
.DE
The old value of SP will be returned.  You should not assign
directly to SP because certain other global variables must also
be changed.
.PP
All curses routines always affect the current terminal.  To
handle several terminals, switch to each one in turn with \fIset_term()\fP,
and then access it.  Each terminal must be set up with \fInewterm()\fP,
and closed down with \fIendwin()\fP.
.NH 2
Video Attributes
.PP
Video attributes can be displayed in any combination on terminals
with this capability.  They are treated as an extension of the
standout capability, which is still present.
.PP
Each character position on the screen has 16 bits of information
associated with it.  7 of these bits are the character to be
displayed, leaving separate bits for 9 video attributes.  These
bits are used for standout, underline, reverse video, blink, dim,
bold, blank, protect, and alternate character set.  Standout is
taken to be whatever highlighting works best on the terminal, and
should be used by any program that does not need specific or
combined attributes.  Underlining, reverse video, blink, dim, and
bold are the usual video attributes.  Blank means that the
character is displayed as a space, for security reasons.  Protected
and alternate character set are dependent on the particular
terminal.  The use of these last three bits is subject to change and
not recommended.
.PP
The routines to use these attributes include
.DS
.ta 2i
\fIattrset\fP(attrs)	\fIwattrset\fP(attrs)
\fIattron\fP(attrs)	\fIwattron\fP(attrs)
\fIattroff\fP(attrs)	\fIwattroff\fP(attrs)
\fIstandout\fP()	\fIwstandout\fP()
\fIstandend\fP()	\fIwstandend\fP()
.DE
.PP
Attributes, if given, can be any combination of A_STANDOUT,
A_UNDERLINE, A_REVERSE, A_BLINK, A_DIM, A_BOLD, A_INVIS,
A_PROTECT, and A_ALTCHARSET.  These constants, defined in
curses.h, can be combined with the C | (or) operator to get
multiple attributes.  \fIAttrset()\fP sets the current attributes to the
given \fIattr\fP; \fIattron()\fP turns on the given \fIattrs\fP in addition to any
attributes that are already on; \fIattroff()\fP turns off the given
attributes, without affecting any others.  \fIstandout()\fP and \fIstandend()\fP
are equivalent to \fIattron\fP(A_STANDOUT) and \fIattroff\fP(A_STANDOUT).
.PP
Since standout is stored in the 8th bit of the text byte, it is
possible to recompile curses so that only 8 bits are stored for
each character, making a smaller curses, and still be able to use
standout.  Also, programs that restrict themselves to the
routines \fIstandout()\fP and \fIstandend()\fP will work with both
the new and old curses.
.PP
If the particular terminal does not have the particular attribute
or combination requested, curses will attempt to use some other
attribute in its place.  If the terminal has no highlighting at
all, all attributes will be ignored.
.NH 2
Function Keys
.PP
Many terminals have special keys, such as arrow keys, keys to
erase the screen, insert or delete text, and keys intended for
user functions.  The particular sequences these terminals send
differs from terminal to terminal.  Curses allows the programmer
to handle these keys.
.PP
A program using function keys should turn on the keypad by
calling
.DS
\fIkeypad\fP(\fBstdscr\fP, TRUE)
.DE
at initialization.  This will cause special characters to be
passed through to the program by the function \fIgetch()\fP.  These keys
have constants which are defined in curses.h.  They have values
starting at 0401, so they should not be stored in a \fBchar\fP
variable, as significant bits will be lost.
.PP
A program using function keys should avoid using the \s-2ESCAPE\s0 key,
since most sequences start with escape, creating an ambiguity.
Curses will set a one second alarm to deal with this ambiguity,
which will cause delayed response to the escape key.  It is a
good idea to avoid escape in any case, since there is eventually
pressure for nearly \fIany\fP screen oriented program to accept arrow
key input.
.NH 2
Scrolling Region
.PP
There is a user accessible scrolling region, like the DEC VT100.
Normally, it is set to the entire window, but the calls
.DS
\fIsetscrreg\fP(top, bot)
\fIwsetscrreg\fP(win, top, bot)
.DE
set the scrolling region for \fBstdscr\fP or the given window to any
combination of top and bottom margins.  If scrolling has been
enabled with \fIscrollok\fP, scrolling will take place only within that
window.  See the \fICurses Reference Manual\fP for the detailed semantics
of this construct.
.NH 2
Mini-Curses\u*\d
.FS
\u*\dThis feature is not supported in the current test release.  It will
be implemented in the official distribution.
.FE
.PP
The new curses is bigger than the old one, and has to copy from
the current window to an internal screen image for every call to
\fIrefresh()\fP.  If the programmer is only interested in screen output
optimization, and does not want the windowing or input functions,
an interface to the lower level routines is available.  This will
make the program somewhat smaller and faster.  The interface is a
subset of full curses, so that conversion between the levels is
not necessary to switch from mini-curses to full curses.
.PP
The subset mainly requires you to avoid use of more than the one
window \fBstdscr\fP.  Thus, all functions beginning with ``w'' are
generally undefined.  Certain high level functions that are
convenient but not essential are also not available, including
\fIprintw()\fP and \fIscanw()\fP  Also, the input routine \fIgetch()\fP
cannot be used
with mini-curses.  Features implemented at a low level, such as
use of hardware insert/delete line and video attributes, are
available in both versions.  Also, mode setting routines such as
\fIcbreak()\fP and \fInoecho()\fP are allowed.
See the manual page for the exact
list of routines allowed with mini-curses.
.PP
To access mini-curses, add \fB-DMINICURSES\fP to the CFLAGS in your
makefile.  If you ask for routines that are not in the subset,
the loader will print error messages such as
.DS
Undefined:
no_getch
no_waddch
.DE
to tell you that the routines \fIgetch()\fP and \fIwaddch()\fP were used but are
not available in the subset.  Since the preprocessor is involved
in the implementation of mini-curses, you must recompile the
entire program if you change from one version to the other.
Similarly, programs compiled with the old curses must be
recompiled for the new curses.
.NH 2
TTY Mode Functions
.PP
In addition to the save/restore routines \fIsavetty()\fP and \fIresetty()\fP,
standard routines are available for going into and out of normal
tty mode.  These routines are \fIresetterm()\fP, which puts the
terminal back in the mode it was in when curses was started, and \fIfixterm()\fP,
which undoes the effects of \fIresetterm()\fP, that is, restores
the ``current curses mode''.  \fIendwin()\fP automatically calls
\fIresetterm()\fP, and the routine to handle control-Z (on 4.1BSD systems with
process control) also uses \fIresetterm()\fP and \fIfixterm()\fP.  The programmer
should use these routines before and after shell escapes, and
also if he writes his own routine to handle control-Z.  These
routines are also available at the \fIterminfo\fP level.
.NH 2
Typeahead Check\u*\d
.FS
\u*\dThis feature is not supported in the current test release.  It will
be implemented in the official distribution.
.FE
.PP
On systems that support it (current only 4.1BSD), if the user
types something during an update, the update will stop, pending a
future update.  This is useful when the user rapidly hits several
keys, each of which causes a good deal of output.  This feature
is automatic and cannot be disabled.
.NH 2
Getstr()
.PP
The routine \fIgetstr()\fP is smarter.  The semantics are slightly
different from the old \fIgetstr()\fP, but no incompatibilities are
anticipated.  No matter what the setting of \fIecho\fP is, strings typed in
here are echoed at the current cursor location.  The users erase
and kill characters are understood and handled.  This makes it
unnecessary for an interactive program to deal with erase, kill,
and echoing when the user is typing a line of text.
.NH 2
Longname()
.PP
The function \fIlongname()\fP is now useful and actually works.  The
previous version required the programmer to call \fItgetent()\fP directly
and pass the resulting string, along with a buffer, to \fIlongname()\fP.
The string actually returned was the second alias for the
terminal, not the long name.
.PP
The new \fIlongname()\fP function does not take any arguments.  It
returns a pointer to a static area containing the actual long
name of the terminal.  No call to \fItgetent()\fP is needed, in fact,
that routine no longer exists.
.NH 2
Nodelay Mode
.PP
The call
.DS
\fInodelay\fP(\fBstdscr\fP, TRUE)
.DE
will put the terminal in ``nodelay mode''.  While in this mode,
any call to \fIgetch()\fP will return -1 if there is nothing waiting to
be read immediately.  This is useful for writing programs
requiring ``real time'' behavior where the user watches action on the
screen and presses a key when he wants something to happen.  For
example, the cursor can be moving across the screen, and the user
can press an arrow key to change direction.  This mode is
especially useful for games such as PacMan and Space Invaders.
.NH 2
Portability
.PP
Several useful routines are provided to enhance portability.
While these routines do not directly relate to terminal handling,
their implementation is different from system to system, and the
differences can be isolated from the user program by including
them in curses.
.PP
Functions \fIerasechar()\fP and \fIkillchar()\fP return the characters which
erase one character, and kill the entire input line,
respectively.  The function \fIbaudrate()\fP will return the current baud
rate, as an integer.  (For example, at 9600 baud, the integer
9600 will be returned, not the value B9600 from <sgtty.h>.) The
routine \fIflushinp()\fP will cause all typeahead to be thrown away.
.NH 2
Features No Longer Supported
.PP
In general, an effort has been made to support old features where
possible.  However, there are some features of the old curses
that cannot be supported, due to the change to terminfo, or due
to other miscelaneous causes.
.PP
The old curses defined a number of two letter variables, such as
CM, containing termcap capabilities.  These variables are no
longer accessible to the user.  In general, their semantics are
different, as are their names.  A program using primarily these
variables is really written at the termcap level.  Also
unavailable are the related variables NONL, GT, and UPPERCASE.
.PP
Such programs should be recoded to avoid these capabilities, if
at all possible, instead using the higher level curses functions.
If this is not possible, recode at the terminfo level.  A program
making only light use can probably be easily changed to avoid
these variables completely.  A program at the terminfo level that
only needs motion optimization should probably still be recoded
to use the high level routines, in order to work on more
terminals.  If this is not possible, recode at the terminfo level,
continuing to use \fImvcur()\fP, which is still supported.  It is not
necessary to call \fImvcur()\fP to move to the lower left corner of the
screen before calling \fIendwin()\fP.
.PP
Some programs (notably rogue) use varibles in <curses.h> which
begin with an underline.  Use of these variables and fields is to
be avoided.  Most of the internal structures used by curses are
hidden from the user.  The variables _tty and _tty_ch are no
longer accessible.  (Since _tty was a version 7 dependent
structure, it was not portable to use it anyway.) Useful fields, such
as the erase and kill characters, and the baud rate, can be
discovered using the portable functions described above.
.NH
Termlib-Level Changes
.PP
The termcap(3) (termlib) library has been consolidated with the
curses(3) library to form a new curses(3) library.  The termlib
level is very different in the new version.  The routines
\fItgetent()\fP, \fItgetnum()\fP, \fItgetstr()\fP, and \fItgetflag()\fP are gone.
Initialization is instead done by calling
.DS
\fIsetupterm\fP(termtype, filedes, errret)
\fBchar\fP *termtype;
\fBint\fP filedes;
\fBint\fP *errret;
.DE
This routine takes care of all reading in of capabilities, and
any other system dependent initialization.  The terminal type can
be passed as 0, causing \fIsetupterm()\fP to use \fIgetenv\fP(``TERM'') as a
default.  \fIerrret\fP is a pointer to an integer used to return a
status value.  The value returned is 0 if there is no such
terminal type, 1 if all went well, or -1 for some trouble.  A null
pointer can be passed for this value, telling \fIsetupterm()\fP to print
an error message and exit if the terminal cannot be found.
.PP
When exiting, or calling a shell escape, the user program should
call \fIresetterm()\fP to restore the tty modes.  After the shell
escape, \fIfixterm()\fP can be called to set the tty modes back to
their internal settings.  These calls are now \fBrequired\fP, since
they perform system dependent processing.  They do not output the
\fBenter_ca_mode\fP and \fBexit_ca_mode\fP strings (\fBti\fP and \fBte\fP
in termcap) but
should be called at the same times.
\fISetupterm()\fP calls \fIfixterm()\fP.
.PP
\fItgoto()\fP has been replaced by \fItparm()\fP, which is a more powerful
parameterized string mechanism.  The \fItgoto()\fP routine is still
available for compatibility.  \fItputs()\fP is unchanged.
.PP
The external variables \fBUP\fP, \fBBC\fP, \fBPC\fP, and \fBospeed\fP
no longer exist.
The programmer need not worry about these, as their function is
now handled internally.
.NH
Changes from Termcap to Terminfo
.PP
This section describes the extensions in terminfo that were not
present in termcap, and the incompatible changes that were made.
It is intended for a programmer or termcap author who is familiar
with termcap and wishes to become familiar with terminfo.  The
emphasis is on the database, not on the programmer interface.
.NH 2
Syntax
.PP
The first thing you will notice upon scanning terminfo is that it
looks cosmetically different from termcap.  All the backslashes
are gone from ends of lines.  Fields are separated with commas
instead of colons, and white space after the commas makes them
more readable.  Continuation lines are now defined as lines
beginning with a blank or tab, not lines following a backslash.
These changes make terminfo easier to read and to modify.
.NH 2
Names
.PP
The names of the capabilities are no longer limited to two
letters.  There is no longer a hard limit to the names, but an
informal limit of 5 characters is used.  Since the two letter
limit is gone, many of the capabilities have been renamed.  They
now correspond as closely as possible the the ANSI standard
X3.64.  While learning the new set of names will be tricky at
first, eventually life will be simpler, since most new terminals
use the ANSI abbreviations.
.NH 2
Defaults
.PP
A change that is perhaps not so obvious is that certain defaults
are no longer implied.  In termcap, \er was assumed to be a
carriage return unless \fBnc\fP was present, indicating that it did not
work, or \fBcr\fP was present, indicating an alternative.  In terminfo,
if \fBcr\fP is present, the string so given works, otherwise it should
be assumed \fInot\fP to work.  The \fBbs\fP and \fBbc\fP capabilities are replaced
by \fBcub\fP and \fBcub1\fP.  (The former takes a parameter, moving left that
many spaces.  The latter is probably more common in terminals and
moves left one space.)  \fBnl\fP (linefeed) has been split into two
functions: \fBcud1\fP (moves the cursor down one line) and \fBind\fP (scroll
forward).  \fBcud1\fP applies when the cursor is not on the bottom
line, \fBind\fP applies when it is on the bottom line.  The bell
capability is now explicitly given as \fBbel\fP.
.NH 2
Compilation
.PP
The terminfo database is compiled, unlike termcap.  This means
that a terminfo source file (describing some set of terminals) is
processed by the terminfo compiler, producing a binary
description of the terminal in a file under /etc/term.  The setupterm
routine reads in this file.
.PP
The advantage to compilation is that starting up a program using
terminfo is faster.  It is no longer necessary to carry around
the variable TERMCAP in the environment.  It is actually faster
to start up a compiled terminfo \fIwithout\fP the environment variable,
than it is to start up an uncompiled termcap \fIwith\fP the environment
variable.  The increase in speed comes partly from not having to
skip past other terminal descriptions, and partly from the
compiler having sorted the capabilities into order so that a linear
scan can read them in.  (The termcap initialization algorithm is
quadratic on the size of the capability.  The more capabilities
you are interested in, the worse this gets.  It had gotten to the
point where it took 2 CPU seconds on a VAX 11/750 to start up a
process using an uncompiled terminfo!)
.PP
There exists an environment variable TERMINFO which is taken by the compiler
to be the destination directory of the new object files.  It is also used by
\fIsetupterm()\fP to find an entry for a given terminal.  First it looks in
the directory given in TERMINFO and, if not found there, checks /etc/term.
\fBNote\fP, however, that, unlike the old TERMCAP variable, you may not
put the source for an entry in the TERMINFO variable.  \fIAll\fP
terminfo entries must be compiled.
.NH 2
Parameterised Strings
.PP
The old \fItgoto()\fP mechanism, which was designed for cursor addressing
only, has been replaced by a more general parameter mechanism,
accessed through the function \fItparm()\fP.  Since the parameters are
not compatible in the terminfo database, a termcap \fBcm\fI description
must be converted manually to terminfo.
.PP
The new mechanism is based on a stack.  % operations are used to
push parameters and constants onto the stack, do arithmetic and
other operations on the top of the stack, and print out values in
various formats.  This makes it possible to handle a larger class
of terminals, such as the AED 512, which addresses the cursor in
terms of pixels, not character positions, and the TEC scope,
which numbers the rows and columns from the lower right hand
corner of the screen.  Any number of parameters from 1 to 9 is
possible, whereas \fItgoto()\fP allowed only two parameters. 
If-then-else testing is possible, as is storage in a limited number of
variables.  There is no provision for loops or printing strings
in any format other than %s.  The full details are described in
terminfo(5).
.PP
A few brief examples are included here to show common
conversions.  For more examples, compare the termcap \fBcm\fP and terminfo
\fBcup\fP entries for your favorite terminal.  ``%+ '' (add space and
print as a character) would be treated as ``%p1%' '%+%c'', that
is, push the first parameter, push space, add the top two numbers
on the stack, and output the top item on the stack using
character (%c) format.  (Of course, for the second parameter, the %p1
must be changed to %p2.) ``%.'' (print as a character) would be
``%p1%c''.  ``%d'' (print in decimal) would be ``%p1%d''.  As
with \fItgoto()\fP, characters standing by themselves (no % sign) are
output as is.
.NH 2
More Capabilities
.PP
There are a number of new capabilities.  The set of new
capabilities may vary, depending on the version of termcap you are used
to.  It is probably worthwhile to read terminfo(5) for a complete
list.  This section describes capabilities new to terminfo that
were never put in termcap.
.PP
There are provisions for dealing with more video attributes.
Termcap had strings to turn on and off standout and underline
modes.  Terminfo has these and several more.  There are strings
to turn on bold, inverse video, blinking, dim, protected, and
blanking.  Rather than have separate string for turning off each
of these, a single capability: \fBsgr0\fP, turns them all off.
.PP
The effect of turning on more than one attribute at a time with
the separate strings is undefined.  A parameterized string, \fBsgr\fP,
can be used to turn them on in combination.
.PP
More function keys are defined now.  There are provisions for f0
through f10 as well as keys such as erase, insert mode, insert
line, delete line, delete character, print, and so on.  All of
these keys can be accessed through curses as if they were single
characters.  Also, \fBvi\fP version 3.8 has default meanings for many
of them.
.PP
Several new uses are made of parameterized strings.  For example,
capabilities exist to move the cursor to a particular column in
the current row, a particular row in the current column, and to
move left, right, up, or down a given number of spaces.  These
capabilities make a big difference on some terminals, such as the
Tektronix 4025.  Also, column addressing is useful for filters
that do not know what row they are in, or as a shorter form of
cursor addressing when the target is in the same row.
.PP
There are now capabilities to turn on and off a local printer,
and to print the current page.  Also, there are provisions for
moving the cursor to and from a status line.  These capabilities
can be used by a background status program, such as \fIsysline\fP, to
keep status information in the status line without bothering
foreground processes.  This only works on terminals with a
writable status line, such as the h19 or tvi950, or on terminals
where one can be simulated, such as the hp2626, vt100, or
ambassador, by allocating one of the ordinary screen lines for a
status line.
.NH 2
How to Convert from Termcap to Terminfo
.PP
This section is intended for programmers who need to convert
programs that use termcap to the new terminfo database.  It
describes the steps needed for the conversion.
.PP
If you must make the conversion, you are strongly urged to
convert to curses, rather than converting to terminfo.  The curses
interface is higher level and will probably do a better job of
optimizing your output.  Your program will work on a wider range
of terminals if you use curses.  It will also become more
portable.  The effort to convert to curses is probably about the same
as to convert to terminfo.
.PP
There are some programs for which curses is not a possibility.
Curses takes over the CRT screen, and this implies initially
clearing the screen.  For some programs, such as filters, this
may not make sense.  Also, if you are writing a special purpose
program which uses some terminfo capability that curses does not
use, it will probably be necessary to use the terminfo level
interface.
.NH 2
Conversion
.PP
The first step is to include the headers <curses.h> and <term.h>
(in that order).  These headers will bring into existence a set
of ``variables'' (actually macros) that contain values of
capabilities.  For example, the macro \fBcursor_address\fP will be defined,
replacing the termcap \fBcm\fP
capability.  You should remove the declarations for all variables
you use for capabilities returned by \fItgetflag()\fP, \fItgetnum()\fP, and
\fItgetstr()\fP.
.PP
The most difficult step is that all variables removed in the
previous step must be renamed the standard names.  For example, if
you stored \fBcm\fP in the variable CM, you would change
\fItputs\fP(\fItgoto\fP(\fBCM\fP, i, j), 1, outch) to
\fItputs\fP(\fItgoto\fP(\fBcursor_address\fP, i, j), 1, outch).
Consult terminfo(5) for a list of standard
names.  A \fBsed\fP script is often useful for this step.  Care must be
taken to avoid mention of the variable as part of a longer word
(a version of \fBsed\fP supporting the \fBex\fP \<word\> convention is useful
here.) Also, you should proofread the results, since sometimes
comments and strings get substituted that shouldn't have been.
.PP
Remove all your termcap initialization code.  This code typically
calls \fItgetent()\fP, \fItgetstr()\fP, \fItgetflag()\fP, and \fItgetnum()\fP.
You can also
remove declarations used only for this initialization, usually
including buffers for the entry and string values.  Replace it
with a single call to \fIsetupterm\fP(0, 1, 0).  This call will never
return if something goes wrong, that is, if there is no $TERM in
the environment or there is no such terminal, the routine will
print an error and exit.  If you need an error indication passed
back for more sophisticated error recovery, pass an integer
variable in the third parameter, i.e.  setupterm(0, 1, &i).  The
value returned in \fBi\fP will be the same as that previously returned
by \fItgetent()\fP.  Other more sophisticated calls to \fIsetupterm()\fP are
possible, see the documentation if some terminal other than $TERM or
some file descriptor other than \fBstdout\fP are involved.
.PP
Before the program exits, insert a call to \fIresetterm()\fP.  This
will restore the tty modes to their state before setupterm was
called, and do any other system dependent exit processing.  This
routine can also be called before a shell escape, you should call
\fIfixterm()\fP after the shell escape to restore the tty modes to
those needed by terminfo.  (Currently \fIsetupterm()\fP will turn off the
XTABS bit in the tty driver, since some terminals need to send
control I for escape sequences.  You should be sure to expand any
tabs in your software if necessary.)
.PP
From the programmers viewpoint, the routine \fItputs()\fP is exactly as
in termcap.  The padding syntax in the capability is different,
but this only affects the capabilities in the terminfo database.
No change to a program will be needed for \fItputs()\fP.
.PP
The \fItgoto()\fP routine is kept around for upward compatibility, but
you should probably replace calls to \fItgoto()\fP by calls to \fItparm()\fP.
The call \fItgoto\fP(cap, y, x) will call \fItparm\fP(cap, x, y).  Note that
the order of the last two arguments is reversed - it was
backwards in \fItgoto()\fP from what it probably should have been.  In
addition to the capability, \fItparm()\fP can now take up to nine parameters,
or as few as one.
.PP
If you use certain capabilities, there are a few convention
changes you should be aware of.  These do not affect very many
programs, but will require some minor recoding of a few programs.
In termcap, the cursor is moved left by control-H if \fBbs\fP is
present, otherwise, if \fBbc\fP is present, that character is used.  In
terminfo, the cursor is moved left with \fBcub1\fP, if present, or by
\fBcub\fP, if present.  If neither is there, there is no implied
control-H.  Similarly, termcap assumed that control-M was carriage
return unless \fBnc\fP or \fBcr\fP was specified.  In terminfo, carriage
return is always the string specified by \fBcr\fP, and if not present,
there is no carriage return capability.  In termcap, linefeed is
assumed to both move the cursor down (if it is not on the bottom
line) and to scroll one line (if it is on the bottom line),
unless \fBns\fP is present.  \fBsf\fP and \fBdo\fP capabilities were present but
little used, and some software assumed that \fBsf\fP worked with the
cursor anywhere on the screen.  In terminfo, there is no implied
linefeed - moving the cursor down is done with \fBcud1\fP or \fBcud\fP and
scrolling is done with \fBind\fP.  \fBind\fP is only defined when the cursor
is at the bottom of the screen.  Finally, the implied control G
used to ring the bell unless \fBvb\fP was present has been replaced
with an explicit \fBbel\fP.
.PP
Replace references in your makefile from -ltermcap or -ltermlib
with references to -lcurses.
.PP
Now recompile your program.  It should run properly using
terminfo.
.NH 2
Space Conditions
.PP
The expansion of a macro name into a structure reference 
will probably make your program a bit bigger.  If space is a
problem, one thing you can do is add \fB-DSINGLE\fP to the CFLAGS in
your makefile.  This causes the macros to expand to a static
reference instead of a dynamic reference, resulting in smaller
code.  It cannot be used if you intend to involve more than one
terminal from a single process.  Since very few programs talk to
two terminals at once, it is almost always safe to define SINGLE.
.PP
If your program was pushing the limit on a small machine, it may
not fit with terminfo unless you trim it down some.  While the
startup routines are faster, they tend to generate larger code
than those of termcap.  Also, \fItputs()\fP and \fItparm()\fP are more
sophisticated and larger.
