
/* This work is copyrighted. See COPYRIGHT.OLD & COPYRIGHT.NEW for   *
*  details. If they are missing then this copy is in violation of    *
*  the copyright conditions.                                        */

/*
 *	raw.c
 *
 *	Routines:
 *		raw()
 *		echo()
 *		nl()
 *		cbreak()
 *		crmode()
 *		noraw()
 *		noecho()
 *		nonl()
 *		nocbreak()
 *		nocrmode()
 *
 *	cbreak() == crmode()
 *	nocbreak() == crmode()
 *
 *
 */

#include "curses.h"
#include "curses.priv.h"
#include "terminfo.h"

int raw()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("raw() called");
#endif

	SP->_raw = TRUE;
	SP->_nlmapping = TRUE;

#ifdef TERMIOS
	cur_term->Nttyb.c_lflag &= ~(ICANON|ISIG);
	cur_term->Nttyb.c_iflag &= ~(INPCK|ISTRIP|IXON);
	cur_term->Nttyb.c_oflag &= ~(OPOST);
	cur_term->Nttyb.c_cc[VMIN] = 1;
	cur_term->Nttyb.c_cc[VTIME] = 0;
	if((tcsetattr(cur_term->Filedes, TCSANOW, &cur_term->Nttyb)) == -1)
		return ERR;
	else
		return OK;
#else
	cur_term->Nttyb.sg_flags |= RAW;
	stty(cur_term->Filedes, &cur_term->Nttyb);
	return OK;
#endif
}

int cbreak()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("cbreak() called");
#endif

	SP->_cbreak = 1;

#ifdef TERMIOS
	cur_term->Nttyb.c_lflag &= ~ICANON; 
	cur_term->Nttyb.c_lflag |= ISIG;
	cur_term->Nttyb.c_cc[VMIN] = 1;
	cur_term->Nttyb.c_cc[VTIME] = 0;
	if((tcsetattr(cur_term->Filedes, TCSANOW, &cur_term->Nttyb)) == -1)
		return ERR;
	else
		return OK;
#else
	cur_term->Nttyb.sg_flags |= CBREAK;
	stty(cur_term->Filedes, &cur_term->Nttyb);
	return OK;
#endif
}

int crmode()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("crmode() called");
#endif
	return(cbreak());
}


int echo()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("echo() called");
#endif

	SP->_echo = TRUE;
    
#ifdef BRAINDEAD
#define echoes	ECHO
#else
#define echoes	ECHO|ECHOCTL|ECHOPRT|ECHOKE
#endif
#ifdef TERMIOS
	cur_term->Nttyb.c_lflag |= ECHO|ECHOCTL|ECHOPRT|ECHOKE;
	if((tcsetattr(cur_term->Filedes, TCSANOW, &cur_term->Nttyb)) == -1)
		return ERR;
	else
		return OK;
#else
	cur_term->Nttyb.sg_flags |= ECHO;
	stty(cur_term->Filedes, &cur_term->Nttyb);
	return OK;
#endif
}


int nl()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("nl() called");
#endif

	SP->_nl = TRUE;
	SP->_nlmapping = ! SP->_raw;

#ifdef TERMIOS
	cur_term->Nttyb.c_iflag |= IXON|ICRNL|IXOFF;
	cur_term->Nttyb.c_oflag |= OPOST|ONLCR;
	if((tcsetattr(cur_term->Filedes, TCSANOW, &cur_term->Nttyb)) == -1)
		return ERR;
	else
		return OK;
#else
	cur_term->Nttyb.sg_flags |= CRMOD;
	stty(cur_term->Filedes, &cur_term->Nttyb);
	return OK;
#endif
}


int noraw()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("noraw() called");
#endif

	SP->_raw = FALSE;
	SP->_nlmapping = SP->_nl;

#ifdef TERMIOS
	cur_term->Nttyb.c_lflag |= ISIG|ICANON;
	cur_term->Nttyb.c_iflag |= IXON;
	cur_term->Nttyb.c_oflag |= OPOST;
	if((tcsetattr(cur_term->Filedes, TCSANOW, &cur_term->Nttyb)) == -1)
		return ERR;
	else
		return OK;
#else
	cur_term->Nttyb.sg_flags &= ~RAW;
	stty(cur_term->Filedes, &cur_term->Nttyb);
	return OK;
#endif

}


int nocbreak()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("nocbreak() called");
#endif

	SP->_cbreak = 0;
	
#ifdef TERMIOS
	cur_term->Nttyb.c_lflag |= ICANON;
	if((tcsetattr(cur_term->Filedes, TCSANOW, &cur_term->Nttyb)) == -1)
		return ERR;
	else
		return OK;
#else 
	cur_term->Nttyb.sg_flags &= ~CBREAK;
	stty(cur_term->Filedes, &cur_term->Nttyb);
	return OK;
#endif
}

int nocrmode()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("nocrmode() called");
#endif

	return(nocbreak());
}


int noecho()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("noecho() called");
#endif

	SP->_echo = FALSE;
	
#ifdef TERMIOS
	cur_term->Nttyb.c_lflag &= ~(ECHO|ECHOCTL|ECHOPRT|ECHOKE);
	if((tcsetattr(cur_term->Filedes, TCSANOW, &cur_term->Nttyb)) == -1)
		return ERR;
	else
		return OK;
#else
	cur_term->Nttyb.sg_flags &= ~ECHO;
	stty(cur_term->Filedes, &cur_term->Nttyb);
	return OK;
#endif
}


int nonl()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("nonl() called");
#endif

	SP->_nl = SP->_nlmapping = FALSE;
	
#ifdef TERMIOS
	cur_term->Nttyb.c_iflag &= ~ICRNL;
	cur_term->Nttyb.c_oflag &= ~ONLCR;
	if((tcsetattr(cur_term->Filedes, TCSANOW, &cur_term->Nttyb)) == -1)
		return ERR;
	else
		return OK;
#else
	cur_term->Nttyb.sg_flags &= ~CRMOD;
	stty(cur_term->Filedes, &cur_term->Nttyb);
	return OK;
#endif
}
