.\" $LynxId: lynx.man,v 1.117 2017/04/28 01:19:42 tom Exp $
.\" **************************************************************************
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds AQ \(aq
.el       .ds AQ '
.ie \n(.g .ds `` \(lq
.el       .ds `` ``
.ie \n(.g .ds '' \(rq
.el       .ds '' ''
.de bP
.IP \(bu 4
..
.de NS
.ie \n(.sp
.el    .sp .5
.ie \n(.in +4
.el    .in +2
.nf
.ft C			\" Courier
..
.de NE
.fi
.ft R
.in -4
..
.\" **************************************************************************
.TH LYNX 1
.SH NAME
lynx \- a general purpose distributed information browser for the World Wide Web
.SH SYNOPSIS
.B lynx \fI[options] [optional paths or URLs]
.sp
.B lynx \fI[options] [path or URL]\fP \fB\-get_data
.br
.I data
.br
.B \-\-
.sp
.B lynx \fI[options] [path or URL]\fP \fB\-post_data
.br
.I data
.br
.B \-\-
.PP
Use \*(``lynx \-help\*('' to display a complete list of current options.
.SH DESCRIPTION
.hy 0
.I
Lynx
is a fully-featured World Wide Web (WWW) client for users
running cursor-addressable, character-cell display devices
(e.g., vt100 terminals,
vt100 emulators running on Windows 95/NT/XP/7/8 or any POSIX platform,
or any other \*(``curses-oriented\*('' display).
It will display hypertext
markup language (HTML) documents containing links to
files residing on the local system, as well as files residing on
remote systems running Gopher, HTTP, FTP, WAIS, and NNTP servers.
Current versions of
.I
Lynx
run on
Unix, VMS, Windows 95/NT/XP/7/8, DOS DJGPP and OS/2.
.PP
.I
Lynx
can be used to access information on the World Wide Web, or
to build information systems intended primarily for local access.
For example,
.I
Lynx
has been used to build several Campus Wide
Information Systems (CWIS).
In addition,
.I
Lynx
can be used to
build systems isolated within a single LAN.
.SH OPTIONS
At start up, \fILynx\fR will load any local
file or remote URL specified at the command line.
For help with URLs, press \*(``\fB?\fR\*(''
or \*(``\fBH\fR\*('' while running \fILynx\fR.
Then follow the link titled, \*(``Help on URLs.\*(''
.PP
If more than one local file or remote URL is listed on the command line,
\fILynx\fP will open only the last interactively.
All of the names (local files and remote URLs) are added to the \fBG)oto\fP history.
.PP
\fILynx\fR uses only long option names.
Option names can begin with double dash \*(``\-\-\*('' as well,
underscores and dashes can be intermixed in
option names (in the reference below, options
are shown
with one dash \*(``\-\*('' before them, and
with underscores \*(``_\*('').
.PP
\fILynx\fR provides many command-line options.
Some options require a value (string, number or keyword).
These are noted in the reference below.
The other options set boolean values in the program.
There are three types of boolean options: set, unset and toggle.
If no option value is given, these have the obvious meaning:
set (to true), unset (to false), or toggle (between true/false).
For any of these, an explicit value can be given in different
forms to allow for operating system constraints,
e.g.,
.NS
\fB\-center:off\fP
\fB\-center=off\fP
\fB\-center\-\fP
.NE
.PP
\fILynx\fR recognizes
\*(``1\*('', \*(``+\*('', \*(``on\*('' and \*(``true\*('' for true values, and
\*(``0\*('', \*(``\-\*('', \*(``off\*('' and \*(``false\*('' for false values.
Other option-values are ignored.
.PP
The default boolean, number and string option values that are compiled
into \fILynx\fP are displayed in the help-message provided by \fBlynx \-help\fP.
Some of those may differ according to how \fILynx\fP was built;
see the help message itself for these values.
The \fB\-help\fP option is processed in the third pass of options-processing,
so any option which sets a value,
as well as runtime configuration values are reflected in the help-message.
.TP 7
.B \-
If the argument is only \*(``\-\*('', then \fILynx\fP expects to receive
the arguments from the standard input.
This is to allow for the
potentially very long command line that can be associated
with the \fB\-get_data\fR or \fB\-post_data\fR arguments (see below).
It can also be used to avoid having sensitive information
in the invoking command line (which would be visible to
other processes on most systems), especially when
the \fB\-auth\fR or \fB\-pauth\fR options are used.
.TP
.B \-accept_all_cookies
accept all cookies.
.TP
.B \-anonymous
apply restrictions for anonymous account, see also \fB\-restrictions\fR.
.TP
.B \-assume_charset\fR=\fIMIMEname
charset for documents that do not specify it.
.TP
.B \-assume_local_charset\fR=\fIMIMEname
charset assumed for local files,
i.e., files which \fILynx\fP creates such as internal pages for the options menu.
.TP
.B \-assume_unrec_charset\fR=\fIMIMEname
use this instead of unrecognized charsets.
.TP
.B \-auth\fR=\fIID\fR:\fIPASSWD
set authorization ID and password for protected documents at startup.
Be sure to protect any script files which use
this switch.
.TP
.B \-base
prepend a request URL comment and BASE tag to text/html
outputs for \fB\-source\fR dumps.
.TP
.B \-bibhost\fR=\fIURL
specify a local bibp server (default http://bibhost/).
.TP
.B \-blink
forces high intensity background colors for color mode, if available
and supported by the terminal.
This applies to the \fBslang\fR library (for a few terminal emulators),
or to OS/2 EMX with \fBncurses\fR.
.TP
.B \-book
use the bookmark page as the startfile.
The default or command
line startfile is still set for the Main screen command, and will
be used if the bookmark page is unavailable or blank.
.TP
.B \-buried_news
toggles scanning of news articles for buried references, and
converts them to news links.
Not recommended because email
addresses enclosed in angle brackets will be converted to
false news links, and uuencoded messages can be trashed.
.TP
.B \-cache\fR=\fINUMBER
set the NUMBER of documents cached in memory.
The default is 10.
.TP
.B \-case
enable case-sensitive string searching.
.TP
.B \-center
Toggle center alignment in HTML TABLE.
.TP
.B \-cfg\fR=\fIFILENAME
specifies a \fILynx\fP configuration file other than the default
lynx.cfg.
.TP
.B \-child
exit on left-arrow in startfile, and disable save to disk and associated
print/mail options.
.TP
.B \-child_relaxed
exit on left-arrow in startfile, but allow save to disk and associated
print/mail options.
.TP
.B \-cmd_log\fR=\fIFILENAME
write keystroke commands and related information to the specified file.
.TP
.B \-cmd_script\fR=\fIFILENAME
read keystroke commands from the specified file.
You can use the data written using the \fB\-cmd_log\fR option.
\fILynx\fP will ignore other information which the command-logging may have
written to the logfile.
Each line of the command script contains either a comment beginning with \*(``#\*('',
or a keyword:
.RS
.TP 3
.B exit
causes the script to stop, and forces \fILynx\fP to exit immediately.
.TP
.B key
the character value, in printable form.
Cursor and other special keys are given as names, e.g., \*(``Down Arrow\*(''.
Printable 7-bit ASCII codes are given as-is,
and hexadecimal values represent other 8-bit codes.
.TP
.B set
followed by a \*(``name=value\*('' allows one to override values set in the
lynx.cfg or \&.lynxrc files.
\fILynx\fP tries the cfg-file setting first.
.RE
.TP
.B \-color
forces color mode on, if available.
Default color control sequences
which work for many terminal types are assumed if the terminal
capability description does not specify how to handle color.
\fILynx\fP needs to be compiled with the \fBslang\fR library for this flag,
it is equivalent to setting the \fBCOLORTERM\fR environment variable.
(If color support is instead provided by a color-capable curses
library like \fBncurses\fR, \fILynx\fP relies completely on the terminal
description to determine whether color mode is possible, and
this flag is not needed and thus unavailable.)
A saved show_color=always setting found in a \&.lynxrc file at
startup has the same effect.
A saved show_color=never found
in \&.lynxrc on startup is overridden by this flag.
.TP
.B \-connect_timeout\fR=\fIN
Sets the connection timeout, where N is given in seconds.
.TP
.B \-cookie_file\fR=\fIFILENAME
specifies a file to use to read cookies.
If none is specified, the default value is ~/.lynx_cookies
for most systems, but ~/cookies for MS-DOS.
.TP
.B \-cookie_save_file\fR=\fIFILENAME
specifies a file to use to store cookies.
If none is specified, the value given by
\fB\-cookie_file\fR is used.
.TP
.B \-cookies
toggles handling of Set-Cookie headers.
.TP
.B \-core
toggles forced core dumps on fatal errors.
Turn this option off to ask \fILynx\fP to force a core dump if a fatal error occurs.
.TP
.B \-crawl
with \fB\-traversal,\fR output each page to a file.
with \fB\-dump\fR, format output as with \fB\-traversal\fR,
but to the standard output.
.TP
.B \-curses_pads
toggles the use of curses \*(``pad\*('' feature which supports
left/right scrolling of the display.
The feature is normally available for curses configurations,
but inactive.
To activate it, use the \*(``|\*('' character or the LINEWRAP_TOGGLE command.
Toggling this option makes the feature altogether unavailable.
.TP
.B \-debug_partial
separate incremental display stages with MessageSecs delay
.TP
.B \-default_colors
toggles the default-colors feature which is normally set in the lynx.cfg file.
.TP
.B \-delay
add DebugSecs delay after each progress-message
.TP
.B \-display\fR=\fIDISPLAY
set the display variable for X rexec-ed programs.
.TP
.B \-display_charset\fR=\fIMIMEname
set the charset for the terminal output.
.TP
.B \-dont_wrap_pre
inhibit wrapping of text when \fB\-dump\fR'ing and \fB\-crawl\fR'ing,
mark wrapped lines of <pre> in interactive session.
.TP
.B \-dump
dumps the formatted output of the default document or those
specified on the command line to standard output.
Unlike interactive mode, all documents are processed.
This can be used in the following way:
.NS
lynx \fB\-dump\fR http://www.subir.com/lynx.html
.NE
.IP
Files specified on the command line are formatted as HTML if
their names end with one of the standard web suffixes such
as \*(``.htm\*('' or \*(``.html\*(''.
Use the \fB\-force_html\fP option to format files whose names do not follow
this convention.
.TP
.B \-editor\fR=\fIEDITOR
enable external editing, using the specified
EDITOR.
(vi, ed, emacs, etc.)
.TP
.B \-emacskeys
enable emacs-like key movement.
.TP
.B \-enable_scrollback
toggles compatibility with communication programs' scrollback keys
(may be incompatible with some curses packages).
.TP
.B \-error_file\fR=\fIFILE
define a file where \fILynx\fP will report HTTP access codes.
.TP
.B \-exec
enable local program execution (normally not configured).
.TP
.B \-fileversions
include all versions of files in local VMS directory listings.
.TP
.B \-find_leaks
toggle memory leak-checking.
Normally this
is not compiled-into your executable, but when it is,
it can be disabled for a session.
.TP
.B \-force_empty_hrefless_a
force HREF-less \*(``A\*('' elements to be empty
(close them as soon as they are seen).
.TP
.B \-force_html
forces the first document to be interpreted as HTML.
.IP
This is most useful when processing files specified on the command line
which have an unrecognized suffix (or the suffix is associated with a
non-HTML type, such as \*(``.txt\*('' for plain text files).
.IP
\fILynx\fP recognizes these file suffixes as HTML:
.NS
\*(``.ht3\*('',
\*(``.htm\*('',
\*(``.html3\*('',
\*(``.html\*('',
\*(``.htmlx\*('',
\*(``.php3\*('',
\*(``.php\*('',
\*(``.phtml\*('',
\*(``.sht\*('', and
\*(``.shtml\*(''.
.NE
.TP
.B \-force_secure
toggles forcing of the secure flag for SSL cookies.
.TP
.B \-forms_options
toggles whether the Options Menu is key-based or form-based.
.TP
.B \-from
toggles transmissions of From headers.
.TP
.B \-ftp
disable ftp access.
.TP
.B \-get_data
properly formatted data for a \fIget\fP form are read in from
the standard input and passed to the form.
Input is terminated by a line that starts with \*(``\-\-\-\*(''.
.IP
\fILynx\fP issues an HTTP \fBGET\fP,
sending the form to the path or URL given on the
command-line and prints the response of the server.
If no path or URL is given, \fILynx\fP sends the form to the start-page.
.TP
.B \-head
send a HEAD request for the mime headers.
.TP
.B \-help
print the \fILynx\fP command syntax usage message, and exit.
.TP
.B \-hiddenlinks=[option]
control the display of hidden links.
.RS
.TP 3
.B merge
hidden links show up as bracketed numbers
and are numbered together with other links in the sequence of their
occurrence in the document.
.TP
.B listonly
hidden links are shown only on \fBL)ist\fP screens and listings generated by
.B \-dump
or from the \fBP)rint\fP menu, but appear separately at the end of those lists.
This is the default behavior.
.TP
.B ignore
hidden links do not appear even in listings.
.RE
.TP
.B \-historical
toggles use of \*(``>\*('' or \*(``\-\->\*('' as a terminator for comments.
.TP
.B \-homepage\fR=\fIURL
set homepage separate from start page.
.TP
.B \-image_links
toggles inclusion of links for all images.
.TP
.B \-index\fR=\fIURL
set the default index file to the specified URL.
.TP
.B \-ismap
toggles inclusion of ISMAP links when client-side
MAPs are present.
.TP
.B \-justify
do justification of text.
.TP
.B \-link\fR=\fINUMBER
starting count for lnk#.dat files produced by \fB\-crawl\fR.
.TP
.B \-list_inline
for \fB\-dump\fR, show the links inline with the text.
.TP
.B \-listonly
for \fB\-dump\fR, show only the list of links.
.TP
.B \-localhost
disable URLs that point to remote hosts.
.TP
.B \-locexec
enable local program execution from local files only (if
\fILynx\fP was compiled with local execution enabled).
.TP
.B \-lss\fR=\fIFILENAME
specify filename containing color-style information.
The default is lynx.lss.
If you give an empty filename, \fILynx\fP uses a built-in monochrome
scheme which imitates the non-color-style configuration.
.TP
.B \-mime_header
prints the MIME header of a fetched document along with its
source.
.TP
.B \-minimal
toggles minimal versus valid comment parsing.
.TP
.B \-nested_tables
toggles nested-tables logic (for debugging).
.TP
.B \-newschunksize\fR=\fINUMBER
number of articles in chunked news listings.
.TP
.B \-newsmaxchunk\fR=\fINUMBER
maximum news articles in listings before chunking.
.TP
.B \-nobold
disable bold video-attribute.
.TP
.B \-nobrowse
disable directory browsing.
.TP
.B \-nocc
disable Cc: prompts for self copies of mailings.
Note that this does not disable any CCs which are incorporated
within a mailto URL or form ACTION.
.TP
.B \-nocolor
force color mode off, overriding terminal capabilities and any
\-color flags, COLORTERM variable, and saved \&.lynxrc settings.
.TP
.B \-noexec
disable local program execution.
(DEFAULT)
.TP
.B \-nofilereferer
disable transmissions of Referer headers for file URLs.
.TP
.B \-nolist
disable the link list feature in dumps.
.TP
.B \-nolog
disable mailing of error messages to document owners.
.TP
.B \-nomargins
disable left/right margins in the default style sheet.
.TP
.B \-nomore
disable \-more\- string in statusline messages.
.TP
.B \-nonrestarting_sigwinch
This flag is not available on all systems,
\fILynx\fP needs to be compiled with HAVE_SIGACTION defined.
If available, this flag \fImay\fR cause \fILynx\fP to react
more immediately to window changes when run within
an \fBxterm\fR.
.TP
.B \-nonumbers
disable link- and field-numbering.
This overrides \fB\-number_fields\fR and \fB\-number_links\fR.
.TP
.B \-nopause
disable forced pauses for statusline messages.
.TP
.B \-noprint
disable most print functions.
.TP
.B \-noredir
prevents automatic redirection and prints a message with a
link to the new URL.
.TP
.B \-noreferer
disable transmissions of Referer headers.
.TP
.B \-noreverse
disable reverse video-attribute.
.TP
.B \-nosocks
disable SOCKS proxy usage by a SOCKSified \fILynx\fP.
.TP
.B \-nostatus
disable the retrieval status messages.
.TP
.B \-notitle
disable title and blank line from top of page.
.TP
.B \-nounderline
disable underline video-attribute.
.TP
.B \-number_fields
force numbering of links as well as form input fields
.TP
.B \-number_links
force numbering of links.
.TP
.B \-partial
toggles display partial pages while loading.
.TP
.B \-partial_thres\fR=\fINUMBER
number of lines to render before repainting display
with partial-display logic
.TP
.B \-passive_ftp
toggles passive ftp connections.
.TP
.B \-pauth\fR=\fIID\fR:\fIPASSWD
set authorization ID and password for a protected proxy server at startup.
Be sure to protect any script files which use this switch.
.TP
.B \-popup
toggles handling of single-choice SELECT options via
popup windows or as lists of radio buttons.
.TP
.B \-post_data
properly formatted data for a \fIpost\fP form are read in from
the standard input and passed to the form.
Input is terminated by a line that starts with \*(``\-\-\-\*(''.
.IP
\fILynx\fP issues an HTTP \fBPOST\fP,
sending the form to the path or URL given on the
command-line and prints the response of the server.
If no path or URL is given, \fILynx\fP sends the form to the start-page.
.TP
.B \-preparsed
show HTML source preparsed and reformatted when used with \fB\-source\fR
or in source view.
.TP
.B \-prettysrc
show HTML source view with lexical elements and tags in color.
.TP
.B \-print
enable print functions.
(default)
.TP
.B \-pseudo_inlines
toggles pseudo-ALTs for inline images with no ALT string.
.TP
.B \-raw
toggles default setting of 8-bit character translations
or CJK mode for the startup character set.
.TP
.B \-realm
restricts access to URLs in the starting realm.
.TP
.B \-read_timeout\fR=\fIN
Sets the read-timeout, where N is given in seconds.
.TP
.B \-reload
flushes the cache on a proxy server
(only the first document given on the command-line is affected).
.TP
.B \-restrictions\fR=\fI[option][,option][,option]...
allows a list of services to be disabled selectively.
Dashes and underscores in option names can be intermixed.
The following list is printed if no options are specified.
.RS
.TP 3
.B all
restricts all options listed below.
.TP
.B bookmark
disallow changing the location of the bookmark
file.
.TP
.B bookmark_exec
disallow execution links via the bookmark file.
.TP
.B change_exec_perms
disallow changing the eXecute permission on files
(but still allow it for directories) when local file
management is enabled.
.TP
.B default
same as command line option \fB\-anonymous\fR.
Disables default services for anonymous users.
Set to all restricted, except for:
inside_telnet, outside_telnet,
inside_ftp, outside_ftp,
inside_rlogin, outside_rlogin,
inside_news, outside_news, telnet_port,
jump, mail, print, exec, and goto.
The settings for these,
as well as additional goto restrictions for
specific URL schemes that are also applied,
are derived from definitions within userdefs.h.
.TP
.B dired_support
disallow local file management.
.TP
.B disk_save
disallow saving to disk in the download and
print menus.
.TP
.B dotfiles
disallow access to, or creation of, hidden (dot) files.
.TP
.B download
disallow some downloaders in the download menu (does not
imply disk_save restriction).
.TP
.B editor
disallow external editing.
.TP
.B exec
disable execution scripts.
.TP
.B exec_frozen
disallow the user from changing the local
execution option.
.TP
.B externals
disallow some \*(``EXTERNAL\*('' configuration lines
if support for passing URLs to external
applications (with the EXTERN command) is
compiled in.
.TP
.B file_url
disallow using \fBG)oto\fP, served links or bookmarks for
file: URLs.
.TP
.B goto
disable the \*(``g\*('' (goto) command.
.TP
.B inside_ftp
disallow ftps for people coming from inside your
domain (utmp required for selectivity).
.TP
.B inside_news
disallow USENET news posting for people coming
from inside your domain (utmp required for selectivity).
.TP
.B inside_rlogin
disallow rlogins for people coming from inside
your domain (utmp required for selectivity).
.TP
.B inside_telnet
disallow telnets for people coming from inside
your domain (utmp required for selectivity).
.TP
.B jump
disable the \*(``j\*('' (jump) command.
.TP
.B multibook
disallow multiple bookmarks.
.TP
.B mail
disallow mail.
.TP
.B news_post
disallow USENET News posting.
.TP
.B options_save
disallow saving options in \&.lynxrc.
.TP
.B outside_ftp
disallow ftps for people coming from outside your
domain (utmp required for selectivity).
.TP
.B outside_news
disallow USENET news reading and posting for people coming
from outside your domain (utmp required for selectivity).
This restriction applies to \*(``news\*('', \*(``nntp\*('', \*(``newspost\*('', and
\*(``newsreply\*('' URLs, but not to \*(``snews\*('', \*(``snewspost\*('',
or \*(``snewsreply\*('' in case they are supported.
.TP
.B outside_rlogin
disallow rlogins for people coming from outside
your domain (utmp required for selectivity).
.TP
.B outside_telnet
disallow telnets for people coming from
outside your domain (utmp required for selectivity).
.TP
.B print
disallow most print options.
.TP
.B shell
disallow shell escapes and lynxexec or lynxprog \fBG)oto\fP's.
.TP
.B suspend
disallow Unix Control-Z suspends with escape to shell.
.TP
.B telnet_port
disallow specifying a port in telnet \fBG)oto\fP's.
.TP
.B useragent
disallow modifications of the User-Agent header.
.RE
.TP
.B \-resubmit_posts
toggles forced resubmissions (no-cache) of forms with
method POST when the documents they returned are sought
with the PREV_DOC command or from the History List.
.TP
.B \-rlogin
disable recognition of rlogin commands.
.TP
.B \-scrollbar
toggles showing scrollbar.
.TP
.B \-scrollbar_arrow
toggles showing arrows at ends of the scrollbar.
.TP
.B \-selective
require \&.www_browsable files to browse directories.
.TP
.B \-session\fR=\fIFILENAME
resumes from specified file on startup and saves session to that file on exit.
.TP
.B \-sessionin\fR=\fIFILENAME
resumes session from specified file.
.TP
.B \-sessionout\fR=\fIFILENAME
saves session to specified file.
.TP
.B \-short_url
show very long URLs in the status line with \*(``...\*('' to represent the
portion which cannot be displayed.
The beginning and end of the URL are displayed, rather than suppressing the end.
.TP
.B \-show_cfg
Print the configuration settings, e.g., as read from \*(``lynx.cfg\*('', and exit.
.TP
.B \-show_cursor
If enabled the cursor will not be hidden in the right hand
corner but will instead be positioned at the start of the
currently selected link.
Show cursor is the default for systems without FANCY_CURSES capabilities.
The default configuration can be changed in userdefs.h or lynx.cfg.
The command line switch toggles the default.
.TP
.B \-show_rate
If enabled the transfer rate is shown in bytes/second.
If disabled, no transfer rate is shown.
Use lynx.cfg or the options menu to select KB/second and/or ETA.
.TP
.B \-soft_dquotes
toggles emulation of the old Netscape and Mosaic bug which
treated \*(``>\*('' as a co-terminator for double-quotes and tags.
.TP
.B \-source
works the same as dump but outputs HTML source instead of
formatted text.
For example
.NS
lynx \-source . >foo.html
.NE
.IP
generates HTML source listing the files in the current directory.
Each file is marked by an HREF relative to the parent directory.
Add a trailing slash to make the HREF's relative to the current directory:
.NS
lynx \-source ./ >foo.html
.NE
.TP
.B \-stack_dump
disable SIGINT cleanup handler
.TP
.B \-startfile_ok
allow non-http startfile and homepage with \fB\-validate\fR.
.TP
.B \-stderr
When dumping a document using \fB\-dump\fR or \fB\-source\fR,
\fILynx\fP normally does not display alert (error)
messages that you see on the screen in the status line.
Use the \fB\-stderr\fR option to tell \fILynx\fP to write these messages
to the standard error.
.TP
.B \-stdin
read the startfile from standard input
(UNIX only).
.TP
.B \-syslog\fR=\fItext
information for syslog call.
.TP
.B \-syslog_urls
log requested URLs with syslog.
.TP
.B \-tagsoup
initialize parser, using Tag Soup DTD rather than SortaSGML.
.TP
.B \-telnet
disable recognition of telnet commands.
.TP
.B \-term\fR=\fITERM
tell \fILynx\fP what terminal type to assume it is talking to.
(This may be useful for remote execution, when, for example,
\fILynx\fP connects to a remote TCP/IP port that starts a script that,
in turn, starts another \fILynx\fP process.)
.TP
.B \-timeout\fR=\fIN
For win32, sets the network read-timeout, where N is given in seconds.
.TP
.B \-tlog
toggles between using a \fILynx\fP Trace Log and stderr for trace output
from the session.
.TP
.B \-tna
turns on \*(``Textfields Need Activation\*('' mode.
.TP
.B \-trace
turns on \fILynx\fP trace mode.
Destination of trace output depends
on \-tlog.
.TP
.B \-trace_mask\fR=\fIvalue
turn on optional traces, which may result in very large trace files.
Logically OR the values to combine options:
.RS
.TP 3
.B 1
SGML character parsing states
.TP
.B 2
color-style
.TP
.B 4
TRST (table layout)
.TP
.B 8
configuration (lynx.cfg, \&.lynxrc, \&.lynx-keymaps, mime.types and mailcap contents)
.TP
.B 16
binary string copy/append, used in form data construction.
.TP
.B 32
cookies
.TP
.B 64
character sets
.TP
.B 128
GridText parsing
.TP
.B 256
timing
.RE
.TP
.B \-traversal
traverse all http links derived from startfile.
When used with
\fB\-crawl\fR, each link that begins with the same string as startfile
is output to a file, intended for indexing.
.IP
See CRAWL.announce for more information.
.TP
.B \-trim_input_fields
trim input text/textarea fields in forms.
.TP
.B \-underline_links
toggles use of underline/bold attribute for links.
.TP
.B \-underscore
toggles use of _underline_ format in dumps.
.TP
.B \-unique_urls
check for duplicate link numbers in
each page and corresponding lists,
and reuse the original link number.
.TP
.B \-use_mouse
turn on mouse support, if available.
Clicking the left mouse button on a link traverses it.
Clicking the right mouse button pops back.
Click on the top line to scroll up.
Click on the bottom line to scroll down.
The first few positions in the top and bottom line may invoke
additional functions.
\fILynx\fP must be compiled with \fBncurses\fR or \fBslang\fR to support this feature.
If \fBncurses\fR is used, clicking the middle mouse button pops up
a simple menu.
Mouse clicks may only work reliably while \fILynx\fP is
idle waiting for input.
.TP
.B \-useragent=Name
set alternate \fILynx\fP User-Agent header.
.TP
.B \-validate
accept only http URLs (for validation).
Complete security restrictions also are implemented.
.TP
.B \-verbose
toggle [LINK], [IMAGE] and [INLINE] comments with filenames of these images.
.TP
.B \-version
print version information, and exit.
.TP
.B \-vikeys
enable vi-like key movement.
.TP
.B \-wdebug
enable Waterloo tcp/ip packet debug (print to watt debugfile).
This applies only to DOS versions compiled with WATTCP or WATT-32.
.TP
.B \-width\fR=\fINUMBER
number of columns for formatting of dumps, default is 80.
This is limited by the number of columns that \fILynx\fP could display,
typically 1024 (the \fIMAX_LINE\fP symbol).
.TP
.B \-with_backspaces
emit backspaces in output if \fB\-dump\fR'ing or \fB\-crawl\fR'ing
(like \fBman\fP does)
.TP
.B \-xhtml_parsing
tells \fILynx\fP that it can ignore certain tags which have no content
in an XHTML 1.0 document.
For example \*(``<p/>\*('' will be discarded.
.SH COMMANDS
.PP
More than one key can be mapped to a given command.
Here are some of the most useful:
.bP
Use \fBUp arrow\fR and \fBDown arrow\fR to scroll through hypertext links.
.bP
\fBRight arrow\fR or \fBReturn\fR will follow a highlighted hypertext link.
.bP
\fBLeft Arrow\fR or \*(``\fBu\fR\*('' will retreat from a link.
.bP
Type \*(``\fBH\fR\*('', \*(``\fB?\fR\*('', or \fBF1\fR for online help and descriptions
of key-stroke commands.
.bP
Type \*(``\fBk\fR\*('' or \*(``\fBK\fR\*('' for a list of the current key-stroke
command mappings.
.IP
If the same command is mapped to the same letter differing only
by upper/lowercase only the lowercase mapping is shown.
.bP
Type \fBDelete\fR to view history list.
.SH ENVIRONMENT
In addition to various \*(``standard\*('' environment variables such as
\fBHOME\fR, \fBPATH\fR, \fBUSER\fR, \fBDISPLAY\fR, \fBTMPDIR\fR, \fBetc\fR,
\fILynx\fR utilizes several \fILynx\fP-specific environment variables, if they
exist.
.PP
Others may be created or modified by \fILynx\fR to pass data to an external
program, or for other reasons.
These are listed separately below.
.PP
See also the sections on \fBSIMULATED CGI SUPPORT\fR and
\fBNATIVE LANGUAGE SUPPORT\fR, below.
.PP
Note:  Not all environment variables apply to all types of platforms
supported by \fILynx\fR, though most do.
Feedback on platform dependencies is solicited.
.PP
Environment Variables Used By \fILynx\fR:
.TP 20
.B COLORTERM
If set, color capability for the terminal is forced on at startup time.
The actual value assigned to the variable is ignored.
This variable is only meaningful if \fILynx\fR was built using the \fBslang\fR
screen-handling library.
.TP
.B LYNX_CFG
This variable, if set, will override the default location and name of
the global configuration file (normally, \fBlynx.cfg\fR) that was defined
by the LYNX_CFG_FILE constant in the userdefs.h file, during installation.
.IP
See the userdefs.h file for more information.
.TP
.B LYNX_CFG_PATH
If set, this variable overrides the compiled-in search-list of directories
used to find the configuration files, e.g., \fBlynx.cfg\fP and \fBlynx.lss\fP.
The list is delimited with ":" (or ";" for Windows) like the \fBPATH\fP
environment variable.
.TP
.B LYNX_HELPFILE
If set, this variable overrides the compiled-in URL and configuration
file URL for the \fILynx\fP help file.
.TP
.B LYNX_LOCALEDIR
If set, this variable overrides the compiled-in location of the
locale directory which contains native language (NLS) message text.
.TP
.B LYNX_LSS
This variable, if set, specifies the location of the default \fILynx\fR
character style sheet file.
[Currently only meaningful if \fILynx\fR was
built using curses color style support.]
.TP
.B LYNX_SAVE_SPACE
This variable, if set, will override the default path prefix for files
saved to disk that is defined in the \fBlynx.cfg SAVE_SPACE:\fR statement.
.IP
See the \fBlynx.cfg\fR file for more information.
.TP
.B LYNX_TEMP_SPACE
This variable, if set, will override the default path prefix for temporary
files that was defined during installation, as well as any value that may
be assigned to the \fBTMPDIR\fR variable.
.TP
.B MAIL
This variable specifies the default inbox \fILynx\fR will check for new
mail, if such checking is enabled in the \fBlynx.cfg\fR file.
.TP
.B NEWS_ORGANIZATION
This variable, if set, provides the string used in the \fBOrganization:\fR
header of \fBUSENET\fR news postings.
It will override the setting of the
ORGANIZATION environment variable, if it is also set (and, on \fBUNIX\fR,
the contents of an /etc/organization file, if present).
.TP
.B NNTPSERVER
If set, this variable specifies the default NNTP server that will be used
for \fBUSENET\fR news reading and posting with \fILynx\fR, via news: URL's.
.TP
.B ORGANIZATION
This variable, if set, provides the string used in the \fBOrganization:\fR
header of \fBUSENET\fR news postings.
On \fBUNIX\fR, it will override the
contents of an /etc/organization file, if present.
.TP
.I PROTOCOL\fB_proxy\fR
\fILynx\fR supports the use of proxy servers that can act as firewall
gateways and caching servers.
They are preferable to the older gateway
servers (see WWW_access_GATEWAY, below).
.IP
Each protocol used by \fILynx\fR,
(http, ftp, gopher, etc), can be mapped separately by setting environment
variables of the form \fIPROTOCOL\fP_proxy.
Protocols are indicated in a URI by the name before \*(``:\*('', e.g.,
\*(``http\*('' in 
\*(``http://some.server.dom:port/\*('' for HTML. 
.IP
Depending on your system configuration and supported protocols,
the environment variables recognized by \fIlynx\fP may include
.NS
cso_proxy
finger_proxy
ftp_proxy
gopher_proxy
https_proxy
http_proxy
newspost_proxy
newsreply_proxy
news_proxy
nntp_proxy
no_proxy
snewspost_proxy
snewsreply_proxy
snews_proxy
wais_proxy
.NE
.IP
See \fBLynx Users Guide\fR for additional details and examples.
.TP
.B SSL_CERT_DIR
Set to the directory containing trusted certificates.
.TP
.B SSL_CERT_FILE
Set to the full path and filename for your file of trusted certificates.
.TP
.B WWW_\fIaccess\fB_GATEWAY
\fILynx\fR still supports use of gateway servers, with the servers specified
via \*(``WWW_\fIaccess\fP_GATEWAY\*('' variables
(where \*(``\fIaccess\fP\*('' is lower case and can be
\*(``http\*('', \*(``ftp\*('', \*(``gopher\*('' or \*(``wais\*('').
However most gateway servers have been discontinued.
Note that you do not include a terminal \*(``/\*('' for gateways, but
do for proxies specified by \fIPROTOCOL\fP_proxy environment variables.
.IP
See \fBLynx Users Guide\fR for details.
.TP
.B WWW_HOME
This variable, if set, will override the default startup URL specified
in any of the \fILynx\fR configuration files.
.PP
Environment Variables \fBSet\fR or \fBModified\fR By \fILynx\fR:
.TP 20
.B LYNX_PRINT_DATE
This variable is set by the \fILynx\fR p(rint) function, to the
\fBDate:\fR
string seen in the document's \*(``\fBInformation about\fR\*('' page (= cmd),
if any.
It is created for use by an external program, as defined in a
\fBlynx.cfg PRINTER:\fR definition statement.
If the field does not exist for the document, the variable is set to a
null string under \fBUNIX\fR, or \*(``No Date\*('' under \fBVMS\fR.
.TP
.B LYNX_PRINT_LASTMOD
This variable is set by the \fILynx\fR p(rint) function, to the
\fBLast Mod:\fR
string seen in the document's \*(``\fBInformation about\fR\*('' page (= cmd),
if any.
It is created for use by an external program, as defined in a
\fBlynx.cfg PRINTER:\fR definition statement.
If the field does not exist for the document, the variable is set to a
null string under \fBUNIX\fR, or \*(``No LastMod\*('' under \fBVMS\fR.
.TP
.B LYNX_PRINT_TITLE
This variable is set by the \fILynx\fR p(rint) function, to the
\fBLinkname:\fR
string seen in the document's \*(``\fBInformation about\fR\*('' page (= cmd),
if any.
It is created for use by an external program, as defined in a
\fBlynx.cfg PRINTER:\fR definition statement.
If the field does not exist for the document, the variable is set to a
null string under \fBUNIX\fR, or \*(``No Title\*('' under \fBVMS\fR.
.TP
.B LYNX_PRINT_URL
This variable is set by the \fILynx\fR p(rint) function, to the
\fBURL:\fR
string seen in the document's \*(``\fBInformation about\fR\*('' page (= cmd),
if any.
It is created for use by an external program, as defined in a
\fBlynx.cfg PRINTER:\fR definition statement.
If the field does not exist for the document, the variable is set to a
null string under \fBUNIX\fR, or \*(``No URL\*('' under \fBVMS\fR.
.TP
.B LYNX_TRACE
If set, causes \fILynx\fR to write a trace file as if the \fB\-trace\fR
option were supplied.
.TP
.B LYNX_TRACE_FILE
If set, overrides the compiled-in name of the trace file,
which is either \fBLynx.trace\fP or \fBLY\-TRACE.LOG\fP
(the latter on the DOS/Windows platforms).
The trace file is in either case relative to the home directory.
.TP
.B LYNX_VERSION
This variable is always set by \fILynx\fR, and may be used by an external
program to determine if it was invoked by \fILynx\fR.
.IP
See also the comments
in the distribution's sample \fBmailcap\fR file, for notes on usage in such
a file.
.TP
.B TERM
Normally, this variable is used by \fILynx\fR to determine the terminal type
being used to invoke \fILynx\fR.
If, however, it is unset at startup time
(or has the value \*(``unknown\*(''),
or if the \fB\-term\fR command-line option is used (see \fBOPTIONS\fR section
above), \fILynx\fR will set or modify its value to the user specified
terminal type (for the \fILynx\fR execution environment).
Note: If set/modified by \fILynx\fR, the values of the \fBLINES\fR and/or
\fBCOLUMNS\fR environment variables may also be changed.
.SH SIMULATED CGI SUPPORT
If built with the \fBcgi-links\fR option enabled, \fILynx\fR allows access
to a cgi script directly without the need for an http daemon.
.PP
When executing such \*(``lynxcgi scripts\*('' (if enabled), the following variables
may be set for simulating a CGI environment:
.PP
.B CONTENT_LENGTH
.PP
.B CONTENT_TYPE
.PP
.B DOCUMENT_ROOT
.PP
.B HTTP_ACCEPT_CHARSET
.PP
.B HTTP_ACCEPT_LANGUAGE
.PP
.B HTTP_USER_AGENT
.PP
.B PATH_INFO
.PP
.B PATH_TRANSLATED
.PP
.B QUERY_STRING
.PP
.B REMOTE_ADDR
.PP
.B REMOTE_HOST
.PP
.B REQUEST_METHOD
.PP
.B SERVER_SOFTWARE
.PP
Other environment variables are not inherited by the script, unless they
are provided via a LYNXCGI_ENVIRONMENT statement in the configuration file.
See the \fBlynx.cfg\fR file, and the (draft) CGI 1.1 Specification
<http://Web.Golux.Com/coar/cgi/draft-coar-cgi-v11-00.txt> for the
definition and usage of these variables.
.PP
The CGI Specification, and other associated documentation, should be consulted
for general information on CGI script programming.
.SH NATIVE LANGUAGE SUPPORT
If configured and installed with \fBNative Language Support\fR, \fILynx\fR
will display status and other messages in your local language.
See the
file \fBABOUT_NLS\fR in the source distribution, or at your local \fBGNU\fR
site, for more information about internationalization.
.PP
The following environment variables may be used to alter default settings:
.TP 20
.B LANG
This variable, if set, will override the default message language.
It is an \fBISO 639\fR two-letter code identifying the language.
Language codes are \fBNOT\fR the same
as the country codes given in \fBISO 3166\fR.
.TP
.B LANGUAGE
This variable, if set, will override the default message language.
This is a \fBGNU\fR extension that has higher priority for setting
the message catalog than \fBLANG\fR or \fBLC_ALL\fR.
.TP
.B LC_ALL
and
.TP
.B LC_MESSAGES
These variables, if set, specify the notion of native language
formatting style.
They are \fBPOSIXly\fR correct.
.TP
.B LINGUAS
This variable, if set prior to configuration, limits the installed
languages to specific values.
It is a space-separated list of two-letter codes.
Currently, it is hard-coded to a wish list.
.TP
.B NLSPATH
This variable, if set, is used as the path prefix for message catalogs.
.SH NOTES
This is the \fILynx\fP v2.8.8 Release; development is in progress for 2.8.9.
.PP
If you wish to contribute to the further development
of \fILynx\fR, subscribe to our mailing list.
Send email to
<lynx-dev-request@nongnu.org> with \*(``subscribe lynx-dev\*('' as the only line
in the body of your message.
.PP
Send bug reports, comments, suggestions to <lynx-dev@nongnu.org>
after subscribing.
.PP
Unsubscribe by sending email to <lynx-dev-request@nongnu.org> with
\*(``unsubscribe lynx-dev\*('' as the only line in the body of your message.
Do not send the unsubscribe message to the lynx-dev list, itself.
.SH SEE ALSO
.hy 0
\fIcatgets\fR(3),
\fIcurses\fR(3),
\fIenviron\fR(7),
\fIexecve\fR(2),
\fIftp\fR(1),
\fIgettext\fR(GNU),
\fIlocaleconv\fR(3),
\fIncurses\fR(3),
\fIsetlocale\fR(3),
\fIslang\fR(?),
\fItermcap\fR(5),
\fIterminfo\fR(5),
\fIwget\fR(GNU)
.hy 1
.PP
Note that man page availability and section numbering is somewhat
platform dependent, and may vary from the above references.
.PP
A section shown as (GNU), is intended to denote that the topic
may be available via an info page, instead of a man page (i.e., try
\*(``info subject\*('', rather than \*(``man subject\*('').
.PP
A section shown as \fB(?)\fP denotes that documentation on the topic exists,
but is not part of an established documentation retrieval system (see
the distribution files associated with the topic, or contact your
System Administrator for further information).
.SH ACKNOWLEDGMENTS
\fILynx\fP has incorporated code from a variety of sources along the way.
The earliest versions of \fILynx\fP included code from Earl Fogel of Computing
Services at the University of Saskatchewan, who implemented HYPERREZ
in the Unix environment.
HYPERREZ was developed by Niel Larson of
Think.com and served as the model for the early versions of \fILynx\fP.
Those versions also incorporated libraries from the Unix Gopher clients
developed at the University of Minnesota, and the later versions of
\fILynx\fP rely on the WWW client library code developed by Tim Berners-Lee
and the WWW community.
Also a special thanks to Foteos Macrides who ported
much of \fILynx\fP to VMS and did or organized most of its development since the
departures of Lou Montulli and Garrett Blythe from the University of Kansas
in the summer of 1994 through the release of v2.7.2, and to everyone
on the net who has contributed to \fILynx\fP's development either directly (through
patches, comments or bug reports) or indirectly (through inspiration and
development of other systems).
.SH AUTHORS
Lou Montulli, Garrett Blythe, Craig Lavender, Michael Grobe, Charles Rezac
.br
Academic Computing Services
.br
University of Kansas
.br
Lawrence, Kansas 66047
.PP
Foteos Macrides
.br
Worcester Foundation for Biomedical Research
.br
Shrewsbury, Massachusetts 01545
.PP
Thomas E.\& Dickey
.br
<dickey@invisible-island.net>
