/*
   Copyright 1999-2002,2010, Thomas E. Dickey

   Copyright (c) 1993,1994, Joseph Arceneaux.  All rights reserved.

   This file is subject to the terms of the GNU General Public License as
   published by the Free Software Foundation.  A copy of this license is
   included with this software distribution in the file COPYING.  If you
   do not have a copy, you may obtain a copy by writing to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details. */

#ifndef INDENT_SYS_H
#define INDENT_SYS_H 1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#if defined (HAVE_UNISTD_H)
#include <unistd.h>
#endif

/* Values of special characters. */
#define TAB '\t'
#define EOL '\n'
#define FORM_FEED '\014'
#define BACKSLASH '\\'
#define NULL_CHAR '\0'

#ifndef isblank
#undef  isblank
#define isblank(c) ((c) == ' ' || (c) == TAB)
#endif

#define isName(c)  (isalnum(UChar(c)) || (c) == '_' || (c) == '$')

#ifdef VMS
# define ONE_DOT_PER_FILENAME 1
# define NODIR 1
# define PROFILE_FORMAT "%s%s"
# define BACKUP_SUFFIX_STR    "_"
# define BACKUP_SUFFIX_CHAR   '_'
# define BACKUP_SUFFIX_FORMAT "%s._%d_"
# define SYS_READ vms_read	/* Defined in io.c */
# ifdef VAXC
#  include <unixio.h>
# endif
#endif /* VMS */

/* Contributed by Beverly Brown, <beverly@norton.datacube.com> */
#ifdef _WIN32
# define USG 1
# define NODIR 1
#endif /* _WIN32 */

struct file_buffer
  {
    char *name;
    size_t size;
    char *data;
  };

extern struct file_buffer *read_file (const char *);
extern struct file_buffer *read_stdin (void);

#endif /* INDENT_SYS_H */
