/*
 * Some or all of this work - Copyright (c) 2006 - 2011, Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * Neither the name of Intel Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Method execution control
 *
 * Switch, Case(Package), Default operators
 */

Name(z073, 73)

Name(ppee, Package() {6,7,8,9})

// The same as m0df and m0e0 but all the values
// of Cases are in one Package
Method(m100, 1)
{
	Switch (arg0) {

		Case (Package() {

		// Buffer

		Buffer(1){10},
		Buffer(2){11,12},
		Buffer() {13,14,15},
		Buffer(2){16,17,18},
		Buffer(3){19,20},
		Buffer(3){21,22,23},
		Buffer(4){24,25,26,27},
		Buffer(5){28,29,30,31,32},
		Buffer(8){33,34,35,36,37,38,39,40},
		Buffer(){0x12,0x34,0x56,0x78,0x9a,0xbc,0xde,0xf0},
		Buffer(9){41,42,43,44,45,46,47,48,49},
		Buffer(67){0x7d},
		Buffer() {
			0x00,0x00,0x02,0x03,0x04,0x05,0x06,0x07,
			0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
			0x00,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
			0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
			0x10,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
			0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
			0x20,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
			0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
			0x30,0x41,0x42},
		Buffer(67) {
			0x00,0x00,0x02,0x03,0x04,0x05,0x06,0x07,
			0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
			0x00,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
			0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
			0x10,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
			0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
			0x20,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
			0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
			0x30,0x41,0x42},
		Buffer(4){0,0,0,0},
		Buffer(8){0,0,0,0,0,0,0,0},
		Buffer(4){0xff,0xff,0xff,0xff},
		Buffer(9){0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
		Buffer(8){0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
		Buffer(5){0xff,0xff,0xff,0xff,0xff},
		Buffer(1){0xff},
		Buffer(1){},
		Buffer(5){},
		Buffer(9){},
		Buffer(9){0xab, 0xcd, 0xef},

		// String

		"0321",
		"321",
		"ba9876",
		"c179b3fe",
		"fe7cb391d650a284",
		"ffffffff",
		"ffffffffffffffff",
		"ffffffffff",
		"ff",
		"987654321",
		"0xfe7cb3",

		// Integer

		0321,
		9876543210,
		0xc179b3fe,
		0xfe7cb391d650a284,
		0,
		0xffffffff,
		0xffffffffffffffff,
		0xff,
		0xabcdef
		}) {
			Store(5, Local7)
		}

		Default {
			Store(7, Local7)
		}
	}

	return (Local7)
}

Method(m101, 1)
{
	// Integer

	Store(m100(0321), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 0, 0, 0, Local0, 5)
	}
	Store(m100(0xd1), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 1, 0, 0, Local0, 5)
	}

	Store(m100(9876543210), Local0)
	if (F64) {
		if (LNotEqual(Local0, 5)) {
			err(arg0, z073, 2, 0, 0, Local0, 5)
		}
	} else {
		if (LNotEqual(Local0, 5)) {
			err(arg0, z073, 3, 0, 0, Local0, 5)
		}
	}
	Store(m100(0xc179b3fe), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 4, 0, 0, Local0, 5)
	}
	Store(m100(0xfe7cb391d650a284), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 5, 0, 0, Local0, 5)
	}
	Store(m100(0), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 6, 0, 0, Local0, 5)
	}
	Store(m100(0xffffffff), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 7, 0, 0, Local0, 5)
	}
	Store(m100(0xffffffffffffffff), Local0)
	if (F64) {
		if (LNotEqual(Local0, 5)) {
			err(arg0, z073, 8, 0, 0, Local0, 5)
		}
	} else {
		if (LNotEqual(Local0, 5)) {
			err(arg0, z073, 9, 0, 0, Local0, 5)
		}
	}
	Store(m100(0xff), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 10, 0, 0, Local0, 5)
	}
	Store(m100(0xabcdef), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 11, 0, 0, Local0, 5)
	}
}

// The same as m0e3 and m0e4 but all the values
// of Cases are in one Package
Method(m102, 1)
{
	Switch (ToString(arg0)) {

		Case (Package() {

		// Integer

		0321,
		9876543210,
		0xc179b3fe,
		0xfe7cb391d650a284,
		0,
		0xffffffff,
		0xffffffffffffffff,
		0xff,
		0xabcdef,

		// Buffer

		Buffer(1){10},
		Buffer(2){11,12},
		Buffer() {13,14,15},
		Buffer(2){16,17,18},
		Buffer(3){19,20},
		Buffer(3){21,22,23},
		Buffer(4){24,25,26,27},
		Buffer(5){28,29,30,31,32},
		Buffer(8){33,34,35,36,37,38,39,40},
		Buffer(){0x12,0x34,0x56,0x78,0x9a,0xbc,0xde,0xf0},
		Buffer(9){41,42,43,44,45,46,47,48,49},
		Buffer(67){0x7d},
		Buffer() {
			0x00,0x00,0x02,0x03,0x04,0x05,0x06,0x07,
			0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
			0x00,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
			0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
			0x10,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
			0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
			0x20,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
			0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
			0x30,0x41,0x42},
		Buffer(67) {
			0x00,0x00,0x02,0x03,0x04,0x05,0x06,0x07,
			0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
			0x00,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
			0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
			0x10,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
			0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
			0x20,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
			0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
			0x30,0x41,0x42},
		Buffer(4){0,0,0,0},
		Buffer(8){0,0,0,0,0,0,0,0},
		Buffer(4){0xff,0xff,0xff,0xff},
		Buffer(9){0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
		Buffer(8){0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
		Buffer(5){0xff,0xff,0xff,0xff,0xff},
		Buffer(1){0xff},
		Buffer(1){},
		Buffer(5){},
		Buffer(9){},
		Buffer(9){0xab, 0xcd, 0xef},

		// String

		"0321",
		"321",
		"ba9876",
		"c179b3fe",
		"fe7cb391d650a284",
		"ffffffff",
		"ffffffffffffffffff",
		"ffffffffffffffff",
		"ffffffffff",
		"ff",
		"fe7cb391d650a2841",
		"987654321",
		"0xfe7cb3",
		"1234q",
		"qwertyuiopasdfghjklzxcvbnm1234567890QWERTYUIOPASDFGHJKLZXCVBNMqwertyuiopasdfghjklzxcvbnm1234567890QWERTYUIOPASDFGHJKLZXCVBNMqwertyuiopasdfghjklzxcvbnm1234567890QWERTYUIOPASDFGHJKLZXCVBNMqwertyuiopasdf",
		"",
		" ",
		"`1234567890-=qwertyuiop[]\\asdfghjkl;'zxcvbnm,./~!@#$%^&*()_+QWERTYUIOP{}|ASDFGHJKL:\"ZXCVBNM<>?",
		"abcdef",
		"ABCDEF",
		}) {
			Store(5, Local7)
		}

		Default {
			Store(7, Local7)
		}
	}

	return (Local7)
}

Method(m103, 1)
{
	// String

	Store(m102("0321"), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 12, 0, 0, Local0, 5)
	}
	Store(m102("321"), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 13, 0, 0, Local0, 5)
	}
	Store(m102("ba9876"), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 14, 0, 0, Local0, 5)
	}
	Store(m102("c179b3fe"), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 15, 0, 0, Local0, 5)
	}
	Store(m102("fe7cb391d650a284"), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 16, 0, 0, Local0, 5)
	}
	Store(m102("ffffffff"), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 17, 0, 0, Local0, 5)
	}
	Store(m102("ffffffffffffffffff"), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 18, 0, 0, Local0, 5)
	}
	Store(m102("ffffffffffffffff"), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 19, 0, 0, Local0, 5)
	}
	Store(m102("ffffffffff"), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 20, 0, 0, Local0, 5)
	}
	Store(m102("ff"), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 21, 0, 0, Local0, 5)
	}
	Store(m102("fe7cb391d650a2841"), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 22, 0, 0, Local0, 5)
	}
	Store(m102("987654321"), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 23, 0, 0, Local0, 5)
	}
	Store(m102("0xfe7cb3"), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 24, 0, 0, Local0, 5)
	}
	Store(m102("1234q"), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 25, 0, 0, Local0, 5)
	}
	Store(m102(BIG0), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 26, 0, 0, Local0, 5)
	}
	Store(m102(""), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 27, 0, 0, Local0, 5)
	}
	Store(m102(" "), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 28, 0, 0, Local0, 5)
	}
	Store(m102(ALL0), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 29, 0, 0, Local0, 5)
	}
	Store(m102("abcdef"), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 30, 0, 0, Local0, 5)
	}
	Store(m102("ABCDEF"), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 31, 0, 0, Local0, 5)
	}
}

// The same as m0e5 and m0e6 but all the values
// of Cases are in one Package
Method(m104, 1)
{
	Switch (ToBuffer(arg0)) {

		Case (Package() {

		// Integer

		0321,
		9876543210,
		0xc179b3fe,
		0xfe7cb391d650a284,
		0,
		0xffffffff,
		0xffffffffffffffff,
		0xff,
		0xabcdef,

		// String

		"0321",
		"321",
		"ba9876",
		"c179b3fe",
		"fe7cb391d650a284",
		"ffffffff",
		"ffffffffffffffffff",
		"ffffffffffffffff",
		"ffffffffff",
		"ff",
		"fe7cb391d650a2841",
		"987654321",
		"0xfe7cb3",
		"1234q",
		"qwertyuiopasdfghjklzxcvbnm1234567890QWERTYUIOPASDFGHJKLZXCVBNMqwertyuiopasdfghjklzxcvbnm1234567890QWERTYUIOPASDFGHJKLZXCVBNMqwertyuiopasdfghjklzxcvbnm1234567890QWERTYUIOPASDFGHJKLZXCVBNMqwertyuiopasdf",
		"",
		" ",
		"`1234567890-=qwertyuiop[]\\asdfghjkl;'zxcvbnm,./~!@#$%^&*()_+QWERTYUIOP{}|ASDFGHJKL:\"ZXCVBNM<>?",
		"abcdef",
		"ABCDEF",

		// Buffer

		Buffer(1){10},
		Buffer(2){11,12},
		Buffer() {13,14,15},
		Buffer(2){16,17,18},
		Buffer(3){19,20},
		Buffer(3){21,22,23},
		Buffer(4){24,25,26,27},
		Buffer(5){28,29,30,31,32},
		Buffer(8){33,34,35,36,37,38,39,40},
		Buffer(){0x12,0x34,0x56,0x78,0x9a,0xbc,0xde,0xf0},
		Buffer(9){41,42,43,44,45,46,47,48,49},
		Buffer(257){0x7d},
		Buffer(257) {
			// 0-127
			0x00,0x00,0x02,0x03,0x04,0x05,0x06,0x07,
			0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
			0x00,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
			0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
			0x10,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
			0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
			0x20,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
			0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
			0x30,0x41,0x42,0x43,0x44,0x45,0x46,0x47,
			0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
			0x40,0x51,0x52,0x53,0x54,0x55,0x56,0x57,
			0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
			0x50,0x61,0x62,0x63,0x64,0x65,0x66,0x67,
			0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
			0x60,0x71,0x72,0x73,0x74,0x75,0x76,0x77,
			0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,

			// 128-255
			0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,
			0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
			0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,
			0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
			0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,
			0xa8,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf,
			0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,
			0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
			0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,
			0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
			0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,
			0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf,
			0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,
			0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef,
			0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,
			0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff,
			// 256
			0x01},
		Buffer() {
			// 0-127
			0x00,0x00,0x02,0x03,0x04,0x05,0x06,0x07,
			0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
			0x00,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
			0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
			0x10,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
			0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
			0x20,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
			0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
			0x30,0x41,0x42,0x43,0x44,0x45,0x46,0x47,
			0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
			0x40,0x51,0x52,0x53,0x54,0x55,0x56,0x57,
			0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
			0x50,0x61,0x62,0x63,0x64,0x65,0x66,0x67,
			0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
			0x60,0x71,0x72,0x73,0x74,0x75,0x76,0x77,
			0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,

			// 128-255
			0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,
			0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
			0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,
			0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
			0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,
			0xa8,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf,
			0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,
			0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
			0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,
			0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
			0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,
			0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf,
			0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,
			0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef,
			0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,
			0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff,
			// 256
			0x02},
		Buffer(4){0,0,0,0},
		Buffer(8){0,0,0,0,0,0,0,0},
		Buffer(4){0xff,0xff,0xff,0xff},
		Buffer(9){0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
		Buffer(8){0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
		Buffer(5){0xff,0xff,0xff,0xff,0xff},
		Buffer(1){0xff},
		Buffer(1){},
		Buffer(5){},
		Buffer(9){},
		Buffer(9){0xab, 0xcd, 0xef},
		}) {
			Store(5, Local7)
		}

		Default {
			Store(7, Local7)
		}
	}

	return (Local7)
}

Method(m105, 1)
{
	// Buffer

	Store(m104(Buffer(1){10}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 32, 0, 0, Local0, 5)
	}
	Store(m104(Buffer(2){11,12}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 33, 0, 0, Local0, 5)
	}
	Store(m104(Buffer() {13,14,15}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 34, 0, 0, Local0, 5)
	}
	Store(m104(Buffer(2){16,17,18}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 35, 0, 0, Local0, 5)
	}
	Store(m104(Buffer(3){19,20}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 36, 0, 0, Local0, 5)
	}
	Store(m104(Buffer(3){21,22,23}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 37, 0, 0, Local0, 5)
	}
	Store(m104(Buffer(4){24,25,26,27}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 38, 0, 0, Local0, 5)
	}
	Store(m104(Buffer(5){28,29,30,31,32}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 39, 0, 0, Local0, 5)
	}
	Store(m104(Buffer(8){33,34,35,36,37,38,39,40}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 40, 0, 0, Local0, 5)
	}
	Store(m104(Buffer(){0x12,0x34,0x56,0x78,0x9a,0xbc,0xde,0xf0}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 41, 0, 0, Local0, 5)
	}
	Store(m104(Buffer(9){41,42,43,44,45,46,47,48,49}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 42, 0, 0, Local0, 5)
	}
	Store(m104(Buffer(257){0x7d}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 43, 0, 0, Local0, 5)
	}
	Store(m104(Buffer(257) {
			// 0-127
			0x00,0x00,0x02,0x03,0x04,0x05,0x06,0x07,
			0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
			0x00,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
			0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
			0x10,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
			0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
			0x20,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
			0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
			0x30,0x41,0x42,0x43,0x44,0x45,0x46,0x47,
			0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
			0x40,0x51,0x52,0x53,0x54,0x55,0x56,0x57,
			0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
			0x50,0x61,0x62,0x63,0x64,0x65,0x66,0x67,
			0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
			0x60,0x71,0x72,0x73,0x74,0x75,0x76,0x77,
			0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,

			// 128-255
			0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,
			0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
			0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,
			0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
			0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,
			0xa8,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf,
			0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,
			0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
			0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,
			0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
			0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,
			0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf,
			0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,
			0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef,
			0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,
			0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff,
			// 256
			0x01}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 44, 0, 0, Local0, 5)
	}
	Store(m104(Buffer() {
			// 0-127
			0x00,0x00,0x02,0x03,0x04,0x05,0x06,0x07,
			0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
			0x00,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
			0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
			0x10,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
			0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
			0x20,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
			0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
			0x30,0x41,0x42,0x43,0x44,0x45,0x46,0x47,
			0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
			0x40,0x51,0x52,0x53,0x54,0x55,0x56,0x57,
			0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
			0x50,0x61,0x62,0x63,0x64,0x65,0x66,0x67,
			0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
			0x60,0x71,0x72,0x73,0x74,0x75,0x76,0x77,
			0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,

			// 128-255
			0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,
			0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
			0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,
			0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
			0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,
			0xa8,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf,
			0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,
			0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
			0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,
			0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
			0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,
			0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf,
			0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,
			0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef,
			0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,
			0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff,
			// 256
			0x02}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 45, 0, 0, Local0, 5)
	}
	if (F64) {
		Store(m104(Buffer(4){0,0,0,0}), Local0)
		if (LNotEqual(Local0, 5)) {
			err(arg0, z073, 46, 0, 0, Local0, 5)
		}
		Store(m104(Buffer(8){0,0,0,0,0,0,0,0}), Local0)
		if (LNotEqual(Local0, 5)) {
			err(arg0, z073, 47, 0, 0, Local0, 5)
		}
		Store(m104(Buffer(4){0xff,0xff,0xff,0xff}), Local0)
		if (LNotEqual(Local0, 5)) {
			err(arg0, z073, 48, 0, 0, Local0, 5)
		}
		Store(m104(Buffer(8){0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff}), Local0)
		if (LNotEqual(Local0, 5)) {
			err(arg0, z073, 49, 0, 0, Local0, 5)
		}
	} else {
		Store(m104(Buffer(4){0,0,0,0}), Local0)
		if (LNotEqual(Local0, 5)) {
			err(arg0, z073, 50, 0, 0, Local0, 5)
		}
		Store(m104(Buffer(8){0,0,0,0,0,0,0,0}), Local0)
		if (LNotEqual(Local0, 5)) {
			err(arg0, z073, 51, 0, 0, Local0, 5)
		}
		Store(m104(Buffer(4){0xff,0xff,0xff,0xff}), Local0)
		if (LNotEqual(Local0, 5)) {
			err(arg0, z073, 52, 0, 0, Local0, 5)
		}
		Store(m104(Buffer(8){0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff}), Local0)
		if (LNotEqual(Local0, 5)) {
			err(arg0, z073, 53, 0, 0, Local0, 5)
		}
	}

	Store(m104(Buffer(9){0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 54, 0, 0, Local0, 5)
	}
	Store(m104(Buffer(5){0xff,0xff,0xff,0xff,0xff}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 55, 0, 0, Local0, 5)
	}
	Store(m104(Buffer(1){0xff}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 56, 0, 0, Local0, 5)
	}
	Store(m104(Buffer(1){}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 57, 0, 0, Local0, 5)
	}
	Store(m104(Buffer(5){}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 58, 0, 0, Local0, 5)
	}
	Store(m104(Buffer(9){}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 59, 0, 0, Local0, 5)
	}
	Store(m104(Buffer(9){0xab, 0xcd, 0xef}), Local0)
	if (LNotEqual(Local0, 5)) {
		err(arg0, z073, 60, 0, 0, Local0, 5)
	}
}

// Run-method
Method(SW10)
{
	Store("TEST: SW10, Switch, Case, Default operators", Debug)

	Name(ts, "SW10")

	m101(ts)
	m103(ts)
	m105(ts)

	return (0)
}
