/*
 * Some or all of this work - Copyright (c) 2006 - 2015, Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * Neither the name of Intel Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


/*

   ============================
   !!!!!!!!!!!!!!!!!!!!!!!!!!!!
   IT IS IN PROGRESS !!!!!!!!!!
   !!!!!!!!!!!!!!!!!!!!!!!!!!!!
   ============================

SEE: LEqual (and LGreater ?) tests were mostly checked for 64-bit mode only.
     Do that after ACPICA bugs are fixed.
SEE: what can be removed from m48b
*/

//
// Implicit Source Operand Conversion, complex test
//

Name(z065, 65)

// Acquire (mux, wrd) => Boolean
//
// Total scale of unacceptable types:
//    SyncObject: 0x5cff
// Total scale of acceptable types:
//    SyncObject: 0x0200
Method(m400, 1, Serialized)
{
	Name(op, 0)

	Name(ts, "m400")

	ts00(ts)

	if (arg0) {
		m486()
		Store(0x900, df00)
		Store(m488(op, 0x5cff, 0, 0, 0, 0), Local7)
	} else {

		Store(m48d(op, 0x900, 0, 0, 0, Zero, Zero), Local7)
		Store(m48d(op, 0x901, 0, 0, 0, Zero, Zero), Local7)
	}
}

// Add, check all unavailable non-hex symbols
Method(m4a2, 1, Serialized)
{
	Name(ts, "m4a2")

	Name(s000, "`-=qwrtyuiop[]\\sghjkl;'zxvnm,./~!@#$%^&*()_+QWRTYUIOP{}|SGHJKL:\"ZXVNM<>? ")

	Name(lpN0, 73)
	Name(lpC0, 0)

	While (lpN0) {

		Store(m4a1(s000, lpC0), Local0)

		Store(ObjectType(Local0), Local1)
		if (LNotEqual(Local1, 2)) {
			err(arg0, z065, 0, 0, 0, Local1, 2)
		} else {
			Store(SizeOf(Local0), Local1)
			if (LNotEqual(Local1, 1)) {
				err(arg0, z065, 1, 0, 0, Local1, 1)
			} else {
				CH03(ts, z065, 0, 0, 0)
				Add(Local0, 0, Local7)
				CH04(arg0, 0, 34, z065, 1, 0, 0)	// AE_BAD_HEX_CONSTANT

				CH03(ts, z065, 2, 0, 0)
				Add(0, Local0, Local7)
				CH04(arg0, 0, 34, z065, 3, 0, 0)	// AE_BAD_HEX_CONSTANT
			}
		}

		Store(Local0, Debug)

		Decrement(lpN0)
		Increment(lpC0)
	}
}

// Add, check all available hex symbols
Method(m4a4, 1, Serialized)
{
	Name(ts, "m4a4")

	Name(s000, "0123456789abcdefABCDEF")

	Name(lpN0, 22)
	Name(lpC0, 0)

	While (lpN0) {

		Store(m4a1(s000, lpC0), Local0)

		Store(ObjectType(Local0), Local1)
		if (LNotEqual(Local1, 2)) {
			err(arg0, z065, 2, 0, 0, Local1, 2)
		} else {
			Store(SizeOf(Local0), Local1)
			if (LNotEqual(Local1, 1)) {
				err(arg0, z065, 3, 0, 0, Local1, 1)
			} else {
				CH03(ts, z065, 4, 0, 0)
				Add(Local0, 0, Local7)
				CH03(ts, z065, 5, 0, 0)

				CH03(ts, z065, 6, 0, 0)
				Add(0, Local0, Local7)
				CH03(ts, z065, 7, 0, 0)
			}
		}

		Store(Local0, Debug)

		Decrement(lpN0)
		Increment(lpC0)
	}
}

// Add, checkings in accordance with the Table 1
Method(m4a0, 1, Serialized)
{
	Name(ts, "m4a0")

	ts00(ts)

	if (arg0) {

	CH03(ts, z065, 8, 0, 0)
	Add("fedcba98765432101", 0, Local7)
	CH04(ts, 0, 34, z065, 9, 0, 0)	// AE_BAD_HEX_CONSTANT

	CH03(ts, z065, 10, 0, 0)
	Add(0, "fedcba98765432101", Local7)
	CH04(ts, 0, 34, z065, 11, 0, 0)	// AE_BAD_HEX_CONSTANT

	CH03(ts, z065, 12, 0, 0)
	Add("1234q", 0, Local7)
	CH04(ts, 0, 34, z065, 13, 0, 0)	// AE_BAD_HEX_CONSTANT

	CH03(ts, z065, 14, 0, 0)
	Add(0, "1234q", Local7)
	CH04(ts, 0, 34, z065, 15, 0, 0)	// AE_BAD_HEX_CONSTANT


if (0) {

	CH03(ts, z065, 16, 0, 0)
	Add("0xfedcba98765432", 0, Local7)
	CH04(ts, 0, 34, z065, 17, 0, 0)	// AE_BAD_HEX_CONSTANT

	CH03(ts, z065, 18, 0, 0)
	Add(0, "0xfedcba98765432", Local7)
	CH04(ts, 0, 34, z065, 19, 0, 0)	// AE_BAD_HEX_CONSTANT

	CH03(ts, z065, 20, 0, 0)
	Add("", 0, Local7)
	CH04(ts, 0, 34, z065, 21, 0, 0)	// AE_BAD_HEX_CONSTANT

	CH03(ts, z065, 22, 0, 0)
	Add(0, "", Local7)
	CH04(ts, 0, 34, z065, 23, 0, 0)	// AE_BAD_HEX_CONSTANT

	CH03(ts, z065, 24, 0, 0)
	Add(" ", 0, Local7)
	CH04(ts, 0, 34, z065, 25, 0, 0)	// AE_BAD_HEX_CONSTANT

	CH03(ts, z065, 26, 0, 0)
	Add(0, " ", Local7)
	CH04(ts, 0, 34, z065, 27, 0, 0)	// AE_BAD_HEX_CONSTANT
}

	m4a2(ts)

	} else {

	// Integers, directly

	Add(0321, 0, Local7)
	m4c0(ts, Local7, 0xd1, 0xd1)

	Add(9876543210, 0, Local7)
	m4c0(ts, Local7, 0x000000024CB016EA, 0x4CB016EA)

	Add(0xfedcba9876543210, 0, Local7)
	m4c0(ts, Local7, 0xFEDCBA9876543210, 0x76543210)

	Add(0, 0, Local7)
	m4c0(ts, Local7, 0, 0)

	Add(0xffffffffffffffff, 0, Local7)
	m4c0(ts, Local7, 0xffffffffffffffff, 0xffffffff)

	Add(0, 0321, Local7)
	m4c0(ts, Local7, 0xd1, 0xd1)

	Add(0, 9876543210, Local7)
	m4c0(ts, Local7, 0x000000024CB016EA, 0x4CB016EA)

	Add(0, 0xfedcba9876543210, Local7)
	m4c0(ts, Local7, 0xFEDCBA9876543210, 0x76543210)

	Add(0, 0xffffffffffffffff, Local7)
	m4c0(ts, Local7, 0xffffffffffffffff, 0xffffffff)


	// Strings, directly

	Add("0321", 0, Local7)
	m4c0(ts, Local7, 0x321, 0x321)

	Add("9876543210", 0, Local7)
	m4c0(ts, Local7, 0x9876543210, 0x76543210)

	Add("321", 0, Local7)
	m4c0(ts, Local7, 0x321, 0x321)

	Add("fedcba9876543210", 0, Local7)
	m4c0(ts, Local7, 0xfedcba9876543210, 0x76543210)

	m4a4(ts)

	// Buffers
	// Buffer Units

	}

/*
	Add(xxxxxx, 0, Local7)
	m4c0(ts, Local7, 0, 0)

	Add("xxxxxx", 0, Local7)
	m4c0(ts, Local7, 0, 0)
*/

if (0) {
    Store(9876543210, Debug)
}
}

// Add (int, int, Result) => Integer
//
// Total scale of unacceptable types:
//    Addend1: 0x1ed1
//    Addend2: 0x1ed1
// Total scale of acceptable types:
//    Addend1: 0x402e
//    Addend1: 0x402e
Method(m401, 1, Serialized)
{
	Name(op, 1)

	ts00("m401")

	// Expected results: 64-bit, 32-bit
	Name(p000, Package() {

		// X - Integer

		0x58765432, 0x58765432,

		// X - String

		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",

		0x9876, 0x9876,
		0xabcd, 0xabcd,
		0x1234567890987654, 0x90987654,
		0xdafecbaabbddffee, 0xbbddffee,
		0x1234567890abcdef, 0x90abcdef,
		0xfdeacb0132547698, 0x32547698,

		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",

		// X - Buffer

		0x832291, 0x832291,
		0x80, 0x80,
		0x8281, 0x8281,
		0x86858483, 0x86858483,
		0x9b9A999887, 0x9A999887,
		0xa3a2a1a09F9E9D9C, 0x9F9E9D9C,
		0xbbbab9b8A7A6A5A4, 0xA7A6A5A4,
		0x6261605F94939291, 0x94939291,
		0x0807060504030201, 0x04030201,

		// X - Field Unit

		0x7f, 0x7f,
		0x07, 0x07,
		0x8d, 0x8d,
		0x8c8d, 0x8c8d,
		0x8a8b8c8d, 0x8a8b8c8d,
		0x1ffffffff, 0xffffffff,
		0x5cdefa1988374658, 0x88374658,
		0xdcdefa1988379a58, 0x88379a58,
		0xdcdefa198837c758, 0x8837c758,
		0xEFCDAB9078563482, 0x78563482,
		0x52CD1299EFCDAB93, 0xEFCDAB93,

		// X - Buffer Field

		0x918654ab, 0x918654ab,
		0x07, 0x07,
		0x8d, 0x8d,
		0x8c8d, 0x8c8d,
		0x8a8b8c8d, 0x8a8b8c8d,
		0x1ffffffff, 0xffffffff,
		0x5cdefa1988374658, 0x88374658,
		0xdcdefa1988379a58, 0x88379a58,
		0xdcdefa198837c758, 0x8837c758,
		0xEFCDAB9078563482, 0x78563482,
		0x52CD1299EFCDAB93, 0xEFCDAB93,
		})

	if (arg0) {

 if (0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
 }
		m4a0(1)
	} elseif (0) {
		Store(1, FLG1)
		Store(1, com2)
		Store(p000, PKG1)
		Store(PKG0, PKG2)
		m48b(op, 0x104)
		Store(PKG0, PKG1)
		Store(PKG0, PKG2)
		Store(0, com2)
		Store(0, FLG1)
	} else {
		m4a0(0)
	}
}

// And (int, int, Result) => Integer
//
// Total scale of unacceptable types:
//    Source1: 0x1ed1
//    Source2: 0x1ed1
// Total scale of acceptable types:
//    Source1: 0x402e
//    Source2: 0x402e
Method(m402, 1, Serialized)
{
	Name(op, 2)

	ts00("m402")

	// Expected results: 64-bit, 32-bit
	Name(p000, Package() {

		// X - Integer

		0x58765432, 0x58765432,

		// X - String

		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",

		0x9876, 0x9876,
		0xabcd, 0xabcd,
		0x1234567890987654, 0x90987654,
		0xdafecbaabbddffee, 0xbbddffee,
		0x1234567890abcdef, 0x90abcdef,
		0xfdeacb0132547698, 0x32547698,

		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",

		// X - Buffer

		0x832291, 0x832291,
		0x80, 0x80,
		0x8281, 0x8281,
		0x86858483, 0x86858483,
		0x9b9A999887, 0x9A999887,
		0xa3a2a1a09F9E9D9C, 0x9F9E9D9C,
		0xbbbab9b8A7A6A5A4, 0xA7A6A5A4,
		0x6261605F94939291, 0x94939291,
		0x0807060504030201, 0x04030201,

		// X - Field Unit

		0x7f, 0x7f,
		0x07, 0x07,
		0x8d, 0x8d,
		0x8c8d, 0x8c8d,
		0x8a8b8c8d, 0x8a8b8c8d,
		0x1ffffffff, 0xffffffff,
		0x5cdefa1988374658, 0x88374658,
		0xdcdefa1988379a58, 0x88379a58,
		0xdcdefa198837c758, 0x8837c758,
		0xEFCDAB9078563482, 0x78563482,
		0x52CD1299EFCDAB93, 0xEFCDAB93,

		// X - Buffer Field

		0x918654ab, 0x918654ab,
		0x07, 0x07,
		0x8d, 0x8d,
		0x8c8d, 0x8c8d,
		0x8a8b8c8d, 0x8a8b8c8d,
		0x1ffffffff, 0xffffffff,
		0x5cdefa1988374658, 0x88374658,
		0xdcdefa1988379a58, 0x88379a58,
		0xdcdefa198837c758, 0x8837c758,
		0xEFCDAB9078563482, 0x78563482,
		0x52CD1299EFCDAB93, 0xEFCDAB93,
		})

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
		Store(1, FLG1)
		Store(1, com2)
		Store(p000, PKG1)
		Store(PKG0, PKG2)
		m48b(op, 0x106)
		Store(PKG0, PKG1)
		Store(PKG0, PKG2)
		Store(0, com2)
		Store(0, FLG1)
	}
}

// Concatenate({int|str|buf}, {int|str|buf}, Result) => ComputationalData
//
// Total scale of unacceptable types:
//    Source1: 0x1ed1
//    Source2: 0x1ed1
// Total scale of acceptable types:
//    Source1: 0x402e
//    Source2: 0x402e
Method(m403, 1, Serialized)
{
	Name(op, 3)

	ts00("m403")

	// Expected results: 64-bit, 32-bit
	Name(p000, Package() {

		// X - Integer

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,0x32,0x54,0x76,0x58,0,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0x32,0x54,0x76,0x58},

		// X - String

		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x76,0x98,0,0,0,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0x76,0x98,0,0},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0xcd,0xab,0,0,0,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0xcd,0xab,0,0},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x54,0x76,0x98,0x90,0x78,0x56,0x34,0x12},
		Buffer() {0x78,0x56,0x34,0x42,0x54,0x76,0x98,0x90},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0xEE,0xFF,0xDD,0xBB,0xAA,0xCB,0xFE,0xDA},
		Buffer() {0x78,0x56,0x34,0x42,0xEE,0xFF,0xDD,0xBB},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0xEF,0xCD,0xAB,0x90,0x78,0x56,0x34,0x12},
		Buffer() {0x78,0x56,0x34,0x42,0xEF,0xCD,0xAB,0x90},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x98,0x76,0x54,0x32,0x01,0xCB,0xEA,0xFD},
		Buffer() {0x78,0x56,0x34,0x42,0x98,0x76,0x54,0x32},

		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",
		"Exc", "Exc",

		// X - Buffer

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x91,0x22,0x83,0,0,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0x91,0x22,0x83,0},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x80,0,0,0,0,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0x80,0,0,0},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x81,0x82,0,0,0,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0x81,0x82,0,0},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x83,0x84,0x85,0x86,0,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0x83,0x84,0x85,0x86},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x87,0x98,0x99,0x9A,0x9B,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0x87,0x98,0x99,0x9A},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x9C,0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3},
		Buffer() {0x78,0x56,0x34,0x42,0x9C,0x9D,0x9E,0x9F},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0xA4,0xA5,0xA6,0xA7,0xB8,0xB9,0xBA,0xBB},
		Buffer() {0x78,0x56,0x34,0x42,0xA4,0xA5,0xA6,0xA7},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x91,0x92,0x93,0x94,0x5F,0x60,0x61,0x62},
		Buffer() {0x78,0x56,0x34,0x42,0x91,0x92,0x93,0x94},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				1,2,3,4,5,6,7,8},
		Buffer() {0x78,0x56,0x34,0x42,1,2,3,4},

		// X - Field Unit

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x7f,0,0,0,0,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0x7f,0,0,0},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x07,0,0,0,0,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0x07,0,0,0},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x8d,0,0,0,0,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0x8d,0,0,0},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x8d,0x8c,0,0,0,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0x8d,0x8c,0,0},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x8D,0x8C,0x8B,0x8A,0,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0x8D,0x8C,0x8B,0x8A},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0xFF,0xFF,0xFF,0xFF,0x01,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0xFF,0xFF,0xFF,0xFF},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x58,0x46,0x37,0x88,0x19,0xFA,0xDE,0x5C},
		Buffer() {0x78,0x56,0x34,0x42,0x58,0x46,0x37,0x88},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x58,0x9a,0x37,0x88,0x19,0xFA,0xDE,0xDC},
		Buffer() {0x78,0x56,0x34,0x42,0x58,0x9a,0x37,0x88},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x58,0xc7,0x37,0x88,0x19,0xFA,0xDE,0xDC},
		Buffer() {0x78,0x56,0x34,0x42,0x58,0xc7,0x37,0x88},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x82,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF},
		Buffer() {0x78,0x56,0x34,0x42,0x82,0x34,0x56,0x78},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x93,0xAB,0xCD,0xEF,0x99,0x12,0xCD,0x52},
		Buffer() {0x78,0x56,0x34,0x42,0x93,0xAB,0xCD,0xEF},

		// X - Buffer Field

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0xAB,0x54,0x86,0x91,0,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0xAB,0x54,0x86,0x91},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x07,0,0,0,0,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0x07,0,0,0},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x8d,0,0,0,0,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0x8d,0,0,0},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x8d,0x8c,0,0,0,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0x8d,0x8c,0,0},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x8D,0x8C,0x8B,0x8A,0,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0x8D,0x8C,0x8B,0x8A},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0xFF,0xFF,0xFF,0xFF,0x01,0,0,0},
		Buffer() {0x78,0x56,0x34,0x42,0xFF,0xFF,0xFF,0xFF},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x58,0x46,0x37,0x88,0x19,0xFA,0xDE,0x5C},
		Buffer() {0x78,0x56,0x34,0x42,0x58,0x46,0x37,0x88},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x58,0x9a,0x37,0x88,0x19,0xFA,0xDE,0xDC},
		Buffer() {0x78,0x56,0x34,0x42,0x58,0x9a,0x37,0x88},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x58,0xc7,0x37,0x88,0x19,0xFA,0xDE,0xDC},
		Buffer() {0x78,0x56,0x34,0x42,0x58,0xc7,0x37,0x88},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x82,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF},
		Buffer() {0x78,0x56,0x34,0x42,0x82,0x34,0x56,0x78},

		Buffer() {0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB,
				0x93,0xAB,0xCD,0xEF,0x99,0x12,0xCD,0x52},
		Buffer() {0x78,0x56,0x34,0x42,0x93,0xAB,0xCD,0xEF},
		})

	// Expected results: 64-bit, 32-bit
	Name(p001, Package() {

		// X - Integer

		Buffer() {0x32,0x54,0x76,0x58,0x00,0x00,0x00,0x00,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x32,0x54,0x76,0x58,0x78,0x56,0x34,0x42},

		// X - String

		"qwrtABEDF18942345678",
		"qwrt42345678",

		"svnmjklABEDF18942345678",
		"svnmjkl42345678",

		"1234zyqABEDF18942345678",
		"1234zyq42345678",

		"abcdefzyqABEDF18942345678",
		"abcdefzyq42345678",

		"9876ABEDF18942345678",
		"987642345678",

		"aBcDABEDF18942345678",
		"aBcD42345678",

		"1234567890987654ABEDF18942345678",
		"123456789098765442345678",

		"daFeCBaabbddffeeABEDF18942345678",
		"daFeCBaabbddffee42345678",

		"1234567890abCdeFABEDF18942345678",
		"1234567890abCdeF42345678",

		"FdeAcb0132547698ABEDF18942345678",
		"FdeAcb013254769842345678",

		"12345678909876540ABEDF18942345678",
		"1234567890987654042345678",

		"fdeacb01325476980ABEDF18942345678",
		"fdeacb0132547698042345678",

		"123456789011223344556677889998765432199983337744ABEDF18942345678",
		"12345678901122334455667788999876543219998333774442345678",

		"abcdefaAbbccddeeffffeeddccaabbddeeffaaaabbbbeeefffddABEDF18942345678",
		"abcdefaAbbccddeeffffeeddccaabbddeeffaaaabbbbeeefffdd42345678",

		"1234567890abcdef9876543210fedbca1122334455667788fdeacbABEDF18942345678",
		"1234567890abcdef9876543210fedbca1122334455667788fdeacb42345678",

		"defa1234567890abcdef9876543210fedbca1122334455667788fdeacbABEDF18942345678",
		"defa1234567890abcdef9876543210fedbca1122334455667788fdeacb42345678",

		"123456789011223344556677889998765432199983337744zABEDF18942345678",
		"123456789011223344556677889998765432199983337744z42345678",

		// X - Buffer

		Buffer() {0x91,0x22,0x83,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x91,0x22,0x83,0x78,0x56,0x34,0x42},

		Buffer() {0x80,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x80,0x78,0x56,0x34,0x42},

		Buffer() {0x81,0x82,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x81,0x82,0x78,0x56,0x34,0x42},

		Buffer() {0x83,0x84,0x85,0x86,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x83,0x84,0x85,0x86,0x78,0x56,0x34,0x42},

		Buffer() {0x87,0x98,0x99,0x9A,0x9B,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x87,0x98,0x99,0x9A,0x9B,0x78,0x56,0x34,0x42},

		Buffer() {0x9C,0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x9C,0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3,0x78,0x56,0x34,0x42},

		Buffer() {0xA4,0xA5,0xA6,0xA7,0xB8,0xB9,0xBA,0xBB,0xBC,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0xA4,0xA5,0xA6,0xA7,0xB8,0xB9,0xBA,0xBB,0xBC,0x78,0x56,0x34,0x42},

		Buffer() {
		 0x91, 0x92, 0x93, 0x94, 95, 96, 97, 98, 99, 10, 11, 12, 13, 14, 15, 16,
		 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
		 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
		 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
		 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
		 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
		 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,112,
		113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
		129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,
		145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,
		161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,
		177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,
		193,194,195,196,197,198,199,200,
		0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {
		 0x91, 0x92, 0x93, 0x94, 95, 96, 97, 98, 99, 10, 11, 12, 13, 14, 15, 16,
		 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
		 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
		 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
		 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
		 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
		 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,112,
		113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
		129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,
		145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,
		161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,
		177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,
		193,194,195,196,197,198,199,200,
		0x78,0x56,0x34,0x42},

		Buffer() {
		  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
		 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
		 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
		 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
		 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
		 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
		 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,112,
		113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
		129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,
		145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,
		161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,
		177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,
		193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,
		209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,
		225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,
		241,242,243,244,245,246,247,248,249,250,251,252,253,254,255, 0, 1,
		0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {
		  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
		 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
		 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
		 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
		 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
		 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
		 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,112,
		113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
		129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,
		145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,
		161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,
		177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,
		193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,
		209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,
		225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,
		241,242,243,244,245,246,247,248,249,250,251,252,253,254,255, 0, 1,
		0x78,0x56,0x34,0x42},

		// X - Field Unit

		Buffer() {0x7F,0,0,0,0,0,0,0,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x7F,0,0,0,0x78,0x56,0x34,0x42},

		Buffer() {0x07,0,0,0,0,0,0,0,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x07,0,0,0,0x78,0x56,0x34,0x42},

		Buffer() {0x8d,0,0,0,0,0,0,0,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x8d,0,0,0,0x78,0x56,0x34,0x42},

		Buffer() {0x8d,0x8c,0,0,0,0,0,0,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x8d,0x8c,0,0,0x78,0x56,0x34,0x42},

		Buffer() {0x8d,0x8c,0x8b,0x8a,0,0,0,0,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x8d,0x8c,0x8b,0x8a,0x78,0x56,0x34,0x42},

		Buffer() {0xFF,0xFF,0xFF,0xFF,0x01,0,0,0,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0xFF,0xFF,0xFF,0xFF,0x01,0x78,0x56,0x34,0x42},

		Buffer() {0x58,0x46,0x37,0x88,0x19,0xFA,0xDE,0x5C,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x58,0x46,0x37,0x88,0x19,0xFA,0xDE,0x5C,0x78,0x56,0x34,0x42},


		Buffer() {0x58,0x9A,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x58,0x9A,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x78,0x56,0x34,0x42},

		Buffer() {0x58,0xC7,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x00,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x58,0xC7,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x00,0x78,0x56,0x34,0x42},

		Buffer() {0x82,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF,0x55,
				0,0,0,0,0,0,0,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x82,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF,0x55,
				0,0,0,0,0,0,0,0x78,0x56,0x34,0x42},

		Buffer() {0x93,0xAB,0xCD,0xEF,0x99,0x12,0xCD,0x52,0x87,
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
				0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x93,0xAB,0xCD,0xEF,0x99,0x12,0xCD,0x52,0x87,
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
				0x78,0x56,0x34,0x42},

		// X - Buffer Field

		Buffer() {0xAB,0x54,0x86,0x91,0,0,0,0,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0xAB,0x54,0x86,0x91,0x78,0x56,0x34,0x42},

		Buffer() {0x07,0,0,0,0,0,0,0,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x07,0,0,0,0x78,0x56,0x34,0x42},

		Buffer() {0x8D,0,0,0,0,0,0,0,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x8D,0,0,0,0x78,0x56,0x34,0x42},

		Buffer() {0x8D,0x8c,0,0,0,0,0,0,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x8D,0x8c,0,0,0x78,0x56,0x34,0x42},

		Buffer() {0x8D,0x8c,0x8b,0x8a,0,0,0,0,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x8D,0x8c,0x8b,0x8a,0x78,0x56,0x34,0x42},

		Buffer() {0xff,0xff,0xff,0xff,0x01,0,0,0,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0xff,0xff,0xff,0xff,0x01,0x78,0x56,0x34,0x42},

		Buffer() {0x58,0x46,0x37,0x88,0x19,0xFA,0xDE,0x5C,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x58,0x46,0x37,0x88,0x19,0xFA,0xDE,0x5C,0x78,0x56,0x34,0x42},

		Buffer() {0x58,0x9A,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x58,0x9A,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x78,0x56,0x34,0x42},

		Buffer() {0x58,0xC7,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x00,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x58,0xC7,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x00,0x78,0x56,0x34,0x42},

		Buffer() {0x82,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF,0x55,
				0,0,0,0,0,0,0,0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x82,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF,0x55,
				0,0,0,0,0,0,0,0x78,0x56,0x34,0x42},

		Buffer() {0x93,0xAB,0xCD,0xEF,0x99,0x12,0xCD,0x52,0x87,
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
				0x78,0x56,0x34,0x42,0x89,0xF1,0xED,0xAB},
		Buffer() {0x93,0xAB,0xCD,0xEF,0x99,0x12,0xCD,0x52,0x87,
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
				0x78,0x56,0x34,0x42},
		})

	// Expected results: 64-bit, 32-bit
	Name(p002, Package() {

		// X - Integer

		"98760000000058765432", "987658765432",

		// X - String

		"9876qwrt", "9876qwrt",
		"9876svnmjkl", "9876svnmjkl",
		"98761234zyq", "98761234zyq",
		"9876abcdefzyq", "9876abcdefzyq",
		"98769876", "98769876",
		"9876aBcD", "9876aBcD",
		"98761234567890987654", "98761234567890987654",
		"9876daFeCBaabbddffee", "9876daFeCBaabbddffee",
		"98761234567890abCdeF", "98761234567890abCdeF",
		"9876FdeAcb0132547698", "9876FdeAcb0132547698",

		"987612345678909876540", "987612345678909876540",
		"9876fdeacb01325476980", "9876fdeacb01325476980",

		"9876123456789011223344556677889998765432199983337744",
		"9876123456789011223344556677889998765432199983337744",

		"9876abcdefaAbbccddeeffffeeddccaabbddeeffaaaabbbbeeefffdd",
		"9876abcdefaAbbccddeeffffeeddccaabbddeeffaaaabbbbeeefffdd",

		"98761234567890abcdef9876543210fedbca1122334455667788fdeacb",
		"98761234567890abcdef9876543210fedbca1122334455667788fdeacb",

		"9876defa1234567890abcdef9876543210fedbca1122334455667788fdeacb",
		"9876defa1234567890abcdef9876543210fedbca1122334455667788fdeacb",

		"9876123456789011223344556677889998765432199983337744z",
		"9876123456789011223344556677889998765432199983337744z",

		// X - Buffer

		"987691 22 83", "987691 22 83",
		"987680", "987680",
		"987681 82", "987681 82",
		"987683 84 85 86", "987683 84 85 86",
		"987687 98 99 9A 9B", "987687 98 99 9A 9B",
		"98769C 9D 9E 9F A0 A1 A2 A3", "98769C 9D 9E 9F A0 A1 A2 A3",
		"9876A4 A5 A6 A7 B8 B9 BA BB BC", "9876A4 A5 A6 A7 B8 B9 BA BB BC",
		"Exc", "Exc",
		"Exc", "Exc",

		// X - Field Unit

		"9876000000000000007F", "98760000007F",
		"98760000000000000007", "987600000007",
		"9876000000000000008D", "98760000008D",
		"98760000000000008C8D", "987600008C8D",
		"9876000000008A8B8C8D", "98768A8B8C8D",
		"987600000001FFFFFFFF", "9876FF FF FF FF 01",
		"98765CDEFA1988374658", "987658 46 37 88 19 FA DE 5C",
		"9876DCDEFA1988379A58", "987658 9A 37 88 19 FA DE DC",
		"987658 C7 37 88 19 FA DE DC 00", "987658 C7 37 88 19 FA DE DC 00",

		"987682 34 56 78 90 AB CD EF 55 00 00 00 00 00 00 00",
		"987682 34 56 78 90 AB CD EF 55 00 00 00 00 00 00 00",

		"987693 AB CD EF 99 12 CD 52 87 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00",
		"987693 AB CD EF 99 12 CD 52 87 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00",

		// X - Buffer Field

		"987600000000918654AB", "9876918654AB",
		"98760000000000000007", "987600000007",
		"9876000000000000008D", "98760000008D",
		"98760000000000008C8D", "987600008C8D",
		"9876000000008A8B8C8D", "98768A8B8C8D",
		"987600000001FFFFFFFF", "9876FF FF FF FF 01",
		"98765CDEFA1988374658", "987658 46 37 88 19 FA DE 5C",
		"9876DCDEFA1988379A58", "987658 9A 37 88 19 FA DE DC",
		"987658 C7 37 88 19 FA DE DC 00", "987658 C7 37 88 19 FA DE DC 00",

		"987682 34 56 78 90 AB CD EF 55 00 00 00 00 00 00 00",
		"987682 34 56 78 90 AB CD EF 55 00 00 00 00 00 00 00",

		"987693 AB CD EF 99 12 CD 52 87 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00",
		"987693 AB CD EF 99 12 CD 52 87 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00",
		})

	// Expected results: 64-bit, 32-bit
	Name(p003, Package() {

		// X - Integer

		Buffer() {0x32,0x54,0x76,0x58,0,0,0,0,0x76,0x98,0,0,0,0,0,0},
		Buffer() {0x32,0x54,0x76,0x58,0x76,0x98,0,0},

		// X - String

		"qwrt9876", "qwrt9876",
		"svnmjkl9876", "svnmjkl9876",
		"1234zyq9876", "1234zyq9876",
		"abcdefzyq9876", "abcdefzyq9876",
		"98769876", "98769876",
		"aBcD9876", "aBcD9876",
		"12345678909876549876", "12345678909876549876",
		"daFeCBaabbddffee9876", "daFeCBaabbddffee9876",
		"1234567890abCdeF9876", "1234567890abCdeF9876",
		"FdeAcb01325476989876", "FdeAcb01325476989876",
		"123456789098765409876", "123456789098765409876",
		"fdeacb013254769809876", "fdeacb013254769809876",

		"1234567890112233445566778899987654321999833377449876",
		"1234567890112233445566778899987654321999833377449876",

		"abcdefaAbbccddeeffffeeddccaabbddeeffaaaabbbbeeefffdd9876",
		"abcdefaAbbccddeeffffeeddccaabbddeeffaaaabbbbeeefffdd9876",

		"1234567890abcdef9876543210fedbca1122334455667788fdeacb9876",
		"1234567890abcdef9876543210fedbca1122334455667788fdeacb9876",

		"defa1234567890abcdef9876543210fedbca1122334455667788fdeacb9876",
		"defa1234567890abcdef9876543210fedbca1122334455667788fdeacb9876",

		"123456789011223344556677889998765432199983337744z9876",
		"123456789011223344556677889998765432199983337744z9876",

		// X - Buffer

		Buffer() {0x91,0x22,0x83,0x39,0x38,0x37,0x36},
		Buffer() {0x91,0x22,0x83,0x39,0x38,0x37,0x36},

		Buffer() {0x80,0x39,0x38,0x37,0x36},
		Buffer() {0x80,0x39,0x38,0x37,0x36},

		Buffer() {0x81,0x82,0x39,0x38,0x37,0x36},
		Buffer() {0x81,0x82,0x39,0x38,0x37,0x36},


		Buffer() {0x83,0x84,0x85,0x86,0x39,0x38,0x37,0x36},
		Buffer() {0x83,0x84,0x85,0x86,0x39,0x38,0x37,0x36},

		Buffer() {0x87,0x98,0x99,0x9A,0x9B,0x39,0x38,0x37,0x36},
		Buffer() {0x87,0x98,0x99,0x9A,0x9B,0x39,0x38,0x37,0x36},


		Buffer() {0x9C,0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3,0x39,0x38,0x37,0x36},
		Buffer() {0x9C,0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3,0x39,0x38,0x37,0x36},

		Buffer() {0xA4,0xA5,0xA6,0xA7,0xB8,0xB9,0xBA,0xBB,0xBC,0x39,0x38,0x37,0x36},
		Buffer() {0xA4,0xA5,0xA6,0xA7,0xB8,0xB9,0xBA,0xBB,0xBC,0x39,0x38,0x37,0x36},

		Buffer() {0x91,0x92,0x93,0x94,0x5F,0x60,0x61,0x62,0x63,0x0A,0x0B,0x0C,0x0D,
				0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,
				0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
				0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,
				0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,
				0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,
				0x4F,0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,
				0x5C,0x5D,0x5E,0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,
				0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,
				0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0x80,0x81,0x82,
				0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
				0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,
				0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,
				0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,
				0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,0xC0,0xC1,0xC2,0xC3,
				0xC4,0xC5,0xC6,0xC7,0xC8,0x39,0x38,0x37,0x36},
		Buffer() {0x91,0x92,0x93,0x94,0x5F,0x60,0x61,0x62,0x63,0x0A,0x0B,0x0C,0x0D,
				0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,
				0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
				0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,
				0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,
				0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,
				0x4F,0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,
				0x5C,0x5D,0x5E,0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,
				0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,
				0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0x80,0x81,0x82,
				0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
				0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,
				0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,
				0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,
				0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,0xC0,0xC1,0xC2,0xC3,
				0xC4,0xC5,0xC6,0xC7,0xC8,0x39,0x38,0x37,0x36},

		Buffer() {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,
				0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,
				0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
				0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,
				0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,
				0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,
				0x4F,0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,
				0x5C,0x5D,0x5E,0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,
				0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,
				0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0x80,0x81,0x82,
				0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
				0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,
				0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,
				0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,
				0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,0xC0,0xC1,0xC2,0xC3,
				0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,0xD0,
				0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,
				0xDE,0xDF,0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,
				0xEB,0xEC,0xED,0xEE,0xEF,0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,
				0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF,0x00,0x01,0x39,0x38,0x37,
				0x36},
		Buffer() {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,
				0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,
				0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
				0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,
				0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,
				0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,
				0x4F,0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,
				0x5C,0x5D,0x5E,0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,
				0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,
				0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0x80,0x81,0x82,
				0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
				0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,
				0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,
				0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,
				0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,0xC0,0xC1,0xC2,0xC3,
				0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,0xD0,
				0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,
				0xDE,0xDF,0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,
				0xEB,0xEC,0xED,0xEE,0xEF,0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,
				0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF,0x00,0x01,0x39,0x38,0x37,
				0x36},

		// X - Field Unit

		Buffer() {0x7F,0,0,0,0,0,0,0,0x76,0x98,0,0,0,0,0,0},
		Buffer() {0x7F,0,0,0,0x76,0x98,0,0},

		Buffer() {0x07,0,0,0,0,0,0,0,0x76,0x98,0,0,0,0,0,0},
		Buffer() {0x07,0,0,0,0x76,0x98,0,0},

		Buffer() {0x8d,0,0,0,0,0,0,0,0x76,0x98,0,0,0,0,0,0},
		Buffer() {0x8d,0,0,0,0x76,0x98,0,0},

		Buffer() {0x8d,0x8c,0,0,0,0,0,0,0x76,0x98,0,0,0,0,0,0},
		Buffer() {0x8d,0x8c,0,0,0x76,0x98,0,0},

		Buffer() {0x8d,0x8c,0x8b,0x8a,0,0,0,0,0x76,0x98,0,0,0,0,0,0},
		Buffer() {0x8d,0x8c,0x8b,0x8a,0x76,0x98,0,0},

		Buffer() {0xff,0xff,0xff,0xff,0x01,0,0,0,0x76,0x98,0,0,0,0,0,0},
		Buffer() {0xff,0xff,0xff,0xff,0x01,0x39,0x38,0x37,0x36},

		Buffer() {0x58,0x46,0x37,0x88,0x19,0xFA,0xDE,0x5C,0x76,0x98,0,0,0,0,0,0},
		Buffer() {0x58,0x46,0x37,0x88,0x19,0xFA,0xDE,0x5C,0x39,0x38,0x37,0x36},

		Buffer() {0x58,0x9A,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x76,0x98,0,0,0,0,0,0},
		Buffer() {0x58,0x9A,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x39,0x38,0x37,0x36},

		Buffer() {0x58,0xc7,0x37,0x88,0x19,0xFA,0xDE,0xDC,0,0x39,0x38,0x37,0x36},
		Buffer() {0x58,0xc7,0x37,0x88,0x19,0xFA,0xDE,0xDC,0,0x39,0x38,0x37,0x36},

		Buffer() {0x82,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF,0x55,0,0,0,0,0,0,0,0x39,0x38,0x37,0x36},
		Buffer() {0x82,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF,0x55,0,0,0,0,0,0,0,0x39,0x38,0x37,0x36},

		Buffer() {0x93,0xAB,0xCD,0xEF,0x99,0x12,0xCD,0x52,0x87,0,0,0,0,0,0,0,
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0x39,0x38,0x37,0x36},
		Buffer() {0x93,0xAB,0xCD,0xEF,0x99,0x12,0xCD,0x52,0x87,0,0,0,0,0,0,0,
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0x39,0x38,0x37,0x36},

		// X - Buffer Field

		Buffer() {0xAB,0x54,0x86,0x91,0,0,0,0,0x76,0x98,0,0,0,0,0,0},
		Buffer() {0xAB,0x54,0x86,0x91,0x76,0x98,0,0},

		Buffer() {0x07,0,0,0,0,0,0,0,0x76,0x98,0,0,0,0,0,0},
		Buffer() {0x07,0,0,0,0x76,0x98,0,0},

		Buffer() {0x8d,0,0,0,0,0,0,0,0x76,0x98,0,0,0,0,0,0},
		Buffer() {0x8d,0,0,0,0x76,0x98,0,0},

		Buffer() {0x8d,0x8c,0,0,0,0,0,0,0x76,0x98,0,0,0,0,0,0},
		Buffer() {0x8d,0x8c,0,0,0x76,0x98,0,0},

		Buffer() {0x8d,0x8c,0x8b,0x8a,0,0,0,0,0x76,0x98,0,0,0,0,0,0},
		Buffer() {0x8d,0x8c,0x8b,0x8a,0x76,0x98,0,0},

		Buffer() {0xff,0xff,0xff,0xff,0x01,0,0,0,0x76,0x98,0,0,0,0,0,0},
		Buffer() {0xff,0xff,0xff,0xff,0x01,0x39,0x38,0x37,0x36},

		Buffer() {0x58,0x46,0x37,0x88,0x19,0xFA,0xDE,0x5C,0x76,0x98,0,0,0,0,0,0},
		Buffer() {0x58,0x46,0x37,0x88,0x19,0xFA,0xDE,0x5C,0x39,0x38,0x37,0x36},

		Buffer() {0x58,0x9A,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x76,0x98,0,0,0,0,0,0},
		Buffer() {0x58,0x9A,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x39,0x38,0x37,0x36},

		Buffer() {0x58,0xc7,0x37,0x88,0x19,0xFA,0xDE,0xDC,0,0x39,0x38,0x37,0x36},
		Buffer() {0x58,0xc7,0x37,0x88,0x19,0xFA,0xDE,0xDC,0,0x39,0x38,0x37,0x36},

		Buffer() {0x82,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF,0x55,0,0,0,0,0,0,0,0x39,0x38,0x37,0x36},
		Buffer() {0x82,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF,0x55,0,0,0,0,0,0,0,0x39,0x38,0x37,0x36},

		Buffer() {0x93,0xAB,0xCD,0xEF,0x99,0x12,0xCD,0x52,0x87,0,0,0,0,0,0,0,
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0x39,0x38,0x37,0x36},
		Buffer() {0x93,0xAB,0xCD,0xEF,0x99,0x12,0xCD,0x52,0x87,0,0,0,0,0,0,0,
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0x39,0x38,0x37,0x36},
		})

	// Expected results: 64-bit, 32-bit
	Name(p004, Package() {

		// X - Integer

		Buffer() {0x81,0x82,0x32,0x54,0x76,0x58,0,0,0,0},
		Buffer() {0x81,0x82,0x32,0x54,0x76,0x58},

		// X - String

		Buffer() {0x81,0x82,0x71,0x77,0x72,0x74},
		Buffer() {0x81,0x82,0x71,0x77,0x72,0x74},

		Buffer() {0x81,0x82,0x73,0x76,0x6E,0x6D,0x6A,0x6B,0x6C},
		Buffer() {0x81,0x82,0x73,0x76,0x6E,0x6D,0x6A,0x6B,0x6C},

		Buffer() {0x81,0x82,0x31,0x32,0x33,0x34,0x7A,0x79,0x71},
		Buffer() {0x81,0x82,0x31,0x32,0x33,0x34,0x7A,0x79,0x71},

		Buffer() {0x81,0x82,0x61,0x62,0x63,0x64,0x65,0x66,0x7A,0x79,0x71},
		Buffer() {0x81,0x82,0x61,0x62,0x63,0x64,0x65,0x66,0x7A,0x79,0x71},

		Buffer() {0x81,0x82,0x39,0x38,0x37,0x36},
		Buffer() {0x81,0x82,0x39,0x38,0x37,0x36},

		Buffer() {0x81,0x82,0x61,0x42,0x63,0x44},
		Buffer() {0x81,0x82,0x61,0x42,0x63,0x44},

		Buffer() {0x81,0x82,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x30,0x39,0x38,0x37,0x36,0x35,0x34},
		Buffer() {0x81,0x82,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x30,0x39,0x38,0x37,0x36,0x35,0x34},

		Buffer() {0x81,0x82,0x64,0x61,0x46,0x65,0x43,0x42,0x61,0x61,0x62,0x62,0x64,0x64,0x66,0x66,0x65,0x65},
		Buffer() {0x81,0x82,0x64,0x61,0x46,0x65,0x43,0x42,0x61,0x61,0x62,0x62,0x64,0x64,0x66,0x66,0x65,0x65},

		Buffer() {0x81,0x82,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x30,0x61,0x62,0x43,0x64,0x65,0x46},
		Buffer() {0x81,0x82,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x30,0x61,0x62,0x43,0x64,0x65,0x46},

		Buffer() {0x81,0x82,0x46,0x64,0x65,0x41,0x63,0x62,0x30,0x31,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38},
		Buffer() {0x81,0x82,0x46,0x64,0x65,0x41,0x63,0x62,0x30,0x31,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38},

		Buffer() {0x81,0x82,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x30,0x39,0x38,0x37,0x36,0x35,0x34,0x30},
		Buffer() {0x81,0x82,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x30,0x39,0x38,0x37,0x36,0x35,0x34,0x30},

		Buffer() {0x81,0x82,0x66,0x64,0x65,0x61,0x63,0x62,0x30,0x31,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38,0x30},
		Buffer() {0x81,0x82,0x66,0x64,0x65,0x61,0x63,0x62,0x30,0x31,0x33,0x32,0x35,0x34,0x37,0x36,0x39,0x38,0x30},

		Buffer() {0x81,0x82,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x30,0x31,0x31,0x32,0x32,0x33,0x33,0x34,
				0x34,0x35,0x35,0x36,0x36,0x37,0x37,0x38,0x38,0x39,0x39,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,
				0x31,0x39,0x39,0x39,0x38,0x33,0x33,0x33,0x37,0x37,0x34,0x34},
		Buffer() {0x81,0x82,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x30,0x31,0x31,0x32,0x32,0x33,0x33,0x34,
				0x34,0x35,0x35,0x36,0x36,0x37,0x37,0x38,0x38,0x39,0x39,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,
				0x31,0x39,0x39,0x39,0x38,0x33,0x33,0x33,0x37,0x37,0x34,0x34},

		Buffer() {0x81,0x82,0x61,0x62,0x63,0x64,0x65,0x66,0x61,0x41,0x62,0x62,0x63,0x63,0x64,0x64,0x65,0x65,
				0x66,0x66,0x66,0x66,0x65,0x65,0x64,0x64,0x63,0x63,0x61,0x61,0x62,0x62,0x64,0x64,0x65,0x65,
				0x66,0x66,0x61,0x61,0x61,0x61,0x62,0x62,0x62,0x62,0x65,0x65,0x65,0x66,0x66,0x66,0x64,0x64},
		Buffer() {0x81,0x82,0x61,0x62,0x63,0x64,0x65,0x66,0x61,0x41,0x62,0x62,0x63,0x63,0x64,0x64,0x65,0x65,
				0x66,0x66,0x66,0x66,0x65,0x65,0x64,0x64,0x63,0x63,0x61,0x61,0x62,0x62,0x64,0x64,0x65,0x65,
				0x66,0x66,0x61,0x61,0x61,0x61,0x62,0x62,0x62,0x62,0x65,0x65,0x65,0x66,0x66,0x66,0x64,0x64},

		Buffer() {0x81,0x82,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x30,0x61,0x62,0x63,0x64,0x65,
				0x66,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x66,0x65,0x64,0x62,0x63,0x61,
				0x31,0x31,0x32,0x32,0x33,0x33,0x34,0x34,0x35,0x35,0x36,0x36,0x37,0x37,0x38,0x38,0x66,
				0x64,0x65,0x61,0x63,0x62},
		Buffer() {0x81,0x82,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x30,0x61,0x62,0x63,0x64,0x65,
				0x66,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x66,0x65,0x64,0x62,0x63,0x61,
				0x31,0x31,0x32,0x32,0x33,0x33,0x34,0x34,0x35,0x35,0x36,0x36,0x37,0x37,0x38,0x38,0x66,
				0x64,0x65,0x61,0x63,0x62},

		Buffer() {0x81,0x82,0x64,0x65,0x66,0x61,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x30,0x61,
				0x62,0x63,0x64,0x65,0x66,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x66,0x65,
				0x64,0x62,0x63,0x61,0x31,0x31,0x32,0x32,0x33,0x33,0x34,0x34,0x35,0x35,0x36,0x36,0x37,
				0x37,0x38,0x38,0x66,0x64,0x65,0x61,0x63,0x62},
		Buffer() {0x81,0x82,0x64,0x65,0x66,0x61,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x30,0x61,
				0x62,0x63,0x64,0x65,0x66,0x39,0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x30,0x66,0x65,
				0x64,0x62,0x63,0x61,0x31,0x31,0x32,0x32,0x33,0x33,0x34,0x34,0x35,0x35,0x36,0x36,0x37,
				0x37,0x38,0x38,0x66,0x64,0x65,0x61,0x63,0x62},

		Buffer() {0x81,0x82,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x30,0x31,0x31,0x32,0x32,0x33,
				0x33,0x34,0x34,0x35,0x35,0x36,0x36,0x37,0x37,0x38,0x38,0x39,0x39,0x39,0x38,0x37,0x36,
				0x35,0x34,0x33,0x32,0x31,0x39,0x39,0x39,0x38,0x33,0x33,0x33,0x37,0x37,0x34,0x34,0x7A},
		Buffer() {0x81,0x82,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x30,0x31,0x31,0x32,0x32,0x33,
				0x33,0x34,0x34,0x35,0x35,0x36,0x36,0x37,0x37,0x38,0x38,0x39,0x39,0x39,0x38,0x37,0x36,
				0x35,0x34,0x33,0x32,0x31,0x39,0x39,0x39,0x38,0x33,0x33,0x33,0x37,0x37,0x34,0x34,0x7A},

		// X - Buffer

		Buffer() {0x81,0x82,0x91,0x22,0x83},
		Buffer() {0x81,0x82,0x91,0x22,0x83},

		Buffer() {0x81,0x82,0x80},
		Buffer() {0x81,0x82,0x80},

		Buffer() {0x81,0x82,0x81,0x82},
		Buffer() {0x81,0x82,0x81,0x82},

		Buffer() {0x81,0x82,0x83,0x84,0x85,0x86},
		Buffer() {0x81,0x82,0x83,0x84,0x85,0x86},

		Buffer() {0x81,0x82,0x87,0x98,0x99,0x9A,0x9B},
		Buffer() {0x81,0x82,0x87,0x98,0x99,0x9A,0x9B},

		Buffer() {0x81,0x82,0x9C,0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3},
		Buffer() {0x81,0x82,0x9C,0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3},

		Buffer() {0x81,0x82,0xA4,0xA5,0xA6,0xA7,0xB8,0xB9,0xBA,0xBB,0xBC},
		Buffer() {0x81,0x82,0xA4,0xA5,0xA6,0xA7,0xB8,0xB9,0xBA,0xBB,0xBC},

		Buffer() {0x81,0x82,0x91,0x92,0x93,0x94,0x5F,0x60,0x61,0x62,0x63,0x0A,0x0B,
				0x0C,0x0D,0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,
				0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,
				0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,
				0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
				0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,
				0x4D,0x4E,0x4F,0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,
				0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,
				0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,
				0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0x80,
				0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,
				0x8E,0x8F,0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,
				0x9B,0x9C,0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,
				0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,0xB0,0xB1,0xB2,0xB3,0xB4,
				0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,0xC0,0xC1,
				0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8},
		Buffer() {0x81,0x82,0x91,0x92,0x93,0x94,0x5F,0x60,0x61,0x62,0x63,0x0A,0x0B,
				0x0C,0x0D,0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,
				0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,
				0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,
				0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
				0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,
				0x4D,0x4E,0x4F,0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,
				0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,
				0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,
				0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0x80,
				0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,
				0x8E,0x8F,0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,
				0x9B,0x9C,0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,
				0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,0xB0,0xB1,0xB2,0xB3,0xB4,
				0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,0xC0,0xC1,
				0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8},

		Buffer() {0x81,0x82,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,
				0x0C,0x0D,0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,
				0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,
				0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,
				0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
				0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,
				0x4D,0x4E,0x4F,0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,
				0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,
				0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,
				0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0x80,
				0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,
				0x8E,0x8F,0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,
				0x9B,0x9C,0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,
				0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,0xB0,0xB1,0xB2,0xB3,0xB4,
				0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,0xC0,0xC1,
				0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,
				0xCF,0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,
				0xDC,0xDD,0xDE,0xDF,0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,
				0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,
				0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF,0x00,0x01},
		Buffer() {0x81,0x82,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,
				0x0C,0x0D,0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,
				0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,
				0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,
				0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
				0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,
				0x4D,0x4E,0x4F,0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,
				0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,
				0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,
				0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0x80,
				0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,
				0x8E,0x8F,0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,
				0x9B,0x9C,0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,
				0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,0xB0,0xB1,0xB2,0xB3,0xB4,
				0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,0xC0,0xC1,
				0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,
				0xCF,0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,
				0xDC,0xDD,0xDE,0xDF,0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,
				0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,
				0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF,0x00,0x01},

		// X - Field Unit

		Buffer() {0x81,0x82,0x7F,0,0,0,0,0,0,0},
		Buffer() {0x81,0x82,0x7F,0,0,0},

		Buffer() {0x81,0x82,0x07,0,0,0,0,0,0,0},
		Buffer() {0x81,0x82,0x07,0,0,0},

		Buffer() {0x81,0x82,0x8D,0,0,0,0,0,0,0},
		Buffer() {0x81,0x82,0x8D,0,0,0},

		Buffer() {0x81,0x82,0x8D,0x8C,0,0,0,0,0,0},
		Buffer() {0x81,0x82,0x8D,0x8C,0,0},

		Buffer() {0x81,0x82,0x8D,0x8C,0x8B,0x8A,0,0,0,0},
		Buffer() {0x81,0x82,0x8D,0x8C,0x8B,0x8A},

		Buffer() {0x81,0x82,0xFF,0xFF,0xFF,0xFF,0x01,0,0,0},
		Buffer() {0x81,0x82,0xFF,0xFF,0xFF,0xFF,0x01},

		Buffer() {0x81,0x82,0x58,0x46,0x37,0x88,0x19,0xFA,0xDE,0x5C},
		Buffer() {0x81,0x82,0x58,0x46,0x37,0x88,0x19,0xFA,0xDE,0x5C},

		Buffer() {0x81,0x82,0x58,0x9A,0x37,0x88,0x19,0xFA,0xDE,0xDC},
		Buffer() {0x81,0x82,0x58,0x9A,0x37,0x88,0x19,0xFA,0xDE,0xDC},

		Buffer() {0x81,0x82,0x58,0xC7,0x37,0x88,0x19,0xFA,0xDE,0xDC,0},
		Buffer() {0x81,0x82,0x58,0xC7,0x37,0x88,0x19,0xFA,0xDE,0xDC,0},

		Buffer() {0x81,0x82,0x82,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF,0x55,0,0,0,0,0,0,0},
		Buffer() {0x81,0x82,0x82,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF,0x55,0,0,0,0,0,0,0},

		Buffer() {0x81,0x82,0x93,0xAB,0xCD,0xEF,0x99,0x12,0xCD,0x52,0x87,
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
		Buffer() {0x81,0x82,0x93,0xAB,0xCD,0xEF,0x99,0x12,0xCD,0x52,0x87,
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},

		// X - Buffer Field

		Buffer() {0x81,0x82,0xAB,0x54,0x86,0x91,0,0,0,0},
		Buffer() {0x81,0x82,0xAB,0x54,0x86,0x91},

		Buffer() {0x81,0x82,0x07,0,0,0,0,0,0,0},
		Buffer() {0x81,0x82,0x07,0,0,0},

		Buffer() {0x81,0x82,0x8D,0,0,0,0,0,0,0},
		Buffer() {0x81,0x82,0x8D,0,0,0},

		Buffer() {0x81,0x82,0x8D,0x8C,0,0,0,0,0,0},
		Buffer() {0x81,0x82,0x8D,0x8C,0,0},

		Buffer() {0x81,0x82,0x8D,0x8C,0x8B,0x8A,0,0,0,0},
		Buffer() {0x81,0x82,0x8D,0x8C,0x8B,0x8A},

		Buffer() {0x81,0x82,0xFF,0xFF,0xFF,0xFF,0x01,0,0,0},
		Buffer() {0x81,0x82,0xFF,0xFF,0xFF,0xFF,0x01},

		Buffer() {0x81,0x82,0x58,0x46,0x37,0x88,0x19,0xFA,0xDE,0x5C},
		Buffer() {0x81,0x82,0x58,0x46,0x37,0x88,0x19,0xFA,0xDE,0x5C},

		Buffer() {0x81,0x82,0x58,0x9A,0x37,0x88,0x19,0xFA,0xDE,0xDC},
		Buffer() {0x81,0x82,0x58,0x9A,0x37,0x88,0x19,0xFA,0xDE,0xDC},

		Buffer() {0x81,0x82,0x58,0xC7,0x37,0x88,0x19,0xFA,0xDE,0xDC,0},
		Buffer() {0x81,0x82,0x58,0xC7,0x37,0x88,0x19,0xFA,0xDE,0xDC,0},

		Buffer() {0x81,0x82,0x82,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF,0x55,0,0,0,0,0,0,0},
		Buffer() {0x81,0x82,0x82,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF,0x55,0,0,0,0,0,0,0},

		Buffer() {0x81,0x82,0x93,0xAB,0xCD,0xEF,0x99,0x12,0xCD,0x52,0x87,
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
		Buffer() {0x81,0x82,0x93,0xAB,0xCD,0xEF,0x99,0x12,0xCD,0x52,0x87,
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
		})

	// Expected results: 64-bit, 32-bit
	Name(p005, Package() {

		// X - Integer

		Buffer() {0x32,0x54,0x76,0x58,0,0,0,0,0x81,0x82,0,0,0,0,0,0},
		Buffer() {0x32,0x54,0x76,0x58,0x81,0x82,0,0},

		// X - String

		"qwrt81 82", "qwrt81 82",
		"svnmjkl81 82", "svnmjkl81 82",
		"1234zyq81 82", "1234zyq81 82",
		"abcdefzyq81 82", "abcdefzyq81 82",
		"987681 82",  "987681 82",
		"aBcD81 82", "aBcD81 82",
		"123456789098765481 82", "123456789098765481 82",
		"daFeCBaabbddffee81 82", "daFeCBaabbddffee81 82",
		"1234567890abCdeF81 82", "1234567890abCdeF81 82",
		"FdeAcb013254769881 82", "FdeAcb013254769881 82",
		"1234567890987654081 82", "1234567890987654081 82",
		"fdeacb0132547698081 82", "fdeacb0132547698081 82",

		"12345678901122334455667788999876543219998333774481 82",
		"12345678901122334455667788999876543219998333774481 82",

		"abcdefaAbbccddeeffffeeddccaabbddeeffaaaabbbbeeefffdd81 82",
		"abcdefaAbbccddeeffffeeddccaabbddeeffaaaabbbbeeefffdd81 82",

		"1234567890abcdef9876543210fedbca1122334455667788fdeacb81 82",
		"1234567890abcdef9876543210fedbca1122334455667788fdeacb81 82",

		"defa1234567890abcdef9876543210fedbca1122334455667788fdeacb81 82",
		"defa1234567890abcdef9876543210fedbca1122334455667788fdeacb81 82",

		"123456789011223344556677889998765432199983337744z81 82",
		"123456789011223344556677889998765432199983337744z81 82",

		// X - Buffer

		Buffer() {0x91,0x22,0x83,0x81,0x82},
		Buffer() {0x91,0x22,0x83,0x81,0x82},

		Buffer() {0x80,0x81,0x82},
		Buffer() {0x80,0x81,0x82},

		Buffer() {0x81,0x82,0x81,0x82},
		Buffer() {0x81,0x82,0x81,0x82},

		Buffer() {0x83,0x84,0x85,0x86,0x81,0x82},
		Buffer() {0x83,0x84,0x85,0x86,0x81,0x82},

		Buffer() {0x87,0x98,0x99,0x9A,0x9B,0x81,0x82},
		Buffer() {0x87,0x98,0x99,0x9A,0x9B,0x81,0x82},

		Buffer() {0x9C,0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3,0x81,0x82},
		Buffer() {0x9C,0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3,0x81,0x82},

		Buffer() {0xA4,0xA5,0xA6,0xA7,0xB8,0xB9,0xBA,0xBB,0xBC,0x81,0x82},
		Buffer() {0xA4,0xA5,0xA6,0xA7,0xB8,0xB9,0xBA,0xBB,0xBC,0x81,0x82},

		Buffer() {0x91,0x92,0x93,0x94,0x5F,0x60,0x61,0x62,0x63,0x0A,0x0B,0x0C,
				0x0D,0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,
				0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,
				0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,0x30,
				0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,
				0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,
				0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,0x52,0x53,0x54,
				0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,0x60,
				0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,
				0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
				0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0x80,0x81,0x82,0x83,0x84,
				0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,0x90,
				0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,
				0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,
				0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,0xB0,0xB1,0xB2,0xB3,0xB4,
				0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,0xC0,
				0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0x81,0x82},
		Buffer() {0x91,0x92,0x93,0x94,0x5F,0x60,0x61,0x62,0x63,0x0A,0x0B,0x0C,
				0x0D,0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,
				0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,
				0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,0x30,
				0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,
				0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,
				0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,0x52,0x53,0x54,
				0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,0x60,
				0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,
				0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
				0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0x80,0x81,0x82,0x83,0x84,
				0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,0x90,
				0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,
				0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,
				0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,0xB0,0xB1,0xB2,0xB3,0xB4,
				0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,0xC0,
				0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0x81,0x82},

		Buffer() {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,
				0x0D,0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,
				0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,
				0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,0x30,
				0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,
				0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,
				0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,0x52,0x53,0x54,
				0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,0x60,
				0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,
				0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
				0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0x80,0x81,0x82,0x83,0x84,
				0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,0x90,
				0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,
				0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,
				0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,0xB0,0xB1,0xB2,0xB3,0xB4,
				0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,0xC0,
				0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,
				0xCD,0xCE,0xCF,0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,
				0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,0xE0,0xE1,0xE2,0xE3,0xE4,
				0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,0xF0,
				0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,
				0xFD,0xFE,0xFF,0x00,0x01,0x81,0x82},
		Buffer() {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,
				0x0D,0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,
				0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,
				0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,0x30,
				0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,
				0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,
				0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,0x52,0x53,0x54,
				0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,0x60,
				0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,
				0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
				0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0x80,0x81,0x82,0x83,0x84,
				0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,0x90,
				0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,
				0x9D,0x9E,0x9F,0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,
				0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,0xB0,0xB1,0xB2,0xB3,0xB4,
				0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,0xC0,
				0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,
				0xCD,0xCE,0xCF,0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,
				0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,0xE0,0xE1,0xE2,0xE3,0xE4,
				0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,0xF0,
				0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,
				0xFD,0xFE,0xFF,0x00,0x01,0x81,0x82},

		// X - Field Unit

		Buffer() {0x7F,0,0,0,0,0,0,0,0x81,0x82,0,0,0,0,0,0},
		Buffer() {0x7F,0,0,0,0x81,0x82,0,0},

		Buffer() {0x07,0,0,0,0,0,0,0,0x81,0x82,0,0,0,0,0,0},
		Buffer() {0x07,0,0,0,0x81,0x82,0,0},

		Buffer() {0x8D,0,0,0,0,0,0,0,0x81,0x82,0,0,0,0,0,0},
		Buffer() {0x8D,0,0,0,0x81,0x82,0,0},

		Buffer() {0x8D,0x8c,0,0,0,0,0,0,0x81,0x82,0,0,0,0,0,0},
		Buffer() {0x8D,0x8c,0,0,0x81,0x82,0,0},

		Buffer() {0x8D,0x8c,0x8b,0x8a,0,0,0,0,0x81,0x82,0,0,0,0,0,0},
		Buffer() {0x8D,0x8c,0x8b,0x8a,0x81,0x82,0,0},

		Buffer() {0xFF,0xFF,0xFF,0xFF,0x01,0,0,0,0x81,0x82,0,0,0,0,0,0},
		Buffer() {0xFF,0xFF,0xFF,0xFF,0x01,0x81,0x82},

		Buffer() {0x58,0x46,0x37,0x88,0x19,0xFA,0xDE,0x5C,0x81,0x82,0,0,0,0,0,0},
		Buffer() {0x58,0x46,0x37,0x88,0x19,0xFA,0xDE,0x5C,0x81,0x82},

		Buffer() {0x58,0x9A,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x81,0x82,0,0,0,0,0,0},
		Buffer() {0x58,0x9A,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x81,0x82},

		Buffer() {0x58,0xC7,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x00,0x81,0x82},
		Buffer() {0x58,0xC7,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x00,0x81,0x82},

		Buffer() {0x82,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF,0x55,0,0,0,0,0,0,0,0x81,0x82},
		Buffer() {0x82,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF,0x55,0,0,0,0,0,0,0,0x81,0x82},

		Buffer() {0x93,0xAB,0xCD,0xEF,0x99,0x12,0xCD,0x52,0x87,0,0,0,0,
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0x81,0x82},
		Buffer() {0x93,0xAB,0xCD,0xEF,0x99,0x12,0xCD,0x52,0x87,0,0,0,0,
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0x81,0x82},

		// X - Buffer Field

		Buffer() {0xAB,0x54,0x86,0x91,0,0,0,0,0x81,0x82,0,0,0,0,0,0},
		Buffer() {0xAB,0x54,0x86,0x91,0x81,0x82,0,0},

		Buffer() {0x07,0,0,0,0,0,0,0,0x81,0x82,0,0,0,0,0,0},
		Buffer() {0x07,0,0,0,0x81,0x82,0,0},

		Buffer() {0x8D,0,0,0,0,0,0,0,0x81,0x82,0,0,0,0,0,0},
		Buffer() {0x8D,0,0,0,0x81,0x82,0,0},

		Buffer() {0x8D,0x8c,0,0,0,0,0,0,0x81,0x82,0,0,0,0,0,0},
		Buffer() {0x8D,0x8c,0,0,0x81,0x82,0,0},

		Buffer() {0x8D,0x8c,0x8b,0x8a,0,0,0,0,0x81,0x82,0,0,0,0,0,0},
		Buffer() {0x8D,0x8c,0x8b,0x8a,0x81,0x82,0,0},

		Buffer() {0xFF,0xFF,0xFF,0xFF,0x01,0,0,0,0x81,0x82,0,0,0,0,0,0},
		Buffer() {0xFF,0xFF,0xFF,0xFF,0x01,0x81,0x82},

		Buffer() {0x58,0x46,0x37,0x88,0x19,0xFA,0xDE,0x5C,0x81,0x82,0,0,0,0,0,0},
		Buffer() {0x58,0x46,0x37,0x88,0x19,0xFA,0xDE,0x5C,0x81,0x82},

		Buffer() {0x58,0x9A,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x81,0x82,0,0,0,0,0,0},
		Buffer() {0x58,0x9A,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x81,0x82},

		Buffer() {0x58,0xC7,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x00,0x81,0x82},
		Buffer() {0x58,0xC7,0x37,0x88,0x19,0xFA,0xDE,0xDC,0x00,0x81,0x82},

		Buffer() {0x82,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF,0x55,0,0,0,0,0,0,0,0x81,0x82},
		Buffer() {0x82,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF,0x55,0,0,0,0,0,0,0,0x81,0x82},

		Buffer() {0x93,0xAB,0xCD,0xEF,0x99,0x12,0xCD,0x52,0x87,0,0,0,0,
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0x81,0x82},
		Buffer() {0x93,0xAB,0xCD,0xEF,0x99,0x12,0xCD,0x52,0x87,0,0,0,0,
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0x81,0x82},
		})

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
//		Store(0x200, df00)
//		Store(m488(op, 0, 0x1ed1, 0, 0, 0), Local7)
//		Store(0x300, df00)
//		Store(m488(op, 0, 0x1ed1, 0, 0, 0), Local7)

	} else {
		Store(1, FLG1)

		// (Integer ==> All other types)
		// (All other types ==> Integer)
		Store(2, com2)
		Store(p000, PKG1)
		Store(p001, PKG2)
		m48b(op, 0x103)

		// (String ==> All other types)
		// (All other types ==> String)
		Store(2, com2)
		Store(p002, PKG1)
		Store(p003, PKG2)
		m48b(op, 0x204)

		// (Buffer ==> All other types)
		// (All other types ==> Buffer)
		Store(2, com2)
		Store(p004, PKG1)
		Store(p005, PKG2)
		m48b(op, 0x302)

		Store(PKG0, PKG1)
		Store(PKG0, PKG2)
		Store(0, com2)
		Store(0, FLG1)
	}
}

// ConcatenateResTemplate (rtb, rtb, Result) => Buffer
//
// Total scale of unacceptable types:
//    Source1: 0x5ef7
//    Source2: 0x5ef7
// Total scale of acceptable types:
//    Source1: 0x0008
//    Source2: 0x0008
Method(m404, 1, Serialized)
{
	Name(op, 4)

	ts00("m404")

	if (arg0) {
		m486()
		Store(0x30b, df00)
		Store(0x30b, df01)
		Store(m488(op, 0x5fff, 0x5fff, 0, 0, 0), Local7)
	} else {
	}
}

// CondRefOf (any, Result) => Boolean
//
// Total scale of unacceptable types:
//    Source: 0x0000
// Total scale of acceptable types:
//    Source: 0x5eff
Method(m405, 1, Serialized)
{
	Name(op, 5)

	ts00("m405")

	if (arg0) {
		m486()

// Error: CondRefOf failes with the Unitialized type
		Store(m488(op, 0x0001, 0, 0, 0, 0), Local7)

	} else {
	}
}

// CopyObject (any, Destination) => DataRefObject
//
// Total scale of unacceptable types:
//    Source: 0x0000
// Total scale of acceptable types:
//    Source: 0x5eff
Method(m406, 1, Serialized)
{
	Name(op, 6)

	ts00("m406")

	if (arg0) {
		m486()

// Error: CopyObject failes with the Unitialized type
		Store(m488(op, 0x0001, 0, 0, 0, 0), Local7)

	} else {
	}
}

// Decrement (int) => Integer
//
// Total scale of unacceptable types:
//    Minuend: 0x1ed1
// Total scale of acceptable types:
//    Minuend: 0x402e
Method(m407, 1, Serialized)
{
	Name(op, 7)

	Name(ts, "m407")

	ts00(ts)

	if (arg0) {
		m486()
		Store(m488(op, 0x1ed1, 0, 0, 0, 0), Local7)
	} else {
		Store(m48d(op, 0x102, 0, 0, 0, 0x12345677, 0x12345677), Local7)
		Store(m48d(op, 0x204, 0, 0, 0, 0x9875, 0x9875), Local7)
		Store(m48d(op, 0x209, 0, 0, 0, 0xFdeAcb0132547697, 0x32547697), Local7)
		Store(m48d(op, 0x302, 0, 0, 0, 0x8280, 0x8280), Local7)
		Store(m48d(op, 0x308, 0, 0, 0, 0x0807060504030200, 0x04030200), Local7)
		Store(m48d(op, 0x506, 0, 0, 0,  0x5CDEFA1988374657,  0x88374657), Local7)
		Store(m48d(op, 0xe06, 0, 0, 0,  0x5CDEFA1988374657,  0x88374657), Local7)

		// Exceptions

		Store(m48d(op, 0x202, 0, 0, 0, "Exc", "Exc"), Local7)
		Store(m48d(op, 0x20a, 0, 0, 0, "Exc", "Exc"), Local7)
		Store(m48d(op, 0x210, 0, 0, 0, "Exc", "Exc"), Local7)
	}
}

// DerefOf ({ref|str}) => Object
//
// Total scale of unacceptable types:
//    Source: 0x5fff
// Total scale of acceptable types:
//    Source: 0x0000
Method(m408, 1, Serialized)
{
	Name(op, 8)

	ts00("m408")

	if (arg0) {
		m486()
		Store(m488(op, 0x5fff, 0, 0, 0, 0), Local7)
	} else {
	}
}

// Divide (int, int, Remainder, Result) => Integer
//
// Total scale of unacceptable types:
//    Dividend: 0x1ed1
//    Divisor: 0x1ed1
// Total scale of acceptable types:
//    Dividend: 0x402e
//    Divisor: 0x402e
Method(m409, 1, Serialized)
{
	Name(op, 9)

	ts00("m409")

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
		Store(m48d(op, 0x102, 0x102, 0, 0, 1, 1), Local7)
		Store(m48d(op, 0x103, 0x102, 0, 0, 0x0000000971C214EA, 3), Local7)
		Store(m48d(op, 0x204, 0x102, 0, 0, 0, 0), Local7)
		Store(m48d(op, 0x209, 0x102, 0, 0, 0x0000000DF2B5C737, 2), Local7)
		Store(m48d(op, 0x302, 0x102, 0, 0, 0, 0), Local7)
		Store(m48d(op, 0x308, 0x102, 0, 0, 0x0000000070E2C4AA, 0), Local7)
		Store(m48d(op, 0x506, 0x102, 0, 0,  0x0000000519FF9D32,  7), Local7)
		Store(m48d(op, 0xe06, 0x102, 0, 0,  0x0000000519FF9D32,  7), Local7)
		Store(m48d(op, 0x103, 0x204, 0, 0, 0x000120B0A1E2C2D5, 0x00006F2A), Local7)

		// Exceptions

		Store(m48d(op, 0x202, 0x102, 0, 0, "Exc", "Exc"), Local7)
		Store(m48d(op, 0x20a, 0x102, 0, 0, "Exc", "Exc"), Local7)
		Store(m48d(op, 0x210, 0x102, 0, 0, "Exc", "Exc"), Local7)

		Store(m48d(op, 0x102, 0x202, 0, 0, "Exc", "Exc"), Local7)
		Store(m48d(op, 0x102, 0x20a, 0, 0, "Exc", "Exc"), Local7)
		Store(m48d(op, 0x102, 0x210, 0, 0, "Exc", "Exc"), Local7)
	}
}

// Fatal (byt, dwd, int)
//
// iasl: "Fatal operator requires [Integer|String|Buffer]"
// Total scale of unacceptable types:
//    Arg: 0x1ed1
// Total scale of acceptable types:
//    Arg: 0x402e
Method(m410, 1, Serialized)
{
	Name(op, 10)

	ts00("m410")

	if (arg0) {
		m486()
		Store(m488(op, 0x1ed1, 0, 0, 0, 0), Local7)
	} else {
	}
}

// FindSetLeftBit (int, Result) => Integer
//
// Total scale of unacceptable types:
//    Source: 0x1ed1
// Total scale of acceptable types:
//    Source: 0x402e
Method(m411, 1, Serialized)
{
	Name(op, 11)

	ts00("m411")

	if (arg0) {
		m486()
		Store(m488(op, 0x1ed1, 0, 0, 0, 0), Local7)
	} else {
		Store(m48d(op, 0x102, 0, 0, 0, 29, 29), Local7)
		Store(m48d(op, 0x204, 0, 0, 0, 16, 16), Local7)
		Store(m48d(op, 0x206, 0, 0, 0, 61, 32), Local7)

		// Exceptions

		Store(m48d(op, 0x202, 0, 0, 0, "Exc", "Exc"), Local7)
		Store(m48d(op, 0x20a, 0, 0, 0, "Exc", "Exc"), Local7)
		Store(m48d(op, 0x210, 0, 0, 0, "Exc", "Exc"), Local7)
	}
}

// FindSetRightBit (int, Result) => Integer
//
// Total scale of unacceptable types:
//    Source: 0x1ed1
// Total scale of acceptable types:
//    Source: 0x402e
Method(m412, 1, Serialized)
{
	Name(op, 12)

	ts00("m412")

	if (arg0) {
		m486()
		Store(m488(op, 0x1ed1, 0, 0, 0, 0), Local7)
	} else {
		Store(m48d(op, 0x102, 0, 0, 0, 4, 4), Local7)
		Store(m48d(op, 0x204, 0, 0, 0, 2, 2), Local7)
		Store(m48d(op, 0x206, 0, 0, 0, 3, 3), Local7)

		// Exceptions

		Store(m48d(op, 0x202, 0, 0, 0, "Exc", "Exc"), Local7)
		Store(m48d(op, 0x20a, 0, 0, 0, "Exc", "Exc"), Local7)
		Store(m48d(op, 0x210, 0, 0, 0, "Exc", "Exc"), Local7)
	}
}

// FromBCD (int, Result) => Integer
//
// Total scale of unacceptable types:
//    BCDValue: 0x1ed1
// Total scale of acceptable types:
//    BCDValue: 0x402e
Method(m413, 1, Serialized)
{
	Name(op, 13)

	ts00("m413")

	if (arg0) {
		m486()
		Store(m488(op, 0x1ed1, 0, 0, 0, 0), Local7)
	} else {
	}
}

// Increment (int) => Integer
//
// Total scale of unacceptable types:
//    Addend: 0x1ed1
// Total scale of acceptable types:
//    Addend: 0x402e
Method(m414, 1, Serialized)
{
	Name(op, 14)

	ts00("m414")

	if (arg0) {
		m486()
		Store(m488(op, 0x1ed1, 0, 0, 0, 0), Local7)
	} else {

		Store(m48d(op, 0x102, 0, 0, 0, 0x12345679, 0x12345679), Local7)
		Store(m48d(op, 0x204, 0, 0, 0, 0x9877, 0x9877), Local7)
		Store(m48d(op, 0x209, 0, 0, 0, 0xFdeAcb0132547699, 0x32547699), Local7)
		Store(m48d(op, 0x302, 0, 0, 0, 0x8282, 0x8282), Local7)
		Store(m48d(op, 0x308, 0, 0, 0, 0x0807060504030202, 0x04030202), Local7)
		Store(m48d(op, 0x506, 0, 0, 0,  0x5CDEFA1988374659,  0x88374659), Local7)
		Store(m48d(op, 0xe06, 0, 0, 0,  0x5CDEFA1988374659,  0x88374659), Local7)

		// Exceptions

		Store(m48d(op, 0x202, 0, 0, 0, "Exc", "Exc"), Local7)
		Store(m48d(op, 0x20a, 0, 0, 0, "Exc", "Exc"), Local7)
		Store(m48d(op, 0x210, 0, 0, 0, "Exc", "Exc"), Local7)
	}
}

// Index ({str|buf|pkg}, int, Destination) => ObjectReference
//
// Total scale of unacceptable types:
//    Source: 0x5fe3
//    Index: 0x1ed1
// Total scale of acceptable types:
//    Source: 0x001c
//    Index: 0x402e
Method(m415, 1, Serialized)
{
	Name(op, 15)

	ts00("m415")

	if (arg0) {
		m486()
		Store(0x200, df00)
		Store(0x104, df01)	// Zero
		Store(m488(op, 0x5fe3, 0x1ed1, 0, 0, 0), Local7)

/*
// The action above together with those below generates exception
		Store(0x300, df00)
		Store(m488(op, 0, 0x1ed1, 0, 0, 0), Local7)
		Store(0x400, df00)
		Store(m488(op, 0, 0x1ed1, 0, 0, 0), Local7)
*/

	} else {
	}
}

// LAnd (int, int) => Boolean
//
// Total scale of unacceptable types:
//    Source1: 0x1ed1
//    Source2: 0x1ed1
// Total scale of acceptable types:
//    Source1: 0x402e
//    Source2: 0x402e
Method(m416, 1, Serialized)
{
	Name(op, 16)

	ts00("m416")

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
	}
}

// LEqual ({int|str|buf}, {int|str|buf}) => Boolean
//
// Total scale of unacceptable types:
//    Source1: 0x1ed1
//    Source2: 0x1ed1
// Total scale of acceptable types:
//    Source1: 0x402e
//    Source2: 0x402e
Method(m417, 1, Serialized)
{
	Name(op, 17)

	ts00("m417")

	// Expected results: 64-bit, 32-bit
	Name(p000, Package() {

		// X - Integer

		Zero, Zero,

		// X - String

		"Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",

		Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,


		"Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",
		"Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",

		// X - Buffer

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,

		// X - Field Unit

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,

		// X - Buffer Field

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,
		})

	// Expected results: 64-bit, 32-bit
	Name(p001, Package() {

		// X - Integer

		Zero, Zero,

		// X - String

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,

		// X - Buffer

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,

		// X - Field Unit

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,

		// X - Buffer Field

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,
		})

	// Expected results: 64-bit, 32-bit
	Name(p002, Package() {

		// X - Integer

		Zero, Zero,

		// X - String

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,

		// X - Buffer

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  "Exc", "Exc",  "Exc", "Exc",

		// X - Field Unit

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,

		// X - Buffer Field

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,
		})

	// Expected results: 64-bit, 32-bit
	Name(p003, Package() {

		// X - Integer

		Zero, Zero,

		// X - String

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,

		// X - Buffer

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,

		// X - Field Unit

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,

		// X - Buffer Field

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,
		})

	// Expected results: 64-bit, 32-bit
	Name(p004, Package() {

		// X - Integer

		Zero, Zero,

		// X - String

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,

		// X - Buffer

		Zero, Zero,  Zero, Zero,  Ones, Ones,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,

		// X - Field Unit

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,

		// X - Buffer Field

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,
		})

	// Expected results: 64-bit, 32-bit
	Name(p005, Package() {

		// X - Integer

		Zero, Zero,

		// X - String

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,

		// X - Buffer

		Zero, Zero,  Zero, Zero,  Ones, Ones,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,

		// X - Field Unit

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,

		// X - Buffer Field

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,
		})

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
		Store(1, FLG1)

		// (Integer ==> All other types)
		// (All other types ==> Integer)
		Store(2, com2)
		Store(p000, PKG1)
		Store(p001, PKG2)
		m48b(op, 0x103)

		// (String ==> All other types)
		// (All other types ==> String)
		Store(2, com2)
		Store(p002, PKG1)
		Store(p003, PKG2)
		m48b(op, 0x204)

		// (Buffer ==> All other types)
		// (All other types ==> Buffer)
		Store(2, com2)
		Store(p004, PKG1)
		Store(p005, PKG2)
		m48b(op, 0x302)

		Store(PKG0, PKG1)
		Store(PKG0, PKG2)
		Store(0, com2)
		Store(0, FLG1)
	}
}

// LGreater ({int|str|buf}, {int|str|buf}) => Boolean
//
// Total scale of unacceptable types:
//    Source1: 0x1ed1
//    Source2: 0x1ed1
// Total scale of acceptable types:
//    Source1: 0x402e
//    Source2: 0x402e
Method(m418, 1, Serialized)
{
	Name(op, 18)

	ts00("m418")

	// Expected results: 64-bit, 32-bit
	Name(p000, Package() {

		// X - Integer, (0)

		Ones, Zero,

		// X - String, (1)

		"Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",

		Ones, Ones,  Ones, Ones,  Ones, Zero,
		Zero, Zero,  Ones, Zero,  Zero, Ones,


		"Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",
		"Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",

		// X - Buffer, (18)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Zero,  Ones, Zero,
		Ones, Zero,  Zero, Zero,  Ones, Zero,  Ones, Ones,

		// X - Field Unit, (27)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Zero,
		Ones, Zero,  Ones, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Ones, Zero,

		// X - Buffer Field, (38)

		Ones, Zero,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Zero,
		Ones, Zero,  Ones, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Ones, Zero,
		})

	// Expected results: 64-bit, 32-bit
	Name(p001, Package() {

		// X - Integer, (0)

		Zero, Ones,

		// X - String, (1)

		Ones, Ones,  Ones, Ones,  Zero, Zero,  Ones, Ones,

		Zero, Ones,  Ones, Ones,  Zero, Zero,
		Ones, Ones,  Zero, Zero,  Ones, Ones,

		Zero, Zero,  Ones, Ones,  Zero, Zero,  Ones, Ones,  Zero, Zero,
		Ones, Ones,  Zero, Zero,

		// X - Buffer, (18)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,

		// X - Field Unit, (27)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Ones,
		Zero, Ones,  Zero, Zero,  Ones, Zero,  Zero, Zero,  Ones, Ones,
		Ones, Ones,

		// X - Buffer Field, (38)

		Zero, Ones,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Ones,
		Zero, Ones,  Zero, Zero,  Ones, Zero,  Zero, Zero,  Ones, Ones,
		Ones, Ones,
		})

	// Expected results: 64-bit, 32-bit
	Name(p002, Package() {

		// X - Integer, (0)

		Ones, Ones,

		// X - String, (1)

		Zero, Zero,  Zero, Zero,  Ones, Ones,  Zero, Zero,

		Zero, Zero,  Zero, Zero,  Ones, Ones,
		Zero, Zero,  Ones, Ones,  Zero, Zero,


		Ones, Ones,  Zero, Zero,  Ones, Ones,  Zero, Zero,
		Ones, Ones,  Zero, Zero,  Ones, Ones,

		// X - Buffer, (18)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Zero, Zero,  Zero, Zero,  "Exc", "Exc",  "Exc", "Exc",

		// X - Field Unit, (27)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Zero,  Ones, Ones,  Zero, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,

		// X - Buffer Field, (38)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Zero,  Ones, Ones,  Zero, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,
		})

	// Expected results: 64-bit, 32-bit
	Name(p003, Package() {

		// X - Integer, (0)

		Ones, Ones,

		// X - String, (1)

		Ones, Ones,  Ones, Ones,  Zero, Zero,  Ones, Ones,

		Zero, Zero,  Ones, Ones,  Zero, Zero,
		Ones, Ones,  Zero, Zero,  Ones, Ones,


		Zero, Zero,  Ones, Ones,  Zero, Zero,  Ones, Ones,
		Zero, Zero,  Ones, Ones,  Zero, Zero,

		// X - Buffer, (18)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,

		// X - Field Unit, (27)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,

		// X - Buffer Field, (38)

		Ones, Ones,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,
		})

	// Expected results: 64-bit, 32-bit
	Name(p004, Package() {

		// X - Integer, (0)

		Ones, Ones,

		// X - String, (1)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,

		Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,


		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,

		// X - Buffer, (18)

		Zero, Zero,  Ones, Ones,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,

		// X - Field Unit, (27)

		Ones, Ones,  Ones, Ones,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,
		Zero, Zero,

		// X - Buffer Field, (38)

		Zero, Zero,  Ones, Ones,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,
		Zero, Zero,
		})

	// Expected results: 64-bit, 32-bit
	Name(p005, Package() {

		// X - Integer, (0)

		Ones, Ones,

		// X - String, (1)

		Ones, Ones,  Ones, Ones,  Zero, Zero,  Ones, Ones,

		Ones, Ones,  Ones, Ones,  Zero, Zero,
		Ones, Ones,  Zero, Zero,  Ones, Ones,

		Zero, Zero,  Ones, Ones,  Zero, Zero,  Ones, Ones,
		Zero, Zero,  Ones, Ones,  Zero, Zero,

		// X - Buffer, (18)

		Ones, Ones,  Zero, Zero,  Zero, Zero,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,

		// X - Field Unit, (27)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Zero,  Ones, Zero,  Zero, Zero,  Ones, Ones,
		Ones, Ones,

		// X - Buffer Field, (38)

		Ones, Ones,  Zero, Zero,  Zero, Zero,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Zero,  Ones, Zero,  Zero, Zero,  Ones, Ones,
		Ones, Ones,
		})

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
		Store(1, FLG1)

		// (Integer ==> All other types)
		// (All other types ==> Integer)
		Store(2, com2)
		Store(p000, PKG1)
		Store(p001, PKG2)
		m48b(op, 0x103)

		// (String ==> All other types)
		// (All other types ==> String)
		Store(2, com2)
		Store(p002, PKG1)
		Store(p003, PKG2)
		m48b(op, 0x204)

		// (Buffer ==> All other types)
		// (All other types ==> Buffer)
		Store(2, com2)
		Store(p004, PKG1)
		Store(p005, PKG2)
		m48b(op, 0x302)

		Store(PKG0, PKG1)
		Store(PKG0, PKG2)
		Store(0, com2)
		Store(0, FLG1)
	}
}

// LGreaterEqual ({int|str|buf}, {int|str|buf}) => Boolean
//
// Total scale of unacceptable types:
//    Source1: 0x1ed1
//    Source2: 0x1ed1
// Total scale of acceptable types:
//    Source1: 0x402e
//    Source2: 0x402e
Method(m419, 1, Serialized)
{
	Name(op, 19)

	ts00("m419")

	// Expected results: 64-bit, 32-bit
	Name(p000, Package() {

		// X - Integer, (0)

		Ones, Zero,

		// X - String, (1)

		"Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",

		Ones, Ones,  Ones, Ones,  Ones, Zero,
		Zero, Zero,  Ones, Zero,  Zero, Ones,


		"Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",
		"Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",

		// X - Buffer, (18)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Zero,  Ones, Zero,
		Ones, Zero,  Zero, Zero,  Ones, Zero,  Ones, Ones,

		// X - Field Unit, (27)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Zero,
		Ones, Zero,  Ones, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Ones, Zero,

		// X - Buffer Field, (38)

		Ones, Zero,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Zero,
		Ones, Zero,  Ones, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Ones, Zero,
		})

	// Expected results: 64-bit, 32-bit
	Name(p001, Package() {

		// X - Integer, (0)

		Zero, Ones,

		// X - String, (1)

		Ones, Ones,  Ones, Ones,  Zero, Zero,  Ones, Ones,

		Zero, Ones,  Ones, Ones,  Zero, Zero,
		Ones, Ones,  Zero, Zero,  Ones, Ones,

		Zero, Zero,  Ones, Ones,  Zero, Zero,  Ones, Ones,  Zero, Zero,
		Ones, Ones,  Zero, Zero,

		// X - Buffer, (18)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,

		// X - Field Unit, (27)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Ones,
		Zero, Ones,  Zero, Zero,  Ones, Zero,  Zero, Zero,  Ones, Ones,
		Ones, Ones,

		// X - Buffer Field, (38)

		Zero, Ones,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Ones,
		Zero, Ones,  Zero, Zero,  Ones, Zero,  Zero, Zero,  Ones, Ones,
		Ones, Ones,
		})

	// Expected results: 64-bit, 32-bit
	Name(p002, Package() {

		// X - Integer, (0)

		Ones, Ones,

		// X - String, (1)

		Zero, Zero,  Zero, Zero,  Ones, Ones,  Zero, Zero,

		Ones, Ones,  Zero, Zero,  Ones, Ones,
		Zero, Zero,  Ones, Ones,  Zero, Zero,


		Ones, Ones,  Zero, Zero,  Ones, Ones,  Zero, Zero,
		Ones, Ones,  Zero, Zero,  Ones, Ones,

		// X - Buffer, (18)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Zero, Zero,  Zero, Zero,  "Exc", "Exc",  "Exc", "Exc",

		// X - Field Unit, (27)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Zero,  Ones, Ones,  Zero, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,

		// X - Buffer Field, (38)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Zero,  Ones, Ones,  Zero, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,
		})

	// Expected results: 64-bit, 32-bit
	Name(p003, Package() {

		// X - Integer, (0)

		Ones, Ones,

		// X - String, (1)

		Ones, Ones,  Ones, Ones,  Zero, Zero,  Ones, Ones,

		Ones, Ones,  Ones, Ones,  Zero, Zero,
		Ones, Ones,  Zero, Zero,  Ones, Ones,


		Zero, Zero,  Ones, Ones,  Zero, Zero,  Ones, Ones,
		Zero, Zero,  Ones, Ones,  Zero, Zero,

		// X - Buffer, (18)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,

		// X - Field Unit, (27)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,

		// X - Buffer Field, (38)

		Ones, Ones,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,
		})

	// Expected results: 64-bit, 32-bit
	Name(p004, Package() {

		// X - Integer, (0)

		Ones, Ones,

		// X - String, (1)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,

		Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,


		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,

		// X - Buffer, (18)

		Zero, Zero,  Ones, Ones,  Ones, Ones,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,

		// X - Field Unit, (27)

		Ones, Ones,  Ones, Ones,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,
		Zero, Zero,

		// X - Buffer Field, (38)

		Zero, Zero,  Ones, Ones,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,
		Zero, Zero,
		})

	// Expected results: 64-bit, 32-bit
	Name(p005, Package() {

		// X - Integer, (0)

		Ones, Ones,

		// X - String, (1)

		Ones, Ones,  Ones, Ones,  Zero, Zero,  Ones, Ones,

		Ones, Ones,  Ones, Ones,  Zero, Zero,
		Ones, Ones,  Zero, Zero,  Ones, Ones,


		Zero, Zero,  Ones, Ones,  Zero, Zero,  Ones, Ones,
		Zero, Zero,  Ones, Ones,  Zero, Zero,

		// X - Buffer, (18)

		Ones, Ones,  Zero, Zero,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,

		// X - Field Unit, (27)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Zero,  Ones, Zero,  Zero, Zero,  Ones, Ones,
		Ones, Ones,

		// X - Buffer Field, (38)

		Ones, Ones,  Zero, Zero,  Zero, Zero,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Zero,  Ones, Zero,  Zero, Zero,  Ones, Ones,
		Ones, Ones,
		})

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
		Store(1, FLG1)

		// (Integer ==> All other types)
		// (All other types ==> Integer)
		Store(2, com2)
		Store(p000, PKG1)
		Store(p001, PKG2)
		m48b(op, 0x103)

		// (String ==> All other types)
		// (All other types ==> String)
		Store(2, com2)
		Store(p002, PKG1)
		Store(p003, PKG2)
		m48b(op, 0x204)

		// (Buffer ==> All other types)
		// (All other types ==> Buffer)
		Store(2, com2)
		Store(p004, PKG1)
		Store(p005, PKG2)
		m48b(op, 0x302)

		Store(PKG0, PKG1)
		Store(PKG0, PKG2)
		Store(0, com2)
		Store(0, FLG1)
	}
}

// LLess ({int|str|buf}, {int|str|buf}) => Boolean
//
// Total scale of unacceptable types:
//    Source1: 0x1ed1
//    Source2: 0x1ed1
// Total scale of acceptable types:
//    Source1: 0x402e
//    Source2: 0x402e
Method(m420, 1, Serialized)
{
	Name(op, 20)

	ts00("m420")

	// Expected results: 64-bit, 32-bit
	Name(p000, Package() {

		// X - Integer, (0)

		Zero, Ones,

		// X - String, (1)

		"Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",

		Zero, Zero,  Zero, Zero,  Zero, Ones,
		Ones, Ones,  Zero, Ones,  Ones, Zero,


		"Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",
		"Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",

		// X - Buffer, (18)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Ones,  Zero, Ones,
		Zero, Ones,  Ones, Ones,  Zero, Ones,  Zero, Zero,

		// X - Field Unit, (27)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Ones,
		Zero, Ones,  Zero, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Zero, Ones,

		// X - Buffer Field, (38)

		Zero, Ones,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Ones,
		Zero, Ones,  Zero, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Zero, Ones,
		})

	// Expected results: 64-bit, 32-bit
	Name(p001, Package() {

		// X - Integer, (0)

		Ones, Zero,

		// X - String, (1)

		Zero, Zero,  Zero, Zero,  Ones, Ones,  Zero, Zero,

		Ones, Zero,  Zero, Zero,  Ones, Ones,
		Zero, Zero,  Ones, Ones,  Zero, Zero,

		Ones, Ones,  Zero, Zero,  Ones, Ones,  Zero, Zero,  Ones, Ones,
		Zero, Zero,  Ones, Ones,

		// X - Buffer, (18)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,

		// X - Field Unit, (27)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Zero,
		Ones, Zero,  Ones, Ones,  Zero, Ones,  Ones, Ones,  Zero, Zero,
		Zero, Zero,

		// X - Buffer Field, (38)

		Ones, Zero,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Zero,
		Ones, Zero,  Ones, Ones,  Zero, Ones,  Ones, Ones,  Zero, Zero,
		Zero, Zero,
		})

	// Expected results: 64-bit, 32-bit
	Name(p002, Package() {

		// X - Integer, (0)

		Zero, Zero,

		// X - String, (1)

		Ones, Ones,  Ones, Ones,  Zero, Zero,  Ones, Ones,

		Zero, Zero,  Ones, Ones,  Zero, Zero,
		Ones, Ones,  Zero, Zero,  Ones, Ones,


		Zero, Zero,  Ones, Ones,  Zero, Zero,  Ones, Ones,
		Zero, Zero,  Ones, Ones,  Zero, Zero,

		// X - Buffer, (18)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Ones, Ones,  Ones, Ones,  "Exc", "Exc",  "Exc", "Exc",

		// X - Field Unit, (27)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Ones,  Zero, Zero,  Ones, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,

		// X - Buffer Field, (38)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Ones,  Zero, Zero,  Ones, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,
		})

	// Expected results: 64-bit, 32-bit
	Name(p003, Package() {

		// X - Integer, (0)

		Zero, Zero,

		// X - String, (1)

		Zero, Zero,  Zero, Zero,  Ones, Ones,  Zero, Zero,

		Zero, Zero,  Zero, Zero,  Ones, Ones,
		Zero, Zero,  Ones, Ones,  Zero, Zero,


		Ones, Ones,  Zero, Zero,  Ones, Ones,  Zero, Zero,
		Ones, Ones,  Zero, Zero,  Ones, Ones,

		// X - Buffer, (18)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,

		// X - Field Unit, (27)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,

		// X - Buffer Field, (38)

		Zero, Zero,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,
		})

	// Expected results: 64-bit, 32-bit
	Name(p004, Package() {

		// X - Integer, (0)

		Zero, Zero,

		// X - String, (1)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,

		Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,


		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,

		// X - Buffer, (18)

		Ones, Ones,  Zero, Zero,  Zero, Zero,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,

		// X - Field Unit, (27)

		Zero, Zero,  Zero, Zero,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,
		Ones, Ones,

		// X - Buffer Field, (38)

		Ones, Ones,  Zero, Zero,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,
		Ones, Ones,
		})

	// Expected results: 64-bit, 32-bit
	Name(p005, Package() {

		// X - Integer, (0)

		Zero, Zero,

		// X - String, (1)

		Zero, Zero,  Zero, Zero,  Ones, Ones,  Zero, Zero,

		Zero, Zero,  Zero, Zero,  Ones, Ones,
		Zero, Zero,  Ones, Ones,  Zero, Zero,


		Ones, Ones,  Zero, Zero,  Ones, Ones,  Zero, Zero,
		Ones, Ones,  Zero, Zero,  Ones, Ones,

		// X - Buffer, (18)

		Zero, Zero,  Ones, Ones,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,

		// X - Field Unit, (27)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Ones,  Zero, Ones,  Ones, Ones,  Zero, Zero,
		Zero, Zero,

		// X - Buffer Field, (38)

		Zero, Zero,  Ones, Ones,  Ones, Ones,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Ones,  Zero, Ones,  Ones, Ones,  Zero, Zero,
		Zero, Zero,
		})

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
		Store(1, FLG1)

		// (Integer ==> All other types)
		// (All other types ==> Integer)
		Store(2, com2)
		Store(p000, PKG1)
		Store(p001, PKG2)
		m48b(op, 0x103)

		// (String ==> All other types)
		// (All other types ==> String)
		Store(2, com2)
		Store(p002, PKG1)
		Store(p003, PKG2)
		m48b(op, 0x204)

		// (Buffer ==> All other types)
		// (All other types ==> Buffer)
		Store(2, com2)
		Store(p004, PKG1)
		Store(p005, PKG2)
		m48b(op, 0x302)

		Store(PKG0, PKG1)
		Store(PKG0, PKG2)
		Store(0, com2)
		Store(0, FLG1)
	}
}

// LLessEqual ({int|str|buf}, {int|str|buf}) => Boolean
//
// Total scale of unacceptable types:
//    Source1: 0x1ed1
//    Source2: 0x1ed1
// Total scale of acceptable types:
//    Source1: 0x402e
//    Source2: 0x402e
Method(m421, 1, Serialized)
{
	Name(op, 21)

	ts00("m421")

	// Expected results: 64-bit, 32-bit
	Name(p000, Package() {

		// X - Integer, (0)

		Zero, Ones,

		// X - String, (1)

		"Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",

		Zero, Zero,  Zero, Zero,  Zero, Ones,
		Ones, Ones,  Zero, Ones,  Ones, Zero,


		"Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",
		"Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",

		// X - Buffer, (18)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Ones,  Zero, Ones,
		Zero, Ones,  Ones, Ones,  Zero, Ones,  Zero, Zero,

		// X - Field Unit, (27)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Ones,
		Zero, Ones,  Zero, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Zero, Ones,

		// X - Buffer Field, (38)

		Zero, Ones,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Ones,
		Zero, Ones,  Zero, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Zero, Ones,
		})

	// Expected results: 64-bit, 32-bit
	Name(p001, Package() {

		// X - Integer, (0)

		Ones, Zero,

		// X - String, (1)

		Zero, Zero,  Zero, Zero,  Ones, Ones,  Zero, Zero,

		Ones, Zero,  Zero, Zero,  Ones, Ones,
		Zero, Zero,  Ones, Ones,  Zero, Zero,

		Ones, Ones,  Zero, Zero,  Ones, Ones,  Zero, Zero,  Ones, Ones,
		Zero, Zero,  Ones, Ones,

		// X - Buffer, (18)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,

		// X - Field Unit, (27)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Zero,
		Ones, Zero,  Ones, Ones,  Zero, Ones,  Ones, Ones,  Zero, Zero,
		Zero, Zero,

		// X - Buffer Field, (38)

		Ones, Zero,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Zero,
		Ones, Zero,  Ones, Ones,  Zero, Ones,  Ones, Ones,  Zero, Zero,
		Zero, Zero,
		})

	// Expected results: 64-bit, 32-bit
	Name(p002, Package() {

		// X - Integer, (0)

		Zero, Zero,

		// X - String, (1)

		Ones, Ones,  Ones, Ones,  Zero, Zero,  Ones, Ones,

		Ones, Ones,  Ones, Ones,  Zero, Zero,
		Ones, Ones,  Zero, Zero,  Ones, Ones,


		Zero, Zero,  Ones, Ones,  Zero, Zero,  Ones, Ones,
		Zero, Zero,  Ones, Ones,  Zero, Zero,

		// X - Buffer, (18)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Ones, Ones,  Ones, Ones,  "Exc", "Exc",  "Exc", "Exc",

		// X - Field Unit, (27)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Ones,  Zero, Zero,  Ones, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,

		// X - Buffer Field, (38)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Ones,  Zero, Zero,  Ones, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,
		})

	// Expected results: 64-bit, 32-bit
	Name(p003, Package() {

		// X - Integer, (0)

		Zero, Zero,

		// X - String, (1)

		Zero, Zero,  Zero, Zero,  Ones, Ones,  Zero, Zero,

		Ones, Ones,  Zero, Zero,  Ones, Ones,
		Zero, Zero,  Ones, Ones,  Zero, Zero,


		Ones, Ones,  Zero, Zero,  Ones, Ones,  Zero, Zero,
		Ones, Ones,  Zero, Zero,  Ones, Ones,

		// X - Buffer, (18)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,

		// X - Field Unit, (27)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,

		// X - Buffer Field, (38)

		Zero, Zero,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,
		})

	// Expected results: 64-bit, 32-bit
	Name(p004, Package() {

		// X - Integer, (0)

		Zero, Zero,

		// X - String, (1)

		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,

		Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,


		Zero, Zero,  Zero, Zero,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,

		// X - Buffer, (18)

		Ones, Ones,  Zero, Zero,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,

		// X - Field Unit, (27)

		Zero, Zero,  Zero, Zero,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,
		Ones, Ones,

		// X - Buffer Field, (38)

		Ones, Ones,  Zero, Zero,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,
		Ones, Ones,
		})

	// Expected results: 64-bit, 32-bit
	Name(p005, Package() {

		// X - Integer, (0)

		Zero, Zero,

		// X - String, (1)

		Zero, Zero,  Zero, Zero,  Ones, Ones,  Zero, Zero,

		Zero, Zero,  Zero, Zero,  Ones, Ones,
		Zero, Zero,  Ones, Ones,  Zero, Zero,


		Ones, Ones,  Zero, Zero,  Ones, Ones,  Zero, Zero,
		Ones, Ones,  Zero, Zero,  Ones, Ones,

		// X - Buffer, (18)

		Zero, Zero,  Ones, Ones,  Ones, Ones,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Zero,  Zero, Zero,  Ones, Ones,

		// X - Field Unit, (27)

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Ones,  Zero, Ones,  Ones, Ones,  Zero, Zero,
		Zero, Zero,

		// X - Buffer Field, (38)

		Zero, Zero,  Ones, Ones,  Ones, Ones,  Zero, Zero,  Zero, Zero,
		Zero, Zero,  Zero, Ones,  Zero, Ones,  Ones, Ones,  Zero, Zero,
		Zero, Zero,
		})

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
		Store(1, FLG1)

		// (Integer ==> All other types)
		// (All other types ==> Integer)
		Store(2, com2)
		Store(p000, PKG1)
		Store(p001, PKG2)
		m48b(op, 0x103)

		// (String ==> All other types)
		// (All other types ==> String)
		Store(2, com2)
		Store(p002, PKG1)
		Store(p003, PKG2)
		m48b(op, 0x204)

		// (Buffer ==> All other types)
		// (All other types ==> Buffer)
		Store(2, com2)
		Store(p004, PKG1)
		Store(p005, PKG2)
		m48b(op, 0x302)

		Store(PKG0, PKG1)
		Store(PKG0, PKG2)
		Store(0, com2)
		Store(0, FLG1)
	}
}

// LNot (int) => Boolean
//
// Total scale of unacceptable types:
//    Source: 0x1ed1
// Total scale of acceptable types:
//    Source: 0x402e
Method(m422, 1, Serialized)
{
	Name(op, 22)

	ts00("m422")

	if (arg0) {
		m486()
		Store(m488(op, 0x1ed1, 0, 0, 0, 0), Local7)
	} else {
	}
}

// LNotEqual ({int|str|buf}, {int|str|buf}) => Boolean
//
// Total scale of unacceptable types:
//    Source1: 0x1ed1
//    Source2: 0x1ed1
// Total scale of acceptable types:
//    Source1: 0x402e
//    Source2: 0x402e
Method(m423, 1, Serialized)
{
	Name(op, 23)

	ts00("m423")

	// Expected results: 64-bit, 32-bit
	Name(p000, Package() {

		// X - Integer

		Ones, Ones,

		// X - String

		"Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",

		Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,


		"Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",
		"Exc", "Exc",  "Exc", "Exc",  "Exc", "Exc",

		// X - Buffer

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,

		// X - Field Unit

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,

		// X - Buffer Field

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,
		})

	// Expected results: 64-bit, 32-bit
	Name(p001, Package() {

		// X - Integer

		Ones, Ones,

		// X - String

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,

		// X - Buffer

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,

		// X - Field Unit

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,

		// X - Buffer Field

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,
		})

	// Expected results: 64-bit, 32-bit
	Name(p002, Package() {

		// X - Integer

		Ones, Ones,

		// X - String

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,

		// X - Buffer

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  "Exc", "Exc",  "Exc", "Exc",

		// X - Field Unit

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,

		// X - Buffer Field

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,
		})

	// Expected results: 64-bit, 32-bit
	Name(p003, Package() {

		// X - Integer

		Ones, Ones,

		// X - String

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Zero, Zero,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,

		// X - Buffer

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,

		// X - Field Unit

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,

		// X - Buffer Field

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,
		})

	// Expected results: 64-bit, 32-bit
	Name(p004, Package() {

		// X - Integer

		Ones, Ones,

		// X - String

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,

		// X - Buffer

		Ones, Ones,  Ones, Ones,  Zero, Zero,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,

		// X - Field Unit

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,

		// X - Buffer Field

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,
		})

	// Expected results: 64-bit, 32-bit
	Name(p005, Package() {

		// X - Integer

		Ones, Ones,

		// X - String

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,

		// X - Buffer

		Ones, Ones,  Ones, Ones,  Zero, Zero,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,

		// X - Field Unit

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,

		// X - Buffer Field

		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,  Ones, Ones,
		Ones, Ones,
		})

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
		Store(1, FLG1)

		// (Integer ==> All other types)
		// (All other types ==> Integer)
		Store(2, com2)
		Store(p000, PKG1)
		Store(p001, PKG2)
		m48b(op, 0x103)

		// (String ==> All other types)
		// (All other types ==> String)
		Store(2, com2)
		Store(p002, PKG1)
		Store(p003, PKG2)
		m48b(op, 0x204)

		// (Buffer ==> All other types)
		// (All other types ==> Buffer)
		Store(2, com2)
		Store(p004, PKG1)
		Store(p005, PKG2)
		m48b(op, 0x302)

		Store(PKG0, PKG1)
		Store(PKG0, PKG2)
		Store(0, com2)
		Store(0, FLG1)
	}
}

// LOr (int, int) => Boolean
//
// Total scale of unacceptable types:
//    Source1: 0x1ed1
//    Source2: 0x1ed1
// Total scale of acceptable types:
//    Source1: 0x402e
//    Source2: 0x402e
Method(m424, 1, Serialized)
{
	Name(op, 24)

	ts00("m424")

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
	}
}

// Match (pkg, byt, int, byt, int, int) => Ones | Integer
//
// Total scale of unacceptable types:
//
//                   Total  Currently excluded from it
//    SearchPackage: 0x5eef
//    MatchObject1:  0x1ed1
//    MatchObject2:  0x1ed1 0x1ed1 (causes error)
//    StartIndex:    0x1ed1 0x1ed1 (causes error)
// Total scale of acceptable types:
//    SearchPackage: 0x0010
//    MatchObject1:  0x402e
//    MatchObject2:  0x402e
//    StartIndex:    0x402e
Method(m425, 1, Serialized)
{
	Name(op, 25)

	ts00("m425")

	if (arg0) {
		m486()
		Store(0x400, df00)
		Store(0x100, df01)
		Store(0x100, df02)
		Store(0x100, df03)
		Store(0x100, df04)
		Store(m488(op, 0x5eef, 0, 0x1ed1, 0x0000, 0x0000), Local7)
	} else {
	}
}

// Mid ({str|buf}, int, int, Result) => Buffer or String
//
// Total scale of unacceptable types:
//
//            Total  Currently excluded from it
//    Source: 0x1ed1
//    Index:  0x1ed1 0x0400 Op.Region (causes error)
//    Length: 0x1ed1 0x0400 Op.Region (causes error)
// Total scale of acceptable types:
//    Source: 0x402e
//    Index:  0x402e
//    Length: 0x402e
Method(m426, 1, Serialized)
{
	Name(op, 26)

	ts00("m426")

	if (arg0) {
		m486()
		Store(0x200, df00)
		Store(0x100, df01)
		Store(0x100, df02)
		Store(m488(op, 0x1ed1, 0x1ad1, 0x1ad1, 0, 0), Local7)
	} else {
	}
}

// Mod (int, int, Result) => Integer
//
// Total scale of unacceptable types:
//    Dividend: 0x1ed1
//    Divisor:  0x1ed1
// Total scale of acceptable types:
//    Dividend: 0x402e
//    Divisor:  0x402e
Method(m427, 1, Serialized)
{
	Name(op, 27)

	ts00("m427")

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
	}
}

// Multiply (int, int, Result) => Integer
//
// Total scale of unacceptable types:
//    Multiplicand: 0x1ed1
//    Multiplier:   0x1ed1
// Total scale of acceptable types:
//    Multiplicand: 0x402e
//    Multiplier:   0x402e
Method(m428, 1, Serialized)
{
	Name(op, 28)

	ts00("m428")

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
	}
}

// NAnd (int, int, Result) => Integer
//
// Total scale of unacceptable types:
//    Source1: 0x1ed1
//    Source2: 0x1ed1
// Total scale of acceptable types:
//    Source1: 0x402e
//    Source2: 0x402e
Method(m429, 1, Serialized)
{
	Name(op, 29)

	ts00("m429")

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
	}
}

// NOr (int, int, Result) => Integer
//
// Total scale of unacceptable types:
//    Source1: 0x1ed1
//    Source2: 0x1ed1
// Total scale of acceptable types:
//    Source1: 0x402e
//    Source2: 0x402e
Method(m430, 1, Serialized)
{
	Name(op, 30)

	ts00("m430")

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
	}
}

// Not (int, Result) => Integer
//
// Total scale of unacceptable types:
//    Source: 0x1ed1
// Total scale of acceptable types:
//    Source: 0x402e
Method(m431, 1, Serialized)
{
	Name(op, 31)

	ts00("m431")

	if (arg0) {
		m486()
		Store(m488(op, 0x1ed1, 0, 0, 0, 0), Local7)
	} else {
	}
}

// ObjectType (any) => Integer
//
// Total scale of unacceptable types:
//    Object: 0x0000
// Total scale of acceptable types:
//    Object: 0x5eff
Method(m432, 1, Serialized)
{
	Name(op, 32)

	ts00("m432")

	if (arg0) {
		m486()

// Error: ObjectType failes with the Unitialized type
		Store(m488(op, 0x0001, 0, 0, 0, 0), Local7)

	} else {
	}
}

// Or (int, int, Result) => Integer
//
// Total scale of unacceptable types:
//    Source1: 0x1ed1
//    Source2: 0x1ed1
// Total scale of acceptable types:
//    Source1: 0x402e
//    Source2: 0x402e
Method(m433, 1, Serialized)
{
	Name(op, 33)

	ts00("m433")

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
	}
}

// RefOf (any) => ObjectReference
//
// Total scale of unacceptable types:
//    Object: 0x0000
// Total scale of acceptable types:
//    Object: 0x5eff
Method(m434, 1, Serialized)
{
	Name(op, 34)

	ts00("m434")

	if (arg0) {
		m486()

// Error: RefOf failes with the Unitialized type
		Store(m488(op, 0x0001, 0, 0, 0, 0), Local7)

	} else {
	}
}

// Release (mux)
//
// Total scale of unacceptable types:
//    SyncObject: 0x5cff
// Total scale of acceptable types:
//    SyncObject: 0x0200
Method(m435, 1, Serialized)
{
	Name(op, 35)

	ts00("m435")

	if (arg0) {
		m486()
		Store(m488(op, 0x5cff, 0, 0, 0, 0), Local7)
	} else {
	}
}

// Reset (evt)
//
// Total scale of unacceptable types:
//    SyncObject: 0x5e7f
// Total scale of acceptable types:
//    SyncObject: 0x0080
Method(m436, 1, Serialized)
{
	Name(op, 36)

	ts00("m436")

	if (arg0) {
		m486()
		Store(m488(op, 0x5e7f, 0, 0, 0, 0), Local7)
	} else {
	}
}

// Return ({any|ref})
//
// Total scale of unacceptable types:
//    Arg: 0x0000
// Total scale of acceptable types:
//    Arg: 0x5eff
Method(m437, 1, Serialized)
{
	Name(op, 37)

	ts00("m437")

	if (arg0) {
		m486()

// Error: Return failes with the Unitialized type
		Store(m488(op, 0x0001, 0, 0, 0, 0), Local7)

	} else {
	}
}

// ShiftLeft (int, int, Result) => Integer
//
// Total scale of unacceptable types:
//    Source:     0x1ed1
//    ShiftCount: 0x1ed1
// Total scale of acceptable types:
//    Source:     0x402e
//    ShiftCount: 0x402e
Method(m438, 1, Serialized)
{
	Name(op, 38)

	ts00("m438")

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
	}
}

// ShiftRight (int, int, Result) => Integer
//
// Total scale of unacceptable types:
//    Source:     0x1ed1
//    ShiftCount: 0x1ed1
// Total scale of acceptable types:
//    Source:     0x402e
//    ShiftCount: 0x402e
Method(m439, 1, Serialized)
{
	Name(op, 39)

	ts00("m439")

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
	}
}

// Signal (evt)
//
// Total scale of unacceptable types:
//    SyncObject: 0x5e7f
// Total scale of acceptable types:
//    SyncObject: 0x0080
Method(m440, 1, Serialized)
{
	Name(op, 40)

	ts00("m440")

	if (arg0) {
		m486()
		Store(m488(op, 0x5e7f, 0, 0, 0, 0), Local7)
	} else {
	}
}

// SizeOf ({int|str|buf|pkg}) => Integer
//
// Total scale of unacceptable types:
//    ObjectName: 0x5ee3
// Total scale of acceptable types:
//    ObjectName: 0x004c
Method(m441, 1, Serialized)
{
	Name(op, 41)

	ts00("m441")

	if (arg0) {
		m486()
		Store(m488(op, 0x5ee3, 0, 0, 0, 0), Local7)
	} else {
	}
}

// Sleep (int)
//
// Total scale of unacceptable types:
//    MilliSeconds: 0x1ed1
// Total scale of acceptable types:
//    MilliSeconds: 0x402e
Method(m442, 1, Serialized)
{
	Name(op, 42)

	ts00("m442")

	if (arg0) {
		m486()
		Store(m488(op, 0x1ed1, 0, 0, 0, 0), Local7)
	} else {
	}
}

// Stall (int)
//
// Total scale of unacceptable types:
//    MicroSeconds: 0x1ed1
// Total scale of acceptable types:
//    MicroSeconds: 0x402e
Method(m443, 1, Serialized)
{
	Name(op, 43)

	ts00("m443")

	if (arg0) {
		m486()
		Store(m488(op, 0x1ed1, 0, 0, 0, 0), Local7)
	} else {
	}
}

// Store (any, Destination) => DataRefObject
//
// Total scale of unacceptable types:
//    Source: 0x0000
// Total scale of acceptable types:
//    Source: 0x5eff
Method(m444, 1, Serialized)
{
	Name(op, 44)

	ts00("m444")

	if (arg0) {
		m486()

// Error: Store failes with the Unitialized type
		Store(m488(op, 0x0001, 0, 0, 0, 0), Local7)

	} else {
	}
}

// Subtract (int, int, Result) => Integer
//
// Total scale of unacceptable types:
//    Minuend:    0x1ed1
//    Subtrahend: 0x1ed1
// Total scale of acceptable types:
//    Minuend:    0x402e
//    Subtrahend: 0x402e
Method(m445, 1, Serialized)
{
	Name(op, 45)

	ts00("m445")

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
	}
}

// ToBCD (int, Result) => Integer
//
// Total scale of unacceptable types:
//    Value: 0x1ed1
// Total scale of acceptable types:
//    Value: 0x402e
Method(m446, 1, Serialized)
{
	Name(op, 46)

	ts00("m446")

	if (arg0) {
		m486()
		Store(m488(op, 0x1ed1, 0, 0, 0, 0), Local7)
	} else {
	}
}

// ToBuffer ({int|str|buf}, Result) => Buffer
//
// Total scale of unacceptable types:
//    Data: 0x1ed1
// Total scale of acceptable types:
//    Data: 0x402e
Method(m447, 1, Serialized)
{
	Name(op, 47)

	ts00("m447")

	if (arg0) {
		m486()
		Store(m488(op, 0x1ed1, 0, 0, 0, 0), Local7)
	} else {
	}
}

// ToDecimalString ({int|str|buf}, Result) => String
//
// Total scale of unacceptable types:
//    Data: 0x1ed1
// Total scale of acceptable types:
//    Data: 0x402e
Method(m448, 1, Serialized)
{
	Name(op, 48)

	ts00("m448")

	if (arg0) {
		m486()
		Store(m488(op, 0x1ed1, 0, 0, 0, 0), Local7)
	} else {
		Store(m48d(op, 0x102, 0, 0, 0, "305419896", "305419896"), Local7)
		Store(m48d(op, 0x204, 0, 0, 0, "9876", "9876"), Local7)
		Store(m48d(op, 0x209, 0, 0, 0, "FdeAcb0132547698", "FdeAcb0132547698"), Local7)
		Store(m48d(op, 0x302, 0, 0, 0, "129,130", "129,130"), Local7)
		Store(m48d(op, 0x303, 0, 0, 0, "131,132,133,134", "131,132,133,134"), Local7)
		Store(m48d(op, 0x506, 0, 0, 0,  "6692061083885586008",  "88,70,55,136,25,250,198,82"), Local7)
		Store(m48d(op, 0xe06, 0, 0, 0,  "6692061083885586008",  "88,70,55,136,25,250,198,82"), Local7)
	}
}

// ToHexString ({int|str|buf}, Result) => String
//
// Total scale of unacceptable types:
//    Data: 0x1ed1
// Total scale of acceptable types:
//    Data: 0x402e
Method(m449, 1, Serialized)
{
	Name(op, 49)

	ts00("m449")

	if (arg0) {
		m486()
		Store(m488(op, 0x1ed1, 0, 0, 0, 0), Local7)
	} else {
		Store(m48d(op, 0x102, 0, 0, 0, "0000000012345678", "12345678"), Local7)
		Store(m48d(op, 0x204, 0, 0, 0, "9876", "9876"), Local7)
		Store(m48d(op, 0x209, 0, 0, 0, "FdeAcb0132547698", "FdeAcb0132547698"), Local7)
		Store(m48d(op, 0x302, 0, 0, 0, "81,82", "81,82"), Local7)
		Store(m48d(op, 0x303, 0, 0, 0, "83,84,85,86", "83,84,85,86"), Local7)
		Store(m48d(op, 0x506, 0, 0, 0, "6692061083885586008", "58,46,37,88,19,FA,C6,52"), Local7)
		Store(m48d(op, 0xe06, 0, 0, 0,  "6692061083885586008",  "58,46,37,88,19,FA,C6,52"), Local7)
	}
}

// ToInteger ({int|str|buf}, Result) => Integer
//
// Total scale of unacceptable types:
//    Data: 0x1ed1
// Total scale of acceptable types:
//    Data: 0x402e
Method(m450, 1, Serialized)
{
	Name(op, 50)

	ts00("m450")

	if (arg0) {
		m486()
		Store(m488(op, 0x1ed1, 0, 0, 0, 0), Local7)
	} else {
		Store(m48d(op, 0x102, 0, 0, 0, 0x12345678, 0x12345678), Local7)
		Store(m48d(op, 0x204, 0, 0, 0, 0x9876, 0x9876), Local7)
		Store(m48d(op, 0x211, 0, 0, 0, 0xF1dAB98e0D794Bc5, 0xD794BC5), Local7)
		Store(m48d(op, 0x302, 0, 0, 0, 0x8281, 0x8281), Local7)
		Store(m48d(op, 0x303, 0, 0, 0, 0x86858483, 0x86858483), Local7)
		Store(m48d(op, 0x506, 0, 0, 0, 0x52C6FA1988374658, 0x88374658), Local7)
		Store(m48d(op, 0xe06, 0, 0, 0, 0x52C6FA1988374658, 0x88374658), Local7)
	}
}

// ToString (buf, int, Result) => String
//
// Total scale of unacceptable types:
//    Source: 0x1ed1
//    Length: 0x1ed1
// Total scale of acceptable types:
//    Source: 0x402e
//    Length: 0x402e
Method(m451, 1, Serialized)
{
	Name(op, 51)

	ts00("m451")

	if (arg0) {
		m486()
		Store(0x300, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
	}
}

// Wait (evt, int) => Boolean
//
// Total scale of unacceptable types:
//    SyncObject: 0x5e7f
//    SyncObject: 0x1ed1
// Total scale of acceptable types:
//    SyncObject: 0x0080
//    SyncObject: 0x402e
Method(m452, 1, Serialized)
{
	Name(op, 52)

	ts00("m452")

	if (arg0) {
		m486()
		Store(0x700, df00)
		Store(0x100, df01)
		Store(m488(op, 0x5e7f, 0x1ed1, 0, 0, 0), Local7)
	} else {
	}
}

// XOr (int, int, Result) => Integer
//
// Total scale of unacceptable types:
//    Source1: 0x1ed1
//    Source2: 0x1ed1
// Total scale of acceptable types:
//    Source1: 0x402e
//    Source2: 0x402e
Method(m453, 1, Serialized)
{
	Name(op, 53)

	ts00("m453")

	if (arg0) {
		m486()
		Store(0x100, df00)
		Store(0x100, df01)
		Store(m488(op, 0x1ed1, 0x1ed1, 0, 0, 0), Local7)
	} else {
	}
}

Method(m460, 1, Serialized)
{
if (1) {
	m400(arg0)
	m401(arg0)
	m402(arg0)
	m403(arg0)
	m404(arg0)
	m405(arg0)
	m406(arg0)
	m407(arg0)
	m408(arg0)
	m409(arg0)
	m410(arg0)
	m411(arg0)
	m412(arg0)
	m413(arg0)
	m414(arg0)
	m415(arg0)
	m416(arg0)
	m417(arg0)
	m418(arg0)
	m419(arg0)
	m420(arg0)
	m421(arg0)
	m422(arg0)
	m423(arg0)
	m424(arg0)
	m425(arg0)
	m426(arg0)
	m427(arg0)
	m428(arg0)
	m429(arg0)
	m430(arg0)
	m431(arg0)
	m432(arg0)
	m433(arg0)
	m434(arg0)
	m435(arg0)
	m436(arg0)
	m437(arg0)
	m438(arg0)
	m439(arg0)
	m440(arg0)
	m441(arg0)
	m442(arg0)
	m443(arg0)
	m444(arg0)
	m445(arg0)
	m446(arg0)
	m447(arg0)
	m448(arg0)
	m449(arg0)
	m450(arg0)
	m451(arg0)
	m452(arg0)
	m453(arg0)
} else {
//	m400(arg0)
//	m401(arg0)
//	m402(arg0)
//	m403(arg0)
//	m407(arg0)
//	m409(arg0)
//	m411(arg0)
//	m412(arg0)
//	m414(arg0)
//	m417(arg0)
//	m418(arg0)
//	m448(arg0)
//	m449(arg0)
//	m450(arg0)

//	m400(arg0)
	m401(arg0)
}

if (0) {

Name(xxxx, 0)
Name(b000, Buffer(10) {})
Name(s000, "000000000000000000000000000000")

Store("-=-=-=-=-=-=-=-=-=-=-=", Debug)

Store(LGreater(10, 5), Local0)
Store(Local0, Debug)
Store(LGreater(5, 10), Local0)
Store(Local0, Debug)

Store(LGreater("11", 0x11), Local0)
Store(Local0, Debug)

Store(LEqual("11", 0x11), Local0)
Store(Local0, Debug)

Store("11", xxxx)
Store(xxxx, Debug)


Store(LGreater("11", 0x0fffffff), Local0)
Store(Local0, Debug)

Store(LGreater(0x12, "11"), Local0)
Store(Local0, Debug)

Store("1234567890abCdeF", xxxx)
Store(xxxx, Debug)

Store("FdeAcb0132547698", xxxx)
Store(xxxx, Debug)

Store("FdeAcb0132547698", xxxx)
Store(xxxx, Debug)

// [ACPI Debug] Integer: 0x90ABCDEF
// [ACPI Debug] Integer: 0x32547698

Store("qwrt", b000)
Store(b000, Debug)

// 71 77 72 74 00 00 00 00 00 00

Store(0xABEDF18942345678, s000)
Store(s000, Debug)

// "ABEDF18942345678"

Store("ABEDF18942345678", b000)
Store(b000, Debug)

// 41 42 45 44 46 31 38 39 34 32
}

}

