/*
 * Copyright (c) 2024, Arm Limited and Contributors. All rights reserved.
 * Copyright (c) 2024, Linaro Limited and Contributors. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <errno.h>
#include <string.h>

#include <plat/common/platform.h>

/*
 * This is the CBOR serialization of the CCA platform token described at
 * https://git.trustedfirmware.org/TF-M/tf-m-tools/+/refs/heads/main/iat-verifier/tests/data/cca_example_platform_token.yaml
 */
static const uint8_t sample_platform_token[] = {
	0xd2, 0x84, 0x44, 0xa1, 0x01, 0x38, 0x22, 0xa0,
	0x59, 0x05, 0x81, 0xa9, 0x19, 0x01, 0x09, 0x78,
	0x23, 0x74, 0x61, 0x67, 0x3a, 0x61, 0x72, 0x6d,
	0x2e, 0x63, 0x6f, 0x6d, 0x2c, 0x32, 0x30, 0x32,
	0x33, 0x3a, 0x63, 0x63, 0x61, 0x5f, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x23, 0x31,
	0x2e, 0x30, 0x2e, 0x30, 0x0a, 0x58, 0x20, 0x0d,
	0x22, 0xe0, 0x8a, 0x98, 0x46, 0x90, 0x58, 0x48,
	0x63, 0x18, 0x28, 0x34, 0x89, 0xbd, 0xb3, 0x6f,
	0x09, 0xdb, 0xef, 0xeb, 0x18, 0x64, 0xdf, 0x43,
	0x3f, 0xa6, 0xe5, 0x4e, 0xa2, 0xd7, 0x11, 0x19,
	0x09, 0x5c, 0x58, 0x20, 0x7f, 0x45, 0x4c, 0x46,
	0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x3e, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x50, 0x58, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x19, 0x01, 0x00, 0x58,
	0x21, 0x01, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02,
	0x01, 0x00, 0x0f, 0x0e, 0x0d, 0x0c, 0x0b, 0x0a,
	0x09, 0x08, 0x17, 0x16, 0x15, 0x14, 0x13, 0x12,
	0x11, 0x10, 0x1f, 0x1e, 0x1d, 0x1c, 0x1b, 0x1a,
	0x19, 0x18, 0x19, 0x09, 0x61, 0x44, 0xcf, 0xcf,
	0xcf, 0xcf, 0x19, 0x09, 0x5b, 0x19, 0x30, 0x03,
	0x19, 0x09, 0x62, 0x67, 0x73, 0x68, 0x61, 0x2d,
	0x32, 0x35, 0x36, 0x19, 0x09, 0x60, 0x78, 0x3a,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x76, 0x65, 0x72, 0x61, 0x69, 0x73, 0x6f, 0x6e,
	0x2e, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x2f, 0x2e, 0x77, 0x65, 0x6c, 0x6c, 0x2d, 0x6b,
	0x6e, 0x6f, 0x77, 0x6e, 0x2f, 0x76, 0x65, 0x72,
	0x61, 0x69, 0x73, 0x6f, 0x6e, 0x2f, 0x76, 0x65,
	0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x19, 0x09, 0x5f, 0x8d, 0xa4, 0x01,
	0x69, 0x52, 0x53, 0x45, 0x5f, 0x42, 0x4c, 0x31,
	0x5f, 0x32, 0x05, 0x58, 0x20, 0x53, 0x78, 0x79,
	0x63, 0x07, 0x53, 0x5d, 0xf3, 0xec, 0x8d, 0x8b,
	0x15, 0xa2, 0xe2, 0xdc, 0x56, 0x41, 0x41, 0x9c,
	0x3d, 0x30, 0x60, 0xcf, 0xe3, 0x22, 0x38, 0xc0,
	0xfa, 0x97, 0x3f, 0x7a, 0xa3, 0x02, 0x58, 0x20,
	0x9a, 0x27, 0x1f, 0x2a, 0x91, 0x6b, 0x0b, 0x6e,
	0xe6, 0xce, 0xcb, 0x24, 0x26, 0xf0, 0xb3, 0x20,
	0x6e, 0xf0, 0x74, 0x57, 0x8b, 0xe5, 0x5d, 0x9b,
	0xc9, 0x4f, 0x6f, 0x3f, 0xe3, 0xab, 0x86, 0xaa,
	0x06, 0x67, 0x73, 0x68, 0x61, 0x2d, 0x32, 0x35,
	0x36, 0xa4, 0x01, 0x67, 0x52, 0x53, 0x45, 0x5f,
	0x42, 0x4c, 0x32, 0x05, 0x58, 0x20, 0x53, 0x78,
	0x79, 0x63, 0x07, 0x53, 0x5d, 0xf3, 0xec, 0x8d,
	0x8b, 0x15, 0xa2, 0xe2, 0xdc, 0x56, 0x41, 0x41,
	0x9c, 0x3d, 0x30, 0x60, 0xcf, 0xe3, 0x22, 0x38,
	0xc0, 0xfa, 0x97, 0x3f, 0x7a, 0xa3, 0x02, 0x58,
	0x20, 0x53, 0xc2, 0x34, 0xe5, 0xe8, 0x47, 0x2b,
	0x6a, 0xc5, 0x1c, 0x1a, 0xe1, 0xca, 0xb3, 0xfe,
	0x06, 0xfa, 0xd0, 0x53, 0xbe, 0xb8, 0xeb, 0xfd,
	0x89, 0x77, 0xb0, 0x10, 0x65, 0x5b, 0xfd, 0xd3,
	0xc3, 0x06, 0x67, 0x73, 0x68, 0x61, 0x2d, 0x32,
	0x35, 0x36, 0xa4, 0x01, 0x65, 0x52, 0x53, 0x45,
	0x5f, 0x53, 0x05, 0x58, 0x20, 0x53, 0x78, 0x79,
	0x63, 0x07, 0x53, 0x5d, 0xf3, 0xec, 0x8d, 0x8b,
	0x15, 0xa2, 0xe2, 0xdc, 0x56, 0x41, 0x41, 0x9c,
	0x3d, 0x30, 0x60, 0xcf, 0xe3, 0x22, 0x38, 0xc0,
	0xfa, 0x97, 0x3f, 0x7a, 0xa3, 0x02, 0x58, 0x20,
	0x11, 0x21, 0xcf, 0xcc, 0xd5, 0x91, 0x3f, 0x0a,
	0x63, 0xfe, 0xc4, 0x0a, 0x6f, 0xfd, 0x44, 0xea,
	0x64, 0xf9, 0xdc, 0x13, 0x5c, 0x66, 0x63, 0x4b,
	0xa0, 0x01, 0xd1, 0x0b, 0xcf, 0x43, 0x02, 0xa2,
	0x06, 0x67, 0x73, 0x68, 0x61, 0x2d, 0x32, 0x35,
	0x36, 0xa4, 0x01, 0x66, 0x41, 0x50, 0x5f, 0x42,
	0x4c, 0x31, 0x05, 0x58, 0x20, 0x53, 0x78, 0x79,
	0x63, 0x07, 0x53, 0x5d, 0xf3, 0xec, 0x8d, 0x8b,
	0x15, 0xa2, 0xe2, 0xdc, 0x56, 0x41, 0x41, 0x9c,
	0x3d, 0x30, 0x60, 0xcf, 0xe3, 0x22, 0x38, 0xc0,
	0xfa, 0x97, 0x3f, 0x7a, 0xa3, 0x02, 0x58, 0x20,
	0x15, 0x71, 0xb5, 0xec, 0x78, 0xbd, 0x68, 0x51,
	0x2b, 0xf7, 0x83, 0x0b, 0xb6, 0xa2, 0xa4, 0x4b,
	0x20, 0x47, 0xc7, 0xdf, 0x57, 0xbc, 0xe7, 0x9e,
	0xb8, 0xa1, 0xc0, 0xe5, 0xbe, 0xa0, 0xa5, 0x01,
	0x06, 0x67, 0x73, 0x68, 0x61, 0x2d, 0x32, 0x35,
	0x36, 0xa4, 0x01, 0x66, 0x41, 0x50, 0x5f, 0x42,
	0x4c, 0x32, 0x05, 0x58, 0x20, 0x53, 0x78, 0x79,
	0x63, 0x07, 0x53, 0x5d, 0xf3, 0xec, 0x8d, 0x8b,
	0x15, 0xa2, 0xe2, 0xdc, 0x56, 0x41, 0x41, 0x9c,
	0x3d, 0x30, 0x60, 0xcf, 0xe3, 0x22, 0x38, 0xc0,
	0xfa, 0x97, 0x3f, 0x7a, 0xa3, 0x02, 0x58, 0x20,
	0x10, 0x15, 0x9b, 0xaf, 0x26, 0x2b, 0x43, 0xa9,
	0x2d, 0x95, 0xdb, 0x59, 0xda, 0xe1, 0xf7, 0x2c,
	0x64, 0x51, 0x27, 0x30, 0x16, 0x61, 0xe0, 0xa3,
	0xce, 0x4e, 0x38, 0xb2, 0x95, 0xa9, 0x7c, 0x58,
	0x06, 0x67, 0x73, 0x68, 0x61, 0x2d, 0x32, 0x35,
	0x36, 0xa4, 0x01, 0x67, 0x53, 0x43, 0x50, 0x5f,
	0x42, 0x4c, 0x31, 0x05, 0x58, 0x20, 0x53, 0x78,
	0x79, 0x63, 0x07, 0x53, 0x5d, 0xf3, 0xec, 0x8d,
	0x8b, 0x15, 0xa2, 0xe2, 0xdc, 0x56, 0x41, 0x41,
	0x9c, 0x3d, 0x30, 0x60, 0xcf, 0xe3, 0x22, 0x38,
	0xc0, 0xfa, 0x97, 0x3f, 0x7a, 0xa3, 0x02, 0x58,
	0x20, 0x10, 0x12, 0x2e, 0x85, 0x6b, 0x3f, 0xcd,
	0x49, 0xf0, 0x63, 0x63, 0x63, 0x17, 0x47, 0x61,
	0x49, 0xcb, 0x73, 0x0a, 0x1a, 0xa1, 0xcf, 0xaa,
	0xd8, 0x18, 0x55, 0x2b, 0x72, 0xf5, 0x6d, 0x6f,
	0x68, 0x06, 0x67, 0x73, 0x68, 0x61, 0x2d, 0x32,
	0x35, 0x36, 0xa4, 0x01, 0x67, 0x53, 0x43, 0x50,
	0x5f, 0x42, 0x4c, 0x32, 0x05, 0x58, 0x20, 0xf1,
	0x4b, 0x49, 0x87, 0x90, 0x4b, 0xcb, 0x58, 0x14,
	0xe4, 0x45, 0x9a, 0x05, 0x7e, 0xd4, 0xd2, 0x0f,
	0x58, 0xa6, 0x33, 0x15, 0x22, 0x88, 0xa7, 0x61,
	0x21, 0x4d, 0xcd, 0x28, 0x78, 0x0b, 0x56, 0x02,
	0x58, 0x20, 0xaa, 0x67, 0xa1, 0x69, 0xb0, 0xbb,
	0xa2, 0x17, 0xaa, 0x0a, 0xa8, 0x8a, 0x65, 0x34,
	0x69, 0x20, 0xc8, 0x4c, 0x42, 0x44, 0x7c, 0x36,
	0xba, 0x5f, 0x7e, 0xa6, 0x5f, 0x42, 0x2c, 0x1f,
	0xe5, 0xd8, 0x06, 0x67, 0x73, 0x68, 0x61, 0x2d,
	0x32, 0x35, 0x36, 0xa4, 0x01, 0x67, 0x41, 0x50,
	0x5f, 0x42, 0x4c, 0x33, 0x31, 0x05, 0x58, 0x20,
	0x53, 0x78, 0x79, 0x63, 0x07, 0x53, 0x5d, 0xf3,
	0xec, 0x8d, 0x8b, 0x15, 0xa2, 0xe2, 0xdc, 0x56,
	0x41, 0x41, 0x9c, 0x3d, 0x30, 0x60, 0xcf, 0xe3,
	0x22, 0x38, 0xc0, 0xfa, 0x97, 0x3f, 0x7a, 0xa3,
	0x02, 0x58, 0x20, 0x2e, 0x6d, 0x31, 0xa5, 0x98,
	0x3a, 0x91, 0x25, 0x1b, 0xfa, 0xe5, 0xae, 0xfa,
	0x1c, 0x0a, 0x19, 0xd8, 0xba, 0x3c, 0xf6, 0x01,
	0xd0, 0xe8, 0xa7, 0x06, 0xb4, 0xcf, 0xa9, 0x66,
	0x1a, 0x6b, 0x8a, 0x06, 0x67, 0x73, 0x68, 0x61,
	0x2d, 0x32, 0x35, 0x36, 0xa4, 0x01, 0x63, 0x52,
	0x4d, 0x4d, 0x05, 0x58, 0x20, 0x53, 0x78, 0x79,
	0x63, 0x07, 0x53, 0x5d, 0xf3, 0xec, 0x8d, 0x8b,
	0x15, 0xa2, 0xe2, 0xdc, 0x56, 0x41, 0x41, 0x9c,
	0x3d, 0x30, 0x60, 0xcf, 0xe3, 0x22, 0x38, 0xc0,
	0xfa, 0x97, 0x3f, 0x7a, 0xa3, 0x02, 0x58, 0x20,
	0xa1, 0xfb, 0x50, 0xe6, 0xc8, 0x6f, 0xae, 0x16,
	0x79, 0xef, 0x33, 0x51, 0x29, 0x6f, 0xd6, 0x71,
	0x34, 0x11, 0xa0, 0x8c, 0xf8, 0xdd, 0x17, 0x90,
	0xa4, 0xfd, 0x05, 0xfa, 0xe8, 0x68, 0x81, 0x64,
	0x06, 0x67, 0x73, 0x68, 0x61, 0x2d, 0x32, 0x35,
	0x36, 0xa4, 0x01, 0x69, 0x48, 0x57, 0x5f, 0x43,
	0x4f, 0x4e, 0x46, 0x49, 0x47, 0x05, 0x58, 0x20,
	0x53, 0x78, 0x79, 0x63, 0x07, 0x53, 0x5d, 0xf3,
	0xec, 0x8d, 0x8b, 0x15, 0xa2, 0xe2, 0xdc, 0x56,
	0x41, 0x41, 0x9c, 0x3d, 0x30, 0x60, 0xcf, 0xe3,
	0x22, 0x38, 0xc0, 0xfa, 0x97, 0x3f, 0x7a, 0xa3,
	0x02, 0x58, 0x20, 0x1a, 0x25, 0x24, 0x02, 0x97,
	0x2f, 0x60, 0x57, 0xfa, 0x53, 0xcc, 0x17, 0x2b,
	0x52, 0xb9, 0xff, 0xca, 0x69, 0x8e, 0x18, 0x31,
	0x1f, 0xac, 0xd0, 0xf3, 0xb0, 0x6e, 0xca, 0xae,
	0xf7, 0x9e, 0x17, 0x06, 0x67, 0x73, 0x68, 0x61,
	0x2d, 0x32, 0x35, 0x36, 0xa4, 0x01, 0x69, 0x46,
	0x57, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47,
	0x05, 0x58, 0x20, 0x53, 0x78, 0x79, 0x63, 0x07,
	0x53, 0x5d, 0xf3, 0xec, 0x8d, 0x8b, 0x15, 0xa2,
	0xe2, 0xdc, 0x56, 0x41, 0x41, 0x9c, 0x3d, 0x30,
	0x60, 0xcf, 0xe3, 0x22, 0x38, 0xc0, 0xfa, 0x97,
	0x3f, 0x7a, 0xa3, 0x02, 0x58, 0x20, 0x9a, 0x92,
	0xad, 0xbc, 0x0c, 0xee, 0x38, 0xef, 0x65, 0x8c,
	0x71, 0xce, 0x1b, 0x1b, 0xf8, 0xc6, 0x56, 0x68,
	0xf1, 0x66, 0xbf, 0xb2, 0x13, 0x64, 0x4c, 0x89,
	0x5c, 0xcb, 0x1a, 0xd0, 0x7a, 0x25, 0x06, 0x67,
	0x73, 0x68, 0x61, 0x2d, 0x32, 0x35, 0x36, 0xa4,
	0x01, 0x6c, 0x54, 0x42, 0x5f, 0x46, 0x57, 0x5f,
	0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x05, 0x58,
	0x20, 0x53, 0x78, 0x79, 0x63, 0x07, 0x53, 0x5d,
	0xf3, 0xec, 0x8d, 0x8b, 0x15, 0xa2, 0xe2, 0xdc,
	0x56, 0x41, 0x41, 0x9c, 0x3d, 0x30, 0x60, 0xcf,
	0xe3, 0x22, 0x38, 0xc0, 0xfa, 0x97, 0x3f, 0x7a,
	0xa3, 0x02, 0x58, 0x20, 0x23, 0x89, 0x03, 0x18,
	0x0c, 0xc1, 0x04, 0xec, 0x2c, 0x5d, 0x8b, 0x3f,
	0x20, 0xc5, 0xbc, 0x61, 0xb3, 0x89, 0xec, 0x0a,
	0x96, 0x7d, 0xf8, 0xcc, 0x20, 0x8c, 0xdc, 0x7c,
	0xd4, 0x54, 0x17, 0x4f, 0x06, 0x67, 0x73, 0x68,
	0x61, 0x2d, 0x32, 0x35, 0x36, 0xa4, 0x01, 0x6d,
	0x53, 0x4f, 0x43, 0x5f, 0x46, 0x57, 0x5f, 0x43,
	0x4f, 0x4e, 0x46, 0x49, 0x47, 0x05, 0x58, 0x20,
	0x53, 0x78, 0x79, 0x63, 0x07, 0x53, 0x5d, 0xf3,
	0xec, 0x8d, 0x8b, 0x15, 0xa2, 0xe2, 0xdc, 0x56,
	0x41, 0x41, 0x9c, 0x3d, 0x30, 0x60, 0xcf, 0xe3,
	0x22, 0x38, 0xc0, 0xfa, 0x97, 0x3f, 0x7a, 0xa3,
	0x02, 0x58, 0x20, 0xe6, 0xc2, 0x1e, 0x8d, 0x26,
	0x0f, 0xe7, 0x18, 0x82, 0xde, 0xbd, 0xb3, 0x39,
	0xd2, 0x40, 0x2a, 0x2c, 0xa7, 0x64, 0x85, 0x29,
	0xbc, 0x23, 0x03, 0xf4, 0x86, 0x49, 0xbc, 0xe0,
	0x38, 0x00, 0x17, 0x06, 0x67, 0x73, 0x68, 0x61,
	0x2d, 0x32, 0x35, 0x36, 0x58, 0x60, 0x31, 0xd0,
	0x4d, 0x52, 0xcc, 0xde, 0x95, 0x2c, 0x1e, 0x32,
	0xcb, 0xa1, 0x81, 0x88, 0x5a, 0x40, 0xb8, 0xcc,
	0x38, 0xe0, 0x52, 0x8c, 0x1e, 0x89, 0x58, 0x98,
	0x07, 0x64, 0x2a, 0xa5, 0xe3, 0xf2, 0xbc, 0x37,
	0xf9, 0x53, 0x74, 0x50, 0x6b, 0xff, 0x4d, 0x2e,
	0x4b, 0xe7, 0x06, 0x3c, 0x4d, 0x72, 0x41, 0x92,
	0x70, 0xc7, 0x22, 0xe8, 0xd4, 0xd9, 0x3e, 0xe8,
	0xb6, 0xc9, 0xfa, 0xce, 0x3b, 0x43, 0xc9, 0x76,
	0x1a, 0x49, 0x94, 0x1a, 0xb6, 0xf3, 0x8f, 0xfd,
	0xff, 0x49, 0x6a, 0xd4, 0x63, 0xb4, 0xcb, 0xfa,
	0x11, 0xd8, 0x3e, 0x23, 0xe3, 0x1f, 0x7f, 0x62,
	0x32, 0x9d, 0xe3, 0x0c, 0x1c, 0xc8
};

/*
 * Get the hardcoded platform attestation token as QEMU does not support
 * RSE.
 */
int plat_rmmd_get_cca_attest_token(uintptr_t buf, size_t *len,
				   uintptr_t hash, size_t hash_size,
				   size_t *remaining_len)
{
	const size_t token_size = sizeof(sample_platform_token);
	(void)hash;
	(void)hash_size;

	/* Shouldn't happen because RMM uses the whole 4kB shared buffer */
	if (*len < token_size) {
		return -EINVAL;
	}

	memcpy((void *)buf, sample_platform_token, token_size);
	*len = token_size;
	*remaining_len = 0;

	return 0;
}
