/* SPDX-License-Identifier: GPL-2.0-only OR MIT */

/*
 * This file is created based on MT8189 Functional Specification
 * Chapter number: 9.2
 */

#include <device/mmio.h>
#include <gpio.h>

#define SPI_NOR_GPIO_BASE	150

enum {
	SPI_NOR_CK = 0,
	SPI_NOR_CS = 1,
	SPI_NOR_IO0 = 2,
	SPI_NOR_IO1 = 3,
	SPI_NOR_IO2 = 4,
	SPI_NOR_IO3 = 5,
};

static const struct gpio_drv_info bootblock_gpio_driving_info[] = {
	[SPI_NOR_CK] = { 0x10, 12, 3, },
	[SPI_NOR_CS] = { 0x10, 27, 3, },
	[SPI_NOR_IO0] = { 0x10, 15, 3, },
	[SPI_NOR_IO1] = { 0x10, 18, 3, },
	[SPI_NOR_IO2] = { 0x10, 21, 3, },
	[SPI_NOR_IO3] = { 0x10, 24, 3, },
};

static const struct gpio_drv_info gpio_driving_info[] = {
	[0] = { 0x10, 15, 3, },
	[1] = { 0x10, 9, 3, },
	[2] = { 0x10, 12, 3, },
	[3] = { 0x10, 15, 3, },
	[4] = { 0x10, 18, 3, },
	[5] = { 0x10, 21, 3, },
	[6] = { 0x10, 18, 3, },
	[7] = { 0x10, 21, 3, },
	[8] = { 0x10, 24, 3, },
	[9] = { 0x10, 27, 3, },
	[10] = { 0x10, 0, 3, },
	[11] = { 0x10, 3, 3, },
	[12] = { 0x10, 15, 3, },
	[13] = { 0x10, 18, 3, },
	[14] = { 0x10, 0, 3, },
	[15] = { 0x10, 3, 3, },
	[16] = { 0x10, 21, 3, },
	[17] = { 0x10, 24, 3, },
	[18] = { 0x10, 0, 3, },
	[19] = { 0x10, 6, 3, },
	[20] = { 0x10, 3, 3, },
	[21] = { 0x10, 9, 3, },
	[22] = { 0x10, 0, 3, },
	[23] = { 0x10, 3, 3, },
	[24] = { 0x10, 6, 3, },
	[25] = { 0x10, 6, 3, },
	[26] = { 0x10, 3, 3, },
	[27] = { 0x10, 3, 3, },
	[28] = { 0x10, 6, 3, },
	[29] = { 0x10, 0, 3, },
	[30] = { 0x10, 0, 3, },
	[31] = { 0x10, 27, 3, },
	[32] = { 0x10, 0, 3, },
	[33] = { 0x10, 3, 3, },
	[34] = { 0x10, 0, 3, },
	[35] = { 0x10, 9, 3, },
	[36] = { 0x10, 6, 3, },
	[37] = { 0x10, 15, 3, },
	[38] = { 0x10, 12, 3, },
	[39] = { 0x10, 15, 3, },
	[40] = { 0x10, 6, 3, },
	[41] = { 0x10, 9, 3, },
	[42] = { 0x10, 12, 3, },
	[43] = { 0x10, 18, 3, },
	[44] = { 0x10, 0, 3, },
	[45] = { 0x10, 3, 3, },
	[46] = { 0x10, 6, 3, },
	[47] = { 0x10, 9, 3, },
	[48] = { 0x10, 15, 3, },
	[49] = { 0x10, 12, 3, },
	[50] = { 0x10, 9, 3, },
	[51] = { 0x10, 24, 3, },
	[52] = { 0x10, 0, 3, },
	[53] = { 0x10, 27, 3, },
	[54] = { 0x10, 3, 3, },
	[55] = { 0x10, 18, 3, },
	[56] = { 0x10, 21, 3, },
	[57] = { 0x10, 9, 3, },
	[58] = { 0x10, 21, 3, },
	[59] = { 0x10, 12, 3, },
	[60] = { 0x10, 24, 3, },
	[61] = { 0x10, 15, 3, },
	[62] = { 0x10, 27, 3, },
	[63] = { 0x10, 18, 3, },
	[64] = { 0x10, 0, 3, },
	[65] = { 0x10, 0, 3, },
	[66] = { 0x10, 6, 3, },
	[67] = { 0x10, 3, 3, },
	[68] = { 0x10, 9, 3, },
	[69] = { 0x10, 6, 3, },
	[70] = { 0x10, 3, 3, },
	[71] = { 0x10, 12, 3, },
	[72] = { 0x10, 9, 3, },
	[73] = { 0x10, 18, 3, },
	[74] = { 0x10, 15, 3, },
	[75] = { 0x10, 9, 3, },
	[76] = { 0x10, 21, 3, },
	[77] = { 0x10, 9, 3, },
	[78] = { 0x10, 6, 3, },
	[79] = { 0x10, 15, 3, },
	[80] = { 0x10, 12, 3, },
	[81] = { 0x10, 27, 3, },
	[82] = { 0x10, 24, 3, },
	[83] = { 0x10, 0, 3, },
	[84] = { 0x10, 12, 3, },
	[85] = { 0x10, 15, 3, },
	[86] = { 0x10, 18, 3, },
	[87] = { 0x10, 21, 3, },
	[88] = { 0x10, 0, 3, },
	[89] = { 0x10, 27, 3, },
	[90] = { 0x10, 6, 3, },
	[91] = { 0x10, 3, 3, },
	[92] = { 0x10, 18, 3, },
	[93] = { 0x10, 21, 3, },
	[94] = { 0x10, 9, 3, },
	[95] = { 0x10, 15, 3, },
	[96] = { 0x10, 24, 3, },
	[97] = { 0x10, 0, 3, },
	[98] = { 0x10, 15, 3, },
	[99] = { 0x10, 9, 3, },
	[100] = { 0x10, 12, 3, },
	[101] = { 0x10, 3, 3, },
	[102] = { 0x10, 6, 3, },
	[103] = { 0x10, 15, 3, },
	[104] = { 0x10, 6, 3, },
	[105] = { 0x10, 12, 3, },
	[106] = { 0x10, 9, 3, },
	[107] = { 0x10, 27, 3, },
	[108] = { 0x10, 18, 3, },
	[109] = { 0x10, 24, 3, },
	[110] = { 0x10, 21, 3, },
	[111] = { 0x10, 12, 3, },
	[112] = { 0x10, 0, 3, },
	[113] = { 0x10, 3, 3, },
	[114] = { 0x10, 6, 3, },
	[115] = { 0x10, 27, 3, },
	[116] = { 0x10, 6, 3, },
	[117] = { 0x10, 0, 3, },
	[118] = { 0x10, 3, 3, },
	[119] = { 0x10, 18, 3, },
	[120] = { 0x10, 15, 3, },
	[121] = { 0x10, 12, 3, },
	[122] = { 0x10, 9, 3, },
	[123] = { 0x10, 27, 3, },
	[124] = { 0x10, 24, 3, },
	[125] = { 0x10, 21, 3, },
	[126] = { 0x10, 18, 3, },
	[127] = { 0x10, 6, 3, },
	[128] = { 0x10, 15, 3, },
	[129] = { 0x10, 0, 3, },
	[130] = { 0x10, 21, 3, },
	[131] = { 0x10, 9, 3, },
	[132] = { 0x10, 12, 3, },
	[133] = { 0x10, 24, 3, },
	[134] = { 0x10, 3, 3, },
	[135] = { 0x10, 3, 3, },
	[136] = { 0x10, 6, 3, },
	[137] = { 0x10, 9, 3, },
	[138] = { 0x10, 12, 3, },
	[139] = { 0x10, 9, 3, },
	[140] = { 0x10, 12, 3, },
	[141] = { 0x10, 0, 3, },
	[142] = { 0x10, 3, 3, },
	[143] = { 0x10, 6, 3, },
	[144] = { 0x10, 15, 3, },
	[145] = { 0x10, 18, 3, },
	[146] = { 0x10, 21, 3, },
	[147] = { 0x10, 24, 3, },
	[148] = { 0x10, 27, 3, },
	[149] = { 0x10, 0, 3, },
	[150] = { 0x10, 12, 3, },
	[151] = { 0x10, 27, 3, },
	[152] = { 0x10, 15, 3, },
	[153] = { 0x10, 18, 3, },
	[154] = { 0x10, 21, 3, },
	[155] = { 0x10, 24, 3, },
	[156] = { 0x10, 6, 3, },
	[157] = { 0x10, 3, 3, },
	[158] = { 0x10, 0, 3, },
	[159] = { 0x10, 6, 3, },
	[160] = { 0x10, 12, 3, },
	[161] = { 0x10, 21, 3, },
	[162] = { 0x10, 18, 3, },
	[163] = { 0x10, 3, 3, },
	[164] = { 0x10, 27, 3, },
	[165] = { 0x10, 24, 3, },
	[166] = { 0x10, 0, 3, },
	[167] = { 0x10, 9, 3, },
	[168] = { 0x10, 24, 3, },
	[169] = { 0x10, 21, 3, },
	[170] = { 0x10, 27, 3, },
	[171] = { 0x10, 0, 3, },
	[172] = { 0x10, 3, 3, },
	[173] = { 0x10, 6, 3, },
	[174] = { 0x10, 15, 3, },
	[175] = { 0x10, 12, 3, },
	[176] = { 0x10, 18, 3, },
	[177] = { 0x10, 21, 3, },
	[178] = { 0x10, 24, 3, },
	[179] = { 0x10, 27, 3, },
	[180] = { 0x10, 12, 3, },
	[181] = { 0x10, 15, 3, },
	[182] = { 0x10, 9, 3, },
};
_Static_assert(ARRAY_SIZE(gpio_driving_info) == GPIO_NUM,
	       "gpio_driving_info array size not match");

static const struct gpio_drv_info gpio_driving_adv_info[] = {
	[51] = { 0x10, 0, 3, },
	[52] = { 0x10, 6, 3, },
	[53] = { 0x10, 3, 3, },
	[54] = { 0x10, 9, 3, },
	[55] = { 0x10, 0, 3, },
	[56] = { 0x10, 3, 3, },
	[57] = { 0x10, 0, 3, },
	[58] = { 0x10, 12, 3, },
	[59] = { 0x10, 3, 3, },
	[60] = { 0x10, 15, 3, },
	[61] = { 0x10, 6, 3, },
	[62] = { 0x10, 18, 3, },
	[63] = { 0x10, 9, 3, },
	[64] = { 0x10, 21, 3, },
	[65] = { 0x10, 0, 3, },
	[66] = { 0x10, 6, 3, },
	[67] = { 0x10, 3, 3, },
	[68] = { 0x10, 9, 3, },
	[180] = { 0x10, 0, 3, },
	[181] = { 0x10, 3, 3, },
};

void *gpio_find_reg_addr(gpio_t gpio)
{
	void *reg_addr;

	switch (gpio.base & 0x0f) {
	case 1:
		reg_addr = (void *)IOCFG_LM_BASE;
		break;
	case 2:
		reg_addr = (void *)IOCFG_RB0_BASE;
		break;
	case 3:
		reg_addr = (void *)IOCFG_RB1_BASE;
		break;
	case 4:
		reg_addr = (void *)IOCFG_BM0_BASE;
		break;
	case 5:
		reg_addr = (void *)IOCFG_BM1_BASE;
		break;
	case 6:
		reg_addr = (void *)IOCFG_BM2_BASE;
		break;
	case 7:
		reg_addr = (void *)IOCFG_LT0_BASE;
		break;
	case 8:
		reg_addr = (void *)IOCFG_LT1_BASE;
		break;
	case 9:
		reg_addr = (void *)IOCFG_RT_BASE;
		break;
	default:
		reg_addr = NULL;
		break;
	}

	return reg_addr;
}

const struct gpio_drv_info *get_gpio_driving_info(uint32_t raw_id)
{
	if (ENV_BOOTBLOCK) {
		uint32_t id = raw_id - SPI_NOR_GPIO_BASE;

		if (id >= ARRAY_SIZE(bootblock_gpio_driving_info))
			return NULL;
		return &bootblock_gpio_driving_info[id];
	} else {
		if (raw_id >= ARRAY_SIZE(gpio_driving_info))
			return NULL;
		return &gpio_driving_info[raw_id];
	}
}

const struct gpio_drv_info *get_gpio_driving_adv_info(uint32_t raw_id)
{
	if (ENV_BOOTBLOCK) {
		return NULL;
	} else {
		if (raw_id >= ARRAY_SIZE(gpio_driving_adv_info))
			return NULL;
		return &gpio_driving_adv_info[raw_id];
	}
}
