/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) 2002 The Open Group
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   char *
 *   XtRealloc()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

#define PAT_SKIP	10240

extern void alloc_handler();
extern int alloc_handler_called;


#define T_XtRealloc	1
char    *TestName = "XtRealloc";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

char *ptr, *ptr1, *ptr2;
size_t max_limit, half_limit;
int i;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtRealloc-1.(A)");
	report_assertion("A successful call to char *XtRealloc(ptr, num) when ptr");
	report_assertion("matches a pointer returned by a prior call to XtMalloc,");
	report_assertion("XtCalloc or XtRealloc shall change the size of the block of");
	report_assertion("storage pointed to by ptr to num, copy the old contents");
	report_assertion("pointed by ptr into the new block, free the old block, and");
	report_assertion("return a pointer to the newly allocated block.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Trealloc1", "XtRealloc");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Determine largest realloc");
	tet_infoline("TEST: Allocate memory");
	half_limit = 1024;
	ptr = (char *) XtMalloc(half_limit);
	if (ptr == (char *)NULL) {
			sprintf(ebuf, "ERROR: XtMalloc could not allocate %d bytes", half_limit);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("PREP: Write data to the allocated memory");
	ptr1 = ptr;
	for (i = 1; i <= half_limit; i++, ptr++)
		*ptr = 0x55;
	tet_infoline("TEST: Realloc and cut the request to 1/10 of current value");
	half_limit /= 10;
	ptr = XtRealloc(ptr1, half_limit);
	if (ptr == (char *)NULL) {
			sprintf(ebuf, "ERROR: XtRealloc could not allocate %d bytes", half_limit);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	ptr2 = ptr;
	tet_infoline("TEST: Read the pattern back from the allocated memory");
	for (i = 1; i <= half_limit; i++, ptr++)
		if (*ptr != 0x55) {
		sprintf(ebuf, "ERROR: %s\nExpected %d\nActual %d", "Memory area returned by XtRealloc invalid", 0x55, *ptr);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
		break;
		}
	tet_infoline("CLEANUP: Free memory");
	if( ptr2 != ptr1 )
		XtFree(ptr2);
	XtFree(ptr1);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.12079 */
/* End of included file Mdefcode.tmc.12079 */

/* Including from file Mdefcode.tmc.12079 */
static void t002(){

pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtRealloc-2.(B)");
	report_assertion("A successful call to char *XtRealloc(ptr, num) when num is");
	report_assertion("less than the size of the storage allocated for ptr shall");
	report_assertion("copy only as much data as will fit into the newly allocated");
	report_assertion("storage from ptr.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.12079 */

static void t003(){

char *ptr, *ptr1;
size_t max_limit;
pid_t pid2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtRealloc-3.(A)");
	report_assertion("When there is insufficient memory to allocate the requested");
	report_assertion("block a call to char *XtRealloc(ptr, num) shall issue an");
	report_assertion("allocError error and return NULL.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Trealloc2", "XtRealloc");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Set up toolkit handler for XtRealloc failure");
	XtAppSetErrorMsgHandler(app_ctext, alloc_handler);
	tet_infoline("PREP: Determine largest realloc");
	max_limit = mem_limit();
	tet_infoline("TEST: Allocate memory then verify over the limit XtRealloc calls error handler");
	ptr = (char *) XtMalloc(max_limit);
	if (ptr == (char *)NULL) {
	 	sprintf(ebuf, "ERROR: XtMalloc could not allocate %d bytes", max_limit);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	ptr1 = (char *)XtRealloc(NULL, max_limit);
	XtFree(ptr);
	tet_infoline("CLEANUP: Free memory");
	if (alloc_handler_called == 0) {
		sprintf(ebuf, "ERROR: XtRealloc did not call error handler");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.12079 */
/* End of included file Mdefcode.tmc.12079 */

static void t004(){

char *ptr, *ptr1;
size_t max_limit;
pid_t pid2;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtRealloc-4.(A)");
	report_assertion("When ptr is NULL a call to char *XtRealloc(ptr, num) shall");
	report_assertion("allocate new storage and not copy any data into it.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Trealloc3", "XtRealloc");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Determine largest realloc");
	max_limit = mem_limit();
	tet_infoline("TEST: Allocate memory");
	ptr = (char *) XtRealloc(NULL, max_limit);
	if (ptr == (char *)NULL) {
	 	sprintf(ebuf, "ERROR: XtRealloc could not allocate %d bytes", max_limit);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	XtFree(ptr);
	tet_infoline("CLEANUP: Free memory");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.12079 */
/* End of included file Mdefcode.tmc.12079 */

/* Including from file Mdefcode.tmc.12079 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtRealloc-5.(B)");
	report_assertion("The contents of the newly allocated portion of the object");
	report_assertion("on a call to char *XtRealloc(ptr, num) when num is larger");
	report_assertion("than the size of the storage pointed to by ptr.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.12079 */

static void t006(){

char *ptr, *ptr1;
size_t max_limit;
int i;
pid_t pid2;
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtRealloc-6.(A)");
	report_assertion("When num is zero and ptr is not NULL a call to char");
	report_assertion("*XtRealloc(ptr, num) shall free the object pointed to by");
	report_assertion("ptr.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Trealloc", "XtRealloc");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Determine largest malloc");
	max_limit = mem_limit();
	tet_infoline("PREP: Allocate memory then call XtRealloc for memory, setting num = 0");
	tet_infoline("TEST: Then, again attempt the XtMalloc");
	ptr = (char *) XtMalloc(max_limit);
	if (ptr == (char *)0) {
		sprintf(ebuf, "ERROR: XtMalloc could not allocate %d bytes", max_limit);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	XtRealloc(ptr, 0);
	ptr = (char *)XtMalloc(max_limit);
	if (ptr == (char *)0) {
		sprintf(ebuf, "ERROR: XtMalloc could not re-allocate space after XtRealloc");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	else {
		XtFree(ptr);
		tet_infoline("CLEANUP: Memory freed");
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.12079 */
/* End of included file Mdefcode.tmc.12079 */

/* Including from file Mdefcode.tmc.12079 */
static void t007(){

pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtRealloc-7.(B)");
	report_assertion("The behavior of a call to char *XtRealloc(ptr, num) when");
	report_assertion("ptr does not match a pointer returned by a prior call to");
	report_assertion("XtMalloc, XtCalloc or XtRealloc.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.12079 */

/* Including from file Mdefcode.tmc.12079 */
static void t008(){

pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtRealloc-8.(B)");
	report_assertion("The behavior of a call to char *XtRealloc(ptr, num) when");
	report_assertion("the space pointed to by ptr has been previously deallocated.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.12079 */

/* Including from file Mdefcode.tmc.12079 */
static void t009(){

pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtRealloc-9.(B)");
	report_assertion("The order and contiguity of the storage allocated by");
	report_assertion("successive calls to char *XtRealloc(ptr, num).");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.12079 */

/* Including from file Mdefcode.tmc.12079 */
static void t010(){

pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtRealloc-10.(B)");
	report_assertion("A successful call to char *XtRealloc(ptr, num) shall return");
	report_assertion("a pointer to an object that is disjoint from any other");
	report_assertion("object.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.12079 */

/* Including from file Mdefcode.tmc.12079 */
static void t011(){

pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtRealloc-11.(B)");
	report_assertion("The pointer returned by a successful call to char");
	report_assertion("*XtRealloc(ptr, num) shall point to the lowest byte address");
	report_assertion("of the allocated space.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.12079 */

/* Including from file Mdefcode.tmc.12079 */
static void t012(){

pid_t	pid;

 	report_purpose(12);

	report_assertion("Assertion XtRealloc-12.(B)");
	report_assertion("The pointer returned by a call to char *XtRealloc(ptr, num)");
	report_assertion("when num is zero.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.12079 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
