/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   XtCallbackStatus
 *   XtHasCallbacks()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

/*
** XtCBP1_Proc
*/
void XtCBP1_Proc(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
}


#define T_XtHasCallbacks	1
char    *TestName = "XtHasCallbacks";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Widget labelw_good;
XtCallbackStatus status;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtHasCallbacks-1.(A)");
	report_assertion("A call to XtCallbackStatus XtHasCallbacks(w, callback_name)");
	report_assertion("when the callback list specified by callback_name does not");
	report_assertion("exist for the widget w shall return XtCallbackNoList.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Thscbacks1", "XtHasCallbacks");
	tet_infoline("PREP: Create labelw_good widget Hello in boxw1 widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Add callback XtCBP1_Proc to labelw_good widget");
	XtAddCallback(labelw_good,
			XtNdestroyCallback,
			XtCBP1_Proc,
			(XtPointer)NULL
			);
	tet_infoline("TEST: One call back in the list shall return XtCallbackHasSome");
	status = XtHasCallbacks(labelw_good, XtNdestroyCallback);
	check_dec(XtCallbackHasSome, status, "XtHasCallbacks");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.11551 */
/* End of included file Mdefcode.tmc.11551 */

static void t002(){

Widget labelw_good;
XtCallbackStatus status;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtHasCallbacks-2.(A)");
	report_assertion("A call to XtCallbackStatus XtHasCallbacks(w, callback_name)");
	report_assertion("when the callback list specified by callback_name exists for");
	report_assertion("the widget w and has no callbacks registered for it shall");
	report_assertion("return XtCallbackHasNone.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Thscbacks2", "XtHasCallbacks");
	tet_infoline("PREP: Create labelw_good widget Hello in boxw1 widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: No call back in the list shall return XtCallbackHasNone");
	status = XtHasCallbacks(labelw_good, XtNdestroyCallback);
	check_dec(XtCallbackHasNone, status, "XtHasCallbacks");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.11551 */
/* End of included file Mdefcode.tmc.11551 */

static void t003(){

#define XavsNotResource "bogus resource"
Widget labelw_good;
XtCallbackStatus status;
pid_t pid2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtHasCallbacks-3.(A)");
	report_assertion("A call to XtCallbackStatus XtHasCallbacks(w, callback_name)");
	report_assertion("when the callback list specified by callback_name exists in");
	report_assertion("the widget w and has at least one callback registered for it");
	report_assertion("shall return XtCallbackHasSome.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Thscbacks3", "XtHasCallbacks");
	tet_infoline("PREP: Create labelw_good widget Hello in boxw1 widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: The bogus resource XavsNotResource returns XtCallbackNoList");
	status = XtHasCallbacks(labelw_good, XavsNotResource);
	check_dec(XtCallbackNoList, status, "XtHasCallbacks");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.11551 */
/* End of included file Mdefcode.tmc.11551 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
