/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* 
* SCCS:  @(#)  crtfntcrsr.m Rel 1.5	    (11/25/91)
* 
* 	UniSoft Ltd., London, England
* 
* (C) Copyright 1991 X/Open Company Limited
* 
* All rights reserved.  No part of this source code may be reproduced,
* stored in a retrieval system, or transmitted, in any form or by any
* means, electronic, mechanical, photocopying, recording or otherwise,
* except as stated in the end-user licence agreement, without the prior
* permission of the copyright owners.
* 
* X/Open and the 'X' symbol are trademarks of X/Open Company Limited in
* the UK and other countries.
* 
*/
/*
 * SYNOPSIS:
 *   Cursor
 *   XCreateFontCursor(display, shape)
 *   Display *display;
 *   unsigned int shape;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XCreateFontCursor	1
char    *TestName = "XCreateFontCursor";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XCreateFontCursor function
 */
static Display *display;
static unsigned int shape;


#include <X11/cursorfont.h>

/*
 * mkcolor() -	return a pointer to a color structure.
 *		flag indicates whether or not color is foreground
 * 		(Copied from rclrcrs.m.)
 */
static XColor *
mkcolor(flag)
{
	static	XColor	fore;
	static	XColor	back;
	static	int	first = 1;

	if (first)
	{
		first = 0;

		fore.pixel = BlackPixel(display, DefaultScreen(display));
		XQueryColor(display, DefaultColormap(display, DefaultScreen(display)), &fore);
		back.pixel = WhitePixel(display, DefaultScreen(display));
		XQueryColor(display, DefaultColormap(display, DefaultScreen(display)), &back);
	}
	return(flag ? &fore : &back);
}

static
void
test_font(symbol)
int	symbol;
{
Cursor	qstat;
Window w;
XVisualInfo *vp;
int     pass = 0, fail = 0;

/* Create windows. */
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		w = makewin(display, vp);

		shape = symbol;

		trace("Shape used is %x", shape);
/* Call XCreateFontCursor with specified shape. */
	
		startcall(display);
		if (isdeleted())
			return;
		qstat = XCreateFontCursor(display, shape);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

/* Verify that XCreateFontCursor returns non-zero. */
		if (qstat == 0) {
			report("On a call to XCreateFontCursor,");
			report("wrong value %ld was returned", (long) qstat);
			FAIL;
		} else
			CHECK;

/* Call XDefineCursor and verify that no error occurs. */
		startcall(display);
		if (isdeleted())
			return;
		XDefineCursor(display, w, qstat);
		endcall(display);
		if (geterr() != Success) {
			report("On a call to XDefineCursor,");
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		else
			CHECK;

/* Call XRecolorCursor and verify that no error occurs. */
		startcall(display);
		if (isdeleted())
			return;
		XRecolorCursor(display, qstat, mkcolor(1), mkcolor(0));
		endcall(display);
		if (geterr() != Success) {
			report("On a call to XRecolorCursor,");
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		else
			CHECK;

/* Call XFreeCursor and verify that no error occurs. */
		startcall(display);
		if (isdeleted())
			return;
		XFreeCursor(display, qstat);
		endcall(display);
		if (geterr() != Success) {
			report("On a call to XFreeCursor,");
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		else
			CHECK;
	}

	CHECKPASS(4*nvinf());
}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	shape = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XCreateFontCursor-1.(A)");
	report_assertion("When the shape argument is XC_X_cursor, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_X_cursor.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_X_cursor);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XCreateFontCursor-2.(A)");
	report_assertion("When the shape argument is XC_bottom_left_corner, then a");
	report_assertion("call to XCreateFontCursor creates a Cursor and returns the");
	report_assertion("cursor ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_bottom_left_corner.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_bottom_left_corner);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XCreateFontCursor-3.(A)");
	report_assertion("When the shape argument is XC_bottom_right_corner, then a");
	report_assertion("call to XCreateFontCursor creates a Cursor and returns the");
	report_assertion("cursor ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_bottom_right_corner.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_bottom_right_corner);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XCreateFontCursor-4.(A)");
	report_assertion("When the shape argument is XC_top_left_corner, then a call");
	report_assertion("to XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_top_left_corner.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_top_left_corner);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XCreateFontCursor-5.(A)");
	report_assertion("When the shape argument is XC_top_right_corner, then a");
	report_assertion("call to XCreateFontCursor creates a Cursor and returns the");
	report_assertion("cursor ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_top_right_corner.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_top_right_corner);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XCreateFontCursor-6.(A)");
	report_assertion("When the shape argument is XC_arrow, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_arrow.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_arrow);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XCreateFontCursor-7.(A)");
	report_assertion("When the shape argument is XC_based_arrow_down, then a");
	report_assertion("call to XCreateFontCursor creates a Cursor and returns the");
	report_assertion("cursor ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_based_arrow_down.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_based_arrow_down);

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XCreateFontCursor-8.(A)");
	report_assertion("When the shape argument is XC_based_arrow_up, then a call");
	report_assertion("to XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_based_arrow_up.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_based_arrow_up);

	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XCreateFontCursor-9.(A)");
	report_assertion("When the shape argument is XC_double_arrow, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_double_arrow.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_double_arrow);

	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XCreateFontCursor-10.(A)");
	report_assertion("When the shape argument is XC_question_arrow, then a call");
	report_assertion("to XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_question_arrow.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_question_arrow);

	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XCreateFontCursor-11.(A)");
	report_assertion("When the shape argument is XC_sb_h_double_arrow, then a");
	report_assertion("call to XCreateFontCursor creates a Cursor and returns the");
	report_assertion("cursor ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_sb_h_double_arrow.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_sb_h_double_arrow);

	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XCreateFontCursor-12.(A)");
	report_assertion("When the shape argument is XC_sb_v_double_arrow, then a");
	report_assertion("call to XCreateFontCursor creates a Cursor and returns the");
	report_assertion("cursor ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_sb_v_double_arrow.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_sb_v_double_arrow);

	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XCreateFontCursor-13.(A)");
	report_assertion("When the shape argument is XC_top_left_arrow, then a call");
	report_assertion("to XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_top_left_arrow.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_top_left_arrow);

	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XCreateFontCursor-14.(A)");
	report_assertion("When the shape argument is XC_bottom_tee, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_bottom_tee.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_bottom_tee);

	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){

int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion XCreateFontCursor-15.(A)");
	report_assertion("When the shape argument is XC_left_tee, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_left_tee.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_left_tee);

	tpcleanup();
	pfcount(pass, fail);
}

static void t016(){

int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion XCreateFontCursor-16.(A)");
	report_assertion("When the shape argument is XC_right_tee, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_right_tee.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_right_tee);

	tpcleanup();
	pfcount(pass, fail);
}

static void t017(){

int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion XCreateFontCursor-17.(A)");
	report_assertion("When the shape argument is XC_top_tee, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_top_tee.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_top_tee);

	tpcleanup();
	pfcount(pass, fail);
}

static void t018(){

int 	pass = 0, fail = 0;

 	report_purpose(18);

	report_assertion("Assertion XCreateFontCursor-18.(A)");
	report_assertion("When the shape argument is XC_bottom_side, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_bottom_side.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_bottom_side);

	tpcleanup();
	pfcount(pass, fail);
}

static void t019(){

int 	pass = 0, fail = 0;

 	report_purpose(19);

	report_assertion("Assertion XCreateFontCursor-19.(A)");
	report_assertion("When the shape argument is XC_left_side, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_left_side.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_left_side);

	tpcleanup();
	pfcount(pass, fail);
}

static void t020(){

int 	pass = 0, fail = 0;

 	report_purpose(20);

	report_assertion("Assertion XCreateFontCursor-20.(A)");
	report_assertion("When the shape argument is XC_right_side, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_right_side.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_right_side);

	tpcleanup();
	pfcount(pass, fail);
}

static void t021(){

int 	pass = 0, fail = 0;

 	report_purpose(21);

	report_assertion("Assertion XCreateFontCursor-21.(A)");
	report_assertion("When the shape argument is XC_top_side, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_top_side.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_top_side);

	tpcleanup();
	pfcount(pass, fail);
}

static void t022(){

int 	pass = 0, fail = 0;

 	report_purpose(22);

	report_assertion("Assertion XCreateFontCursor-22.(A)");
	report_assertion("When the shape argument is XC_ll_angle, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_ll_angle.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_ll_angle);

	tpcleanup();
	pfcount(pass, fail);
}

static void t023(){

int 	pass = 0, fail = 0;

 	report_purpose(23);

	report_assertion("Assertion XCreateFontCursor-23.(A)");
	report_assertion("When the shape argument is XC_lr_angle, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_lr_angle.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_lr_angle);

	tpcleanup();
	pfcount(pass, fail);
}

static void t024(){

int 	pass = 0, fail = 0;

 	report_purpose(24);

	report_assertion("Assertion XCreateFontCursor-24.(A)");
	report_assertion("When the shape argument is XC_ul_angle, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_ul_angle.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_ul_angle);

	tpcleanup();
	pfcount(pass, fail);
}

static void t025(){

int 	pass = 0, fail = 0;

 	report_purpose(25);

	report_assertion("Assertion XCreateFontCursor-25.(A)");
	report_assertion("When the shape argument is XC_ur_angle, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_ur_angle.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_ur_angle);

	tpcleanup();
	pfcount(pass, fail);
}

static void t026(){

int 	pass = 0, fail = 0;

 	report_purpose(26);

	report_assertion("Assertion XCreateFontCursor-26.(A)");
	report_assertion("When the shape argument is XC_circle, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_circle.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_circle);

	tpcleanup();
	pfcount(pass, fail);
}

static void t027(){

int 	pass = 0, fail = 0;

 	report_purpose(27);

	report_assertion("Assertion XCreateFontCursor-27.(A)");
	report_assertion("When the shape argument is XC_cross, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_cross.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_cross);

	tpcleanup();
	pfcount(pass, fail);
}

static void t028(){

int 	pass = 0, fail = 0;

 	report_purpose(28);

	report_assertion("Assertion XCreateFontCursor-28.(A)");
	report_assertion("When the shape argument is XC_crosshair, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_crosshair.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_crosshair);

	tpcleanup();
	pfcount(pass, fail);
}

static void t029(){

int 	pass = 0, fail = 0;

 	report_purpose(29);

	report_assertion("Assertion XCreateFontCursor-29.(A)");
	report_assertion("When the shape argument is XC_center_ptr, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_center_ptr.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_center_ptr);

	tpcleanup();
	pfcount(pass, fail);
}

static void t030(){

int 	pass = 0, fail = 0;

 	report_purpose(30);

	report_assertion("Assertion XCreateFontCursor-30.(A)");
	report_assertion("When the shape argument is XC_left_ptr, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_left_ptr.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_left_ptr);

	tpcleanup();
	pfcount(pass, fail);
}

static void t031(){

int 	pass = 0, fail = 0;

 	report_purpose(31);

	report_assertion("Assertion XCreateFontCursor-31.(A)");
	report_assertion("When the shape argument is XC_right_ptr, then a call to");
	report_assertion("XCreateFontCursor creates a Cursor and returns the cursor");
	report_assertion("ID.");

	report_strategy("Create windows.");
	report_strategy("Call XCreateFontCursor with shape XC_right_ptr.");
	report_strategy("Verify that XCreateFontCursor returns non-zero.");
	report_strategy("Call XDefineCursor and verify that no error occurs.");
	report_strategy("Call XRecolorCursor and verify that no error occurs.");
	report_strategy("Call XFreeCursor and verify that no error occurs.");

	tpstartup();
	setargs();
	test_font(XC_right_ptr);

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ t021, 21 },
	{ t022, 22 },
	{ t023, 23 },
	{ t024, 24 },
	{ t025, 25 },
	{ t026, 26 },
	{ t027, 27 },
	{ t028, 28 },
	{ t029, 29 },
	{ t030, 30 },
	{ t031, 31 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = fontstartup;
void	(*tet_cleanup)() = fontcleanup;
