/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XQueryTextExtents(display, font_ID, string, nchars, direction_return, font_ascent_return, font_descent_return, overall_return)
 *   Display	*display;
 *   XID 	font_ID;
 *   char	*string;
 *   int 	nchars;
 *   int 	*direction_return;
 *   int 	*font_ascent_return;
 *   int 	*font_descent_return;
 *   XCharStruct	*overall_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XQueryTextExtents	1
char    *TestName = "XQueryTextExtents";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XQueryTextExtents function
 */
static Display	*display;
static XID 	font_ID;
static char	*string;
static int 	nchars;
static int 	*direction_return;
static int 	*font_ascent_return;
static int 	*font_descent_return;
static XCharStruct	*overall_return;


static int 	StatusReturn;

static	int 	direction;
static	int 	font_ascent;
static	int 	font_descent;
static	XCharStruct	overall;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	font_ID = 0;
	string = 0;
	nchars = 0;
	direction_return = &direction;
	font_ascent_return = &font_ascent;
	font_descent_return = &font_descent;
	overall_return = &overall;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

extern	struct	fontinfo	fontinfo[];
extern	int 	nfontinfo;
int 	i;
char	buf[256];
int 	good_direction;
int 	good_font_ascent;
int 	good_font_descent;
XCharStruct	good_overall;
Drawable	d;
GC		gc;
Font	font;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XQueryTextExtents-1.(A)");
	report_assertion("When the font_ID argument is a valid GContext resource,");
	report_assertion("then a call to XQueryTextExtents returns the bounding box of");
	report_assertion("the specified 8-bit character string, string, as rendered");
	report_assertion("in the font in the corresponding GC's font field.");

	report_strategy("Make a string consisting of all characters from 0 to 255");
	report_strategy("Create drawable");
	report_strategy("Create gc usable with the drawable.");
	report_strategy("For each VSW5 font");
	report_strategy("  Load font");
	report_strategy("  Set font into gc.");
	report_strategy("  Call XQueryTextExtents.");
	report_strategy("  Verify by direct calculation from the metrics.");

	tpstartup();
	setargs();
	for (i = 0; i < 256; i++)
		buf[i] = i;
	string = buf;
	nchars  = 256;

	d = defdraw(display, VI_WIN_PIX);
	gc = makegc(display, d);
	if (isdeleted())
		return;

	for (i = 0; i < nfontinfo; i++) {
		font = XLoadFont(display, fontinfo[i].name);
		XSetFont(display, gc, font);

		font_ID = XGContextFromGC(gc);
		startcall(display);
		if (isdeleted())
			return;
		StatusReturn = XQueryTextExtents(display, font_ID, string, nchars, direction_return, font_ascent_return, font_descent_return, overall_return);
		endcall(display);
		if (StatusReturn == 0) {
			report("Status returned was %d", StatusReturn);
			FAIL;
		}
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		txtextents(fontinfo[i].fontstruct, (unsigned char *)string,
			nchars, &good_direction, &good_font_ascent, &good_font_descent,
			&good_overall);

		/*
		 * Don't check this because not well enough defined.
		 * Just check that it is one of the allowed values.
		 */
		if (direction != FontLeftToRight && direction != FontRightToLeft) {
			report("Font %s - Direction was %d", fontinfo[i].name);
			FAIL;
		} else
			CHECK;

		if (good_font_ascent != font_ascent) {
			report("Font %s: font ascent was %d, expecting %d",
				fontinfo[i].name, font_ascent, good_font_ascent);
			FAIL;
		} else
			CHECK;
		if (good_font_descent != font_descent) {
			report("Font %s: font descent was %d, expecting %d",
				fontinfo[i].name, font_descent, good_font_descent);
			FAIL;
		} else
			CHECK;
		if (good_overall.lbearing != overall.lbearing) {
			report("Font %s: lbearing was %d, expecting %d",
				fontinfo[i].name, overall.lbearing, good_overall.lbearing);
			FAIL;
		} else
			CHECK;
		if (good_overall.rbearing != overall.rbearing) {
			report("Font %s: rbearing was %d, expecting %d",
				fontinfo[i].name, overall.rbearing, good_overall.rbearing);
			FAIL;
		} else
			CHECK;
		if (good_overall.ascent != overall.ascent) {
			report("Font %s: ascent was %d, expecting %d",
				fontinfo[i].name, overall.ascent, good_overall.ascent);
			FAIL;
		} else
			CHECK;
		if (good_overall.descent != overall.descent) {
			report("Font %s: descent was %d, expecting %d",
				fontinfo[i].name, overall.descent, good_overall.descent);
			FAIL;
		} else
			CHECK;
		if (good_overall.width != overall.width) {
			report("Font %s: width was %d, expecting %d",
				fontinfo[i].name, overall.width, good_overall.width);
			FAIL;
		} else
			CHECK;
	}
	CHECKPASS(8*nfontinfo);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

extern	struct	fontinfo	fontinfo[];
extern	int 	nfontinfo;
int 	i;
char	buf[256];
int 	good_direction;
int 	good_font_ascent;
int 	good_font_descent;
XCharStruct	good_overall;
Font	font;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XQueryTextExtents-2.(A)");
	report_assertion("When the font_ID argument is a valid Font resource, then a");
	report_assertion("call to XQueryTextExtents returns the bounding box of the");
	report_assertion("specified 8-bit character string, string, as rendered in");
	report_assertion("the font with font ID font_ID and returns non-zero.");

	report_strategy("Make a string consisting of all characters from 0 to 255");
	report_strategy("For each VSW5 font");
	report_strategy("  Load font.");
	report_strategy("  Call XQueryTextExtents.");
	report_strategy("  Verify by direct calculation from the metrics.");

	tpstartup();
	setargs();
	for (i = 0; i < 256; i++)
		buf[i] = i;
	string = buf;
	nchars  = 256;

	for (i = 0; i < nfontinfo; i++) {
		font = XLoadFont(display, fontinfo[i].name);
		if (isdeleted()) {
			delete("Could not load font '%s'", fontinfo[i].name);
			return;
		}

		font_ID = font;
		startcall(display);
		if (isdeleted())
			return;
		StatusReturn = XQueryTextExtents(display, font_ID, string, nchars, direction_return, font_ascent_return, font_descent_return, overall_return);
		endcall(display);
		if (StatusReturn == 0) {
			report("Status returned was %d", StatusReturn);
			FAIL;
		}
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		txtextents(fontinfo[i].fontstruct, (unsigned char *)string,
			nchars, &good_direction, &good_font_ascent, &good_font_descent,
			&good_overall);

		/*
		 * Don't check this because not well enough defined.
		 * Just check that it is one of the allowed values.
		 */
		if (direction != FontLeftToRight && direction != FontRightToLeft) {
			report("Font %s - Direction was %d", fontinfo[i].name);
			FAIL;
		} else
			CHECK;

		if (good_font_ascent != font_ascent) {
			report("Font %s: font ascent was %d, expecting %d",
				fontinfo[i].name, font_ascent, good_font_ascent);
			FAIL;
		} else
			CHECK;
		if (good_font_descent != font_descent) {
			report("Font %s: font descent was %d, expecting %d",
				fontinfo[i].name, font_descent, good_font_descent);
			FAIL;
		} else
			CHECK;
		if (good_overall.lbearing != overall.lbearing) {
			report("Font %s: lbearing was %d, expecting %d",
				fontinfo[i].name, overall.lbearing, good_overall.lbearing);
			FAIL;
		} else
			CHECK;
		if (good_overall.rbearing != overall.rbearing) {
			report("Font %s: rbearing was %d, expecting %d",
				fontinfo[i].name, overall.rbearing, good_overall.rbearing);
			FAIL;
		} else
			CHECK;
		if (good_overall.ascent != overall.ascent) {
			report("Font %s: ascent was %d, expecting %d",
				fontinfo[i].name, overall.ascent, good_overall.ascent);
			FAIL;
		} else
			CHECK;
		if (good_overall.descent != overall.descent) {
			report("Font %s: descent was %d, expecting %d",
				fontinfo[i].name, overall.descent, good_overall.descent);
			FAIL;
		} else
			CHECK;
		if (good_overall.width != overall.width) {
			report("Font %s: width was %d, expecting %d",
				fontinfo[i].name, overall.width, good_overall.width);
			FAIL;
		} else
			CHECK;
	}
	CHECKPASS(8*nfontinfo);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){


 	report_purpose(3);

	report_assertion("Assertion XQueryTextExtents-3.(-)");
	report_assertion("The ascent field of overall is set to the maximum of the");
	report_assertion("ascent metrics of all characters in the string.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t004(){


 	report_purpose(4);

	report_assertion("Assertion XQueryTextExtents-4.(-)");
	report_assertion("The descent field of overall is set to the maximum of the");
	report_assertion("descent metrics of all characters in the string.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t005(){


 	report_purpose(5);

	report_assertion("Assertion XQueryTextExtents-5.(-)");
	report_assertion("The width field of overall is set to the sum of the");
	report_assertion("character-width metrics of all characters in the string.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t006(){


 	report_purpose(6);

	report_assertion("Assertion XQueryTextExtents-6.(-)");
	report_assertion("The lbearing field of overall is set to the minimum L of");
	report_assertion("all characters in the string, where for each character L is");
	report_assertion("the left-side-metric plus the sum of the character widths of");
	report_assertion("all preceding characters in the string.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t007(){


 	report_purpose(7);

	report_assertion("Assertion XQueryTextExtents-7.(-)");
	report_assertion("The rbearing field of overall is set to the maximum R of");
	report_assertion("all characters in the string, where for each character R is");
	report_assertion("the right-side-bearing metric plus the sum of the character");
	report_assertion("widths of all preceding characters in the string.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t008(){


 	report_purpose(8);

	report_assertion("Assertion XQueryTextExtents-8.(-)");
	report_assertion("The font_ascent_return argument is set to the logical");
	report_assertion("ascent of the font, the font_descent_return argument is set");
	report_assertion("to the logical descent of the font and the direction_return");
	report_assertion("argument is set to either FontLeftToRight or");
	report_assertion("FontRightToLeft.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t009(){


 	report_purpose(9);

	report_assertion("Assertion XQueryTextExtents-9.(-)");
	report_assertion("When the font has no defined default character, then");
	report_assertion("undefined characters in the string are taken to have all");
	report_assertion("zero metrics.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t010(){


 	report_purpose(10);

	report_assertion("Assertion XQueryTextExtents-10.(-)");
	report_assertion("Characters with all zero metrics are ignored.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t011(){


 	report_purpose(11);

	report_assertion("Assertion XQueryTextExtents-11.(-)");
	report_assertion("When the font has no defined default_char, then the");
	report_assertion("undefined characters in the string are also ignored.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

/* Including from file error/EFon2.mc */
/* End of included file error/EFon2.mc */

static void t012(){

int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XQueryTextExtents-12.(A)");
	report_assertion("When the font argument does not name a valid GContext or");
	report_assertion("font resource, then a BadFont error occurs.");

	report_strategy("Pass a bad font");
	report_strategy("Verify BadFont error occurs");
	report_strategy("Pass a bad gc");
	report_strategy("Verify BadFont error occurs");

	tpstartup();
	setargs();
	string = "jfdkjfk";
	nchars = strlen(string);
	font_ID = badfont(display);

	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XQueryTextExtents(display, font_ID, string, nchars, direction_return, font_ascent_return, font_descent_return, overall_return);
	endcall(display);
	if (StatusReturn != 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadFont) {
		report("Got %s, Expecting BadFont", errorname(geterr()));
		FAIL;
	}
	if (geterr() == BadFont)
		CHECK;
	else {
		report("No BadFont occurred with a bad font");
		FAIL;
	}

	font_ID = XGContextFromGC(badgc(display));	/* XXX */
	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XQueryTextExtents(display, font_ID, string, nchars, direction_return, font_ascent_return, font_descent_return, overall_return);
	endcall(display);
	if (StatusReturn != 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadFont) {
		report("Got %s, Expecting BadFont", errorname(geterr()));
		FAIL;
	}
	if (geterr() == BadFont)
		CHECK;
	else {
		report("No BadFont occurred with a bad gc");
		FAIL;
	}
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = fontstartup;
void	(*tet_cleanup)() = fontcleanup;
