/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   char	**
 *   XListFonts(display, patternarg, maxnames, actual_count_return)
 *   Display	*display;
 *   char	*patternarg;
 *   int 	maxnames;
 *   int 	*actual_count_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XListFonts	1
char    *TestName = "XListFonts";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XListFonts function
 */
static Display	*display;
static char	*patternarg;
static int 	maxnames;
static int 	*actual_count_return;


#include	<ctype.h>
#include	<string.h>

static	int 	Count;

extern	struct	fontinfo	fontinfo[];
extern	int 	nfontinfo;

static lowerstring(str)
char	*str;
{
	for (; *str; str++) {
		if (isupper(*str))
			tolower(*str);
	}
}

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	patternarg = 0;
	maxnames = 1000;
	actual_count_return = &Count;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

char	**names;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XListFonts-1.(A)");
	report_assertion("When the patternarg argument is a string in ISO Latin-1");
	report_assertion("encoding terminated with ASCII nul, then a call to");
	report_assertion("XListFonts returns an array of strings terminated with ASCII");
	report_assertion("nul which are available font names that match the patternarg");
	report_assertion("argument and returns the number of fonts in the");
	report_assertion("actual_count_return argument.");

	report_strategy("Set patternarg to \"xtfont0\"");
	report_strategy("Call XListFonts.");
	report_strategy("Verify that returned count was 1.");
	report_strategy("Verify that the returned names pointer was non-NULL.");
	report_strategy("Lower-case the returned string.");
	report_strategy("Verify that xtfont0 was returned.");

	tpstartup();
	setargs();
	patternarg = "xtfont0";
	startcall(display);
	if (isdeleted())
		return;
	names = XListFonts(display, patternarg, maxnames, actual_count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (Count != 1) {
		report("actual_count_return was %d, expecting 1", Count);
		FAIL;
	} else
		CHECK;

	if (names == NULL) {
		report("NULL was returned");
		FAIL;
		return;
	} else
		CHECK;

	lowerstring(*names);
	if (strcmp(*names, patternarg) != 0) {
		report("returned name was '%s', expecting '%s'", *names, patternarg);
		FAIL;
	} else
		CHECK;

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

char	**names;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XListFonts-2.(A)");
	report_assertion("Upper and lower case characters in the patternarg argument");
	report_assertion("refer to the same font.");

	report_strategy("Try matching with XtFoNt0");
	report_strategy("Call XListFonts.");
	report_strategy("Verify that returned count was 1.");
	report_strategy("Verify that the returned names pointer was non-NULL.");
	report_strategy("Lower-case the returned string.");
	report_strategy("Verify that xtfont0 was returned.");

	tpstartup();
	setargs();
	patternarg = "XtFoNt0";
	startcall(display);
	if (isdeleted())
		return;
	names = XListFonts(display, patternarg, maxnames, actual_count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (Count != 1) {
		report("actual_count_return was %d, expecting 1", Count);
		FAIL;
	} else
		CHECK;

	if (names == NULL) {
		report("NULL was returned");
		FAIL;
		return;
	} else
		CHECK;

	lowerstring(*names);
	patternarg = "xtfont0";
	if (strcmp(*names, patternarg) != 0) {
		report("returned name was '%s', expecting '%s'", *names, patternarg);
		FAIL;
	} else
		CHECK;

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

char	**names;
char	*curname;
int 	i;
int 	j;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XListFonts-3.(A)");
	report_assertion("Each asterisk (*) in the string is a wildcard for any");
	report_assertion("number of characters.");

	report_strategy("Set patternarg to \"x*t*t*\"");
	report_strategy("Call XListFonts.");
	report_strategy("Verify that at least all the VSW5 fonts are returned, and");
	report_strategy("that any other returned string matches the patternarg.");

	tpstartup();
	setargs();
	patternarg = "x*t*t*";
	startcall(display);
	if (isdeleted())
		return;
	names = XListFonts(display, patternarg, maxnames, actual_count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (Count < XT_NFONTS) {
		report("returned count was %d, expecting at least %d", Count,XT_NFONTS);
		FAIL;
	} else
		CHECK;

	if (names == NULL) {
		report("returned name pointer was NULL");
		FAIL;
		return;
	} else
		CHECK;

	for (i = 0; i < Count; i++) {
		curname = names[i];
		lowerstring(curname);
		for (j = 0; j < nfontinfo; j++) {
			if (strcmp(curname, fontinfo[j].name) == 0) {
				/* Check if we have already seen this one */
				if (fontinfo[j].flag) {
					report("name %s repeated in list", curname);
					FAIL;
				} else {
					fontinfo[j].flag++;
					CHECK;
				}
				break;
			}
		}
		if (j == nfontinfo) {
		char	*cp;

			/* It wasn't one of ours... */
			trace("extra font name %s found", curname);
			cp = strchr(curname, 'x');
			if (cp == NULL) {
				report("Found name %s that did not match patternarg");
				FAIL;
			} else if ((cp = strchr(cp, 't')) == NULL) {
				report("Found name %s that did not match patternarg");
				FAIL;
			} else if ((cp = strchr(cp, 't')) == NULL) {
				report("Found name %s that did not match patternarg");
				FAIL;
			} else {
				CHECK;
			}
		}
	}
	for (i = 0; i < nfontinfo; i++) {
		if (fontinfo[i].flag == 0) {
			report("VSW5 font '%s' was not found", fontinfo[i].name);
			FAIL;
		} else {
			/* reset to zero for next test */
			fontinfo[i].flag = 0;
			CHECK;
		}
	}
	CHECKPASS(2+Count+nfontinfo);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

char	**names;
char	*curname;
int 	i;
int 	j;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XListFonts-4.(A)");
	report_assertion("Each question mark (?) in the string is a wildcard for a");
	report_assertion("single character.");

	report_strategy("Set patternarg to \"x?f?nt?\"");
	report_strategy("Call XListFonts.");
	report_strategy("Verify that returned count is at least XT_NFONTS");
	report_strategy("Verify that the VSW5 font names are returned.");
	report_strategy("Verify that any other name returned matches the patternarg.");

	tpstartup();
	setargs();
	patternarg = "x?f?nt?";
	startcall(display);
	if (isdeleted())
		return;
	names = XListFonts(display, patternarg, maxnames, actual_count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (Count < XT_NFONTS) {
		report("returned count was %d, expecting at least %d", Count,XT_NFONTS);
		FAIL;
	} else
		CHECK;

	if (names == NULL) {
		report("returned name pointer was NULL");
		FAIL;
		return;
	} else
		CHECK;

	for (i = 0; i < Count; i++) {
		curname = names[i];
		lowerstring(curname);
		for (j = 0; j < nfontinfo; j++) {
			if (strcmp(curname, fontinfo[j].name) == 0) {
				/* Check if we have already seen this one */
				/* XXX I am assuming that duplicates are not allowed ??? */
				if (fontinfo[j].flag) {
					report("name %s repeated in list", curname);
					FAIL;
				} else {
					fontinfo[j].flag++;
					CHECK;
				}
				break;
			}
		}
		if (j == nfontinfo) {
		int 	len;

			/* It wasn't one of ours... */
			trace("extra font name %s found", curname);
			len = strlen(patternarg);
			if (strlen(curname) != len) {
				report("name '%s' did not match patternarg");
				FAIL;
			} else {
				for (j = 0; j < len; j++) {
					if (patternarg[j] == '?')
						continue;
					if (curname[j] != patternarg[j]) {
						report("name '%s' did not match patternarg");
						FAIL;
						break;
					}
				}
				if (j == len)
					CHECK;
			}
		}
	}
	for (i = 0; i < nfontinfo; i++) {
		if (fontinfo[i].flag == 0) {
			report("VSW5 font '%s' was not found", fontinfo[i].name);
			FAIL;
		} else {
			/* reset to zero for next test */
			fontinfo[i].flag = 0;
			CHECK;
		}
	}
	CHECKPASS(2+Count+nfontinfo);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

char	**names;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XListFonts-5.(A)");
	report_assertion("The number of fonts returned in the actual_count_return");
	report_assertion("argument will not exceed ma XListFonts s.");

	report_strategy("Set maXListFontss to 1");
	report_strategy("Set patternarg to \"*\"");
	report_strategy("Verify that only one name was returned.");

	tpstartup();
	setargs();
	maxnames = 1;
	patternarg = "*";

	startcall(display);
	if (isdeleted())
		return;
	names = XListFonts(display, patternarg, maxnames, actual_count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (Count > maxnames) {
		report("returned count was %d, not expecting it to exceed %d", Count, maxnames);
		FAIL;
	} else {
		PASS;
	}
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

char	**names;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XListFonts-6.(A)");
	report_assertion("When there are no available font names that match the");
	report_assertion("patternarg argument, then a call to XListFonts returns NULL.");

	report_strategy("Set patternarg to a bad name.");
	report_strategy("Call XListFonts.");
	report_strategy("Verify that NULL is returned.");

	tpstartup();
	setargs();
	/* Of course if someone deliberately adds such a name.. */
	patternarg = "xtfont non existant name";

	startcall(display);
	if (isdeleted())
		return;
	names = XListFonts(display, patternarg, maxnames, actual_count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (names != NULL) {
		report("returned pointer was not NULL");
		FAIL;
	} else
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = fontstartup;
void	(*tet_cleanup)() = fontcleanup;
