/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XAllocColor(display, colormap, screen_in_out)
 *   Display *display;
 *   Colormap colormap;
 *   XColor *screen_in_out;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XAllocColor	1
char    *TestName = "XAllocColor";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_COLORMAP colormap


/*
 * Arguments to the XAllocColor function
 */
static Display *display;
static Colormap colormap;
static XColor *screen_in_out;


static int 	StatusReturn;

XColor dummy;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	colormap = DefaultColormap(display, DefaultScreen(display));
	screen_in_out = &dummy;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display	*disp2;
XVisualInfo *vp;
Status status;
XColor screencol, testcol;
unsigned long vmask;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XAllocColor-1.(A)");
	report_assertion("A call to XAllocColor allocates a read-only entry in the");
	report_assertion("colormap argument corresponding to the closest RGB value");
	report_assertion("that is supported by the hardware to the value specified by");
	report_assertion("the red, green, and blue components in the XColor");
	report_assertion("structure named by the screen_in_out argument, returns that");
	report_assertion("value in the red, green, and blue components in the XColor");
	report_assertion("structure named by the screen_in_out argument and returns");
	report_assertion("the colourmap entry in the pixel component in the XColor");
	report_assertion("structure named by the screen_in_out argument.");

	report_strategy("For each supported visual class:");
	report_strategy("  Create a colormap with XCreateColormap.");
	report_strategy("  Create a new client with XOpenDisplay.");
	report_strategy("  Allocate one read-only colorcell with XAllocColor with the second client.");
	report_strategy("  Reallocate a cell with the returned RGB values with the original client.");
	report_strategy("  Verify that the returned pixel is identical to the first and that the r, g and b value argee.");
	report_strategy("  Verify  the cell is read only with the failure of XStoreColor.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, 0L)) == 0L) {
		delete("No visuals reported as valid.");
		return;
	}

	if( (disp2 = opendisplay()) == (Display *) 0) {
		delete("Could not open display");
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		trace("Attempting AllocColor() for class %s", displayclassname(vp->class));
		colormap = makecolmap(display, vp -> visual, AllocNone);

		testcol.red = 0xf3f3;
		testcol.green = 0xe4e4;
		testcol.blue = 0xd5d5;
		
		trace("Source colour :  r %u g %u b %u", testcol.red, testcol.green, testcol.blue);
		screen_in_out = &testcol;
		display = disp2;
		startcall(display);
		if (isdeleted())
			return;
		status = XAllocColor(display, colormap, screen_in_out);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if( status == (Status) 0) {
			report("XAllocColor() failed to return non-zero.");
			FAIL;
			continue;
		}

		screencol = testcol;
		trace("Screen: pixel %lu, r %u g %u b %u", screencol.pixel , screencol.red, screencol.green, screencol.blue);
		trace("Test : pixel %lu, r %u g %u b %u", testcol.pixel, testcol.red, testcol.green, testcol.blue);

		screen_in_out = &testcol;
		display = Dsp; 
		startcall(display);
		if (isdeleted())
			return;
		status = XAllocColor(display, colormap, screen_in_out);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
	
		if(status == (Status) 0) {
			report("XAllocColor() failed to return non-zero.");
			FAIL;
			continue;	
		}

		if( screencol.pixel != testcol.pixel ) {
			report("XAllocColor() return pixel value %lu instead of %lu.", testcol.pixel, screencol.pixel);
			FAIL;
		} else
			CHECK;

		if( (screencol.red != testcol.red) || (screencol.green != testcol.green) || (screencol.blue != testcol.blue) ) {
			report("XAllocColor() return RGB values r %u g %u b %u instead of r %u g %u b %u.", 
				testcol.red, testcol.green, testcol.blue, screencol.red, screencol.green, screencol.blue);
			FAIL;
		} else
			CHECK;
	
		startcall(display);
		XStoreColor(display, colormap, &testcol);
		endcall(display);

		if (geterr() == Success) {
			report("Got success writing to a read-only cell");
			tet_result(TET_FAIL);
		} else
			CHECK;

	}

	CHECKPASS(3 * nsupvis());


	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XVisualInfo *vp;
Status status;
XColor screencol, testcol;
unsigned long vmask;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XAllocColor-2.(A)");
	report_assertion("A call to XAllocColor does not use or affect the flags");
	report_assertion("component of the XColor structure named by the screen_in_out");
	report_assertion("argument.");

	report_strategy("For each supported visual class:");
	report_strategy("  Create a colormap with XCreateColormap.");
	report_strategy("  Allocate a colourcell with an XColor structure flags component of DoGreen,");
	report_strategy("   and red, green and blue components of 255<<8, 63<<8 and 31 <<8.");
	report_strategy("  Verify that the returned flags component is DoGreen.");
	report_strategy("  Allocate a colourcell with an XColor structure flags component of DoRed | DoBlue");
	report_strategy("   and red, green and blue components of 255<<8, 63<<8 and 31 <<8.");
	report_strategy("  Verify that the returned flags component is DoRed | DoBlue.");
	report_strategy("  Verify that the returned pixel and red, green and blue values are identical to");
	report_strategy("   those initially returned.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, 0L)) == 0L) {
		delete("No visuals reported as valid.");
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		trace("Attempting AllocColor() for class %s", displayclassname(vp->class));
		colormap = makecolmap(display, vp -> visual, AllocNone);

		testcol.red = 255 << 8;
		testcol.green = 63 << 8;
		testcol.blue = 31 << 8;
		testcol.flags = DoGreen;		

		screen_in_out = &testcol;
		startcall(display);
		if (isdeleted())
			return;
		status = XAllocColor(display, colormap, screen_in_out);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if( status == (Status) 0) {
			report("XAllocColor() failed to return non-zero.");
			FAIL;
			continue;
		}

		if( DoGreen != testcol.flags ) {
			report("XAllocColor() altered flags value %lu to %lu.",
					 DoGreen, testcol.flags);
			FAIL;
		} else
			CHECK;

		screencol = testcol;
		trace("Screen: pixel %lu, r %u g %u b %u", screencol.pixel , screencol.red, screencol.green, screencol.blue);
		trace("Test : pixel %lu, r %u g %u b %u", testcol.pixel, testcol.red, testcol.green, testcol.blue);

		testcol.red = 255 << 8;
		testcol.green = 63 << 8;
		testcol.blue = 31 << 8;
		testcol.flags = DoRed | DoBlue;

		screen_in_out = &testcol;
		startcall(display);
		if (isdeleted())
			return;
		status = XAllocColor(display, colormap, screen_in_out);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
	
		if(status == (Status) 0) {
			report("XAllocColor() failed to return non-zero.");
			FAIL;
			continue;	
		}

		if( (DoRed | DoBlue) != testcol.flags ) {
			report("XAllocColor() altered flags value %lu to %lu.",
					 (DoRed | DoBlue), testcol.flags);
			FAIL;
		} else
			CHECK;

		if( screencol.pixel != testcol.pixel ) {
			report("XAllocColor() return pixel value %lu instead of %lu.", testcol.pixel, screencol.pixel);
			FAIL;
		} else
			CHECK;

		if( (screencol.red != testcol.red) || (screencol.green != testcol.green) || (screencol.blue != testcol.blue) ) {
			report("XAllocColor() return RGB values r %u g %u b %u instead of r %u g %u b %u.", 
				testcol.red, testcol.green, testcol.blue, screencol.red, screencol.green, screencol.blue);
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(4 * nsupvis());



	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XVisualInfo *vp;
Status status;
XColor screencol, testcol;
unsigned long vmask;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XAllocColor-3.(A)");
	report_assertion("When a call to XAllocColor has allocated a read-only entry");
	report_assertion("in a colourmap, then a subsequent call to XAllocColor with");
	report_assertion("identical red, green and blue components in the XColor");
	report_assertion("structure named by the screen_in_out argument returns an");
	report_assertion("identical pixel component in the XColor structure.");

	report_strategy("For each supported visual class:");
	report_strategy("  Create a colormap with XCreateColormap.");
	report_strategy("  Allocate a colourcell with an XColor structure with");
	report_strategy("   red, green and blue components of 255<<8, 127<<8 and 63 <<8.");
	report_strategy("  Allocate a colourcell with an XColor structure having the");
	report_strategy("   the previously returned rgb values.");
	report_strategy("  Verify that the returned pixel is the same as that initially returned.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, 0L)) == 0L) {
		delete("No visuals reported as valid.");
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		trace("Attempting AllocColor() for class %s", displayclassname(vp->class));
		colormap = makecolmap(display, vp -> visual, AllocNone);

		testcol.red = 255 << 8;
		testcol.green = 127 << 8;
		testcol.blue = 63 << 8;

		screen_in_out = &testcol;
		startcall(display);
		if (isdeleted())
			return;
		status = XAllocColor(display, colormap, screen_in_out);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if( status == (Status) 0) {
			report("XAllocColor() failed to return non-zero.");
			FAIL;
			continue;
		}

		screencol = testcol;
		trace("Screen: pixel %lu, r %u g %u b %u", screencol.pixel , screencol.red, screencol.green, screencol.blue);
		trace("Test : pixel %lu, r %u g %u b %u", testcol.pixel, testcol.red, testcol.green, testcol.blue);

		screen_in_out = &testcol;
		startcall(display);
		if (isdeleted())
			return;
		status = XAllocColor(display, colormap, screen_in_out);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
	
		if(status == (Status) 0) {
			report("XAllocColor() failed to return non-zero.");
			FAIL;
			continue;	
		}

		if( screencol.pixel != testcol.pixel ) {
			report("XAllocColor() return pixel value %lu instead of %lu.", testcol.pixel, screencol.pixel);
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/ECol.mc */
/* End of included file error/ECol.mc */

/* Including from file error/ECol.mc */
static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XAllocColor-4.(A)");
	report_assertion("When a colourmap argument does not name a valid colourmap,");
	report_assertion("then a BadColor error occurs.");

	report_strategy("Create a bad colourmap by creating and freeing a colourmap.");
	report_strategy("Call test function using bad colourmap as the colourmap argument.");
	report_strategy("Verify that a BadColor error occurs.");

	tpstartup();
	setargs();
	A_COLORMAP = badcolormap(A_DISPLAY, DRW(A_DISPLAY));
	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XAllocColor(display, colormap, screen_in_out);
	endcall(display);
	if (StatusReturn != 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadColor) {
		report("Got %s, Expecting BadColor", errorname(geterr()));
		FAIL;
	}
	if(geterr() == BadColor)
		PASS;
	else 
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/ECol.mc */

/* Including from file error/EAll.mc */
/* End of included file error/EAll.mc */

/* Including from file error/EAll.mc */
static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XAllocColor-5.(B)");
	report_assertion("When the server fails to allocate a required resource, then");
	report_assertion("a BadAlloc error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	report("There is no reliable method of testing that a BadAlloc error is generated");
	tet_result(TET_UNTESTED);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAll.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
