/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XUnmapWindow(display, w)
 *   Display	*display;
 *   Window	w;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XUnmapWindow	1
char    *TestName = "XUnmapWindow";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XUnmapWindow function
 */
static Display	*display;
static Window	w;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	w = ErrdefWindow;
}

static void t001(){

Window	base;
struct	area	area;
XWindowAttributes	atts;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XUnmapWindow-1.(A)");
	report_assertion("A call to XUnmapWindow unmaps the specified window.");

	report_strategy("Create window.");
	report_strategy("Draw on window.");
	report_strategy("Unmap window.");
	report_strategy("Verify that map state is IsUnmapped.");
	report_strategy("Verify that window has disappeared from screen.");

	tpstartup();
	setargs();
	base = defwin(display);
	setarea(&area, 10, 10, 50, 50);
	w = crechild(display, base, &area);
	pattern(display, w);

	startcall(display);
	if (isdeleted())
		return;
	XUnmapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetWindowAttributes(display, w, &atts);
	if (atts.map_state != IsUnmapped) {
		report("After unmap map-state was %s, expecting IsUnmapped",
			mapstatename(atts.map_state));
		FAIL;
	} else
		CHECK;

	if (checkclear(display, base))
		CHECK;
	else {
		report("Window did not disappear after unmapping");
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Window	base;
struct	area	area;
XWindowAttributes	atts;
XEvent	ev;
XUnmapEvent	*ump;
XUnmapEvent	good;
int 	got_parent = 0;
int 	got_window = 0;
int 	n;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XUnmapWindow-2.(A)");
	report_assertion("When the specified window is mapped, then a call to");
	report_assertion("XUnmapWindow generates an UnmapNotify event.");

	report_strategy("Create parent window.");
	report_strategy("Create child window.");
	report_strategy("Select SubstructureNotify on parent.");
	report_strategy("Select StructureNotify on child.");
	report_strategy("Call XUnmapWindow to unmap child window.");
	report_strategy("Verify that UnmapNotify is received on window.");
	report_strategy("Verify that UnmapNotify is received on parent.");

	tpstartup();
	setargs();
	base = defwin(display);
	setarea(&area, 10, 10, 50, 50);
	w = crechild(display, base, &area);
	pattern(display, w);

	XSelectInput(display, base, SubstructureNotifyMask);
	XSelectInput(display, w, StructureNotifyMask);

	startcall(display);
	if (isdeleted())
		return;
	XUnmapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSelectInput(display, base, NoEventMask);
	XSelectInput(display, w, NoEventMask);

	n = XPending(display);
	if (n != 2) {
		report("Wrong number of events received got %d, expecting 2", n);
		FAIL;
	} else
		CHECK;

	got_window = 0;
	got_parent = 0;
	while (getevent(display, &ev)) {
		if (ev.type != UnmapNotify) {
			report("Event of type %s was received unexpectedly", eventname(ev.type));
			FAIL;
			continue;
		} else
			CHECK;

		ump = (XUnmapEvent*)&ev;

		if (ump->event == ump->window) {
			got_window++;
		} else if (ump->event != base) {
			report("Event received on a window other than the parent");
			FAIL;
		} else {
			got_parent++;
		}
		good.type = UnmapNotify;
		good.serial = 0L;
		good.send_event = False;
		good.display = display;
		good.event = ump->event;
		good.window = w;
		good.from_configure = False;

		if (checkevent((XEvent*)&good, &ev))
			FAIL;
		else
			CHECK;
	}

	if (got_window > 1) {
		report("Repeat unmap notify event on window");
		FAIL;
	} else if (got_window == 0) {
		report("UnmapNotify event was not received on window");
		FAIL;
	} else
		CHECK;

	if (got_parent > 1) {
		report("Repeat unmap notify event on parent window");
		FAIL;
	} else if (got_parent == 0) {
		report("UnmapNotify event was not received on parent window");
		FAIL;
	} else
		CHECK;

	XGetWindowAttributes(display, w, &atts);
	if (atts.map_state != IsUnmapped) {
		report("After unmap map-state was %s, expecting IsUnmapped",
			mapstatename(atts.map_state));
		FAIL;
	} else
		CHECK;

	if (checkclear(display, base))
		CHECK;
	else {
		report("Window did not disappear after unmapping");
		FAIL;
	}

	CHECKPASS(1+2*2+4);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Window	base;
struct	area	area;
XWindowAttributes	atts;
int 	n;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XUnmapWindow-3.(A)");
	report_assertion("When the specified window is already unmapped, then a call");
	report_assertion("to XUnmapWindow has no effect.");

	report_strategy("Create parent window.");
	report_strategy("Create child window.");
	report_strategy("Select StructureNotify on child.");
	report_strategy("Call XUnmapWindow to unmap child window.");
	report_strategy("Verify that no UnmapNotify event is received on window.");

	tpstartup();
	setargs();
	base = defwin(display);
	setarea(&area, 10, 10, 50, 50);
	w = creunmapchild(display, base, &area);
	pattern(display, w);

	XSelectInput(display, w, StructureNotifyMask);

	startcall(display);
	if (isdeleted())
		return;
	XUnmapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSelectInput(display, w, NoEventMask);

	n = XPending(display);
	if (n != 0) {
		report("Received event when window already unmapped");
		FAIL;
	} else
		CHECK;

	XGetWindowAttributes(display, w, &atts);
	if (atts.map_state != IsUnmapped) {
		report("After unmap map-state was %s, expecting IsUnmapped",
			mapstatename(atts.map_state));
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Window	base;
Window	ch;
struct	area	area;
XWindowAttributes	atts;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XUnmapWindow-4.(A)");
	report_assertion("When there is a viewable child of window, then after a");
	report_assertion("call to XUnmapWindow the child window is no longer viewable.");

	report_strategy("Create base window.");
	report_strategy("Create parent window as inferior of base.");
	report_strategy("Create child window as inferior of parent.");
	report_strategy("Check it is Viewable.");
	report_strategy("Unmap parent window.");
	report_strategy("Verify that map-state of child window is IsUnviewable.");

	tpstartup();
	setargs();
	base = defwin(display);
	setarea(&area, 10, 10, 50, 50);
	w = crechild(display, base, &area);
	pattern(display, w);

	setarea(&area, 5, 5, 10, 10);
	ch = crechild(display, w, &area);

	XGetWindowAttributes(display, ch, &atts);
	if (atts.map_state != IsViewable) {
		delete("Before unmapping parent map-state of child was %s, expecting IsViewable", mapstatename(atts.map_state));
		return;
	} else
		CHECK;

	startcall(display);
	if (isdeleted())
		return;
	XUnmapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetWindowAttributes(display, ch, &atts);
	if (atts.map_state != IsUnviewable) {
		report("After unmap map-state was %s, expecting IsUnviewable",
			mapstatename(atts.map_state));
		FAIL;
	} else
		CHECK;

	if (checkclear(display, base))
		CHECK;
	else {
		report("Window did not disappear after unmapping");
		FAIL;
	}

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Window	base;
struct	area	area;
XWindowAttributes	atts;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XUnmapWindow-5.(A)");
	report_assertion("When a call to XUnmapWindow uncovers part of any window");
	report_assertion("that was formerly obscured, then either Expose events are");
	report_assertion("generated or the contents are restored from backing store.");

	report_strategy("Create base window.");
	report_strategy("Call setforexpose() on base window.");
	report_strategy("Create child window to unmap.");
	report_strategy("Call XUnmapWindow to unmap window.");
	report_strategy("Verify expose or backing store restore occurred with exposecheck().");

	tpstartup();
	setargs();
	base = defwin(display);

	setarea(&area, 10, 10, 50, 50);
	w = crechild(display, base, &area);
	pattern(display, w);

	setforexpose(display, base);
	XSelectInput(display, base, ExposureMask);

	startcall(display);
	if (isdeleted())
		return;
	XUnmapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetWindowAttributes(display, w, &atts);
	if (atts.map_state != IsUnmapped) {
		report("After unmap map-state was %s, expecting IsUnmapped",
			mapstatename(atts.map_state));
		FAIL;
	} else
		CHECK;

	if (exposecheck(display, base))
		CHECK;
	else {
		report("Neither Expose events or backing store processing");
		report("could correctly restore the window contents.");
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XUnmapWindow-6.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XUnmapWindow(display, w);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
