/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XUngrabKeyboard(display, thetime)
 *   Display	*display;
 *   Time	thetime;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XUngrabKeyboard	1
char    *TestName = "XUngrabKeyboard";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XUngrabKeyboard function
 */
static Display	*display;
static Time	thetime;



static Status
ispfrozen()
{
Window	win;
XEvent	ev;

	win = defwin(display);
	XSelectInput(display, win, PointerMotionMask);

	warppointer(display, win, 0, 0);
	warppointer(display, win, 1, 1);

	if (XCheckWindowEvent(display, win, PointerMotionMask, &ev))
		return(False);
	else
		return(True);
}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	thetime = CurrentTime;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Window	win;
int 	key;
int 	n;
int 	first;
XEvent	ev;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XUngrabKeyboard-1.(B)");
	report_assertion("When the client has actively grabbed the keyboard, then a");
	report_assertion("call to XUngrabKeyboard releases the keyboard and any queued");
	report_assertion("events.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create grab window.");
	report_strategy("Grab and freeze keyboard.");
	report_strategy("If no extensions:");
	report_strategy("  Touch test XUngrabKeyboard.");
	report_strategy("else");
	report_strategy("  Press and release key.");
	report_strategy("  Call XUngrabKeyboard.");
	report_strategy("  Verify that events are released.");
	report_strategy("  Create new window.");
	report_strategy("  Verify that keyboard events can be received on it.");

	tpstartup();
	setargs();
	win = defwin(display);
	XSelectInput(display, win, KeyPressMask|KeyReleaseMask);

	XGrabKeyboard(display, win, False, GrabModeAsync, GrabModeSync, thetime);

	if (noext(0)) {
		startcall(display);
		if (isdeleted())
			return;
		XUngrabKeyboard(display, thetime);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		untested("There is no reliable test method, but a touch test was performed");
		return;
	} else
		CHECK;

	key = getkeycode(display);
	warppointer(display, win, 10, 10);
	keypress(display, key);
	keyrel(display, key);

	if (XCheckMaskEvent(display, KeyPressMask|KeyReleaseMask, &ev)) {
		report("Got events while keyboard was meant to be frozen");
		FAIL;
	} else
		CHECK;

	startcall(display);
	if (isdeleted())
		return;
	XUngrabKeyboard(display, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	n = getevent(display, &ev);
	if (n != 2) {
		report("Expecting two events to be released after grab");
		report("  got %d", n);
		FAIL;
	} else {
		first = ev.type;
		getevent(display, &ev);

		if (ev.type != KeyPress && first != KeyPress) {
			report("Did not get KeyPress event after releasing grab");
			FAIL;
		} else
			CHECK;
		if (ev.type != KeyRelease && first != KeyRelease) {
			report("Did not get KeyRelease event after releasing grab");
			FAIL;
		} else
			CHECK;
	}

	win = defwin(display);
	XSelectInput(display, win, KeyPressMask);
	warppointer(display, win, 5, 5);
	keypress(display, key);
	if (XCheckWindowEvent(display, win, KeyPressMask, &ev))
		CHECK;
	else {
		report("Keyboard grab was not released");
		FAIL;
	}

	CHECKPASS(5);

	restoredevstate();

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Window	win;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XUngrabKeyboard-2.(A)");
	report_assertion("When the specified time is earlier than the");
	report_assertion("last-keyboard-grab time or is later than the current X");
	report_assertion("server time, then a call to XUngrabKeyboard does not release");
	report_assertion("the keyboard and any queued events.");

	report_strategy("Get current time.");
	report_strategy("Grab keyboard and freeze pointer with this time.");
	report_strategy("Call XUngrabKeyboard with earlier time.");
	report_strategy("Verify that pointer is still frozen and therefore keyboard grab is not released.");
	report_strategy("");
	report_strategy("Get current time and add several seconds to get future time.");
	report_strategy("Call XUngrabKeyboard with this time.");
	report_strategy("Verify that pointer is still frozen and therefore keyboard grab is not released.");

	tpstartup();
	setargs();
	win = defwin(display);
	thetime = gettime(display);

	XGrabKeyboard(display, win, False, GrabModeSync, GrabModeSync, thetime);

	thetime -= 1;
	startcall(display);
	if (isdeleted())
		return;
	XUngrabKeyboard(display, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen())
		CHECK;
	else {
		report("Grab released for time earlier than last-keyboard-grab time");
		FAIL;
	}

	thetime = gettime(display);
	thetime += (config.speedfactor+1) * 1000000;

	startcall(display);
	if (isdeleted())
		return;
	XUngrabKeyboard(display, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen())
		CHECK;
	else {
		report("Grab release for time later than current X server time");
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Window	grabwin;
Window	win;
Window	ofocus;
XEvent	ev;
XFocusInEvent	figood;
XFocusOutEvent	fogood;
int 	orevert;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XUngrabKeyboard-3.(A)");
	report_assertion("A call to XUngrabKeyboard generates FocusIn and FocusOut");
	report_assertion("events as though the focus were to change from the grab");
	report_assertion("window to the current focus window.");

	report_strategy("Create grab window.");
	report_strategy("Create a focus window and set focus to that window.");
	report_strategy("Grab keyboard.");
	report_strategy("Enable events on windows.");
	report_strategy("Call XUngrabKeyboard to release keyboard.");
	report_strategy("Verify that FocusIn and FocusOut events are received.");

	tpstartup();
	setargs();
	/*
	 * Save current input focus to pose as little inconvenience as
	 * possible.
	 */
	XGetInputFocus(display, &ofocus, &orevert);

	grabwin = defwin(display);
	win = defwin(display);
	XSetInputFocus(display, win, RevertToNone, CurrentTime);
	if (isdeleted()) {
		report("Could not set up focus");
		return;
	}
	XGrabKeyboard(display, grabwin, False, GrabModeSync, GrabModeSync, thetime);

	XSelectInput(display, grabwin, FocusChangeMask);
	XSelectInput(display, win, FocusChangeMask);

	startcall(display);
	if (isdeleted())
		return;
	XUngrabKeyboard(display, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/*
	 * Set up the expected good events.
	 */
	defsetevent(figood, display, FocusIn);
	figood.window = win;
	figood.mode = NotifyUngrab;
	figood.detail = NotifyNonlinear;

	defsetevent(fogood, display, FocusOut);
	fogood.window = grabwin;
	fogood.mode = NotifyUngrab;
	fogood.detail = NotifyNonlinear;

	if (getevent(display, &ev) == 0 || ev.type != FocusOut) {
		report("Did not get expected FocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;

	if (getevent(display, &ev) == 0 || ev.type != FocusIn) {
		report("Did not get expected FocusIn event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&figood, &ev))
		FAIL;
	else
		CHECK;

	/* Reset old focus */
	XSetInputFocus(display, ofocus, orevert, CurrentTime);

	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
