/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XChangeActivePointerGrab(display, event_mask, cursor, thetime)
 *   Display	*display;
 *   unsigned int 	event_mask;
 *   Cursor	cursor;
 *   Time	thetime;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XChangeActivePointerGrab	1
char    *TestName = "XChangeActivePointerGrab";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_CURSOR cursor


/*
 * Arguments to the XChangeActivePointerGrab function
 */
static Display	*display;
static unsigned int 	event_mask;
static Cursor	cursor;
static Time	thetime;


/* check to see if pointer is grabbed. Use existing win and another client */
/* Depending on owner_events in xname or when setting grab may cause
 * events to appear on grabbing clients event queue. Before checking for
 * events in the queue the grabbing client should have flushed any junk
 * left by this function.
 */
static int pgrabbed(win)
Window win;
{
	PointerPlace *p;
	XEvent ev;
	Display *client2 = opendisplay();

	XSelectInput(client2, win, PointerMotionMask);
	XSync(client2, True);
	p = warppointer(client2, win, 1,1);
	warppointer(client2, win, 10,10);
	warppointer(client2, win, 1,1);
	warppointer(client2, p->oroot, p->ox, p->oy);
	return (!getevent(client2, &ev));
}


/* Value list for use in test t005 */
static unsigned long	event_maskvallist[] = {
	ButtonPressMask,
	ButtonReleaseMask,
	EnterWindowMask,
	LeaveWindowMask,
	PointerMotionMask,
	PointerMotionHintMask,
	Button1MotionMask,
	Button2MotionMask,
	Button3MotionMask,
	Button4MotionMask,
	Button5MotionMask,
	ButtonMotionMask,
	KeymapStateMask,
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	event_mask = PointerMotionMask;
	cursor = None;
	thetime = CurrentTime;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XEvent	ev;
Window	win;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XChangeActivePointerGrab-1.(A)");
	report_assertion("When the pointer is actively grabbed by the client and the");
	report_assertion("specified time is not earlier than the last-pointer-grab");
	report_assertion("time nor later than the current X server time, then a call");
	report_assertion("to XChangeActivePointerGrab changes the specified dynamic");
	report_assertion("parameters.");

	report_strategy("Create grab_window.");
	report_strategy("Grab pointer with XGrabPointer using an event_mask of EnterWindowMask.");
	report_strategy("Check that just enter events are reported.");
	report_strategy("Call XChangeActivePointerGrab to change event_mask to PointerMotionMask.");
	report_strategy("Verify that now only motion events are reported.");

	tpstartup();
	setargs();
	warppointer(display, DRW(display), 0, 0);

	win = defwin(display);

	XGrabPointer(display, win, False, EnterWindowMask, GrabModeAsync,
		GrabModeAsync, None, None, CurrentTime);

	warppointer(display, win, 0, 0);
	warppointer(display, win, 2, 2);

	/*
	 * This is just a check to see that the grab is behaving as expected.
	 * delete and return if these fail.  We do the same checks
	 * after the parameters are changed.
	 */
	if (XCheckMaskEvent(display, EnterWindowMask, &ev))
		CHECK;
	else {
		delete("No enter event received when checking set up");
		return;
	}
	if (!XCheckMaskEvent(display, PointerMotionMask, &ev))
		CHECK;
	else {
		delete("A pointer motion event was received when checking set up");
		return;
	}

	warppointer(display, DRW(display), 0, 0);

	startcall(display);
	if (isdeleted())
		return;
	XChangeActivePointerGrab(display, event_mask, cursor, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSync(display, True);	/* Flush any remaining event */
	warppointer(display, win, 0, 0);
	warppointer(display, win, 2, 2);
	if (isdeleted())
		return;

	if (!XCheckMaskEvent(display, EnterWindowMask, &ev))
		CHECK;
	else {
		report("Event mask was not changed to disallow enter events");
		FAIL;
	}
	if (XCheckMaskEvent(display, PointerMotionMask, &ev))
		CHECK;
	else {
		report("Event mask was not changed - no pointer motion event received");
		FAIL;
	}

	CHECKPASS(4);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XEvent	ev;
Window	win;
Time	t;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XChangeActivePointerGrab-2.(A)");
	report_assertion("When the specified time is earlier than the");
	report_assertion("last-pointer-grab time or later than the current X server");
	report_assertion("time, then a call to XChangeActivePointerGrab does not");
	report_assertion("change the parameters.");

	report_strategy("Create grab_window.");
	report_strategy("Grab pointer with XGrabPointer using an event_mask of EnterWindowMask.");
	report_strategy("Use event_mask of PointerMotionMask.");
	report_strategy("Call XChangeActivePointerGrab with time earlier that last pointer grab time.");
	report_strategy("Verify that enter events are still being reported.");
	report_strategy("");
	report_strategy("Call XChangeActivePointerGrab with time later than current X server time.");
	report_strategy("Verify that enter events are still being reported.");

	tpstartup();
	setargs();
	warppointer(display, DRW(display), 0, 0);

	win = defwin(display);
	t = gettime(Dsp);

	XGrabPointer(display, win, False, EnterWindowMask, GrabModeAsync,
		GrabModeAsync, None, None, t);

	/* Earlier than last-pointer-grab time */
	thetime = t - 12;
	startcall(display);
	if (isdeleted())
		return;
	XChangeActivePointerGrab(display, event_mask, cursor, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSync(display, True);	/* Flush any event */
	warppointer(display, win, 0, 0);
	warppointer(display, win, 2, 2);
	if (isdeleted())
		return;

	if (XCheckMaskEvent(display, EnterWindowMask, &ev))
		CHECK;
	else {
		report("Event mask was changed for time earlier than last-pointer-grab time");
		FAIL;
	}
	if (!XCheckMaskEvent(display, PointerMotionMask, &ev))
		CHECK;
	else {
		report("Event mask was changed for time earlier than last-pointer-grab time");
		FAIL;
	}

	warppointer(display, DRW(display), 0, 0);

	/* Later than X server time */
	t = gettime(Dsp);
	thetime = t + (config.speedfactor+1)*1000000;
	startcall(display);
	if (isdeleted())
		return;
	XChangeActivePointerGrab(display, event_mask, cursor, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSync(display, True);	/* Flush any event */
	warppointer(display, win, 0, 0);
	warppointer(display, win, 2, 2);
	if (isdeleted())
		return;

	if (XCheckMaskEvent(display, EnterWindowMask, &ev))
		CHECK;
	else {
		report("Event mask was changed for time later than X server time");
		FAIL;
	}
	if (!XCheckMaskEvent(display, PointerMotionMask, &ev))
		CHECK;
	else {
		report("Event mask was changed for time later than X server time");
		FAIL;
	}

	CHECKPASS(4);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Window	win;
Window	curwin;
XEvent	ev;
int	n;
Cursor	cur;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XChangeActivePointerGrab-3.(B)");
	report_assertion("A call to XChangeActivePointerGrab has no effect on the");
	report_assertion("passive parameters of the function XGrabButton.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create and map a window.");
	report_strategy("Create and map another window (curwin) and attach a non-default");
	report_strategy("  cursor (cur) to it.");
	report_strategy("Select for no events on the window.");
	report_strategy("Set a passive grab with XGrabButton on that window with owner_events = False,");
	report_strategy("  cursor = None and event_mask = 0.");
	report_strategy("Clear event queue.");
	report_strategy("Warp the pointer into the window and around inside it.");
	report_strategy("Check no events received.");
	report_strategy("Call XChangeActivePointerGrab with event_mask = PointerMotionMask and cursor = cur.");
	report_strategy("Clear event queue.");
	report_strategy("Warp the pointer into the window and around inside it.");
	report_strategy("Check no events received.");
	report_strategy("If extension available:");
	report_strategy("  Activate grab with simulated button press in window.");
	report_strategy("  Check grab activated.");
	report_strategy("  Warp pointer around in window.");
	report_strategy("  Check no events received.");
	report_strategy("  Check cursor is not equal to that of curwin.");
	report_strategy("  Call XChangeActivePointerGrab with event_mask = PointerMotionMask and cursor = cur.");
	report_strategy("  Warp pointer around in window.");
	report_strategy("  Check MotionNotify events received.");
	report_strategy("  Check cursor is now equal to that of curwin.");
	report_strategy("  Release all buttons, hence grab.");
	report_strategy("else");
	report_strategy("  Issue message and report untested.");

	tpstartup();
	setargs();
	win = defwin(display);
	curwin = defwin(display);
	cur = makecur2(display);
	XDefineCursor(display, curwin, cur);
	XSelectInput(display, win, 0L);
	XGrabButton(display, AnyButton, 0, win, False, 0, GrabModeAsync,
		GrabModeAsync, None, None);
	if (isdeleted()) {
		delete("Failed to set passive button grab.");
		return;
	} else
		CHECK;
	XSync(display, True);
	warppointer(display, win, 1,1);
	warppointer(display, win, 10,10);
	warppointer(display, win, 1,1);
	if (n=getevent(display, &ev)) {
		delete("Unexpectedly received %d events, first was type %s.",
				n, eventname(ev.type));
		return;
	} else
		CHECK;
	event_mask = PointerMotionMask;
	cursor = cur;
	startcall(display);
	if (isdeleted())
		return;
	XChangeActivePointerGrab(display, event_mask, cursor, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display, True);
	warppointer(display, win, 1,1);
	warppointer(display, win, 10,10);
	warppointer(display, win, 1,1);
	if (n=getevent(display, &ev)) {
		report("event_mask changed passive grab, received %d events, first was type %s.",
				n, eventname(ev.type));
		FAIL;
	} else
		CHECK;
	if (noext(1)) {
		report("Tested as far as possible without activating grab.");
		CHECKUNTESTED(3);
	} else {
		Window	oldf;
		int	oldr;

		XGetInputFocus(display, &oldf, &oldr);
		XSetInputFocus(display, win, RevertToPointerRoot, CurrentTime);
		buttonpress(display, Button1);
		if (!pgrabbed(win)) {
			report("Failed to activate grab.");
			relalldev();
			XSetInputFocus(display, oldf, oldr, CurrentTime);
			return;
		}
		XSync(display, True);
		warppointer(display, win, 1,1);
		warppointer(display, win, 10,10);
		warppointer(display, win, 1,1);
		if (n=getevent(display, &ev)) {
			report("event_mask changed on grab activation, received %d events, first was type %s.",
					n, eventname(ev.type));
			FAIL;
		} else
			CHECK;
		if (spriteiswin(display, curwin)) {
			report("Cursor changed before grab activated.");
			FAIL;
		} else
			CHECK;
		event_mask = PointerMotionMask;
		cursor = cur;
		startcall(display);
		if (isdeleted())
			return;
		XChangeActivePointerGrab(display, event_mask, cursor, thetime);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		XSync(display, True);
		warppointer(display, win, 1,1);
		warppointer(display, win, 10,10);
		warppointer(display, win, 1,1);
		if (!(n=getevent(display, &ev)) || ev.type != MotionNotify) {
			report("event_mask not changed properly for active grab.");
			if (n)
				report("First event of %d was %s instead of MotionNotify.",
					n, eventname(ev.type));
			FAIL;
		} else
			CHECK;
		if (!spriteiswin(display, curwin)) {
			report("Cursor not changed although grab was active.");
			FAIL;
		} else
			CHECK;
		
		relalldev();
		XSetInputFocus(display, oldf, oldr, CurrentTime);
		CHECKPASS(7);
	}

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/ECur.mc */
/* End of included file error/ECur.mc */

/* Including from file error/ECur.mc */
static void t004(){

unsigned int shape;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XChangeActivePointerGrab-4.(A)");
	report_assertion("When a cursor argument does not name a valid Cursor, then a");
	report_assertion("BadCursor error occurs.");

	report_strategy("Create cursor with shape XT_FONTCURSOR_GOOD in font cursor.");
	report_strategy("Free cursor.");
	report_strategy("Call test function using bad cursor as the cursor argument.");
	report_strategy("Verify that a BadCursor error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	/* UNSUPPORTED is not allowed */
	shape = config.fontcursor_good;
	if (config.fontcursor_good == -1) {
		delete("A value of UNSUPPORTED is not allowed for XT_FONTCURSOR_GOOD");
		return;
	}

	A_CURSOR = XCreateFontCursor(A_DISPLAY, shape);
	XFreeCursor(A_DISPLAY, A_CURSOR);

	startcall(display);
	if (isdeleted())
		return;
	XChangeActivePointerGrab(display, event_mask, cursor, thetime);
	endcall(display);
	if (geterr() != BadCursor) {
		report("Got %s, Expecting BadCursor", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadCursor)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/ECur.mc */

/* Including from file Mval.tmc.9283 */
/* End of included file Mval.tmc.9283 */

/* Including from file error/EVal.mc */
static void t005(){

#undef	VALUE_ARG
#define	VALUE_ARG event_mask
#undef	VALUE_LIST
#define	VALUE_LIST event_maskvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE unsigned
#undef	NOTMEMBER
#define	NOTMEMBER notmaskmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XChangeActivePointerGrab-5.(A)");
	report_assertion("When the value of event_mask is not a bitwise combination");
	report_assertion("of ButtonPressMask, ButtonReleaseMask, EnterWindowMask,");
	report_assertion("LeaveWindowMask, PointerMotionMask, PointerMotionHintMask,");
	report_assertion("Button1MotionMask, Button2MotionMask, Button3MotionMask,");
	report_assertion("Button4MotionMask, Button5MotionMask, ButtonMotionMask or");
	report_assertion("KeymapStateMask, then a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XChangeActivePointerGrab(display, event_mask, cursor, thetime);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
