/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_UnmapNotify	1
char    *TestName = "UnmapNotify";



#define	EVENT		UnmapNotify
#define	MASK		StructureNotifyMask
#define	MASKP		SubstructureNotifyMask

int 	tet_thistest;

static void t001(){

Display	*display = Dsp;
Display	*client2;
Display	*client3;
Window	w;
int	count;
XEvent	event_return;
XUnmapEvent good;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion UnmapNotify-1.(A)");
	report_assertion("When an UnmapNotify event is generated, then all clients");
	report_assertion("having set StructureNotifyMask event mask bits on the");
	report_assertion("unmapped window are delivered an UnmapNotify event.");

	report_strategy("Create clients client2 and client3.");
	report_strategy("Create window.");
	report_strategy("Select for UnmapNotify events using StructureNotifyMask.");
	report_strategy("Select for UnmapNotify events using StructureNotifyMask with client2.");
	report_strategy("Select for no events with client3.");
	report_strategy("Generate UnmapNotify event.");
	report_strategy("Verify that a UnmapNotify event was delivered.");
	report_strategy("Verify that event member fields are correctly set.");
	report_strategy("Verify that a UnmapNotify event was delivered to client2.");
	report_strategy("Verify that event member fields are correctly set.");
	report_strategy("Verify that no events were delivered to client3.");

	tpstartup();
/* Create clients client2 and client3. */
	if ((client2 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client2.");
		return;
	}
	else
		CHECK;
	if ((client3 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client3.");
		return;
	}
	else
		CHECK;
/* Create window. */
	w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, True);
/* Select for UnmapNotify events using StructureNotifyMask. */
	XSelectInput(display, w, MASK);
/* Select for UnmapNotify events using StructureNotifyMask with client2. */
	XSelectInput(client2, w, MASK);
/* Select for no events with client3. */
	XSelectInput(client3, w, NoEventMask);
/* Generate UnmapNotify event. */
	XSync(display, True);
	XSync(client2, True);
	XSync(client3, True);
	XUnmapWindow(display, w);
	XSync(display, False);
	XSync(client2, False);
	XSync(client3, False);
/* Verify that a UnmapNotify event was delivered. */
/* Verify that event member fields are correctly set. */
	if (!XCheckTypedWindowEvent(display, w, EVENT, &event_return)) {
		report("Expected %s event, got none", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;
	good = event_return.xunmap;
	good.type = EVENT;
	good.event = w;
	good.window = w;
	good.from_configure = False;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event");
		FAIL;
	}
	else
		CHECK;
/* Verify that a UnmapNotify event was delivered to client2. */
/* Verify that event member fields are correctly set. */
	if (!XCheckTypedWindowEvent(client2, w, EVENT, &event_return)) {
		report("Expected %s event, got none", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;
	good = event_return.xunmap;
	good.type = EVENT;
	good.event = w;
	good.window = w;
	good.from_configure = False;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event for client2");
		FAIL;
	}
	else
		CHECK;
/* Verify that no events were delivered to client3. */
	count = XPending(client3);
	if (count != 0) {
		report("Got %d events, expected %d for client3", count, 0);
		FAIL;
		return;
	}
	else
		CHECK;
	
	CHECKPASS(7);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Display	*display = Dsp;
Display	*client2;
Display	*client3;
Window	parent, w;
int	count;
XEvent	event_return;
XUnmapEvent good;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion UnmapNotify-2.(A)");
	report_assertion("When an UnmapNotify event is generated, then all clients");
	report_assertion("having set SubstructureNotifyMask event mask bits on the");
	report_assertion("parent of the unmapped window are delivered an UnmapNotify");
	report_assertion("event.");

	report_strategy("Create clients client2 and client3.");
	report_strategy("Create window.");
	report_strategy("Select for UnmapNotify events using SubstructureNotifyMask.");
	report_strategy("Select for UnmapNotify events using SubstructureNotifyMask with client2.");
	report_strategy("Select for no events with client3.");
	report_strategy("Generate UnmapNotify event.");
	report_strategy("Verify that a UnmapNotify event was delivered.");
	report_strategy("Verify that event member fields are correctly set.");
	report_strategy("Verify that a UnmapNotify event was delivered to client2.");
	report_strategy("Verify that event member fields are correctly set.");
	report_strategy("Verify that no events were delivered to client3.");

	tpstartup();
/* Create clients client2 and client3. */
	if ((client2 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client2.");
		return;
	}
	else
		CHECK;
	if ((client3 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client3.");
		return;
	}
	else
		CHECK;
	parent = DRW(display);
/* Create window. */
	w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, True);
/* Select for UnmapNotify events using SubstructureNotifyMask. */
	XSelectInput(display, parent, MASKP);
/* Select for UnmapNotify events using SubstructureNotifyMask with client2. */
	XSelectInput(client2, parent, MASKP);
/* Select for no events with client3. */
	XSelectInput(client3, parent, NoEventMask);
/* Generate UnmapNotify event. */
	XSync(display, True);
	XSync(client2, True);
	XSync(client3, True);
	XUnmapWindow(display, w);
	XSync(display, False);
	XSync(client2, False);
	XSync(client3, False);
/* Verify that a UnmapNotify event was delivered. */
/* Verify that event member fields are correctly set. */
	if (!XCheckTypedWindowEvent(display, parent, EVENT, &event_return)) {
		report("Expected %s event, got none", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;
	good = event_return.xunmap;
	good.type = EVENT;
	good.event = parent;
	good.window = w;
	good.from_configure = False;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event");
		FAIL;
	}
	else
		CHECK;
/* Verify that a UnmapNotify event was delivered to client2. */
/* Verify that event member fields are correctly set. */
	if (!XCheckTypedWindowEvent(client2, parent, EVENT, &event_return)) {
		report("Expected %s event, got none", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;
	good = event_return.xunmap;
	good.type = EVENT;
	good.event = parent;
	good.window = w;
	good.from_configure = False;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event for client2");
		FAIL;
	}
	else
		CHECK;
/* Verify that no events were delivered to client3. */
	count = XPending(client3);
	if (count != 0) {
		report("Got %d events, expected %d for client3", count, 0);
		FAIL;
		return;
	}
	else
		CHECK;
	
	CHECKPASS(7);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){


 	report_purpose(3);

	report_assertion("Assertion UnmapNotify-3.(-)");
	report_assertion("When an UnmapNotify event is generated, then clients not");
	report_assertion("having set StructureNotifyMask event mask bits on the");
	report_assertion("unmapped window and also not having set");
	report_assertion("SubstructureNotifyMask event mask bits on the parent of the");
	report_assertion("unmapped window are not delivered an UnmapNotify event.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
