/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_KeyRelease	1
char    *TestName = "KeyRelease";



#define EVENT KeyRelease
#define EVENTMASK KeyReleaseMask

static void
presskey(Dpy, w, kc)
Display		*Dpy;
Window		w;
int		kc;
{
	/*
	 * Note that we do not call XSetInputFocus() since 2 tests require
	 * the event window to be an ancestor of the source window.
	 */
	keypress(Dpy, kc);
	XSync(Dsp, True);
	keyrel(Dsp, kc);
}

static	int	keyc = 0;

static unsigned int
keycode()
{
int	tmp;

	if(keyc == 0) {
		XDisplayKeycodes(Dsp, &keyc, &tmp);
        	if (keyc < 8)
	                keyc = 8;
	}
	return(keyc);
}    

static unsigned int
keystate(keyc)
int keyc;
{
XModifierKeymap *map;
unsigned int state;
int i, j;

	map = XGetModifierMapping(Dsp);
	if (!map)
		return(0);
	state = 0;
	for (i = 0; i < 8; i++) {
		for (j = 0; j < map->max_keypermod; j++) {
			if (map->modifiermap[(i * map->max_keypermod) + j] ==
			    keyc)
				state |= (ShiftMask << i);
		}
	}
	XFreeModifiermap(map);
	return(state);
}

int 	tet_thistest;

static void t001(){

Display		*display = Dsp;
Window		w;
XEvent		event_return;
XKeyEvent	good;
PointerPlace	*ptr;
int		kc;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion KeyRelease-1.(B)");
	report_assertion("When any key is released, then a KeyRelease event is");
	report_assertion("generated.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is enabled:");
	report_strategy("  Create a window.");
	report_strategy("  Select for KeyRelease events.");
	report_strategy("  Simulate a KeyRelease event on the window.");
	report_strategy("  Verify that a KeyRelease event was delivered.");
	report_strategy("  Verify that event member fields are correctly set.");

	tpstartup();
	

	/* If extended testing is enabled: */
	if(noext(0))
		return;

		/* Create a window. */
	w = defwin(display);

		/* Select for xname events. */
	XSelectInput(display, w, EVENTMASK);

		/* Simulate a xname event on the window. */
	ptr = warppointer(display, w, 0,0);
	kc = keycode();
	presskey(display, w, kc);

		/* Verify that a xname event was delivered. */
	if (!XCheckTypedWindowEvent(display, w, EVENT, &event_return)) {
		report("Expected %s event, got none", eventname(EVENT));
		FAIL;
	} else {

		CHECK;

		good = event_return.xkey;
		good.type = EVENT;
		good.send_event = False;
		good.display = display;
		good.window = w;
		good.root = DRW(display);
		good.subwindow = None;
		good.x = 0;
		good.y = 0;
		good.x_root = ptr->nx;
		good.y_root = ptr->ny;
		good.state = keystate(kc);
		good.keycode = kc;
		good.same_screen = True;

		/* Verify that event member fields are correctly set. */
		if (checkevent((XEvent *) &good, &event_return)) {
			report("Unexpected values in delivered event");
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Display			*display = Dsp;
Display			*client2;
Display			*client3;
Window			w;
XEvent			event_return;
XKeyReleasedEvent	good;
PointerPlace		*ptr;
int	 		kc;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion KeyRelease-2.(B)");
	report_assertion("When a KeyRelease event is generated, then all clients");
	report_assertion("having set KeyReleaseMask event mask bits on the event");
	report_assertion("window are delivered a KeyRelease event.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Create a second client.");
	report_strategy("  Create a third client.");
	report_strategy("  Create a window.");
	report_strategy("  Select for KeyRelease events on all clients.");
	report_strategy("  Simulate a KeyRelease event on the window.");
	report_strategy("  Verify that the event was delivered to all clients.");
	report_strategy("  Verify that event member fields are correctly set.");
	report_strategy("Otherwise :");
	report_strategy("  Create a window.");
	report_strategy("  Select for KeyRelease events.");
	report_strategy("  Verify no error was generated.");

	tpstartup();
		/* If extended testing is required: */
	if(config.extensions) {
	
		if(noext(0))
			return;

			/* Create a second client. */
		client2 = opendisplay();
			/* Create a third client. */
		client3 = opendisplay();

			/* Create a window. */
		w = defwin(display);

			/* Select for xname events on all clients. */
		XSelectInput(display, w, EVENTMASK);
		XSelectInput(client2, w, EVENTMASK);
		XSelectInput(client3, w, EVENTMASK);
	
			/* Simulate a xname event on the window. */
		ptr = warppointer(display, w, 0,0);
		kc = keycode();

		XSync(client2, True);
		XSync(client3, True);

		presskey(display, w, kc);

		XSync(client2, False);
		XSync(client3, False);
	
		good = event_return.xkey;
		good.type = EVENT;
		good.send_event = False;
		good.display = display;
		good.window = w;
		good.root = DRW(display);
		good.subwindow = None;
		good.x = 0;
		good.y = 0;
		good.x_root = ptr->nx;
		good.y_root = ptr->ny;
		good.state = keystate(kc);
		good.keycode = kc;
		good.same_screen = True;
	
			/* Verify that the event was delivered to all clients. */
			/* Verify that event member fields are correctly set. */
		if (!XCheckTypedWindowEvent(display, w, EVENT, &event_return)) {
			report("Expected %s event, got none", eventname(EVENT));
			FAIL;
		} else {
			CHECK;
			if (checkevent((XEvent *) &good, &event_return)) {
				report("Unexpected values in delivered event");
				FAIL;
			} else
				CHECK;
		}	
/* client 2 */
		if (!XCheckTypedWindowEvent(client2, w, EVENT, &event_return)) {
			report("Expected %s event, got none", eventname(EVENT));
			FAIL;
		} else {
			CHECK;

			good.display = client2;
		
			if (checkevent((XEvent *) &good, &event_return)) {
				report("Unexpected values in delivered event");
				FAIL;
			} else
				CHECK;
		}
/* client 3 */

		if (!XCheckTypedWindowEvent(client3, w, EVENT, &event_return)) {
			report("Expected %s event, got none", eventname(EVENT));
			FAIL;
		} else {
			CHECK;

			good.display = client3;

			if (checkevent((XEvent *) &good, &event_return)) {
				report("Unexpected values in delivered event");
				FAIL;
			} else
				CHECK;
		}

		CHECKPASS(6);

	} else {

		/* Otherwise : */
			/* Create a window. */
		w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);
			/* Select for xname events. */
		XSelectInput(display, w, EVENTMASK);
		XSync(display, True);
			/* Verify no error was generated. */
		if (geterr() != Success) {
			delete("Error setting up for test.");
			return;
		}
		else
			CHECK;
	
		CHECKUNTESTED(1);
	}

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Display			*client2;
XEvent			ev;
Window			w;
int			count;
int			kc;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion KeyRelease-3.(B)");
	report_assertion("When a KeyRelease event is generated, then clients not");
	report_assertion("having set KeyReleaseMask event mask bits on the event");
	report_assertion("window are not delivered a KeyRelease event.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Create a window.");
	report_strategy("  Create a second client.");
	report_strategy("  Select for various events other that KeyRelease for the first client on the window.");
	report_strategy("  Select for KeyRelease events for the second client on the window.");
	report_strategy("  Simulate a KeyRelease event on the window.");
	report_strategy("  Verify that a KeyRelease event was generated for the second client.");
	report_strategy("  Verify no events were generated for the first client.");

	tpstartup();
	/* If extended testing is required: */
	if(noext(0))
		return;

		/* Create a window. */
	w = defwin(Dsp);

		/* Create a second client. */
	client2 = opendisplay();

		/* Select for various events other that xname for the first client on the window. */
	kc = keycode();
 	XSelectInput(Dsp, w, KeyPressMask|ButtonPressMask|ButtonReleaseMask);

		/* Select for xname events for the second client on the window. */
	XSelectInput(client2, w, EVENTMASK);

		/* Simulate a xname event on the window. */
	warppointer(Dsp, w, 0, 0);
	XSync(Dsp, True);
	XSync(client2, True);

	presskey(Dsp, w, kc);

	XSync(client2, False);

		/* Verify that a xname event was generated for the second client. */
	if(XCheckWindowEvent(client2, w, EVENTMASK, &ev) == False) {
		report("No %s event was generated.", eventname(EVENT));
		FAIL;
	} else
		CHECK;

		/* Verify no events were generated for the first client. */
	count = XPending(Dsp);
	if (count != 0) {
		report("Got %d unexpected events.", count);
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

XEvent			ev;
Window			w;
Window			w1;
Window			w2;
XSetWindowAttributes	atts;
int			kc;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion KeyRelease-4.(B)");
	report_assertion("When a KeyRelease event is generated and no client has");
	report_assertion("selected KeyReleaseMask on the source window, then the event");
	report_assertion("propagates, with propagation stopping at the root window of");
	report_assertion("the screen or at the first window with KeyReleaseMask in its");
	report_assertion("do-not-propagate mask, from the source window to the first");
	report_assertion("ancestor window for which some client has selected for");
	report_assertion("KeyRelease events.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Create a window.");
	report_strategy("  Create a child of that window.");
	report_strategy("  Create a grandchild of the window.");
	report_strategy("  Select KeyRelease events on the root window of the screen.");
	report_strategy("  Simulate a KeyRelease event on the grandchild.");
	report_strategy("  Verify that a KeyRelease event was generated on the root.");
	report_strategy("  Select KeyRelease events on the grandparent window.");
	report_strategy("  Set the do_not_propagate mask on the child to KeyRelease events.");
	report_strategy("  Simulate a KeyRelease event on the grandchild.");
	report_strategy("  Verify no KeyRelease event was generated on the grandchild.");
	report_strategy("  Verify no KeyRelease event was generated on the child.");
	report_strategy("  Verify no KeyRelease event was generated on the parent.");
	report_strategy("  Select KeyRelease events on the child window.");
	report_strategy("  Set the do_not_propagate mask of the grandparent to KeyRelease events.");
	report_strategy("  Set the do_not_propagate mask of the child to NoEventMask.");
	report_strategy("  Simulate a KeyRelease event on the grandchild.");
	report_strategy("  Verify that no KeyRelease event was generated on the grandchild.");
	report_strategy("  Verify that no KeyRelease event was generated on the parent.");
	report_strategy("  Verify that a KeyRelease event was generated on the child.");

	tpstartup();

	/* If extended testing is required: */
	if(noext(0))
		return;

		/* Create a window. */
	w = defwin(Dsp);
		/* Create a child of that window. */
	w1 = crechild(Dsp, w, (struct area *) NULL);
		/* Create a grandchild of the window. */
	w2 = crechild(Dsp, w1, (struct area *) NULL);

		/* Select xname events on the root window of the screen. */
	XSelectInput(Dsp, DRW(Dsp), EVENTMASK);	

		/* Simulate a xname event on the grandchild. */
	warppointer(Dsp, w2, 1,1);
	kc = keycode();
	presskey(Dsp, w2, kc);
	
		/* Verify that a xname event was generated on the root. */
	if (XCheckWindowEvent(Dsp, DRW(Dsp), EVENTMASK, &ev) == False) {
		report("Expected event (%s) not received.", eventname(EVENT));
		FAIL;
	} else
		CHECK;

	XSelectInput(Dsp, DRW(Dsp), NoEventMask);	
		/* Select xname events on the grandparent window. */
	XSelectInput(Dsp, w, EVENTMASK);	

		/* Set the do_not_propagate mask on the child to xname events. */
	atts.do_not_propagate_mask = EVENTMASK;
	XChangeWindowAttributes(Dsp, w1, CWDontPropagate, &atts);
	
		/* Simulate a xname event on the grandchild. */
	presskey(Dsp, w2, kc);	

		/* Verify no xname event was generated on the grandchild. */
	if (XCheckWindowEvent(Dsp, w2, EVENTMASK, &ev) != False) {
		report("Unexpected event (%s) received.", eventname(EVENT));
		FAIL;
	} else
		CHECK;

		/* Verify no xname event was generated on the child. */
	if (XCheckWindowEvent(Dsp, w1, EVENTMASK, &ev) != False) {
		report("Unexpected event (%s) received.", eventname(EVENT));
		FAIL;
	} else
		CHECK;

		/* Verify no xname event was generated on the parent. */
	if (XCheckWindowEvent(Dsp, w, EVENTMASK, &ev) != False) {
		report("Unexpected event (%s) received.", eventname(EVENT));
		FAIL;
	} else
		CHECK;


		/* Select xname events on the child window. */
	XSelectInput(Dsp, w1, EVENTMASK);	
		/* Set the do_not_propagate mask of the grandparent to xname events. */
	XChangeWindowAttributes(Dsp, w, CWDontPropagate, &atts);

		/* Set the do_not_propagate mask of the child to NoEventMask. */
	atts.do_not_propagate_mask = NoEventMask;
	XChangeWindowAttributes(Dsp, w1, CWDontPropagate, &atts);

		/* Simulate a xname event on the grandchild. */
	presskey(Dsp, w2, kc);

		/* Verify that no xname event was generated on the grandchild. */
	if (XCheckWindowEvent(Dsp, w2, EVENTMASK, &ev) != False) {
		report("Unexpected event (%s) received.", eventname(EVENT));
		FAIL;
	} else
		CHECK;

		/* Verify that no xname event was generated on the parent. */
	if (XCheckWindowEvent(Dsp, w, EVENTMASK, &ev) != False) {
		report("Unexpected event (%s) received.", eventname(EVENT));
		FAIL;
	} else
		CHECK;

		/* Verify that a xname event was generated on the child. */
	if (XCheckWindowEvent(Dsp, w1, EVENTMASK, &ev) == False) {
		report("KeyRelease event was not delivered to selecting child window.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(7);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

XEvent		ev;
Window		w;
Window		w1;
int		kc;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion KeyRelease-5.(B)");
	report_assertion("When a KeyRelease event is delivered and the source window");
	report_assertion("is an inferior of the event window and the source window is");
	report_assertion("a child of the event window, then subwindow is set to the");
	report_assertion("source window.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Create a window.");
	report_strategy("  Create a child of the window");
	report_strategy("  Select KeyRelease events on the parent.");
	report_strategy("  Simulate an KeyRelease event on the child.");
	report_strategy("  Verify that a KeyRelease event was generated on the parent.");
	report_strategy("  Verify that the subwindow component was set to the child.");

	tpstartup();

	/* If extended testing is required: */
	if(noext(0))
		return;

		/* Create a window. */
	w = defwin(Dsp);
		/* Create a child of the window */
	w1 = crechild(Dsp, w, (struct area *) NULL);
		/* Select xname events on the parent. */
	XSelectInput(Dsp, w, EVENTMASK);	
	warppointer(Dsp, w1, 1,1);
	
		/* Simulate a xname event on the child. */
	kc=keycode();
	presskey(Dsp, w1, kc);

		/* Verify that a xname event was generated on the parent. */
	if (XCheckWindowEvent(Dsp, w, EVENTMASK, &ev) == False) {
		report("Expected event (%s) not received.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;
		/* Verify that the subwindow component was set to the child. */
		if(ev.xkey.subwindow != w1) {
			report("The subwindow component of the %s name was not set correctly.", eventname(EVENT));
			FAIL;
		} else 
			CHECK;
	}
	
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Window		w;
Window		w1;
Window		w2;
Window		w3;
XEvent		ev;
struct area	area;
int		kc;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion KeyRelease-6.(B)");
	report_assertion("When a KeyRelease event is delivered and the source window");
	report_assertion("is an inferior of the event window and the source window is");
	report_assertion("not a child of the event window, then subwindow is set to");
	report_assertion("the child of the event window that is an ancestor of the");
	report_assertion("source window.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required :");
	report_strategy("  Create a window.  ");
	report_strategy("  Create a child.");
	report_strategy("  Create a grandchild.");
	report_strategy("  Create a great-grandchild.");
	report_strategy("  Select KeyRelease events on the great-grandparent.");
	report_strategy("  Simulate a KeyRelease event on the great-grandchild.");
	report_strategy("  Verify that a KeyRelease event was generated on the great-grandparent.");
	report_strategy("  Verify that subwindow component of the event was the child.");

	tpstartup();
	/* If extended testing is required : */
	if (noext(0))
		return;
		
		/* Create a window. */	
	w = defwin(Dsp);
	setarea(&area, 10, 10, 30, 30);
		/* Create a child. */
	w1 = crechild(Dsp, w, &area);
		/* Create a grandchild. */
	w2 = crechild(Dsp, w1, &area);
		/* Create a great-grandchild. */
	w3 = crechild(Dsp, w2, &area);
	warppointer(Dsp, w3, 1,1);

		/* Select xname events on the great-grandparent. */
	XSelectInput(Dsp, w, EVENTMASK);

		/* Simulate a xname event on the great-grandchild. */
	kc = keycode();
	presskey(Dsp, w3, kc);
	
		/* Verify that a xname event was generated on the great-grandparent. */
	if (XCheckWindowEvent(Dsp, w, EVENTMASK, &ev) == False) {
		report("Expected event (%s) not received.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;
		/* Verify that subwindow component of the event was the child. */
		if(ev.xkey.subwindow != w1) {
			report("The subwindow component of the %s event was not set correctly.", eventname(EVENT));
			FAIL;
		} else 
			CHECK;
	}

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

Window		w;
Window		w2;
XEvent		ev;
int		gr;
int		kc;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion KeyRelease-7.(B)");
	report_assertion("When a KeyRelease event is delivered and the source window");
	report_assertion("is not an inferior of the event window, then subwindow is");
	report_assertion("set to None.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Create a window.");
	report_strategy("  Select KeyRelease events on the window.");
	report_strategy("  Simulate a KeyRelease event on the window.");
	report_strategy("  Verify that a KeyRelease event was generated on the window.");
	report_strategy("  Verify that the subwindow component was set to None.");
	report_strategy("  Create a second window.");
	report_strategy("  Grab the keyboard for the first window with owner_events set to False.");
	report_strategy("  Simulate a KeyRelease event on the second window.");
	report_strategy("  Verify that a KeyRelease event was generated on the grabbing window.");
	report_strategy("  Verify that the subwindow component was set to None.");

	tpstartup();
	/* If extended testing is required: */
	if (noext(0))
		return;

		/* Create a window. */
        w = defwin(Dsp);
	warppointer(Dsp, w, 1,1);

		/* Select xname events on the window. */
	XSelectInput(Dsp, w, EVENTMASK);

		/* Simulate a xname event on the window. */
	kc=keycode();
	presskey(Dsp, w, kc);
	
		/* Verify that a xname event was generated on the window. */
	if (XCheckWindowEvent(Dsp, w, EVENTMASK, &ev) == False) {
		report("Expected event (%s) not received.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;
		/* Verify that the subwindow component was set to None. */
		if(ev.xkey.subwindow != None) {
			report("The subwindow component of the %s event was not set correctly.", eventname(EVENT));
			FAIL;
		} else 
			CHECK;
	}

		/* Create a second window. */
	w2 = defwin(Dsp);

		/* Grab the keyboard for the first window with owner_events set to False. */
	if( (gr=XGrabKeyboard(Dsp, w, False, GrabModeAsync, GrabModeAsync, CurrentTime)) != GrabSuccess) {
		delete("XGrabKeyboard() returned %s instead of GrabSuccess.", grabreplyname(gr));
		return;
	} else
		CHECK;

		/* Simulate a xname event on the second window. */
	warppointer(Dsp, w2, 1,1);
	presskey(Dsp, w2, kc);
	
		/* Verify that a xname event was generated on the grabbing window. */
	if (XCheckWindowEvent(Dsp, w, EVENTMASK, &ev) == False) {
		report("Expected event (%s) not received.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;
		/* Verify that the subwindow component was set to None. */
		if(ev.xkey.subwindow != None) {
			report("The subwindow component of the %s event was not set correctly.", eventname(EVENT));
			FAIL;
		} else 
			CHECK;
	}

	XUngrabKeyboard(Dsp, CurrentTime);

	CHECKPASS(5);

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

Window		w;
Window		w2;
XEvent		ev;
int		gr;
int		kc;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion KeyRelease-8.(D)");
	report_assertion("If multiple screens are supported: When a KeyRelease event");
	report_assertion("is delivered and the event and root windows are not on the");
	report_assertion("same screen, then x and y are set to zero.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If multiple screens are supported:");
	report_strategy("  If extended testing is required:");
	report_strategy("    Create a window on the default screen.");
	report_strategy("    Select KeyRelease events on the window.");
	report_strategy("    Create a window on the alternative screen.");
	report_strategy("    Grab the keyboard for the first window.");
	report_strategy("    Simulate a KeyRelease event on the alternate window.");
	report_strategy("    Verify that a KeyRelease event was generated on the grabbing window.");
	report_strategy("    Verify that the x and y components were set to zero.");

	tpstartup();

	/* If multiple screens are supported: */
	if (config.alt_screen == -1) {
		unsupported("Multiple screens not supported.");
		return;
	} else
		CHECK;

		/* If extended testing is required: */
	if(noext(0))
		return;
		
			/* Create a window on the default screen. */
        w = defwin(Dsp);
	
			/* Select xname events on the window. */
	warppointer(Dsp, w, 1,1);
	XSelectInput(Dsp, w, EVENTMASK);
	
			/* Create a window on the alternative screen. */
	w2 = defdraw(Dsp, VI_ALT_WIN);
	
			/* Grab the keyboard for the first window. */
	if( (gr=XGrabKeyboard(Dsp, w, False, GrabModeAsync, GrabModeAsync, CurrentTime)) != GrabSuccess) {
		delete("XGrabKeyboard() returned %s instead of GrabSuccess.", grabreplyname(gr));
		return;
	} else
		CHECK;
	
	kc=keycode();
			/* Simulate a xname event on the alternate window. */
	warppointer(Dsp, w2, 1,1);
	presskey(Dsp, w2, kc);
	
			/* Verify that a xname event was generated on the grabbing window. */
	if (XCheckWindowEvent(Dsp, w, EVENTMASK, &ev) == False) {
		report("Expected event (%s) not received.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;
			/* Verify that the x and y components were set to zero. */
		if(ev.xkey.x != 0 || ev.xkey.y != 0) {
			report("The x (value %d) and y (value %d) components of the %s event were not set to zero.", ev.xkey.x, ev.xkey.y, eventname(EVENT));
			FAIL;
		} else 
			CHECK;
	}
	
	XUngrabKeyboard(Dsp, CurrentTime);
	
	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

Window		w;
Window		w2;
XEvent		ev;
int		gr;
int		kc;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion KeyRelease-9.(D)");
	report_assertion("If multiple screens are supported: When a KeyRelease event");
	report_assertion("is delivered and the event and root windows are not on the");
	report_assertion("same screen, then same_screen is set to False.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If multiple screens are supported:");
	report_strategy("  If extended testing is required:");
	report_strategy("    Create a window on the default screen.");
	report_strategy("    Select KeyRelease events on the window.");
	report_strategy("    Create a window on the alternative screen.");
	report_strategy("    Grab the keyboard for the first window.");
	report_strategy("    Simulate a KeyRelease event on the alternate window.");
	report_strategy("    Verify that a KeyRelease event was generated on the grabbing window.");
	report_strategy("    Verify that the same_screen component was False.");

	tpstartup();
	/* If multiple screens are supported: */
	if (config.alt_screen == -1) {
		unsupported("Multiple screens not supported.");
		return;
	} else
		CHECK;

		/* If extended testing is required: */
	if(noext(0))
		return;

			/* Create a window on the default screen. */
        w = defwin(Dsp);
	
	warppointer(Dsp, w, 1,1);
			/* Select xname events on the window. */
	XSelectInput(Dsp, w, EVENTMASK);
	
			/* Create a window on the alternative screen. */
	w2 = defdraw(Dsp, VI_ALT_WIN);
	
			/* Grab the keyboard for the first window. */
	if( (gr=XGrabKeyboard(Dsp, w, False, GrabModeAsync, GrabModeAsync, CurrentTime)) != GrabSuccess) {
		delete("XGrabKeyboard() returned %s instead of GrabSuccess.", grabreplyname(gr));
		return;
	} else
		CHECK;
	
	kc=keycode();
			/* Simulate a xname event on the alternate window. */
	warppointer(Dsp, w2, 1,1);
	presskey(Dsp, w2, kc);
	
			/* Verify that a xname event was generated on the grabbing window. */
	if (XCheckWindowEvent(Dsp, w, EVENTMASK, &ev) == False) {
		report("Expected event (%s) not received.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;
			/* Verify that the same_screen component was False. */
		if(ev.xkey.same_screen != False) {
			report("The same_screen component of the %s event was not set to False.", eventname(EVENT));
			FAIL;
		} else 
			CHECK;
	}
	
	XUngrabKeyboard(Dsp, CurrentTime);
	
	CHECKPASS(4);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = focusstartup;
void	(*tet_cleanup)() = focuscleanup;
