/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_ConfigureRequest	1
char    *TestName = "ConfigureRequest";



#define	EVENT		ConfigureRequest
#define	MASK		SubstructureRedirectMask

int 	tet_thistest;

static void t001(){

Display	*display = Dsp;
Display	*client2, *client3;
Winh	*parent, *child, *lastw, *winh;
Winhg	winhg;
XEvent	event;
int	i;
int	status;
int	numchildren = 4;
int	count;
XSetWindowAttributes attrs;
unsigned long valuemask;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion ConfigureRequest-1.(A)");
	report_assertion("When a ConfigureRequest event is generated, then all");
	report_assertion("clients having set SubstructureRedirectMask event mask bits");
	report_assertion("on the parent of the window for which the configure request");
	report_assertion("was issued are delivered a ConfigureRequest event.");

	report_strategy("Create clients client2 and client3.");
	report_strategy("Build and create window hierarchy.");
	report_strategy("Create inferiors with override-redirect set to True.");
	report_strategy("Select for ConfigureRequest events using SubstructureRedirectMask.");
	report_strategy("Select for no events with client3.");
	report_strategy("Raise lowest window to top.");
	report_strategy("Verify that no events were delivered.");
	report_strategy("Verify that no events were delivered to client3.");
	report_strategy("Lower window back to original placement.");
	report_strategy("Set the override-redirect flag on inferiors to False.");
	report_strategy("Attempt to raise lowest window to top.");
	report_strategy("Initialize for expected events.");
	report_strategy("Verify that a ConfigureRequest event is delivered.");
	report_strategy("Verify that no events are delivered to client3.");
	report_strategy("Verify members of event structure.");
	report_strategy("Verify that no events were delivered to client3.");

	tpstartup();
/* Create clients client2 and client3. */
	if ((client2 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client2.");
		return;
	}
	else
		CHECK;
	if ((client3 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client3.");
		return;
	}
	else
		CHECK;
/* Build and create window hierarchy. */
	/* can't use winh() because the windows need to overlap */
	winhg.border_width = 1;
	winhg.area.x = 1;
	winhg.area.y = 1;
	winhg.area.width = 100;
	winhg.area.height = 100;
	parent = winh_adopt(display, (Winh *) NULL, 0L, (XSetWindowAttributes *) NULL, &winhg, WINH_NOMASK);
	if (parent == (Winh *) NULL) {
		report("Could not create parent");
		return;
	}
	else
		CHECK;
	winhg.area.x = 1;
	winhg.area.y = 1;
	winhg.area.width = 30;
	winhg.area.height = 30;
/* Create inferiors with override-redirect set to True. */
	attrs.override_redirect = True;
	attrs.border_pixel = W_FG;
	attrs.background_pixel = W_BG;
	valuemask = CWOverrideRedirect | CWBorderPixel | CWBackPixel;
	for (i=0; i<numchildren; i++) {
		if (!i)
			CHECK;
		lastw = winh_adopt(display, parent, valuemask, &attrs, &winhg, WINH_NOMASK);
		if (lastw == (Winh *) NULL) {
			report("Could not create child %d", i);
			return;
		}
		winhg.area.x += 10;
		winhg.area.y += 10;
	}
	child = parent->firstchild;
	if (winh_create(display, (Winh *) NULL, WINH_MAP))
		return;
	else
		CHECK;
/* Select for ConfigureRequest events using SubstructureRedirectMask. */
	/*
	 * Selection with a single client because only one can select
	 * for this event at a time.
	 */
	if (winh_selectinput(display, parent, MASK)) {
		report("Selection failed.");
		return;
	}
	else
		CHECK;
/* Select for no events with client3. */
	if (winh_selectinput(client3, (Winh *) NULL, NoEventMask)) {
		report("Selection with client3 failed.");
		return;
	}
	else
		CHECK;
/* Raise lowest window to top. */
	XSync(display, True);
	XSync(client2, True);
	XSync(client3, True);
	XRaiseWindow(client2, child->window);
	XSync(client2, False);
	XSync(display, False);
	XSync(client3, False);
/* Verify that no events were delivered. */
	count = XPending(display);
	if (count != 0) {
		report("Got %d events, expected %d (with override-redirect set)", count, 0);
		FAIL;
	}
	else
		CHECK;
/* Verify that no events were delivered to client3. */
	count = XPending(client3);
	if (count != 0) {
		report("Got %d events, expected %d for client3 (with override-redirect set)", count, 0);
		FAIL;
	}
	else
		CHECK;
/* Lower window back to original placement. */
	/*
	 * this assumes that it was raised in the first place
	 * which is not the case where the override-redirect flag is ignored
	 */
	XLowerWindow(client2, child->window);
	XSync(client2, True);
/* Set the override-redirect flag on inferiors to False. */
	attrs.override_redirect = False;
	valuemask = CWOverrideRedirect;
	for (winh = parent->firstchild, i=0; i<numchildren; winh = winh->nextsibling, i++) {
		if (!i)
			CHECK;
		if (winh_changewindowattributes(display, winh, valuemask, &attrs)) {
			report("Failed to change attributes for subwindow %d", i);
			return;
		}
	}
/* Attempt to raise lowest window to top. */
	XSync(display, True);
	XSync(client2, True);
	XSync(client3, True);
	XRaiseWindow(client2, child->window);
	XSync(client2, False);
	XSync(display, False);
	XSync(client3, False);
/* Initialize for expected events. */
	event.xany.type = EVENT;
	event.xany.window = parent->window;
	if (winh_plant(parent, &event, MASK, WINH_NOMASK)) {
		report("Could not plant events for parent");
		return;
	}
	else
		CHECK;
/* Verify that a ConfigureRequest event is delivered. */
/* Verify that no events are delivered to client3. */
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
	if (winh_harvest(client3, (Winh *) NULL)) {
		report("Could not harvest events for client3");
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status == -1)
		return;
	else if (status) {
		report("Event delivery not as expected");
		FAIL;
	}
	else {
		XEvent	*event_return;
		XConfigureRequestEvent	good;

/* Verify members of event structure. */
		event_return = winh_qdel->event;
		good = event_return->xconfigurerequest;
		good.type = EVENT;
		good.send_event = False;
		good.display = display;
		good.parent = parent->window;
		good.window = child->window;
		good.x = child->winhg.area.x;
		good.y = child->winhg.area.y;
		good.width = child->winhg.area.width;
		good.height = child->winhg.area.height;
		good.border_width = child->winhg.border_width;
		good.above = Above;
		good.detail = Above;
		good.value_mask = CWStackMode;
		if (checkevent((XEvent *) &good, event_return)) {
			report("Unexpected values in delivered event");
			FAIL;
		}
		else
			CHECK;
	}
/* Verify that no events were delivered to client3. */
	count = XPending(client3);
	if (count != 0) {
		report("Got %d events, expected %d for client3", count, 0);
		FAIL;
		return;
	}
	else
		CHECK;

	CHECKPASS(15);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){


 	report_purpose(2);

	report_assertion("Assertion ConfigureRequest-2.(-)");
	report_assertion("When a ConfigureRequest event is generated, then clients");
	report_assertion("not having set SubstructureRedirectMask event mask bits on");
	report_assertion("the parent of the window for which the configure request was");
	report_assertion("issued are not delivered a ConfigureRequest event.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t003(){

Display	*display = Dsp;
Display	*client2, *client3;
Winh	*parent, *child, *sibling;
Winhg	winhg;
XEvent	event;
int	i;
int	status;
int	numchildren = 4;
int	count;
XWindowChanges	values;
XSetWindowAttributes attrs;
unsigned long valuemask;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion ConfigureRequest-3.(A)");
	report_assertion("When a ConfigureRequest event is delivered and a sibling");
	report_assertion("attribute was specified in the protocol request issued on");
	report_assertion("the child window, then above is set to the value of the");
	report_assertion("sibling attribute specified in the protocol request.");

	report_strategy("Create clients client2 and client3.");
	report_strategy("Build and create window hierarchy.");
	report_strategy("Select for ConfigureRequest events using SubstructureRedirectMask.");
	report_strategy("Select for no events with client3.");
	report_strategy("Raise lowest window to just below the top window.");
	report_strategy("Initialize for expected events.");
	report_strategy("Verify that a ConfigureRequest event is delivered.");
	report_strategy("Verify that no events are delivered to client3.");
	report_strategy("Verify members of event structure.");
	report_strategy("Verify that no events were delivered to client3.");

	tpstartup();
/* Create clients client2 and client3. */
	if ((client2 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client2.");
		return;
	}
	else
		CHECK;
	if ((client3 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client3.");
		return;
	}
	else
		CHECK;
/* Build and create window hierarchy. */
	/* can't use winh() because the windows need to overlap */
	winhg.border_width = 1;
	winhg.area.x = 1;
	winhg.area.y = 1;
	winhg.area.width = 100;
	winhg.area.height = 100;
	parent = winh_adopt(display, (Winh *) NULL, 0L, (XSetWindowAttributes *) NULL, &winhg, WINH_NOMASK);
	if (parent == (Winh *) NULL) {
		report("Could not create parent");
		return;
	}
	else
		CHECK;
	winhg.area.x = 1;
	winhg.area.y = 1;
	winhg.area.width = 30;
	winhg.area.height = 30;
	attrs.override_redirect = False;
	attrs.border_pixel = W_FG;
	attrs.background_pixel = W_BG;
	valuemask = CWOverrideRedirect | CWBorderPixel | CWBackPixel;
	for (i=0; i<numchildren; i++) {
		if (!i)
			CHECK;
		sibling = winh_adopt(display, parent, valuemask, &attrs, &winhg, WINH_NOMASK);
		if (sibling == (Winh *) NULL) {
			report("Could not create child %d", i);
			return;
		}
		winhg.area.x += 10;
		winhg.area.y += 10;
	}
	child = parent->firstchild;
	if (winh_create(display, (Winh *) NULL, WINH_MAP))
		return;
	else
		CHECK;
/* Select for ConfigureRequest events using SubstructureRedirectMask. */
	/*
	 * Selection with a single client because only one can select
	 * for this event at a time.
	 */
	if (winh_selectinput(display, parent, MASK)) {
		report("Selection failed.");
		return;
	}
	else
		CHECK;
/* Select for no events with client3. */
	if (winh_selectinput(client3, (Winh *) NULL, NoEventMask)) {
		report("Selection with client3 failed.");
		return;
	}
	else
		CHECK;
/* Raise lowest window to just below the top window. */
	XSync(display, True);
	XSync(client2, True);
	XSync(client3, True);
	values.sibling = sibling->window;
	values.stack_mode = Below;
	XConfigureWindow(client2, child->window, CWSibling|CWStackMode, &values);
	XSync(client2, False);
	XSync(display, False);
	XSync(client3, False);
/* Initialize for expected events. */
	event.xany.type = EVENT;
	event.xany.window = parent->window;
	if (winh_plant(parent, &event, MASK, WINH_NOMASK)) {
		report("Could not plant events for parent");
		return;
	}
	else
		CHECK;
/* Verify that a ConfigureRequest event is delivered. */
/* Verify that no events are delivered to client3. */
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
	if (winh_harvest(client3, (Winh *) NULL)) {
		report("Could not harvest events for client3");
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status == -1)
		return;
	else if (status) {
		report("Event delivery not as expected");
		FAIL;
	}
	else {
		XEvent	*event_return;
		XConfigureRequestEvent	good;

/* Verify members of event structure. */
		event_return = winh_qdel->event;
		good = event_return->xconfigurerequest;
		good.type = EVENT;
		good.send_event = False;
		good.display = display;
		good.parent = parent->window;
		good.window = child->window;
		good.x = child->winhg.area.x;
		good.y = child->winhg.area.y;
		good.width = child->winhg.area.width;
		good.height = child->winhg.area.height;
		good.border_width = child->winhg.border_width;
		good.above = sibling->window;
		good.detail = Below;
		good.value_mask = CWSibling|CWStackMode;
		if (checkevent((XEvent *) &good, event_return)) {
			report("Unexpected values in delivered event");
			FAIL;
		}
		else
			CHECK;
	}
/* Verify that no events were delivered to client3. */
	count = XPending(client3);
	if (count != 0) {
		report("Got %d events, expected %d for client3", count, 0);
		FAIL;
		return;
	}
	else
		CHECK;

	CHECKPASS(12);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){


 	report_purpose(4);

	report_assertion("Assertion ConfigureRequest-4.(-)");
	report_assertion("When a ConfigureRequest event is delivered and a sibling");
	report_assertion("attribute was not specified in the protocol request issued");
	report_assertion("on the child window, then above is set to None.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t005(){


 	report_purpose(5);

	report_assertion("Assertion ConfigureRequest-5.(-)");
	report_assertion("When a ConfigureRequest event is delivered and a stack-mode");
	report_assertion("attribute was specified in the protocol request issued on");
	report_assertion("the child window, then detail is set to the value of the");
	report_assertion("stack-mode attribute specified in the protocol request.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t006(){

Display	*display = Dsp;
Display	*client2, *client3;
Winh	*parent, *child, *sibling;
Winhg	winhg;
XEvent	event;
int	i;
int	status;
int	numchildren = 4;
int	count;
XSetWindowAttributes attrs;
unsigned long valuemask;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion ConfigureRequest-6.(A)");
	report_assertion("When a ConfigureRequest event is delivered and a stack-mode");
	report_assertion("attribute was not specified in the protocol request issued");
	report_assertion("on the child window, then detail is set to None.");

	report_strategy("Create clients client2 and client3.");
	report_strategy("Build and create window hierarchy.");
	report_strategy("Select for ConfigureRequest events using SubstructureRedirectMask.");
	report_strategy("Select for no events with client3.");
	report_strategy("Attempt to change window's border width.");
	report_strategy("Initialize for expected events.");
	report_strategy("Verify that a ConfigureRequest event is delivered.");
	report_strategy("Verify that no events are delivered to client3.");
	report_strategy("Verify members of event structure.");
	report_strategy("Verify that no events were delivered to client3.");

	tpstartup();
/* Create clients client2 and client3. */
	if ((client2 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client2.");
		return;
	}
	else
		CHECK;
	if ((client3 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client3.");
		return;
	}
	else
		CHECK;
/* Build and create window hierarchy. */
	/* can't use winh() because the windows need to overlap */
	winhg.border_width = 1;
	winhg.area.x = 1;
	winhg.area.y = 1;
	winhg.area.width = 100;
	winhg.area.height = 100;
	parent = winh_adopt(display, (Winh *) NULL, 0L, (XSetWindowAttributes *) NULL, &winhg, WINH_NOMASK);
	if (parent == (Winh *) NULL) {
		report("Could not create parent");
		return;
	}
	else
		CHECK;
	winhg.area.x = 1;
	winhg.area.y = 1;
	winhg.area.width = 30;
	winhg.area.height = 30;
	attrs.override_redirect = False;
	attrs.border_pixel = W_FG;
	attrs.background_pixel = W_BG;
	valuemask = CWOverrideRedirect | CWBorderPixel | CWBackPixel;
	for (i=0; i<numchildren; i++) {
		if (!i)
			CHECK;
		sibling = winh_adopt(display, parent, valuemask, &attrs, &winhg, WINH_NOMASK);
		if (sibling == (Winh *) NULL) {
			report("Could not create child %d", i);
			return;
		}
		winhg.area.x += 10;
		winhg.area.y += 10;
	}
	child = parent->firstchild;
	if (winh_create(display, (Winh *) NULL, WINH_MAP))
		return;
	else
		CHECK;
/* Select for ConfigureRequest events using SubstructureRedirectMask. */
	/*
	 * Selection with a single client because only one can select
	 * for this event at a time.
	 */
	if (winh_selectinput(display, parent, MASK)) {
		report("Selection failed.");
		return;
	}
	else
		CHECK;
/* Select for no events with client3. */
	if (winh_selectinput(client3, (Winh *) NULL, NoEventMask)) {
		report("Selection with client3 failed.");
		return;
	}
	else
		CHECK;
/* Attempt to change window's border width. */
	XSync(display, True);
	XSync(client2, True);
	XSync(client3, True);
	child->winhg.border_width += 5;
	XSetWindowBorderWidth(client2, child->window, child->winhg.border_width);
	XSync(client2, False);
	XSync(display, False);
	XSync(client3, False);
/* Initialize for expected events. */
	event.xany.type = EVENT;
	event.xany.window = parent->window;
	if (winh_plant(parent, &event, MASK, WINH_NOMASK)) {
		report("Could not plant events for parent");
		return;
	}
	else
		CHECK;
/* Verify that a ConfigureRequest event is delivered. */
/* Verify that no events are delivered to client3. */
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
	if (winh_harvest(client3, (Winh *) NULL)) {
		report("Could not harvest events for client3");
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status == -1)
		return;
	else if (status) {
		report("Event delivery not as expected");
		FAIL;
	}
	else {
		XEvent	*event_return;
		XConfigureRequestEvent	good;

/* Verify members of event structure. */
		event_return = winh_qdel->event;
		good = event_return->xconfigurerequest;
		good.type = EVENT;
		good.send_event = False;
		good.display = display;
		good.parent = parent->window;
		good.window = child->window;
		good.x = child->winhg.area.x;
		good.y = child->winhg.area.y;
		good.width = child->winhg.area.width;
		good.height = child->winhg.area.height;
		good.border_width = child->winhg.border_width;
		good.above = Above;
		good.detail = None;
		good.value_mask = CWBorderWidth;
		if (checkevent((XEvent *) &good, event_return)) {
			report("Unexpected values in delivered event");
			FAIL;
		}
		else
			CHECK;
	}
/* Verify that no events were delivered to client3. */
	count = XPending(client3);
	if (count != 0) {
		report("Got %d events, expected %d for client3", count, 0);
		FAIL;
		return;
	}
	else
		CHECK;

	CHECKPASS(12);
	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){


 	report_purpose(7);

	report_assertion("Assertion ConfigureRequest-7.(-)");
	report_assertion("When a ConfigureRequest event is delivered, then value_mask");
	report_assertion("is set to the components specified in the protocol request.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
