/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XAddToSaveSet(display, w)
 *   Display	*display;
 *   Window	w;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XAddToSaveSet	1
char    *TestName = "XAddToSaveSet";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XAddToSaveSet function
 */
static Display	*display;
static Window	w;



/*
 * These windows are created by client1.
 */
char	*T1[] = {
	"base borders",
	"client1-A base (10,40) 9x4",
	"client1-C base (50,60) 60x60",
	"client1-D base (5,50) 35x70",
	"client1-B base (30,6) 60x30",
};

/*
 * These windows are created by client2 using client1's windows as parent.
 * This will lead to some windows being clipped by their (client1) parent,
 * when the client2 windows are reparented then these should reappear.
 */
char	*T2[] = {
	". borders",
	"client2-a-noadd-nomap . (15, 5) 12x4 unmap",
	"client2-b-noadd . (10, 10) 12x6",
#define	NOADD	2	/* Number not added */
	"client2-c-unmap . (30, 28) 14x7 unmap",
	"client2-d . (45, 15) 9x7",
	"client2-e . (15, 23) 9x7",
};

/*
 * The number of windows that should be reparented.  NOADD of the client2
 * windows is not added to the save set.
 */
#define	NUM_REPARENT ((NELEM(T1)-1)*(NELEM(T2)-NOADD-1))

/* Flags used in uflags */
#define	IN_SAVE_SET	0x01
#define	CLIENT1_INFERIOR	0x02
#define	ON_PARENT	0x04
#define	ON_WINDOW	0x10

/*
 * Create a bunch of windows.  Some are created by client1.  Others are
 * created by client2.  Of the latter some are inferiors of client1 and
 * are marked CLIENT1_INFERIOR.  Some of client2's windows are added to
 * client1's save-set - these are marked IN_SAVE_SET.
 * Client2 windows that are originally unmapped will be marked BT_UNMAP.
 * Structure events are selected for on display Dsp for all appropriate
 * windows.
 * Before returning, client1 is destroyed.
 */
void
setupsaveset(btret)
struct	buildtree	*btret[NELEM(T1)];
{
Display	*client1;
Display	*client2;
Window	base;
struct	buildtree	*bt1;
struct	buildtree	*btp;
XWindowAttributes	batts;
int 	i, j;
int	fail = 0;

	client1 = XOpenDisplay(config.display);
	client2 = opendisplay();
	if (client1 == NULL || client2 == NULL) {
		delete("Could not open display");
		return;
	}

	base = defwin(Dsp);
	XSync(Dsp, False);

	/*
	 * Build a tree for client1, build a tree for client2 on each of
	 * the client1 windows + the base window.
	 */
	bt1 = buildtree(client1, base, T1, NELEM(T1));
	for (i = 0; i < NELEM(T1); i++) {
		btret[i] = buildtree(client2, bt1[i].wid, T2, NELEM(T2));
		/*
		 * Transfer some of the information down from the client1 windows
		 * into the returned array.  This means that all the positions
		 * in the returned array will be relative to base.
		 */
		btret[i][0].x = bt1[i].x;
		btret[i][0].y = bt1[i].y;
		btret[i][0].borderwidth = bt1[i].borderwidth;
	}

	XSync(client2, False);

	for (i = 0; i < NELEM(T1); i++) {
		for (j = 0; j < NELEM(T2); j++) {

			btp = &btret[i][j];
			display = client1;
			w = btp->wid;

			/*
			 * j==0 is the client1 window.
			 * j==1 and j==2 are not added to
			 * the save-set; the rest are.
			 */
			if (j > NOADD) {
				btp->uflags |= IN_SAVE_SET;
				startcall(display);
				if (isdeleted())
					return;
				XAddToSaveSet(display, w);
				endcall(display);
				if (geterr() != Success) {
					report("Got %s, Expecting Success", errorname(geterr()));
					FAIL;
				}
			} /* else not added to save set */

			/*
			 * The windows with i=0 are inferiors of the base window
			 * and not one of client1's window.
			 */
			if (i != 0)
				btp->uflags |= CLIENT1_INFERIOR;

			XSelectInput(Dsp, w, StructureNotifyMask);
		}
	}
	XSelectInput(Dsp, base, SubstructureNotifyMask);

/* Store base window coordinates to allow for absolute coordinate checking */
	XGetWindowAttributes(Dsp, base, &batts);
	btret[0][0].x = batts.x;
	btret[0][0].y = batts.y;
	btret[0][0].borderwidth = batts.border_width;

	XSync(Dsp, False);

	XCloseDisplay(client1);
	sleep(config.speedfactor);

	XSync(Dsp, False);
	XSync(client2, False);

}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	w = ErrdefWindow;
}

static void t001(){

struct	buildtree *bt[NELEM(T1)];
struct	buildtree *btp;
XWindowAttributes	atts;
int 	i, j;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XAddToSaveSet-1.(A)");
	report_assertion("A call to XAddToSaveSet adds the specified window to the");
	report_assertion("client's save-set.");

	report_strategy("Create client1.");
	report_strategy("Create windows for client1.");
	report_strategy("Create client2.");
	report_strategy("Create windows for client2 that are inferiors of the windows created by");
	report_strategy("client1.");
	report_strategy("Add some of client2's windows to client1's save-set with XAddToSaveSet.");
	report_strategy("Close client1.");
	report_strategy("Verify that the inferiors that were added to the save-set still exist");
	report_strategy("and that the ones that were not have been destroyed.");

	tpstartup();
	setargs();
	setupsaveset(bt);

	CATCH_ERROR(Dsp);
	for (i = 0; i < NELEM(T1); i++) {
		for (j = 1; j < NELEM(T2); j++) {
			btp = bt[i] + j;
			debug(1, "window %s", btp->name);

			if ((btp->uflags & CLIENT1_INFERIOR) == 0) {
				if (XGetWindowAttributes(Dsp, btp->wid, &atts) == True)
					CHECK;
				else {
					report("Window that was not inferior was destroyed");
					FAIL;
				}
			} else if (btp->uflags & IN_SAVE_SET) {
				if (XGetWindowAttributes(Dsp, btp->wid, &atts) == True)
					CHECK;
				else {
					report("Window in save-set destroyed");
					FAIL;
				}
			} else {
				if (XGetWindowAttributes(Dsp, btp->wid, &atts) == False)
					CHECK;
				else {
					report("Window not in save-set was not destroyed");
					FAIL;
				}
			}
		}
	}
	RESTORE_ERROR(Dsp);

	CHECKPASS(NELEM(T1)*(NELEM(T2)-1));
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

struct	buildtree *bt[NELEM(T1)];
struct	buildtree *btp;
Window	parent;
Window	dummy;
Window	*children;
Window	base;
unsigned int 	nchild;
int 	i, j;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XAddToSaveSet-2.(A)");
	report_assertion("When the client's resources are destroyed, and the window");
	report_assertion("specified in the call to XAddToSaveSet is an inferior of one");
	report_assertion("of the windows created by the client, then the specified");
	report_assertion("window is reparented to the closest ancestor window such");
	report_assertion("that the save-set window is not an inferior of a window");
	report_assertion("created by the client.");

	report_strategy("Setup windows so that they have been reparented, using setupsaveset.");
	report_strategy("Verify that each window that should have been reparented has the correct parent.");

	tpstartup();
	setargs();
	setupsaveset(bt);

	/*
	 * Base will be stored in bt[0][0] all the windows should be reparented
	 * to there.
	 */
	base = bt[0][0].wid;

	for (i = 0; i < NELEM(T1); i++) {
		for (j = 1; j < NELEM(T2); j++) {

			btp = bt[i] + j;

			/*
			 * Skip if it shouldn't have been reparented.
			 */
			btp->uflags &= (IN_SAVE_SET|CLIENT1_INFERIOR);
			if (btp->uflags != (IN_SAVE_SET|CLIENT1_INFERIOR))
				continue;

			/* Get new parent */
			XQueryTree(Dsp, btp->wid, &dummy, &parent, &children, &nchild);
			if (children && nchild > 0)
				XFree((char*)children);
				
			if (parent != base) {
				report("Window not reparented to correct parent");
				FAIL;
			} else
				CHECK;
		}
	}
	CHECKPASS(NUM_REPARENT);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XWindowAttributes	batts, atts;
struct	buildtree *bt[NELEM(T1)];
struct	buildtree *btp;
struct	buildtree *cli1btp;
int 	oldx, oldy;
int 	newx, newy;
int 	i, j;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XAddToSaveSet-3.(A)");
	report_assertion("When a save-set window is reparented as a result of");
	report_assertion("save-set processing, then the absolute coordinates of the");
	report_assertion("upper-left outer corner of the save-set window are");
	report_assertion("unchanged.");

	report_strategy("Setup reparented windows with setupsaveset(). ");
	report_strategy("Obtain base window coordinates.");
	report_strategy("Verify the base window has not moved.");
	report_strategy("For each reparented window:");
	report_strategy("  Calculate original position relative to base window.");
	report_strategy("  Obtain new position of window.");
	report_strategy("  Verify that window has not moved relative to root window.");

	tpstartup();
	setargs();
	setupsaveset(bt);

	XGetWindowAttributes(Dsp, bt[0][0].wid, &batts);
	if (batts.x != bt[0][0].x || batts.y != bt[0][0].y) {
		report("Window reparenting caused the base window to move");
		report("Pre-reparenting  (%d,%d)" , bt[0][0].x, bt[0][0].y);
		report("Post-reparenting (%d,%d)" , batts.x, batts.y);
		FAIL;
	} else
		CHECK;

	for (i = 0; i < NELEM(T1); i++) {

		/*
		 * Get the information relating to the original client1 window
		 * (that no longer exists).
		 */
		cli1btp = bt[i];

		for (j = 1; j < NELEM(T2); j++) {
			btp = bt[i] + j;

			/*
			 * Skip if it shouldn't have been reparented.
			 */
			btp->uflags &= (IN_SAVE_SET|CLIENT1_INFERIOR);
			if (btp->uflags != (IN_SAVE_SET|CLIENT1_INFERIOR))
				continue;

			debug(1, "window %s", btp->name);

			oldx = bt[0][0].x + bt[0][0].borderwidth + 
				cli1btp->x + cli1btp->borderwidth + btp->x;
			oldy = bt[0][0].y + bt[0][0].borderwidth +
				cli1btp->y + cli1btp->borderwidth + btp->y;

			XGetWindowAttributes(Dsp, btp->wid, &atts);

			newx = batts.x + batts.border_width + atts.x;
			newy = batts.y + batts.border_width + atts.y;

			/*
			 * Most R4 servers seem to have a bug here.  When the window
			 * to which the windows are being reparented is not at the
			 * origin, then the windows get displaced by an amount equal
			 * to the position of the window.
			 */
			if (oldx != newx || oldy != newy) {
				report("Coords relative to root changed after reparenting");
				report(" (%d, %d), expecting (%d, %d)"
					, newx, newy, oldx, oldy);
				FAIL;
			} else
				CHECK;
		}
	}
	CHECKPASS(1 + NUM_REPARENT);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

XEvent	ev;
XUnmapEvent	good;
XUnmapEvent	*ump;
Window	base;
struct	buildtree *bt[NELEM(T1)];
struct	buildtree *btp;
int 	loop;
int 	i, j;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XAddToSaveSet-4.(A)");
	report_assertion("When a save-set window is reparented as a result of");
	report_assertion("save-set processing and it was originally mapped, then the");
	report_assertion("window is unmapped before being reparented and UnmapNotify");
	report_assertion("events are generated.");

	report_strategy("Create save set with setupsaveset.");
	report_strategy("Get all unmap events.");
	report_strategy("Compare event against expected values.");
	report_strategy("Verify that unmap events were received for all save-set windows that");
	report_strategy("were inferiors of client1.");

	tpstartup();
	setargs();
	setupsaveset(bt);

	base = bt[0][0].wid;

	defsetevent(good, Dsp, UnmapNotify);
	good.from_configure = False;

	loop = 0;
	while (getevent(Dsp, &ev)) {
		if (ev.type != UnmapNotify)
			continue;
		ump = (XUnmapEvent*)&ev;

		/*
		 * Find the window that this event refers to.
		 */
		for (btp = NULL, i = 0; btp == NULL && i < NELEM(T1); i++)
			btp = btwtobtp(bt[i], ump->window);

		if (btp == NULL) {
			report("Unmap event received for unrecognised window");
			FAIL;
			return;
		}

		if (ump->event == ump->window) {
			/* On window itself */
			if (btp->uflags & ON_WINDOW) {
				report("Repeated unmap event on window");
				FAIL;
			} else if (loop == 0)
				CHECK;
			btp->uflags |= ON_WINDOW;
			good.event = btp->wid;
		} else {
			/* Shouldn't happen at all */
			if (btp->uflags & ON_PARENT) {
				report("Repeated unmap event on parent of window");
				FAIL;
			} else if (loop == 0)
				CHECK;
			btp->uflags |= ON_PARENT;
			good.event = base;
		}
		good.window = btp->wid;

		if (checkevent((XEvent*)&good, &ev))
			FAIL;
		else if (loop == 0)
			CHECK;

		loop++;
	}

	loop = 0;
	for (i = 0; i < NELEM(T1); i++) {
		for (j = 1; j < NELEM(T2); j++) {
			btp = bt[i] + j;

			debug(1, "window %s", btp->name);

			/*
			 * An unmap should be received when:
			 *   Was mapped && In save set && Was client1 inferior
			 */
			if (       (btp->uflags & IN_SAVE_SET)
					&& (btp->uflags & CLIENT1_INFERIOR)
					&& (btp->opts & BT_UNMAP) == 0
					) {

				if (btp->uflags & ON_WINDOW) {
					if (loop == 0)
						CHECK;
				} else {
					report("Unmap event was not received");
					FAIL;
				}
			} else if (btp->uflags & ON_WINDOW) {

				if ((btp->uflags & CLIENT1_INFERIOR) == 0) {
					report("Unmap event was received for window that was not");
					report("  an inferior of the destroyed client");
					FAIL;
				}
				if ((btp->uflags & IN_SAVE_SET) == 0) {
					report("Unmap event was received for window that was not in save-set");
					FAIL;
				}
				if (btp->opts & BT_UNMAP) {
					report("Unmap event was received for window that was already not mapped");
					FAIL;
				}
			} else {
				if (loop == 0)
					CHECK;
			}

			loop++;
		}
	}

	CHECKPASS(2 + 1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

XEvent	ev;
XReparentEvent	good;
XReparentEvent	*rpp;
Window	base;
struct	buildtree *bt[NELEM(T1)];
struct	buildtree *btp;
int 	loop;
int 	i, j;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XAddToSaveSet-5.(A)");
	report_assertion("When a save-set window is reparented as a result of");
	report_assertion("save-set processing, then a ReparentNotify event is");
	report_assertion("generated on the window and the new parent window.");

	report_strategy("Create save set with setupsaveset.");
	report_strategy("Get all reparent events.");
	report_strategy("Compare event against expected values.");
	report_strategy("Verify that reparent events were received for all save-set windows that");
	report_strategy("were inferiors of client1.");
	report_strategy("Verify that reparent events were received for the parents of all save-set");
	report_strategy("windows that were inferiors of client1.");

	tpstartup();
	setargs();
	setupsaveset(bt);

	base = bt[0][0].wid;

	defsetevent(good, Dsp, ReparentNotify);
	good.parent = base;
	good.override_redirect = False;

	loop = 0;
	while (getevent(Dsp, &ev)) {
		if (ev.type != ReparentNotify)
			continue;
		rpp = (XReparentEvent*)&ev;

		/*
		 * Find the window that this event refers to.
		 */
		for (i = 0, btp = NULL; btp == NULL && i < NELEM(T1); i++)
			btp = btwtobtp(bt[i], rpp->window);

		if (btp == NULL) {
			report("Reparent event received for unrecognised window");
			FAIL;
			return;
		}

		if (rpp->event == rpp->window) {
			/* On window itself */
			if (btp->uflags & ON_WINDOW) {
				report("Repeated reparent event on window");
				FAIL;
			} else if (loop == 0)
				CHECK;
			btp->uflags |= ON_WINDOW;
			good.event = btp->wid;
		} else {
			if (btp->uflags & ON_PARENT) {
				report("Repeated reparent event on parent of window");
				FAIL;
			} else if (loop == 0)
				CHECK;
			btp->uflags |= ON_PARENT;
			good.event = base;
		}

		good.window = btp->wid;
		good.x = btp->x + btp->parent->borderwidth + btp->parent->x;
		good.y = btp->y + btp->parent->borderwidth + btp->parent->y;

		if (checkevent((XEvent*)&good, &ev))
			FAIL;
		else if (loop == 0)
			CHECK;

		loop++;
	}

	loop = 0;
	for (i = 0; i < NELEM(T1); i++) {
		for (j = 1; j < NELEM(T2); j++) {
			btp = bt[i] + j;

			debug(1, "window %s", btp->name);

			/*
			 * A reparent should be received when:
			 *   In save set && Was client1 inferior
			 */
			if (       (btp->uflags & IN_SAVE_SET)
					&& (btp->uflags & CLIENT1_INFERIOR)
					) {

				if (btp->uflags & ON_WINDOW) {
					if (loop == 0)
						CHECK;
				} else {
					report("Reparent event was not received on window");
					FAIL;
				}
				if (btp->uflags & ON_PARENT) {
					if (loop == 0)
						CHECK;
				} else {
					report("Reparent event was not received on parent of window");
					FAIL;
				}
			} else if (btp->uflags & (ON_WINDOW|ON_PARENT)) {

				if ((btp->uflags & CLIENT1_INFERIOR) == 0) {
					report("Reparent event was received for window that was");
					report("  not an inferior of the destroyed client");
					FAIL;
				}
				if ((btp->uflags & IN_SAVE_SET) == 0) {
					report("Reparent event was received for window that was not in save-set");
					FAIL;
				}
			} else {
				if (loop == 0)
					CHECK;
			}

			loop++;
		}
	}

	CHECKPASS(2 + 1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

XEvent	ev;
XMapEvent	good;
XMapEvent	*mp;
Window	base;
struct	buildtree *bt[NELEM(T1)];
struct	buildtree *btp;
int 	loop;
int 	i, j;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XAddToSaveSet-6.(A)");
	report_assertion("When a client is destroyed, then all its save-set windows");
	report_assertion("that are not mapped or that are reparented as a result of");
	report_assertion("save-set processing are mapped and MapNotify or MapRequest");
	report_assertion("events are generated.");

	report_strategy("Create save set with setupsaveset.");
	report_strategy("Get all map events.");
	report_strategy("Compare each event against expected values.");
	report_strategy("Verify that map events were received for all save-set windows that");
	report_strategy("were inferiors of client1 or were not originally mapped.");
	report_strategy("Verify that map events were received for the parents of all save-set");
	report_strategy("windows that were inferiors of client1 or were not originally mapped.");

	tpstartup();
	setargs();
	setupsaveset(bt);

	base = bt[0][0].wid;

	defsetevent(good, Dsp, MapNotify);
	good.override_redirect = False;

	loop = 0;
	while (getevent(Dsp, &ev)) {
		if (ev.type != MapNotify)
			continue;
		mp = (XMapEvent*)&ev;

		/*
		 * Find the window that this event refers to.
		 */
		for (i = 0, btp = NULL; btp == NULL && i < NELEM(T1); i++)
			btp = btwtobtp(bt[i], mp->window);

		if (btp == NULL) {
			report("Map event received for unrecognised window");
			FAIL;
			return;
		}

		if (mp->event == mp->window) {
			/* On window itself */
			if (btp->uflags & ON_WINDOW) {
				report("Repeated map event on window");
				FAIL;
			} else if (loop == 0)
				CHECK;
			btp->uflags |= ON_WINDOW;
			good.event = btp->wid;
		} else {
			if (btp->uflags & ON_PARENT) {
				report("Repeated map event on parent of window");
				FAIL;
			} else if (loop == 0)
				CHECK;
			btp->uflags |= ON_PARENT;
			good.event = base;
		}

		good.window = btp->wid;

		if (checkevent((XEvent*)&good, &ev))
			FAIL;
		else if (loop == 0)
			CHECK;

		loop++;
	}

	for (i = 0; i < NELEM(T1); i++) {
		for (j = 1; j < NELEM(T2); j++) {
			btp = bt[i] + j;

			debug(1, "window %s", btp->name);

			/*
			 * A map should be received when:
			 *    IN_SAVE_SET && CLIENT1_INFERIOR
			 * || IN_SAVE_SET && BT_UNMAP
			 */
			if (( (btp->uflags & IN_SAVE_SET) &&
				(btp->uflags & CLIENT1_INFERIOR) )
			|| ( (btp->uflags & IN_SAVE_SET) &&
				(btp->opts & BT_UNMAP) ))
			{

				if (btp->uflags & ON_WINDOW) {
					CHECK;
				} else {
					report("Map event was not received on window");
					FAIL;
				}
				if (btp->uflags & ON_PARENT) {
					CHECK;
				} else {
					report("Map event was not received on parent of window");
					FAIL;
				}
			} else if (btp->uflags & (ON_WINDOW|ON_PARENT)) {

				if ((btp->uflags & IN_SAVE_SET) == 0) {
					report("Map event was received for window that was not in save-set");
					FAIL;
				}
				if ((btp->opts & BT_UNMAP) == 0) {
					report("Map event was received for window that was already mapped");
					FAIL;
				}
			} else {
				CHECK;
				CHECK;	/* For balance with above */
			}

		}
	}

	CHECKPASS(2 + (2*NELEM(T1)*(NELEM(T2)-1)));
	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XAddToSaveSet-7.(A)");
	report_assertion("When the specified window was created by the same client,");
	report_assertion("then a BadMatch error occurs.");

	report_strategy("Create a window using default client.");
	report_strategy("Call XAddToSaveSet with this client and window.");
	report_strategy("Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	w = defwin(display);

	startcall(display);
	if (isdeleted())
		return;
	XAddToSaveSet(display, w);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XAddToSaveSet-8.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XAddToSaveSet(display, w);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
