/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   XFontStruct *
 *   XQueryFont(display, font_ID)
 *   Display	*display;
 *   XID 	font_ID;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XQueryFont	1
char    *TestName = "XQueryFont";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XQueryFont function
 */
static Display	*display;
static XID 	font_ID;


extern	int 	checkfsp();
extern	struct	fontinfo fontinfo[];
extern	int 	nfontinfo;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	font_ID = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XFontStruct	*fsp;
Font	font;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XQueryFont-1.(A)");
	report_assertion("When the font_ID argument is a valid Font resource, then a");
	report_assertion("call to XQueryFont returns a pointer to an XFontStruct");
	report_assertion("structure which contains information on the font with font");
	report_assertion("ID font_ID.");

	report_strategy("For each VSW5 font");
	report_strategy("  Load font with XLoadFont.");
	report_strategy("  Set font_ID to font");
	report_strategy("  Call XQueryFont.");
	report_strategy("  Verify returned XFontStruct with known good one.");

	tpstartup();
	setargs();
	for (i = 0; i < nfontinfo; i++) {
		trace("Loading font %s", fontinfo[i].name);
		font = XLoadFont(Dsp, fontinfo[i].name);
		if (isdeleted())
			return;

		font_ID = font;
		startcall(display);
		if (isdeleted())
			return;
		fsp = XQueryFont(display, font_ID);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if (checkfsp(fsp, fontinfo[i].fontstruct, *fontinfo[i].string))
			CHECK;
		else {
			report("Returned XFontStruct was incorrect");
			FAIL;
		}
	}
	CHECKPASS(nfontinfo);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XFontStruct	*fsp;
Font	font;
GC		gc;
Drawable	d;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XQueryFont-2.(A)");
	report_assertion("When the font_ID argument specifies a GContext, then a");
	report_assertion("call to XQueryFont returns a pointer to an XFontStruct");
	report_assertion("structure which contains information on the font in the");
	report_assertion("corresponding GC's font field.");

	report_strategy("Load font with ");

	tpstartup();
	setargs();
	d = defdraw(Dsp, VI_WIN_PIX);
	gc = makegc(Dsp, d);
	if (isdeleted())
		return;

	for (i = 0; i < nfontinfo; i++) {
		trace("Loading font %s", fontinfo[i].name);
		font = XLoadFont(Dsp, fontinfo[i].name);
		if (isdeleted())
			return;

		XSetFont(Dsp, gc, font);

		font_ID = XGContextFromGC(gc);
		startcall(display);
		if (isdeleted())
			return;
		fsp = XQueryFont(display, font_ID);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if (checkfsp(fsp, fontinfo[i].fontstruct, *fontinfo[i].string))
			CHECK;
		else {
			report("Returned XFontStruct was incorrect");
			FAIL;
		}
	}
	CHECKPASS(nfontinfo);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XFontStruct	*fsp;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XQueryFont-3.(A)");
	report_assertion("When the font_ID argument does not name a valid GContext or");
	report_assertion("Font resource, then a call to XQueryFont returns NULL.");

	report_strategy("Obtain a bad font ID.");
	report_strategy("Call XQueryFont.");
	report_strategy("Verify that null is returned.");

	tpstartup();
	setargs();
	font_ID = badfont(Dsp);
	startcall(display);
	if (isdeleted())
		return;
	fsp = XQueryFont(display, font_ID);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (fsp != NULL) {
		report("A non-NULL pointer was returned");
		FAIL;
	} else
		PASS;
		
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = fontstartup;
void	(*tet_cleanup)() = fontcleanup;
