/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XGetIconSizes(display, w, size_list_return, count_return)
 *   Display		*display;
 *   Window		w;
 *   XIconSize	**size_list_return;
 *   int		*count_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetIconSizes	1
char    *TestName = "XGetIconSizes";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XGetIconSizes function
 */
static Display		*display;
static Window		w;
static XIconSize	**size_list_return;
static int		*count_return;


static int 	StatusReturn;

#include	"X11/Xatom.h"
#define		NumPropIconSizeElements 6
XIconSize	*icnszp;
int		countret;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = DRW(Dsp);
	size_list_return = &icnszp;
	count_return = &countret;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Status		status;
XVisualInfo	*vp;
int		i;
int		v;
XIconSize	sizelist[5];
int		count = 5;
int		rcount;
XIconSize	*sp = (XIconSize *) NULL, *sref;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetIconSizes-1.(A)");
	report_assertion("When the WM_ICON_SIZES property has been set for the window");
	report_assertion("w, and has format 32, a value which is a multiple of 6");
	report_assertion("elements and type WM_ICON_SIZE, then a call to");
	report_assertion("XGetIconSizes returns a list of XIconSize structures, which");
	report_assertion("can be freed with XFree, in the size_list_return argument");
	report_assertion("and the number of structures in the count_return argument");
	report_assertion("and returns non-zero.");

	report_strategy("Create a window using XCreateWindow.");
	report_strategy("Set the WM_ICON_SIZES property using XSetIconSizes.");
	report_strategy("Obtain the WM_ICON_SIZES property using XGetIconSizes.");
	report_strategy("Verify that the call did not return False.");
	report_strategy("Verify that the property value is correct.");
	report_strategy("Release the allocated memory using XFree.");

	tpstartup();
	setargs();

	resetvinf(VI_WIN);
	nextvinf(&vp);
	w = makewin(display, vp);

	for(i=0, sp=sizelist, v=0; i<count; i++, sp++) {
		sp->min_width = v++;
		sp->min_height = v++;
		sp->max_width = v++;
		sp->max_height = v++;
		sp->width_inc = v++;
		sp->height_inc = v++;
	}

	XSetIconSizes(display, w, sizelist, count);

	size_list_return = &sp;
	count_return = &rcount;

	startcall(display);
	if (isdeleted())
		return;
	status = XGetIconSizes(display, w, size_list_return, count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status == False) {
		report("%s() returned False.", TestName);
		FAIL;
	} else
		CHECK;

	if( sp == (XIconSize *) NULL) {
		report("No value was set for the WM_ICON_SIZES property.");
		FAIL;
	} else {
		
		CHECK;
		if( rcount != count ) {
			report("%s() returned %d elements instead of %d.", TestName, rcount, count);
			FAIL;
		} else {
			for(i=0, sref=sp, v=0; i<count; i++, sref++) {

				if( sref->min_width != v++ ) {
					report("The min_width component of XIconSize structure %d was %d instead of %d.", i, sref->min_width, v-1);
					FAIL;
				} else
					CHECK;

				if( sref->min_height != v++ ) {
					report("The min_height component of XIconSize structure %d was %d instead of %d.", i, sref->min_height, v-1);
					FAIL;
				} else
					CHECK;

				if( sref->max_width != v++ ) {
					report("The max_width component of XIconSize structure %d was %d instead of %d.", i, sref->max_width, v-1);
					FAIL;
				} else
					CHECK;

				if( sref->max_height != v++ ) {
					report("The max_height component of XIconSize structure %d was %d instead of %d.", i, sref->max_height, v-1);
					FAIL;
				} else
					CHECK;

				if( sref->width_inc != v++ ) {
					report("The width_inc component of XIconSize structure %d was %d instead of %d.", i, sref->width_inc, v-1);
					FAIL;
				} else
					CHECK;

				if( sref->height_inc != v++ ) {
					report("The height_inc component of XIconSize structure %d was %d instead of %d.", i, sref->height_inc, v-1);
					FAIL;
				} else
					CHECK;

			}
		}
		XFree((char *)sp);
	}

	CHECKPASS(6*count+2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Status		status;
XVisualInfo	*vp;
XIconSize	*slp = (XIconSize *) NULL;
int		cret;
int		count = 3;
XIconSize	sl[3];
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetIconSizes-2.(A)");
	report_assertion("When the WM_ICON_SIZE property is not set for the window w,");
	report_assertion("or has format other than 32, a value which is not a multiple");
	report_assertion("of 6 elements or type other than WM_ICON_SIZE, then a call");
	report_assertion("to XGetIconSizes returns zero.");

	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Obtain the value of the unset WM_ICON_SIZES property using XGetIconSizes.");
	report_strategy("Verify that the function returned zero.");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the WM_ICON_SIZES property to have format 16 size 6 elements and type WM_ICON_SIZE using XChangeProperty.");
	report_strategy("Obtain the value of the WM_ICON_SIZES property using XGetIconSizes.");
	report_strategy("Verify that the call returned zero");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the WM_ICON_SIZES property to have format 32 size 13 elements and type WM_ICON_SIZE using XChangeProperty.");
	report_strategy("Obtain the value of the WM_ICON_SIZES property using XGetIconSizes.");
	report_strategy("Verify that the call returned zero");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the WM_ICON_SIZES property to have format 32 size 6 elements and type WM_SIZE_HINTS using XChangeProperty.");
	report_strategy("Obtain the value of the WM_ICON_SIZES property using XGetIconSizes.");
	report_strategy("Verify that the call returned zero");
	report_strategy("");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	size_list_return = &slp;
	count_return = &cret;

	w = makewin(display, vp);
/* unset property */

	startcall(display);
	if (isdeleted())
		return;
	status = XGetIconSizes(display, w, size_list_return, count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != False) {
		report("%s() did not return False when the property was unset.", TestName);
		FAIL;
	} else
		CHECK;

	w = makewin(display, vp);
/* format 16 */
	XChangeProperty(display, w, XA_WM_ICON_SIZE, XA_WM_ICON_SIZE, 16, PropModeReplace, (unsigned char *) sl, count*NumPropIconSizeElements);

	startcall(display);
	if (isdeleted())
		return;
	status = XGetIconSizes(display, w, size_list_return, count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != False) {
		report("%s() did not return False when the property format was 16.", TestName);
		FAIL;
	} else
		CHECK;

	w = makewin(display, vp);
/* size 13 */
	XChangeProperty(display, w, XA_WM_ICON_SIZE, XA_WM_ICON_SIZE, 32, PropModeReplace, (unsigned char *) sl, NumPropIconSizeElements*2 + 1);

	startcall(display);
	if (isdeleted())
		return;
	status = XGetIconSizes(display, w, size_list_return, count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != False) {
		report("%s() did not return False when the number of elements was 13.", TestName);
		FAIL;
	} else
		CHECK;

	w = makewin(display, vp);
/* type WM_SIZE_HINTS */
	XChangeProperty(display, w, XA_WM_ICON_SIZE, XA_WM_SIZE_HINTS, 32, PropModeReplace, (unsigned char *) sl, count*NumPropIconSizeElements);

	startcall(display);
	if (isdeleted())
		return;
	status = XGetIconSizes(display, w, size_list_return, count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != False) {
		report("%s() did not return False when the property type was WM_SIZE_HINTS.", TestName);
		FAIL;
	} else
		CHECK;

	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGetIconSizes-3.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XGetIconSizes(display, w, size_list_return, count_return);
	endcall(display);
	if (StatusReturn != 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
