/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode)
 *   Display	*display;
 *   XDevice *device;
 *   int 	button;
 *   unsigned int 	modifiers;
 *   XDevice *modifier_device;
 *   Window	grab_window;
 *   Bool	owner_events;
 *   int 	event_count;
 *   XEventClass *event_list;
 *   int 	this_device_mode;
 *   int 	other_devices_mode;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGrabDeviceButton	1
char    *TestName = "XGrabDeviceButton";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW grab_window
#define A_DRAWABLE grab_window


/*
 * Arguments to the XGrabDeviceButton function
 */
static Display	*display;
static XDevice *device;
static int 	button;
static unsigned int 	modifiers;
static XDevice *modifier_device;
static Window	grab_window;
static Bool	owner_events;
static int 	event_count;
static XEventClass *event_list;
static int 	this_device_mode;
static int 	other_devices_mode;


extern ExtDeviceInfo Devs;
extern int NumButtons;



/* Value list for use in test t012 */
static unsigned long	modifiersvallist[] = {
	ShiftMask,
	LockMask,
	ControlMask,
	Mod1Mask,
	Mod2Mask,
	Mod3Mask,
	Mod4Mask,
	Mod5Mask,
	AnyModifier,
};



/* Value list for use in test t013 */
static int 	owner_eventsvallist[] = {
	True,
	False,
};



/* Value list for use in test t014 */
static int 	this_device_modevallist[] = {
	GrabModeSync,
	GrabModeAsync,
};



/* Value list for use in test t015 */
static int 	other_devices_modevallist[] = {
	GrabModeSync,
	GrabModeAsync,
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
	button = AnyButton;
	modifiers = AnyModifier;
	modifier_device = NULL;
	grab_window = defwin(display);
	owner_events = True;
	event_count = 0;
	event_list = 0;
	this_device_mode = GrabModeAsync;
	other_devices_mode = GrabModeAsync;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int ret;
Display *client1;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGrabDeviceButton-1.(B)");
	report_assertion("A call to XGrabDeviceButton establishes a passive grab on");
	report_assertion("the button device that is activated in the future by the");
	report_assertion("specified button being logically pressed, the specified");
	report_assertion("modifier keys being logically down, no other modifier keys");
	report_assertion("being logically down, the grab_window being the focus window");
	report_assertion("or an ancestor of the focus window or being a descendant of");
	report_assertion("the focus window that contains the pointer and a passive");
	report_assertion("grab on the same button combination not existing on any");
	report_assertion("ancestor of grab_window.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XGrabDeviceButton.  Verify that the grab was correctly installed by pressing");
	report_strategy("a button to activate it, then attempting to grab the device from another");
	report_strategy("client.  Verify that the grab fails with an error of AlreadyGrabbed.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask | ModMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}
	device = Devs.Button;
	modifier_device = Devs.Mod;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	if (noext(1))
	    return;
	warppointer(display, grab_window, 1, 1);
	devicebuttonpress (display, Devs.Button, Button1);
	XSync (display, 0);

	ret = XGrabDevice(client1, Devs.Button, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != AlreadyGrabbed)
	    FAIL;
	else
	    PASS;
	devicebuttonrel (display, Devs.Button, Button1);
	devicerelbuttons (Devs.Button);
	XUngrabDeviceButton(display, device, AnyButton, AnyModifier, modifier_device, grab_window);
	XCloseDisplay(client1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int ret;
Display *client1;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGrabDeviceButton-2.(B)");
	report_assertion("When the conditions for activating the grab are otherwise");
	report_assertion("satisfied and the button device is already grabbed, then no");
	report_assertion("active grab is established.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Establish an active grab on the target device.  Then establish a passive");
	report_strategy("grab from another client.  Press a button to activate the grab.");
	report_strategy("If the passive grab worked, the client that established the passive grab");
	report_strategy("should be able to replace it with an active grab.  If it failed, the active");
	report_strategy("grab should also fail with an error of AlreadyGrabbed.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask | ModMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}
	device = Devs.Button;
	modifier_device = Devs.Mod;

	ret = XGrabDevice(client1, Devs.Button, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != Success)
	    FAIL;
	else
	    CHECK;

	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret != Success)
	    FAIL;
	else
	    CHECK;

	if (noext(1))
	    {
	    untested("Test extension not present - touch test only.\n");
	    return;
	    }
	warppointer(display, grab_window, 1, 1);
	devicebuttonpress (display, Devs.Button, Button1);
	XSync (display, 0);

	ret = XGrabDevice(display, Devs.Button, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != AlreadyGrabbed)
	    FAIL;
	else
	    CHECK;
	devicebuttonrel (display, Devs.Button, Button1);
	devicerelbuttons (Devs.Button);
        XUngrabDevice(client1, Devs.Button, CurrentTime);
	XUngrabDeviceButton(display, device, AnyButton, AnyModifier, modifier_device, grab_window);
        XSync(display, 0);
        XSync(client1, 0);
        XCloseDisplay(client1);
	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

unsigned int 	ret, mods;
Display *client1;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGrabDeviceButton-3.(B)");
	report_assertion("When the modifiers argument is AnyModifier, then this is");
	report_assertion("equivalent to separate calls to XGrabDeviceButton for all");
	report_assertion("possible modifier combinations including no modifiers.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions are available:");
	report_strategy("  Place passive grab with a modifiers of AnyModifier.");
	report_strategy("  Press a bunch of modifier keys.");
	report_strategy("  Press button to activate grab.");
	report_strategy("  Verify that grab is activated.");
	report_strategy("  Release button and keys.");
	report_strategy("");
	report_strategy("  Press button (no modifiers).");
	report_strategy("  Verify that grab is active.");
	report_strategy("else");
	report_strategy("  Perform touch test.");
	report_strategy("  Report untested.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask | ModMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}
	modifiers = AnyModifier;
	device = Devs.Button;
	modifier_device = NULL;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (noext(1)) {
		untested("There is no reliable test method, but a touch test was performed");
		return;
	}

	mods = wantmods(display, 4);
	modpress(display, mods);

	/*
	 * modifiers was AnyModifier, several modifier keys are held down.
	 */
	warppointer(display, grab_window, 1, 1);
	devicebuttonpress(display, Devs.Button, Button1);
	XSync(display,0);
	ret = XGrabDevice(client1, Devs.Button, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != AlreadyGrabbed) 
	    {
	    report("Grab not activated for AnyModifier");
	    report("  Modifiers used %s", keymaskname((unsigned long)mods));
	    FAIL;
	    }
	else
	    CHECK;

	/* Release all buttons and modifiers */
	modrel(display, mods);
	devicebuttonrel(display, Devs.Button, Button1);
	relalldev();
	XSync(display,0);

	ret = XGrabDevice(client1, Devs.Button, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret == AlreadyGrabbed) 
	    {
	    delete("Could not release grab for second part of test");
	    FAIL;
	    }
	else
	    {
	    XUngrabDevice(client1, Devs.Button, CurrentTime);
	    XSync(client1,0);
	    CHECK;
	    }

	devicebuttonpress(display, Devs.Button, Button1);
	XSync(display,0);
	ret = XGrabDevice(client1, Devs.Button, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != AlreadyGrabbed) 
	    {
	    report("Grab with AnyModifier was not activated by a button press with");
	    report("  no modifiers");
	    FAIL;
	    }
	else
	    CHECK;
	devicebuttonrel(display, Devs.Button, Button1);
	devicerelbuttons (Devs.Button);
	XUngrabDeviceButton(display, device, AnyButton, AnyModifier, modifier_device, grab_window);
        XUngrabDevice(client1, Devs.Button, CurrentTime);
        XSync(client1, 0);
        XCloseDisplay(client1);
	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

XEvent	ev;
int	dbp, dbr;
XEventClass dbpclass, dbrclass;
XDeviceButtonPressedEvent	good;
XWindowAttributes	atts;
int 	n;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XGrabDeviceButton-4.(B)");
	report_assertion("When the conditions for activating the grab are satisfied,");
	report_assertion("then the last-device-grab time is set to the time at which");
	report_assertion("the button was pressed and a DeviceButtonPress event is");
	report_assertion("generated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions are available:");
	report_strategy("  Call XGrabDeviceButton to place passive grab.");
	report_strategy("  Enable events on grab window.");
	report_strategy("  Move pointer into grab window.");
	report_strategy("  Activate grab with simulated device events.");
	report_strategy("  Verify that a DeviceButtonPress event is generated.");
	report_strategy("else");
	report_strategy("  Report untested.");

	tpstartup();
	setargs();
	if (noext(1))
		return;

	if (!Setup_Extension_DeviceInfo(BtnMask | ModMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	DeviceButtonPress(device, dbp, dbpclass);
	DeviceButtonRelease(device, dbr, dbrclass);
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSelectExtensionEvent(display, grab_window, &dbrclass, 1);

	warppointer(display, grab_window, 1, 1);
	XSync(display, True);	/* Discard any events */
	devicebuttonpress(display, Devs.Button, Button1);

	XGetWindowAttributes(display, grab_window, &atts);
	n = getevent(display, &ev);
	if (n)
		CHECK;
	else {
		report("No events received");
		FAIL;
		return;
	}

	defsetevent(good, display, dbp);
	good.window = grab_window;
	good.root = DRW(display);
	good.subwindow = None;
	good.time = ((XDeviceButtonPressedEvent*)&ev)->time;
	good.x = 1;
	good.y = 1;
	good.x_root = good.x + atts.x + atts.border_width;
	good.y_root = good.y + atts.y + atts.border_width;
	good.state = modifiers;
	good.button = Button1;
	good.same_screen = True;

	if (checkevent((XEvent*)&good, &ev) == 0)
		CHECK;
	else
		FAIL;

	devicebuttonrel(display, Devs.Button, Button1);
	devicerelbuttons (Devs.Button);
	XUngrabDeviceButton(display, device, AnyButton, AnyModifier, modifier_device, grab_window);
	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

unsigned int 	mods, ret;
Display *client1;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XGrabDeviceButton-5.(B)");
	report_assertion("When the grab subsequently becomes active and later the");
	report_assertion("logical state of the pointer has all buttons released, then");
	report_assertion("the active grab is terminated automatically.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions are available:");
	report_strategy("  Place passive grab with XGrabDeviceButton.");
	report_strategy("  Activate grab with simulated device events.");
	report_strategy("  Simulate pressing some modifier keys.");
	report_strategy("  Release the button.");
	report_strategy("  Verify that the grab has been released.");
	report_strategy("else");
	report_strategy("  Report untested.");

	tpstartup();
	setargs();
	if (noext(1))
		return;

	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}
	if (!Setup_Extension_DeviceInfo(BtnMask | ModMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	devicebuttonpress(display, Devs.Button, Button1);
	mods = wantmods(display, 3);
	modpress(display, mods);
	XSync(display,0);

	devicebuttonrel(display, Devs.Button, Button1);
	XSync(display,0);

	ret = XGrabDevice(client1, Devs.Button, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != Success)
	    {
	    report("Grab was not released, when button was released and ");
	    report("  modifier keys were down");
	    FAIL;
	    }
	else
	    PASS;
	modrel(display, mods);
	devicerelbuttons (Devs.Button);
	relalldev();
	XUngrabDeviceButton(display, device, AnyButton, AnyModifier, modifier_device, grab_window);
        XUngrabDevice (client1, Devs.Button, CurrentTime);
        XSync(client1, 0);
        XCloseDisplay(client1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int count = 0;
int	dbp, dbr;
XEventClass dbpclass, dbrclass;
XEvent ev;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XGrabDeviceButton-6.(B)");
	report_assertion("A call to XGrabDeviceButton overrides all previous passive");
	report_assertion("grabs by the same client on the same button/modifier");
	report_assertion("combinations on the same window.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions are available:");
	report_strategy("  Place a passive grab with this_device_mode = GrabModeSync.");
	report_strategy("  Place a passive grab as before but with this_device_mode = GrabModeAsync.");
	report_strategy("  Move pointer to grab_window and activate grab.");
	report_strategy("  Verify that the device is not frozen, and thus the second");
	report_strategy("  grab overrode the first.");
	report_strategy("else");
	report_strategy("  Report untested.");

	tpstartup();
	setargs();
	if (noext(1))
		return;

	if (!Setup_Extension_DeviceInfo(BtnMask | ModMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	DeviceButtonPress(device, dbp, dbpclass);
	DeviceButtonRelease(device, dbr, dbrclass);
	XSelectExtensionEvent(display, grab_window, &dbpclass, 1);
	XSync(display,0);
	warppointer(display, grab_window, 1, 1);

	this_device_mode = GrabModeSync;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/* Try to override first grab */
	this_device_mode = GrabModeAsync;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	devicebuttonpress(display, Devs.Button, Button1);
	if (NumButtons > 1)
	    devicebuttonpress(display, Devs.Button, Button2);
	if (NumButtons > 2)
	    devicebuttonpress(display, Devs.Button, Button3);
	XSync(display,0);

	while (XPending(display)) 
	    {
	    XNextEvent(display, &ev);
	    count++;
	    if (ev.type==dbp)
		CHECK;
	    else
		FAIL;
	    }

	devicerelbuttons(Devs.Button);
	XUngrabDeviceButton(display, device, AnyButton, AnyModifier, modifier_device, grab_window);
	CHECKPASS(count);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

XModifierKeymap	*mmap;
XModifierKeymap	*newmap;
int 	i, ret;
Display *client1;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XGrabDeviceButton-7.(B)");
	report_assertion("It is not required that all modifiers specified have");
	report_assertion("currently assigned KeyCodes.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions are available:");
	report_strategy("  Get a modifier mask.");
	report_strategy("  Remove the keycode for the modifier from the map.");
	report_strategy("  Call XGrabDeviceButton to set up a passive grab with that modifier.");
	report_strategy("  Reset the keycode in the modifier map.");
	report_strategy("  Verify that the grab can be activated with the newly set modifier.");
	report_strategy("else");
	report_strategy("  Report untested.");

	tpstartup();
	setargs();
	if (noext(1))
		return;

	if (!Setup_Extension_DeviceInfo(BtnMask | ModMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}
	device = Devs.Button;
	modifiers = wantmods(display, 1);
	modifier_device = NULL;
	if (modifiers == 0) {
		untested("No available modifier keys");
		return;
	} else
		CHECK;

	mmap = XGetModifierMapping(display);
	if (mmap == NULL) {
		delete("Could not get modifier map");
		return;
	} else
		CHECK;

	/*
	 * Remove all the modifiers mappings.
	 */
	newmap = XNewModifiermap(mmap->max_keypermod);
	for (i = 0; i < newmap->max_keypermod*8; i++)
		newmap->modifiermap[i] = NoSymbol;

	if ((ret=XSetModifierMapping(display, newmap)) == MappingSuccess)
		CHECK;
	else {
		delete("Could not remove modifier mapping,ret=%d",ret);
		return;
	}

	/*
	 * Now we have a modifier that has no keycode - set up a passive grab.
	 */
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	/*
	 * Reset the modifier map, and try to activate the grab.
	 */
	if (XSetModifierMapping(display, mmap) == MappingSuccess)
		CHECK;
	else {
		delete("Could not reset modifier mapping");
		return;
	}

	warppointer(display, grab_window, 1, 1);
	XSync(display,0);
	modpress(display, modifiers);
	devicebuttonpress(display, Devs.Button, Button1);
	XSync(display,0);

	ret = XGrabDevice(client1, Devs.Button, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != AlreadyGrabbed) 
	    {
	    report("Passive grab not set when the modifier did not have a current keycode");
	    FAIL;
	    }
	else
	    CHECK;

	CHECKPASS(5);
	modrel(display, modifiers);
	devicebuttonrel(display, Devs.Button, Button1);
	devicerelbuttons (Devs.Button);
	relalldev();
	XUngrabDeviceButton(display, device, AnyButton, AnyModifier, modifier_device, grab_window);
        XCloseDisplay(client1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

int i, j, ret, ndevices, nbtns, count=0;
Display *client1;
XDeviceInfo *list;
XAnyClassPtr any;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XGrabDeviceButton-8.(B)");
	report_assertion("When the button argument is AnyButton, then this is");
	report_assertion("equivalent to separate calls to XGrabDeviceButton for all");
	report_assertion("possible buttons.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Establish a passive grab for AnyButton on an input extension device.");
	report_strategy("Press each of the buttons on that device.");
	report_strategy("Verify that pressing each of the buttons activates the grab.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask | ModMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}
	device = Devs.Button;
	list = XListInputDevices(display, &ndevices);
	for (i=0; i<ndevices; i++, list++)
	    if (list->id == Devs.Button->device_id)
		{
		any = (XAnyClassPtr) (list->inputclassinfo);
		for (j=0; j<list->num_classes; j++)
		    {
		    if (any->class == ButtonClass)
			{
			nbtns = ((XButtonInfo *) any)->num_buttons;
			break;
			}
		    any = (XAnyClassPtr) ((char *) any + any->length);
		    }
		break;
		}
	modifier_device = Devs.Mod;
	for (i=1;i<nbtns;i++)
	    {
	    startcall(display);
	    if (isdeleted())
	    	return;
	    ret = XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	    endcall(display);
	    if (geterr() != Success) {
	    	report("Got %s, Expecting Success", errorname(geterr()));
	    	FAIL;
	    }
	    XSync(display,0);

	    if (noext(1))
		return;
	    warppointer(display, grab_window, 1, 1);
	    devicebuttonpress (display, Devs.Button, i);
	    XSync (display, 0);

	    ret = XGrabDevice(client1, Devs.Button, grab_window, True, 0, NULL,
		GrabModeAsync, GrabModeAsync, CurrentTime);
	    if (ret != AlreadyGrabbed)
		{
		report("Pressing a button did not activate the grab.");
		FAIL;
		}
	    else
		{
		CHECK;
		count++;
		}
	    XUngrabDeviceButton(display, Devs.Button, AnyButton, AnyModifier,
		NULL, grab_window);
	    XSync(display,0);
	    devicebuttonrel (display, Devs.Button, i);
	    }
	devicerelbuttons (Devs.Button);
        XCloseDisplay(client1);
	CHECKPASS(count);

	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int ret;
Display *client1;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XGrabDeviceButton-9.(B)");
	report_assertion("When the event window for an active grab becomes not");
	report_assertion("viewable, then the grab is released automatically.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Establish a passive grab on an input device extension device.");
	report_strategy("Activate the grab by pressing a button on the device.");
	report_strategy("Verify that the grab is active by trying to establish another active grab");
	report_strategy("from a different client, and verifying that AlreadyGrabbed is returned.");
	report_strategy("Make the grab window non-viewable.");
	report_strategy("Attempt another active grab and verify that it works this time.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask | ModMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}
	device = Devs.Button;
	modifier_device = Devs.Mod;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	if (noext(1))
	    return;
	warppointer(display, grab_window, 1, 1);
	devicebuttonpress (display, Devs.Button, Button1);
	XSync (display, 0);

	ret = XGrabDevice(client1, Devs.Button, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != AlreadyGrabbed)
	    FAIL;
	else
	    CHECK;
	XUnmapWindow(display,grab_window);
	XSync(display,0);

	grab_window = defwin(display);
	ret = XGrabDevice(client1, Devs.Button, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != Success)
	    FAIL;
	else
	    CHECK;
	devicebuttonrel (display, Devs.Button, Button1);
	devicerelbuttons (Devs.Button);
	XUngrabDeviceButton(display, device, AnyButton, AnyModifier, modifier_device, grab_window);
        XUngrabDevice(client1, Devs.Button, CurrentTime);
        XSync(client1, 0);
        XCloseDisplay(client1);
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

Display *client1;
int ret;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XGrabDeviceButton-10.(B)");
	report_assertion("NULL may be specified as the modifier device. This will");
	report_assertion("cause the X keyboard to be used as the modifier device.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Specify NULL as the modifier device.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: Input extension button device not present.\n", TestName);
	    return;
	    }
	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}
	device = Devs.Button;
	modifier_device = NULL;
	modifiers = wantmods(display, 1);
	if (modifiers == 0) {
		untested("No available modifier keys");
		return;
	} else
		CHECK;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (noext(1))
	    {
	    untested("%d: No XTest extension, can't complete test.",TestName);
	    return;
	    }
	warppointer(display, grab_window, 1, 1);
	modpress(display, modifiers);
	devicebuttonpress (display, Devs.Button, Button1);
	XSync (display, 0);

	ret = XGrabDevice(client1, Devs.Button, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != AlreadyGrabbed)
	    {
	    report("%s: Grab failed to activate.", TestName);
	    FAIL;
	    }
	else
	    CHECK;

	modrel(display, modifiers);
	devicebuttonrel (display, Devs.Button, Button1);
	devicerelbuttons (Devs.Button);
	relalldev();
	XUngrabDeviceButton(display, device, AnyButton, AnyModifier,
		NULL, grab_window);
        XUngrabDevice(client1, Devs.Button, CurrentTime);
        XSync(client1,0);
        XCloseDisplay(client1);
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

int ret, coremask, devmask;
Display *client1;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XGrabDeviceButton-11.(B)");
	report_assertion("If a modifier device other than the core keyboard is");
	report_assertion("specified, pressing the specified button while the specified");
	report_assertion("modifiers are down on the core keyboard will not cause the");
	report_assertion("grab to be activated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Set up a grab with a modifier device other than the core keyboard.");
	report_strategy("Press the equivalent modifiers on the core keyboard");
	report_strategy("Press the specified button.");
	report_strategy("Verify that the grab is not activated.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask | ModMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }

	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}
	device = Devs.Button;
	coremask = wantmods(display, 3);
	devmask = wantdevmods(display, Devs.Mod, 3);
	modifiers = coremask & devmask;
	if (!modifiers)
	    {
	    report("Can't find equivalent modifiers on core and extension devs.");
	    UNTESTED;
	    return;
	    }
	else
	    CHECK;
	modifier_device = Devs.Mod;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	if (noext(1))
	    {
	    report("%d: No XTest extension, can't complete test.",TestName);
	    UNTESTED;
	    return;
	    }
	warppointer(display, grab_window, 1, 1);
	modpress(display, modifiers);
	devicebuttonpress (display, Devs.Button, Button1);
	XSync (display, 0);

	ret = XGrabDevice(client1, Devs.Button, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret == AlreadyGrabbed)
	    {
	    report("Pressing modifiers on the core keyboard activated the grab.");
	    FAIL;
	    }
	else
	    CHECK;

	modrel(display, modifiers);
	devicebuttonrel (display, Devs.Button, Button1);
	devicerelbuttons (Devs.Button);
	relalldev();
        XUngrabDevice(client1, Devs.Button, CurrentTime);
        XSync(client1,0);
        XCloseDisplay(client1);
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mval.tmc.29200 */
/* End of included file Mval.tmc.29200 */

static void t012(){

#undef	VALUE_ARG
#define	VALUE_ARG modifiers
#undef	VALUE_LIST
#define	VALUE_LIST modifiersvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE unsigned
#undef	NOTMEMBER
#define	NOTMEMBER notmaskmember
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XGrabDeviceButton-12.(A)");
	report_assertion("When the value of modifiers is not a bitwise combination of");
	report_assertion("ShiftMask, LockMask, ControlMask, Mod1Mask, Mod2Mask,");
	report_assertion("Mod3Mask, Mod4Mask, Mod5Mask or AnyModifier, then a");
	report_assertion("BadValue error occurs.");

	report_strategy("Call XGrabDeviceButton with a bad value for the modifiers argument.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	modifier_device = NULL;
	modifiers = ~0;

	button = 1;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		CHECK;

	else
		FAIL;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mval.tmc.29200 */
/* End of included file Mval.tmc.29200 */

static void t013(){

#undef	VALUE_ARG
#define	VALUE_ARG owner_events
#undef	VALUE_LIST
#define	VALUE_LIST owner_eventsvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XGrabDeviceButton-13.(A)");
	report_assertion("When the value of owner_events is other than True or False,");
	report_assertion("then a BadValue error occurs.");

	report_strategy("Call XGrabDeviceButton with a bad value for the owner_events argument.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	modifier_device = NULL;
	owner_events = 2;

	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		CHECK;

	else
		FAIL;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mval.tmc.29200 */
/* End of included file Mval.tmc.29200 */

static void t014(){

#undef	VALUE_ARG
#define	VALUE_ARG this_device_mode
#undef	VALUE_LIST
#define	VALUE_LIST this_device_modevallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XGrabDeviceButton-14.(A)");
	report_assertion("When the value of this_device_mode is other than");
	report_assertion("GrabModeSync or GrabModeAsync, then a BadValue error");
	report_assertion("occurs.");

	report_strategy("Call XGrabDeviceButton with a bad value for the this_device_mode argument.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	modifier_device = NULL;
	this_device_mode = 2;

	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		CHECK;

	else
		FAIL;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mval.tmc.29200 */
/* End of included file Mval.tmc.29200 */

static void t015(){

#undef	VALUE_ARG
#define	VALUE_ARG other_devices_mode
#undef	VALUE_LIST
#define	VALUE_LIST other_devices_modevallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion XGrabDeviceButton-15.(A)");
	report_assertion("When the value of other_devices_mode is other than");
	report_assertion("GrabModeSync or GrabModeAsync, then a BadValue error");
	report_assertion("occurs.");

	report_strategy("Call XGrabDeviceButton with a bad value for the other_devices_mode argument.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	modifier_device = NULL;
	other_devices_mode = 2;

	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		PASS;

	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAcc1.mc */
/* End of included file error/EAcc1.mc */

static void t016(){

Display	*client1;
int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion XGrabDeviceButton-16.(A)");
	report_assertion("When an attempt to grab a key/button combination already");
	report_assertion("grabbed by another client is made, then a BadAccess error");
	report_assertion("occurs.");

	report_strategy("Grab a button.");
	report_strategy("Create new client, client1.");
	report_strategy("Attempt to grab same button with client1.");
	report_strategy("Verify that a BadAccess error occurs.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(ModMask | BtnMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	modifier_device = Devs.Mod;

	XGrabDeviceButton(Dsp, device, button, modifiers, modifier_device,
		grab_window, owner_events, event_count, event_list,
		this_device_mode, other_devices_mode);
	XSync (Dsp,0);
	if (isdeleted()) {
		delete("Could not set up initial grab");
		return;
	}

	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}

	display = client1;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != BadAccess) {
		report("Got %s, Expecting BadAccess", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadAccess)
		PASS;
	else
		FAIL;
        XUngrabDevice(Dsp, Devs.Button, CurrentTime);
        XSync(Dsp,0);
        XCloseDisplay(client1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t017(){

int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion XGrabDeviceButton-17.(B)");
	report_assertion("When a call to XGrabDeviceButton is made specifying an");
	report_assertion("invalid window, a BadWindow error will result.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Specify an invalid window as the target window.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	modifier_device = NULL;
	grab_window = 0;

	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}
	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t018(){

int 	pass = 0, fail = 0;

 	report_purpose(18);

	report_assertion("Assertion XGrabDeviceButton-18.(B)");
	report_assertion("When a call to XGrabDeviceButton is made specifying a");
	report_assertion("device with no keys as the modifier device a BadMatch error");
	report_assertion("will result.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Specify a device with no keys as the modifier device.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask | NKeysMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	modifier_device = Devs.NoKeys;

	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);
	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t019(){

XDevice bogus;
XID baddevice;
int 	pass = 0, fail = 0;

 	report_purpose(19);

	report_assertion("Assertion XGrabDeviceButton-19.(B)");
	report_assertion("When a call to XGrabDeviceButton is made specifying an");
	report_assertion("invalid grab device, a BadDevice error will result.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Specify an invalid device.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	BadDevice(display, baddevice);
	device = &bogus;
	bogus.device_id = 128;
	modifier_device = Devs.Mod;

	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	if (geterr() == baddevice)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t020(){

XDevice bogus;
XID baddevice;
int 	pass = 0, fail = 0;

 	report_purpose(20);

	report_assertion("Assertion XGrabDeviceButton-20.(B)");
	report_assertion("When a call to XGrabDeviceButton is made specifying an");
	report_assertion("invalid modifier device, a BadDevice error will result.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Specify an invalid modifier device.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	BadDevice(display, baddevice);
	device = Devs.Button;
	modifier_device = &bogus;
	bogus.device_id = 128;

	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	if (geterr() == baddevice)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t021(){

XEventClass eclass = -1;
XID badclass;
int 	pass = 0, fail = 0;

 	report_purpose(21);

	report_assertion("Assertion XGrabDeviceButton-21.(B)");
	report_assertion("When a call to XGrabDeviceButton is made specifying an");
	report_assertion("invalid event class, a BadClass error will result.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Specify an invalid event class.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(ModMask | BtnMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	BadClass(display,badclass);
	device = Devs.Button;
	modifier_device = Devs.Mod;
	event_count = 1;
	event_list = &eclass;

	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != badclass) {
		report("Got %s, Expecting badclass", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	if (geterr() == badclass)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ t021, 21 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
