/*
 * Copyright © 2009 Intel Corporation
 * Copyright © 1998 Keith Packard
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 *
 * Authors:
 *    Zhigang Gong <zhigang.gong@gmail.com>
 *
 */

#include "glamor_priv.h"

static Bool
_glamor_add_traps(PicturePtr pPicture,
		  INT16 x_off, 
		  INT16 y_off, int ntrap, xTrap * traps,
		  Bool fallback)
{
	if (!fallback
	    && ( !pPicture->pDrawable 
		 || glamor_ddx_fallback_check_pixmap(pPicture->pDrawable)))
		return FALSE;

	if (glamor_prepare_access_picture(pPicture, GLAMOR_ACCESS_RW)) {
		fbAddTraps(pPicture, x_off, y_off, ntrap, traps);
		glamor_finish_access_picture(pPicture, GLAMOR_ACCESS_RW);
	}

	return TRUE;
}

void
glamor_add_traps(PicturePtr pPicture,
		 INT16 x_off, 
		 INT16 y_off, int ntrap, xTrap * traps)
{
	_glamor_add_traps(pPicture, x_off, y_off, ntrap, traps, TRUE);
}

Bool
glamor_add_traps_nf(PicturePtr pPicture,
		    INT16 x_off, 
		    INT16 y_off, int ntrap, xTrap * traps)
{
	return _glamor_add_traps(pPicture, x_off, y_off, ntrap, traps, FALSE);
}

