/* Make table of content */

#include <stdio.h>
#include <stdlib.h>

#include <pcap.h>

#include "pcap-int.h"

#include "gnuc.h"

#ifdef WIN32
#include <windows.h>

static void Say (const char* A) 
{
	MessageBox(NULL,A,"QParser",MB_OK );
}
#endif

FILE *toc_f;

pcap_dumper_t * pcap_toc_open(const char *fname) 
{
	if (fname[0] == '-' && fname[1] == '\0')
		toc_f = stdout;
	else { 
		toc_f = fopen(fname, "w");
		if (toc_f == NULL) {
#ifdef WIN32
			Say("Cannot open Index file");
#else
			fprintf(stderr, "Cannot open Index file\n");
#endif
			return (NULL);
		}
	}
	return ((pcap_dumper_t *)toc_f);
}

void pcap_toc_close() 
{
	if (toc_f) fclose (toc_f);
}
