#ifndef _PSIGNAL_H /* { */
#define _PSIGNAL_H
/*
 * The type of a signal handler is declared inconsistantly in the header files.
 * Extremely picky compilers may require adjustment here; most don't complain.
 * The problem is what the type of signal's argument really is.  POSIX doesn't
 * state this precisely; what is the prototype of the signal handler's
 * declaration supposed to look like exactly?  Like Sun, I would guess 
 *     void handler(int,...) 
 * but most vendors use void handler().
 *
 * Note:  The HP-UX C++ compiler doesn't consider a typedef type compatable
 *        with an explicitly declared type that's the same.  Gnu g++ can't
 *        handle old style argument declaractions in function definitions.
 */
#if defined(__STDC__) || defined(__cplusplus)	/* { */

#if (defined(_HPUX_SOURCE) && defined(__cplusplus)) || defined(linux)	/* { */
typedef void (*pfv)(int);
#else	/* } { */
typedef void (*pfv)();				/* POSIX (normal case) */
#if 0
typedef void (*pfv)(int, ...);			/* sunOS 4.1.2 C++ */
#endif

#endif	/* } !int arg*/

extern pfv psignal(int, pfv);
#else	/* } { !STDC */

typedef void (*pfv)();
extern pfv psignal();

#endif	/* } !STDC */

#endif	/* } */
