" Vim script to download a missing spell file
" Maintainer:	Bram Moolenaar <Bram@vim.org>
" Last Change:	2006 Jan 31

if !exists('g:spellfile_URL')
  let g:spellfile_URL = 'ftp://ftp.vim.org/pub/vim/unstable/runtime/spell'
endif
let s:spellfile_URL = ''    " Start with nothing so that s:donedict is reset.

" This function is used for the spellfile plugin.
function! spellfile#LoadFile(lang)
  " If the netrw plugin isn't loaded we silently skip everything.
  if !exists(":Nread")
    if &verbose
      echomsg 'spellfile#LoadFile(): Nread command is not available.'
    endif
    return
  endif

  " If the URL changes we try all files again.
  if s:spellfile_URL != g:spellfile_URL
    let s:donedict = {}
    let s:spellfile_URL = g:spellfile_URL
  endif

  " I will say this only once!
  if has_key(s:donedict, a:lang . &enc)
    return
  endif
  let s:donedict[a:lang . &enc] = 1

  " Find spell directories we can write in.
  let dirlist = []
  let dirchoices = '&Cancel'
  for dir in split(globpath(&rtp, 'spell'), "\n")
    if filewritable(dir) == 2
      call add(dirlist, dir)
      let dirchoices .= "\n&" . len(dirlist)
    endif
  endfor
  if len(dirlist) == 0
    if &verbose
      echomsg 'spellfile#LoadFile(): There is no writable spell directory.'
    endif
    return
  endif

  echo 'Cannot find spell file for "' . a:lang . '" in ' . &enc
  if confirm('Do you want me to try downloading it? ', "&Yes\n&No", 2) == 1
    let enc = &encoding
    if enc == 'iso-8859-15'
      let enc = 'latin1'
    endif
    let fname = a:lang . '.' . enc . '.spl'

    new
    setlocal bin
    echo 'downloading ' . fname . '...'
    exe 'Nread ' g:spellfile_URL . '/' . fname
    if getline(2) !~ 'VIMspell'
      " Didn't work, perhaps there is an ASCII one.
      g/^/d
      let fname = a:lang . '.ascii.spl'
      echo 'Could not find it, trying ' . fname . '...'
      exe 'Nread ' g:spellfile_URL . '/' . fname
      if getline(2) !~ 'VIMspell'
	echo 'Sorry, downloading failed'
	bwipe!
	return
      endif
    endif

    " Delete the empty first line and mark the file unmodified.
    1d
    set nomod

    let msg = "In which directory shall I write the file:"
    for i in range(len(dirlist))
      let msg .= "\n" . (i + 1) . '. ' . dirlist[i]
    endfor
    let i = confirm(msg, dirchoices)
    if i > 1
      exe "write " . escape(dirlist[i - 2], ' ') . '/' . fname
    endif

    " TODO: also download the .sug file, if the user wants to.

    bwipe
  endif
endfunc
