
#include <fli.h>

int fli_map_next_color (int r, int g, int b)
{
    int
	red, green, blue;
    register int
	index;

    /* loop through colormap to find next free color */
    for (index = 0; index <= FL_FREE_COL16; index++)
    {
	/* obtain RGB components */ 
	fl_getmcolor (index, &red, &green, &blue);

	/* if equal, don't redefine */ 
	if (red == r && green == g && blue == b)
	    return (index);

	/* if unused: redefine the slot, if in free colors range */ 
	if (index >= FL_FREE_COL1 &&
	    red == 255 && green == 255 && blue == 255)
	{
	    fl_mapcolor (index, r, g, b);
	    return (index);
	}
    }

    /* no more empty slots */ 
    return (-1);
}
