/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.CompassPoint;
import cds.healpix.FlatHashIterator;
import cds.healpix.ListOfHash;
import java.util.Arrays;
import java.util.NoSuchElementException;

public final class NeighbourList
implements ListOfHash {
    private final int depth;
    private final long[] neighbours = new long[CompassPoint.MainWind.size()];
    private int size;
    private final CompassPoint.MainWind[] neighMainWinds = new CompassPoint.MainWind[CompassPoint.MainWind.size()];
    private final int[] indirections = new int[CompassPoint.MainWind.size()];

    public NeighbourList(int depth) {
        this.depth = depth;
        this.clear();
    }

    public void clear() {
        Arrays.fill(this.indirections, -1);
        Arrays.fill((Object[])this.neighMainWinds, null);
        this.size = 0;
    }

    public boolean contains(CompassPoint.MainWind mainWind) {
        int i = this.indirections[mainWind.getIndex()];
        return i != -1;
    }

    public long get(CompassPoint.MainWind mainWind) {
        int i = this.indirections[mainWind.getIndex()];
        return i == -1 ? (long)i : this.neighbours[i];
    }

    void put(long neighbourHash, CompassPoint.MainWind mainWind) {
        this.neighbours[this.size] = neighbourHash;
        this.neighMainWinds[this.size] = mainWind;
        this.indirections[mainWind.getIndex()] = this.size++;
    }

    public void sortByHashAsc() {
        if (this.size > 1) {
            int sizem1 = this.size - 1;
            for (int from = 0; from < sizem1; ++from) {
                int iMin = NeighbourList.indexOfMinValue(this.neighbours, from, this.size);
                if (iMin == from) continue;
                long tmpH = this.neighbours[from];
                this.neighbours[from] = this.neighbours[iMin];
                this.neighbours[iMin] = tmpH;
                CompassPoint.MainWind tmpMW = this.neighMainWinds[from];
                this.neighMainWinds[from] = this.neighMainWinds[iMin];
                this.neighMainWinds[iMin] = tmpMW;
            }
            int i = 0;
            while (i < this.size) {
                CompassPoint.MainWind mw = this.neighMainWinds[i];
                this.indirections[mw.getIndex()] = i++;
            }
        }
    }

    private static final int indexOfMinValue(long[] array, int from, int to) {
        int iMin = from;
        long vMin = array[from];
        for (int i = from + 1; i < to; ++i) {
            if (array[i] >= vMin) continue;
            vMin = array[i];
            iMin = i;
        }
        return iMin;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public long get(int i) {
        this.checkIndex(i);
        return this.neighbours[i];
    }

    public CompassPoint.MainWind getDirection(int i) {
        this.checkIndex(i);
        return this.neighMainWinds[i];
    }

    private final void checkIndex(int i) {
        if (i >= this.size) {
            throw new IndexOutOfBoundsException("i: " + i + " ; size: " + this.size);
        }
    }

    @Override
    public void arraycopy(int srcPos, long[] dest, int destPos, int length) {
        if (srcPos + length > this.size) {
            throw new IndexOutOfBoundsException("srcPos + length > source size");
        }
        System.arraycopy(this.neighbours, srcPos, dest, destPos, length);
    }

    @Override
    public FlatHashIterator iterator() {
        return new FlatHashIterator(){
            private int i = 0;

            @Override
            public int depth() {
                return NeighbourList.this.depth;
            }

            @Override
            public boolean hasNext() {
                return this.i < NeighbourList.this.size;
            }

            @Override
            public long next() {
                if (this.i >= NeighbourList.this.size) {
                    throw new NoSuchElementException();
                }
                return NeighbourList.this.neighbours[this.i++];
            }
        };
    }
}

