"""
Definition of constants for vxlapi.
"""

# Import Python Modules
# ==============================
from enum import IntEnum, IntFlag


MAX_MSG_LEN = 8
XL_CAN_MAX_DATA_LEN = 64
XL_INVALID_PORTHANDLE = -1


class XL_AC_Flags(IntEnum):
    XL_ACTIVATE_NONE = 0
    XL_ACTIVATE_RESET_CLOCK = 8


class XL_AcceptanceFilter(IntEnum):
    XL_CAN_STD = 1
    XL_CAN_EXT = 2


class XL_BusCapabilities(IntFlag):
    XL_BUS_COMPATIBLE_CAN = 1
    XL_BUS_ACTIVE_CAP_CAN = 1 << 16
    XL_BUS_COMPATIBLE_LIN = 2
    XL_BUS_ACTIVE_CAP_LIN = 2 << 16
    XL_BUS_COMPATIBLE_FLEXRAY = 4
    XL_BUS_ACTIVE_CAP_FLEXRAY = 4 << 16
    XL_BUS_COMPATIBLE_MOST = 16
    XL_BUS_ACTIVE_CAP_MOST = 16 << 16
    XL_BUS_COMPATIBLE_DAIO = 64
    XL_BUS_ACTIVE_CAP_DAIO = 64 << 16
    XL_BUS_COMPATIBLE_J1708 = 256
    XL_BUS_ACTIVE_CAP_J1708 = 256 << 16
    XL_BUS_COMPATIBLE_KLINE = 2048
    XL_BUS_ACTIVE_CAP_KLINE = 2048 << 16
    XL_BUS_COMPATIBLE_ETHERNET = 4096
    XL_BUS_ACTIVE_CAP_ETHERNET = 4096 << 16
    XL_BUS_COMPATIBLE_A429 = 8192
    XL_BUS_ACTIVE_CAP_A429 = 8192 << 16


class XL_BusStatus(IntEnum):
    XL_CHIPSTAT_BUSOFF = 1
    XL_CHIPSTAT_ERROR_PASSIVE = 2
    XL_CHIPSTAT_ERROR_WARNING = 4
    XL_CHIPSTAT_ERROR_ACTIVE = 8


class XL_BusTypes(IntFlag):
    XL_BUS_TYPE_NONE = 0  # =0x00000000
    XL_BUS_TYPE_CAN = 1  # =0x00000001
    XL_BUS_TYPE_LIN = 2  # =0x00000002
    XL_BUS_TYPE_FLEXRAY = 4  # =0x00000004
    XL_BUS_TYPE_AFDX = 8  # =0x00000008
    XL_BUS_TYPE_MOST = 16  # =0x00000010
    XL_BUS_TYPE_DAIO = 64  # =0x00000040
    XL_BUS_TYPE_J1708 = 256  # =0x00000100
    XL_BUS_TYPE_KLINE = 2048  # =0x00000800
    XL_BUS_TYPE_ETHERNET = 4096  # =0x00001000
    XL_BUS_TYPE_A429 = 8192  # =0x00002000


class XL_CANFD_BusParams_CanOpMode(IntFlag):
    XL_BUS_PARAMS_CANOPMODE_CAN20 = 1
    XL_BUS_PARAMS_CANOPMODE_CANFD = 2
    XL_BUS_PARAMS_CANOPMODE_CANFD_NO_ISO = 8


class XL_CANFD_ConfigOptions(IntEnum):
    CANFD_CONFOPT_NO_ISO = 8


class XL_CANFD_RX_EV_ERROR_errorCode(IntEnum):
    XL_CAN_ERRC_BIT_ERROR = 1
    XL_CAN_ERRC_FORM_ERROR = 2
    XL_CAN_ERRC_STUFF_ERROR = 3
    XL_CAN_ERRC_OTHER_ERROR = 4
    XL_CAN_ERRC_CRC_ERROR = 5
    XL_CAN_ERRC_ACK_ERROR = 6
    XL_CAN_ERRC_NACK_ERROR = 7
    XL_CAN_ERRC_OVLD_ERROR = 8
    XL_CAN_ERRC_EXCPT_ERROR = 9


class XL_CANFD_RX_EventTags(IntEnum):
    XL_SYNC_PULSE = 11
    XL_CAN_EV_TAG_RX_OK = 1024
    XL_CAN_EV_TAG_RX_ERROR = 1025
    XL_CAN_EV_TAG_TX_ERROR = 1026
    XL_CAN_EV_TAG_TX_REQUEST = 1027
    XL_CAN_EV_TAG_TX_OK = 1028
    XL_CAN_EV_TAG_CHIP_STATE = 1033


class XL_CANFD_RX_MessageFlags(IntFlag):
    XL_CAN_RXMSG_FLAG_NONE = 0
    XL_CAN_RXMSG_FLAG_EDL = 1
    XL_CAN_RXMSG_FLAG_BRS = 2
    XL_CAN_RXMSG_FLAG_ESI = 4
    XL_CAN_RXMSG_FLAG_RTR = 16
    XL_CAN_RXMSG_FLAG_EF = 512
    XL_CAN_RXMSG_FLAG_ARB_LOST = 1024
    XL_CAN_RXMSG_FLAG_WAKEUP = 8192
    XL_CAN_RXMSG_FLAG_TE = 16384


class XL_CANFD_TX_EventTags(IntEnum):
    XL_CAN_EV_TAG_TX_MSG = 1088  # =0x0440
    XL_CAN_EV_TAG_TX_ERRFR = 1089  # =0x0441


class XL_CANFD_TX_MessageFlags(IntFlag):
    XL_CAN_TXMSG_FLAG_NONE = 0
    XL_CAN_TXMSG_FLAG_EDL = 1
    XL_CAN_TXMSG_FLAG_BRS = 2
    XL_CAN_TXMSG_FLAG_RTR = 16
    XL_CAN_TXMSG_FLAG_HIGHPRIO = 128
    XL_CAN_TXMSG_FLAG_WAKEUP = 512


class XL_ChannelCapabilities(IntFlag):
    XL_CHANNEL_FLAG_TIME_SYNC_RUNNING = 1
    XL_CHANNEL_FLAG_NO_HWSYNC_SUPPORT = 1024
    XL_CHANNEL_FLAG_SPDIF_CAPABLE = 16384
    XL_CHANNEL_FLAG_CANFD_BOSCH_SUPPORT = 536870912
    XL_CHANNEL_FLAG_CMACTLICENSE_SUPPORT = 1073741824
    XL_CHANNEL_FLAG_CANFD_ISO_SUPPORT = 2147483648


class XL_EventFlags(IntEnum):
    XL_EVENT_FLAG_OVERRUN = 1


class XL_EventTags(IntEnum):
    XL_NO_COMMAND = 0
    XL_RECEIVE_MSG = 1
    XL_CHIP_STATE = 4
    XL_TRANSCEIVER = 6
    XL_TIMER = 8
    XL_TRANSMIT_MSG = 10
    XL_SYNC_PULSE = 11
    XL_APPLICATION_NOTIFICATION = 15


class XL_InterfaceVersion(IntEnum):
    XL_INTERFACE_VERSION_V2 = 2
    XL_INTERFACE_VERSION_V3 = 3
    XL_INTERFACE_VERSION = XL_INTERFACE_VERSION_V3
    XL_INTERFACE_VERSION_V4 = 4


class XL_MessageFlags(IntEnum):
    XL_CAN_MSG_FLAG_NONE = 0
    XL_CAN_MSG_FLAG_ERROR_FRAME = 1
    XL_CAN_MSG_FLAG_OVERRUN = 2
    XL_CAN_MSG_FLAG_NERR = 4
    XL_CAN_MSG_FLAG_WAKEUP = 8
    XL_CAN_MSG_FLAG_REMOTE_FRAME = 16
    XL_CAN_MSG_FLAG_RESERVED_1 = 32
    XL_CAN_MSG_FLAG_TX_COMPLETED = 64
    XL_CAN_MSG_FLAG_TX_REQUEST = 128
    XL_CAN_MSG_FLAG_SRR_BIT_DOM = 512


class XL_MessageFlagsExtended(IntEnum):
    XL_CAN_EXT_MSG_ID = 2147483648


class XL_OutputMode(IntEnum):
    XL_OUTPUT_MODE_SILENT = 0
    XL_OUTPUT_MODE_NORMAL = 1
    XL_OUTPUT_MODE_TX_OFF = 2
    XL_OUTPUT_MODE_SJA_1000_SILENT = 3


class XL_Sizes(IntEnum):
    XL_MAX_LENGTH = 31
    XL_MAX_APPNAME = 32
    XL_MAX_NAME_LENGTH = 48
    XLEVENT_SIZE = 48
    XL_CONFIG_MAX_CHANNELS = 64
    XL_APPLCONFIG_MAX_CHANNELS = 256


class XL_Status(IntEnum):
    XL_SUCCESS = 0  # =0x0000
    XL_PENDING = 1  # =0x0001
    XL_ERR_QUEUE_IS_EMPTY = 10  # =0x000A
    XL_ERR_QUEUE_IS_FULL = 11  # =0x000B
    XL_ERR_TX_NOT_POSSIBLE = 12  # =0x000C
    XL_ERR_NO_LICENSE = 14  # =0x000E
    XL_ERR_WRONG_PARAMETER = 101  # =0x0065
    XL_ERR_TWICE_REGISTER = 110  # =0x006E
    XL_ERR_INVALID_CHAN_INDEX = 111  # =0x006F
    XL_ERR_INVALID_ACCESS = 112  # =0x0070
    XL_ERR_PORT_IS_OFFLINE = 113  # =0x0071
    XL_ERR_CHAN_IS_ONLINE = 116  # =0x0074
    XL_ERR_NOT_IMPLEMENTED = 117  # =0x0075
    XL_ERR_INVALID_PORT = 118  # =0x0076
    XL_ERR_HW_NOT_READY = 120  # =0x0078
    XL_ERR_CMD_TIMEOUT = 121  # =0x0079
    XL_ERR_CMD_HANDLING = 122  # = 0x007A
    XL_ERR_HW_NOT_PRESENT = 129  # =0x0081
    XL_ERR_NOTIFY_ALREADY_ACTIVE = 131  # =0x0083
    XL_ERR_INVALID_TAG = 132  # = 0x0084
    XL_ERR_INVALID_RESERVED_FLD = 133  # = 0x0085
    XL_ERR_INVALID_SIZE = 134  # = 0x0086
    XL_ERR_INSUFFICIENT_BUFFER = 135  # = 0x0087
    XL_ERR_ERROR_CRC = 136  # = 0x0088
    XL_ERR_BAD_EXE_FORMAT = 137  # = 0x0089
    XL_ERR_NO_SYSTEM_RESOURCES = 138  # = 0x008A
    XL_ERR_NOT_FOUND = 139  # = 0x008B
    XL_ERR_INVALID_ADDRESS = 140  # = 0x008C
    XL_ERR_REQ_NOT_ACCEP = 141  # = 0x008D
    XL_ERR_INVALID_LEVEL = 142  # = 0x008E
    XL_ERR_NO_DATA_DETECTED = 143  # = 0x008F
    XL_ERR_INTERNAL_ERROR = 144  # = 0x0090
    XL_ERR_UNEXP_NET_ERR = 145  # = 0x0091
    XL_ERR_INVALID_USER_BUFFER = 146  # = 0x0092
    XL_ERR_INVALID_PORT_ACCESS_TYPE = 147  # = 0x0093
    XL_ERR_NO_RESOURCES = 152  # =0x0098
    XL_ERR_WRONG_CHIP_TYPE = 153  # =0x0099
    XL_ERR_WRONG_COMMAND = 154  # =0x009A
    XL_ERR_INVALID_HANDLE = 155  # =0x009B
    XL_ERR_RESERVED_NOT_ZERO = 157  # =0x009D
    XL_ERR_INIT_ACCESS_MISSING = 158  # =0x009E
    XL_ERR_WRONG_VERSION = 160  # = 0x00A0
    XL_ERR_CANNOT_OPEN_DRIVER = 201  # =0x00C9
    XL_ERR_WRONG_BUS_TYPE = 202  # =0x00CA
    XL_ERR_DLL_NOT_FOUND = 203  # =0x00CB
    XL_ERR_INVALID_CHANNEL_MASK = 204  # =0x00CC
    XL_ERR_NOT_SUPPORTED = 205  # =0x00CD
    XL_ERR_CONNECTION_BROKEN = 210  # =0x00D2
    XL_ERR_CONNECTION_CLOSED = 211  # =0x00D3
    XL_ERR_INVALID_STREAM_NAME = 212  # =0x00D4
    XL_ERR_CONNECTION_FAILED = 213  # =0x00D5
    XL_ERR_STREAM_NOT_FOUND = 214  # =0x00D6
    XL_ERR_STREAM_NOT_CONNECTED = 215  # =0x00D7
    XL_ERR_QUEUE_OVERRUN = 216  # =0x00D8
    XL_ERROR = 255  # =0x00FF

    # CAN FD Error Codes
    XL_ERR_INVALID_DLC = 513  # =0x0201
    XL_ERR_INVALID_CANID = 514  # =0x0202
    XL_ERR_INVALID_FDFLAG_MODE20 = 515  # =0x203
    XL_ERR_EDL_RTR = 516  # =0x204
    XL_ERR_EDL_NOT_SET = 517  # =0x205
    XL_ERR_UNKNOWN_FLAG = 518  # =0x206


class XL_TimeSyncNewValue(IntEnum):
    XL_SET_TIMESYNC_NO_CHANGE = 0
    XL_SET_TIMESYNC_ON = 1
    XL_SET_TIMESYNC_OFF = 2


class XL_HardwareType(IntEnum):
    XL_HWTYPE_NONE = 0
    XL_HWTYPE_VIRTUAL = 1
    XL_HWTYPE_CANCARDX = 2
    XL_HWTYPE_CANAC2PCI = 6
    XL_HWTYPE_CANCARDY = 12
    XL_HWTYPE_CANCARDXL = 15
    XL_HWTYPE_CANCASEXL = 21
    XL_HWTYPE_CANCASEXL_LOG_OBSOLETE = 23
    XL_HWTYPE_CANBOARDXL = 25
    XL_HWTYPE_CANBOARDXL_PXI = 27
    XL_HWTYPE_VN2600 = 29
    XL_HWTYPE_VN2610 = XL_HWTYPE_VN2600
    XL_HWTYPE_VN3300 = 37
    XL_HWTYPE_VN3600 = 39
    XL_HWTYPE_VN7600 = 41
    XL_HWTYPE_CANCARDXLE = 43
    XL_HWTYPE_VN8900 = 45
    XL_HWTYPE_VN8950 = 47
    XL_HWTYPE_VN2640 = 53
    XL_HWTYPE_VN1610 = 55
    XL_HWTYPE_VN1630 = 57
    XL_HWTYPE_VN1640 = 59
    XL_HWTYPE_VN8970 = 61
    XL_HWTYPE_VN1611 = 63
    XL_HWTYPE_VN5240 = 64
    XL_HWTYPE_VN5610 = 65
    XL_HWTYPE_VN5620 = 66
    XL_HWTYPE_VN7570 = 67
    XL_HWTYPE_VN5650 = 68
    XL_HWTYPE_IPCLIENT = 69
    XL_HWTYPE_IPSERVER = 71
    XL_HWTYPE_VX1121 = 73
    XL_HWTYPE_VX1131 = 75
    XL_HWTYPE_VT6204 = 77
    XL_HWTYPE_VN1630_LOG = 79
    XL_HWTYPE_VN7610 = 81
    XL_HWTYPE_VN7572 = 83
    XL_HWTYPE_VN8972 = 85
    XL_HWTYPE_VN0601 = 87
    XL_HWTYPE_VN5640 = 89
    XL_HWTYPE_VX0312 = 91
    XL_HWTYPE_VH6501 = 94
    XL_HWTYPE_VN8800 = 95
    XL_HWTYPE_IPCL8800 = 96
    XL_HWTYPE_IPSRV8800 = 97
    XL_HWTYPE_CSMCAN = 98
    XL_HWTYPE_VN5610A = 101
    XL_HWTYPE_VN7640 = 102
    XL_HWTYPE_VX1135 = 104
    XL_HWTYPE_VN4610 = 105
    XL_HWTYPE_VT6306 = 107
    XL_HWTYPE_VT6104A = 108
    XL_HWTYPE_VN5430 = 109
    XL_HWTYPE_VTSSERVICE = 110
    XL_HWTYPE_VN1530 = 112
    XL_HWTYPE_VN1531 = 113
    XL_HWTYPE_VX1161A = 114
    XL_HWTYPE_VX1161B = 115
    XL_MAX_HWTYPE = 120


class XL_SyncPulseSource(IntEnum):
    XL_SYNC_PULSE_EXTERNAL = 0
    XL_SYNC_PULSE_OUR = 1
    XL_SYNC_PULSE_OUR_SHARED = 2
