# Example Sequences

This directory contains a variety of example FASTA files to be used to play with
`CAI`. Files ending with `.heg.fasta` are from the
[HEG-DB](http://genomes.urv.cat/HEG-DB/) and are to be used as reference sets,
whereas all other FASTA files contain only single CDSs.

## Directory

### Highly Expressed Genes

| File                                 | Species                                 | Sequences |
|--------------------------------------|-----------------------------------------|-----------|
| [banth1.heg.fasta](banth1.heg.fasta) | *Bacillus anthracis* str. Ames          | 330       |
| [ecol.heg.fasta](ecol.heg.fasta)     | *Escherichia coli*                      | 274       |
| [ngon.heg.fasta]()                   | *Neisseria gonorrhoeae*                 | 103       |
| [paer.heg.fasta](paer.heg.fasta)     | *Pseudomonas aeruginosa*                | 61        |
| [saur2.heg.fasta](saur2.heg.fasta)   | *Staphylococcus aureus* subsp. *aureus* | 137       |
| [styp2.heg.fasta](styp2.heg.fasta)   | *Salmonella enterica* subsp. *enterica* | 214       |

### CDSs

| File                                 | Description                                                      | Length  |
|--------------------------------------|------------------------------------------------------------------|---------|
| [BoNT.fasta](BoNT.fasta)             | *Clostridium botulinum* neurotoxin BoNT gene, complete CDS       | 3891 bp |
| [gfp.fasta](gfp.fasta)               | *Aequorea victoria* green-fluorescent protein mRNA, complete CDS | 717 bp  |
| [insulin.fasta](insulin.fasta)       | *Homo sapiens* insulin (INS) gene, complete CDS                  | 333 bp  |
| [luciferase.fasta](luciferase.fasta) | *Photinus pyralis* (firefly) luciferase gene, complete CDS       | 1653 bp |
| [oxytocin.fasta](oxytocin.fasta)     | *Homo sapiens* oxytocin mRNA, complete CDS                       | 376 bp  |
| [ricin.fasta](ricin.fasta)           | *Ricinus communis* ricin-like (LOC8287993), mRNA                 | 1750 bp |
