# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.1.3, generator: {generator})
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    import __init__ as _models


class AcrAccessToken(msrest.serialization.Model):
    """AcrAccessToken.

    :ivar access_token: The access token for performing authenticated requests.
    :vartype access_token: str
    """

    _attribute_map = {
        'access_token': {'key': 'access_token', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        access_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword access_token: The access token for performing authenticated requests.
        :paramtype access_token: str
        """
        super(AcrAccessToken, self).__init__(**kwargs)
        self.access_token = access_token


class AcrErrorInfo(msrest.serialization.Model):
    """Error information.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar detail: Error details.
    :vartype detail: any
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'detail': {'key': 'detail', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        detail: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message.
        :paramtype message: str
        :keyword detail: Error details.
        :paramtype detail: any
        """
        super(AcrErrorInfo, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.detail = detail


class AcrErrors(msrest.serialization.Model):
    """Acr error response describing why the operation failed.

    :ivar errors: Array of detailed error.
    :vartype errors: list[~container_registry.models.AcrErrorInfo]
    """

    _attribute_map = {
        'errors': {'key': 'errors', 'type': '[AcrErrorInfo]'},
    }

    def __init__(
        self,
        *,
        errors: Optional[List["_models.AcrErrorInfo"]] = None,
        **kwargs
    ):
        """
        :keyword errors: Array of detailed error.
        :paramtype errors: list[~container_registry.models.AcrErrorInfo]
        """
        super(AcrErrors, self).__init__(**kwargs)
        self.errors = errors


class AcrManifests(msrest.serialization.Model):
    """Manifest attributes.

    :ivar registry_login_server: Registry login server name. This is likely to be similar to
     {registry-name}.azurecr.io.
    :vartype registry_login_server: str
    :ivar repository: Image name.
    :vartype repository: str
    :ivar manifests: List of manifests.
    :vartype manifests: list[~container_registry.models.ManifestAttributesBase]
    :ivar link:
    :vartype link: str
    """

    _attribute_map = {
        'registry_login_server': {'key': 'registry', 'type': 'str'},
        'repository': {'key': 'imageName', 'type': 'str'},
        'manifests': {'key': 'manifests', 'type': '[ManifestAttributesBase]'},
        'link': {'key': 'link', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        registry_login_server: Optional[str] = None,
        repository: Optional[str] = None,
        manifests: Optional[List["_models.ManifestAttributesBase"]] = None,
        link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword registry_login_server: Registry login server name. This is likely to be similar to
         {registry-name}.azurecr.io.
        :paramtype registry_login_server: str
        :keyword repository: Image name.
        :paramtype repository: str
        :keyword manifests: List of manifests.
        :paramtype manifests: list[~container_registry.models.ManifestAttributesBase]
        :keyword link:
        :paramtype link: str
        """
        super(AcrManifests, self).__init__(**kwargs)
        self.registry_login_server = registry_login_server
        self.repository = repository
        self.manifests = manifests
        self.link = link


class AcrRefreshToken(msrest.serialization.Model):
    """AcrRefreshToken.

    :ivar refresh_token: The refresh token to be used for generating access tokens.
    :vartype refresh_token: str
    """

    _attribute_map = {
        'refresh_token': {'key': 'refresh_token', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        refresh_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword refresh_token: The refresh token to be used for generating access tokens.
        :paramtype refresh_token: str
        """
        super(AcrRefreshToken, self).__init__(**kwargs)
        self.refresh_token = refresh_token


class Annotations(msrest.serialization.Model):
    """Additional information provided through arbitrary metadata.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar created: Date and time on which the image was built (string, date-time as defined by
     https://tools.ietf.org/html/rfc3339#section-5.6).
    :vartype created: ~datetime.datetime
    :ivar authors: Contact details of the people or organization responsible for the image.
    :vartype authors: str
    :ivar url: URL to find more information on the image.
    :vartype url: str
    :ivar documentation: URL to get documentation on the image.
    :vartype documentation: str
    :ivar source: URL to get source code for building the image.
    :vartype source: str
    :ivar version: Version of the packaged software. The version MAY match a label or tag in the
     source code repository, may also be Semantic versioning-compatible.
    :vartype version: str
    :ivar revision: Source control revision identifier for the packaged software.
    :vartype revision: str
    :ivar vendor: Name of the distributing entity, organization or individual.
    :vartype vendor: str
    :ivar licenses: License(s) under which contained software is distributed as an SPDX License
     Expression.
    :vartype licenses: str
    :ivar name: Name of the reference for a target.
    :vartype name: str
    :ivar title: Human-readable title of the image.
    :vartype title: str
    :ivar description: Human-readable description of the software packaged in the image.
    :vartype description: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'created': {'key': 'org\\.opencontainers\\.image\\.created', 'type': 'iso-8601'},
        'authors': {'key': 'org\\.opencontainers\\.image\\.authors', 'type': 'str'},
        'url': {'key': 'org\\.opencontainers\\.image\\.url', 'type': 'str'},
        'documentation': {'key': 'org\\.opencontainers\\.image\\.documentation', 'type': 'str'},
        'source': {'key': 'org\\.opencontainers\\.image\\.source', 'type': 'str'},
        'version': {'key': 'org\\.opencontainers\\.image\\.version', 'type': 'str'},
        'revision': {'key': 'org\\.opencontainers\\.image\\.revision', 'type': 'str'},
        'vendor': {'key': 'org\\.opencontainers\\.image\\.vendor', 'type': 'str'},
        'licenses': {'key': 'org\\.opencontainers\\.image\\.licenses', 'type': 'str'},
        'name': {'key': 'org\\.opencontainers\\.image\\.ref\\.name', 'type': 'str'},
        'title': {'key': 'org\\.opencontainers\\.image\\.title', 'type': 'str'},
        'description': {'key': 'org\\.opencontainers\\.image\\.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        created: Optional[datetime.datetime] = None,
        authors: Optional[str] = None,
        url: Optional[str] = None,
        documentation: Optional[str] = None,
        source: Optional[str] = None,
        version: Optional[str] = None,
        revision: Optional[str] = None,
        vendor: Optional[str] = None,
        licenses: Optional[str] = None,
        name: Optional[str] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword created: Date and time on which the image was built (string, date-time as defined by
         https://tools.ietf.org/html/rfc3339#section-5.6).
        :paramtype created: ~datetime.datetime
        :keyword authors: Contact details of the people or organization responsible for the image.
        :paramtype authors: str
        :keyword url: URL to find more information on the image.
        :paramtype url: str
        :keyword documentation: URL to get documentation on the image.
        :paramtype documentation: str
        :keyword source: URL to get source code for building the image.
        :paramtype source: str
        :keyword version: Version of the packaged software. The version MAY match a label or tag in the
         source code repository, may also be Semantic versioning-compatible.
        :paramtype version: str
        :keyword revision: Source control revision identifier for the packaged software.
        :paramtype revision: str
        :keyword vendor: Name of the distributing entity, organization or individual.
        :paramtype vendor: str
        :keyword licenses: License(s) under which contained software is distributed as an SPDX License
         Expression.
        :paramtype licenses: str
        :keyword name: Name of the reference for a target.
        :paramtype name: str
        :keyword title: Human-readable title of the image.
        :paramtype title: str
        :keyword description: Human-readable description of the software packaged in the image.
        :paramtype description: str
        """
        super(Annotations, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.created = created
        self.authors = authors
        self.url = url
        self.documentation = documentation
        self.source = source
        self.version = version
        self.revision = revision
        self.vendor = vendor
        self.licenses = licenses
        self.name = name
        self.title = title
        self.description = description


class ArtifactManifestPlatform(msrest.serialization.Model):
    """The artifact's platform, consisting of operating system and architecture.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar digest: Required. Manifest digest.
    :vartype digest: str
    :ivar architecture: CPU architecture. Known values are: "386", "amd64", "arm", "arm64", "mips",
     "mipsle", "mips64", "mips64le", "ppc64", "ppc64le", "riscv64", "s390x", "wasm".
    :vartype architecture: str or ~container_registry.models.ArtifactArchitecture
    :ivar operating_system: Operating system. Known values are: "aix", "android", "darwin",
     "dragonfly", "freebsd", "illumos", "ios", "js", "linux", "netbsd", "openbsd", "plan9",
     "solaris", "windows".
    :vartype operating_system: str or ~container_registry.models.ArtifactOperatingSystem
    """

    _validation = {
        'digest': {'required': True, 'readonly': True},
        'architecture': {'readonly': True},
        'operating_system': {'readonly': True},
    }

    _attribute_map = {
        'digest': {'key': 'digest', 'type': 'str'},
        'architecture': {'key': 'architecture', 'type': 'str'},
        'operating_system': {'key': 'os', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ArtifactManifestPlatform, self).__init__(**kwargs)
        self.digest = None
        self.architecture = None
        self.operating_system = None


class ArtifactManifestProperties(msrest.serialization.Model):
    """Manifest attributes details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar registry_login_server: Registry login server name. This is likely to be similar to
     {registry-name}.azurecr.io.
    :vartype registry_login_server: str
    :ivar repository_name: Repository name.
    :vartype repository_name: str
    :ivar digest: Required. Manifest.
    :vartype digest: str
    :ivar size: Image size.
    :vartype size: long
    :ivar created_on: Required. Created time.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: Required. Last update time.
    :vartype last_updated_on: ~datetime.datetime
    :ivar architecture: CPU architecture. Known values are: "386", "amd64", "arm", "arm64", "mips",
     "mipsle", "mips64", "mips64le", "ppc64", "ppc64le", "riscv64", "s390x", "wasm".
    :vartype architecture: str or ~container_registry.models.ArtifactArchitecture
    :ivar operating_system: Operating system. Known values are: "aix", "android", "darwin",
     "dragonfly", "freebsd", "illumos", "ios", "js", "linux", "netbsd", "openbsd", "plan9",
     "solaris", "windows".
    :vartype operating_system: str or ~container_registry.models.ArtifactOperatingSystem
    :ivar related_artifacts: List of artifacts that are referenced by this manifest list, with
     information about the platform each supports.  This list will be empty if this is a leaf
     manifest and not a manifest list.
    :vartype related_artifacts: list[~container_registry.models.ArtifactManifestPlatform]
    :ivar tags: A set of tags. List of tags.
    :vartype tags: list[str]
    :ivar can_delete: Delete enabled.
    :vartype can_delete: bool
    :ivar can_write: Write enabled.
    :vartype can_write: bool
    :ivar can_list: List enabled.
    :vartype can_list: bool
    :ivar can_read: Read enabled.
    :vartype can_read: bool
    """

    _validation = {
        'registry_login_server': {'readonly': True},
        'repository_name': {'readonly': True},
        'digest': {'required': True, 'readonly': True},
        'size': {'readonly': True},
        'created_on': {'required': True, 'readonly': True},
        'last_updated_on': {'required': True, 'readonly': True},
        'architecture': {'readonly': True},
        'operating_system': {'readonly': True},
        'related_artifacts': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'registry_login_server': {'key': 'registry', 'type': 'str'},
        'repository_name': {'key': 'imageName', 'type': 'str'},
        'digest': {'key': 'manifest.digest', 'type': 'str'},
        'size': {'key': 'manifest.imageSize', 'type': 'long'},
        'created_on': {'key': 'manifest.createdTime', 'type': 'iso-8601'},
        'last_updated_on': {'key': 'manifest.lastUpdateTime', 'type': 'iso-8601'},
        'architecture': {'key': 'manifest.architecture', 'type': 'str'},
        'operating_system': {'key': 'manifest.os', 'type': 'str'},
        'related_artifacts': {'key': 'manifest.references', 'type': '[ArtifactManifestPlatform]'},
        'tags': {'key': 'manifest.tags', 'type': '[str]'},
        'can_delete': {'key': 'manifest.changeableAttributes.deleteEnabled', 'type': 'bool'},
        'can_write': {'key': 'manifest.changeableAttributes.writeEnabled', 'type': 'bool'},
        'can_list': {'key': 'manifest.changeableAttributes.listEnabled', 'type': 'bool'},
        'can_read': {'key': 'manifest.changeableAttributes.readEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        can_delete: Optional[bool] = None,
        can_write: Optional[bool] = None,
        can_list: Optional[bool] = None,
        can_read: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword can_delete: Delete enabled.
        :paramtype can_delete: bool
        :keyword can_write: Write enabled.
        :paramtype can_write: bool
        :keyword can_list: List enabled.
        :paramtype can_list: bool
        :keyword can_read: Read enabled.
        :paramtype can_read: bool
        """
        super(ArtifactManifestProperties, self).__init__(**kwargs)
        self.registry_login_server = None
        self.repository_name = None
        self.digest = None
        self.size = None
        self.created_on = None
        self.last_updated_on = None
        self.architecture = None
        self.operating_system = None
        self.related_artifacts = None
        self.tags = None
        self.can_delete = can_delete
        self.can_write = can_write
        self.can_list = can_list
        self.can_read = can_read


class ArtifactTagProperties(msrest.serialization.Model):
    """Tag attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar registry_login_server: Required. Registry login server name. This is likely to be similar
     to {registry-name}.azurecr.io.
    :vartype registry_login_server: str
    :ivar repository_name: Required. Image name.
    :vartype repository_name: str
    :ivar name: Required. Tag name.
    :vartype name: str
    :ivar digest: Required. Tag digest.
    :vartype digest: str
    :ivar created_on: Required. Tag created time.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: Required. Tag last update time.
    :vartype last_updated_on: ~datetime.datetime
    :ivar can_delete: Delete enabled.
    :vartype can_delete: bool
    :ivar can_write: Write enabled.
    :vartype can_write: bool
    :ivar can_list: List enabled.
    :vartype can_list: bool
    :ivar can_read: Read enabled.
    :vartype can_read: bool
    """

    _validation = {
        'registry_login_server': {'required': True, 'readonly': True},
        'repository_name': {'required': True, 'readonly': True},
        'name': {'required': True, 'readonly': True},
        'digest': {'required': True, 'readonly': True},
        'created_on': {'required': True, 'readonly': True},
        'last_updated_on': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'registry_login_server': {'key': 'registry', 'type': 'str'},
        'repository_name': {'key': 'imageName', 'type': 'str'},
        'name': {'key': 'tag.name', 'type': 'str'},
        'digest': {'key': 'tag.digest', 'type': 'str'},
        'created_on': {'key': 'tag.createdTime', 'type': 'iso-8601'},
        'last_updated_on': {'key': 'tag.lastUpdateTime', 'type': 'iso-8601'},
        'can_delete': {'key': 'tag.changeableAttributes.deleteEnabled', 'type': 'bool'},
        'can_write': {'key': 'tag.changeableAttributes.writeEnabled', 'type': 'bool'},
        'can_list': {'key': 'tag.changeableAttributes.listEnabled', 'type': 'bool'},
        'can_read': {'key': 'tag.changeableAttributes.readEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        can_delete: Optional[bool] = None,
        can_write: Optional[bool] = None,
        can_list: Optional[bool] = None,
        can_read: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword can_delete: Delete enabled.
        :paramtype can_delete: bool
        :keyword can_write: Write enabled.
        :paramtype can_write: bool
        :keyword can_list: List enabled.
        :paramtype can_list: bool
        :keyword can_read: Read enabled.
        :paramtype can_read: bool
        """
        super(ArtifactTagProperties, self).__init__(**kwargs)
        self.registry_login_server = None
        self.repository_name = None
        self.name = None
        self.digest = None
        self.created_on = None
        self.last_updated_on = None
        self.can_delete = can_delete
        self.can_write = can_write
        self.can_list = can_list
        self.can_read = can_read


class ContainerRepositoryProperties(msrest.serialization.Model):
    """Properties of this repository.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar registry_login_server: Required. Registry login server name. This is likely to be similar
     to {registry-name}.azurecr.io.
    :vartype registry_login_server: str
    :ivar name: Required. Image name.
    :vartype name: str
    :ivar created_on: Required. Image created time.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: Required. Image last update time.
    :vartype last_updated_on: ~datetime.datetime
    :ivar manifest_count: Required. Number of the manifests.
    :vartype manifest_count: int
    :ivar tag_count: Required. Number of the tags.
    :vartype tag_count: int
    :ivar can_delete: Delete enabled.
    :vartype can_delete: bool
    :ivar can_write: Write enabled.
    :vartype can_write: bool
    :ivar can_list: List enabled.
    :vartype can_list: bool
    :ivar can_read: Read enabled.
    :vartype can_read: bool
    """

    _validation = {
        'registry_login_server': {'required': True, 'readonly': True},
        'name': {'required': True, 'readonly': True},
        'created_on': {'required': True, 'readonly': True},
        'last_updated_on': {'required': True, 'readonly': True},
        'manifest_count': {'required': True, 'readonly': True},
        'tag_count': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'registry_login_server': {'key': 'registry', 'type': 'str'},
        'name': {'key': 'imageName', 'type': 'str'},
        'created_on': {'key': 'createdTime', 'type': 'iso-8601'},
        'last_updated_on': {'key': 'lastUpdateTime', 'type': 'iso-8601'},
        'manifest_count': {'key': 'manifestCount', 'type': 'int'},
        'tag_count': {'key': 'tagCount', 'type': 'int'},
        'can_delete': {'key': 'changeableAttributes.deleteEnabled', 'type': 'bool'},
        'can_write': {'key': 'changeableAttributes.writeEnabled', 'type': 'bool'},
        'can_list': {'key': 'changeableAttributes.listEnabled', 'type': 'bool'},
        'can_read': {'key': 'changeableAttributes.readEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        can_delete: Optional[bool] = None,
        can_write: Optional[bool] = None,
        can_list: Optional[bool] = None,
        can_read: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword can_delete: Delete enabled.
        :paramtype can_delete: bool
        :keyword can_write: Write enabled.
        :paramtype can_write: bool
        :keyword can_list: List enabled.
        :paramtype can_list: bool
        :keyword can_read: Read enabled.
        :paramtype can_read: bool
        """
        super(ContainerRepositoryProperties, self).__init__(**kwargs)
        self.registry_login_server = None
        self.name = None
        self.created_on = None
        self.last_updated_on = None
        self.manifest_count = None
        self.tag_count = None
        self.can_delete = can_delete
        self.can_write = can_write
        self.can_list = can_list
        self.can_read = can_read


class DeleteRepositoryResult(msrest.serialization.Model):
    """Deleted repository.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar deleted_manifests: SHA of the deleted image.
    :vartype deleted_manifests: list[str]
    :ivar deleted_tags: Tag of the deleted image.
    :vartype deleted_tags: list[str]
    """

    _validation = {
        'deleted_manifests': {'readonly': True},
        'deleted_tags': {'readonly': True},
    }

    _attribute_map = {
        'deleted_manifests': {'key': 'manifestsDeleted', 'type': '[str]'},
        'deleted_tags': {'key': 'tagsDeleted', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DeleteRepositoryResult, self).__init__(**kwargs)
        self.deleted_manifests = None
        self.deleted_tags = None


class Descriptor(msrest.serialization.Model):
    """Docker V2 image layer descriptor including config and layers.

    :ivar media_type: Layer media type.
    :vartype media_type: str
    :ivar size: Layer size.
    :vartype size: long
    :ivar digest: Layer digest.
    :vartype digest: str
    :ivar urls: Specifies a list of URIs from which this object may be downloaded.
    :vartype urls: list[str]
    :ivar annotations: Additional information provided through arbitrary metadata.
    :vartype annotations: ~container_registry.models.Annotations
    """

    _attribute_map = {
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'size': {'key': 'size', 'type': 'long'},
        'digest': {'key': 'digest', 'type': 'str'},
        'urls': {'key': 'urls', 'type': '[str]'},
        'annotations': {'key': 'annotations', 'type': 'Annotations'},
    }

    def __init__(
        self,
        *,
        media_type: Optional[str] = None,
        size: Optional[int] = None,
        digest: Optional[str] = None,
        urls: Optional[List[str]] = None,
        annotations: Optional["_models.Annotations"] = None,
        **kwargs
    ):
        """
        :keyword media_type: Layer media type.
        :paramtype media_type: str
        :keyword size: Layer size.
        :paramtype size: long
        :keyword digest: Layer digest.
        :paramtype digest: str
        :keyword urls: Specifies a list of URIs from which this object may be downloaded.
        :paramtype urls: list[str]
        :keyword annotations: Additional information provided through arbitrary metadata.
        :paramtype annotations: ~container_registry.models.Annotations
        """
        super(Descriptor, self).__init__(**kwargs)
        self.media_type = media_type
        self.size = size
        self.digest = digest
        self.urls = urls
        self.annotations = annotations


class FsLayer(msrest.serialization.Model):
    """Image layer information.

    :ivar blob_sum: SHA of an image layer.
    :vartype blob_sum: str
    """

    _attribute_map = {
        'blob_sum': {'key': 'blobSum', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        blob_sum: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword blob_sum: SHA of an image layer.
        :paramtype blob_sum: str
        """
        super(FsLayer, self).__init__(**kwargs)
        self.blob_sum = blob_sum


class History(msrest.serialization.Model):
    """A list of unstructured historical data for v1 compatibility.

    :ivar v1_compatibility: The raw v1 compatibility information.
    :vartype v1_compatibility: str
    """

    _attribute_map = {
        'v1_compatibility': {'key': 'v1Compatibility', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        v1_compatibility: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword v1_compatibility: The raw v1 compatibility information.
        :paramtype v1_compatibility: str
        """
        super(History, self).__init__(**kwargs)
        self.v1_compatibility = v1_compatibility


class ImageSignature(msrest.serialization.Model):
    """Signature of a signed manifest.

    :ivar header: A JSON web signature.
    :vartype header: ~container_registry.models.JWK
    :ivar signature: A signature for the image manifest, signed by a libtrust private key.
    :vartype signature: str
    :ivar protected: The signed protected header.
    :vartype protected: str
    """

    _attribute_map = {
        'header': {'key': 'header', 'type': 'JWK'},
        'signature': {'key': 'signature', 'type': 'str'},
        'protected': {'key': 'protected', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        header: Optional["_models.JWK"] = None,
        signature: Optional[str] = None,
        protected: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword header: A JSON web signature.
        :paramtype header: ~container_registry.models.JWK
        :keyword signature: A signature for the image manifest, signed by a libtrust private key.
        :paramtype signature: str
        :keyword protected: The signed protected header.
        :paramtype protected: str
        """
        super(ImageSignature, self).__init__(**kwargs)
        self.header = header
        self.signature = signature
        self.protected = protected


class JWK(msrest.serialization.Model):
    """A JSON web signature.

    :ivar jwk: JSON web key parameter.
    :vartype jwk: ~container_registry.models.JWKHeader
    :ivar alg: The algorithm used to sign or encrypt the JWT.
    :vartype alg: str
    """

    _attribute_map = {
        'jwk': {'key': 'jwk', 'type': 'JWKHeader'},
        'alg': {'key': 'alg', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        jwk: Optional["_models.JWKHeader"] = None,
        alg: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword jwk: JSON web key parameter.
        :paramtype jwk: ~container_registry.models.JWKHeader
        :keyword alg: The algorithm used to sign or encrypt the JWT.
        :paramtype alg: str
        """
        super(JWK, self).__init__(**kwargs)
        self.jwk = jwk
        self.alg = alg


class JWKHeader(msrest.serialization.Model):
    """JSON web key parameter.

    :ivar crv: crv value.
    :vartype crv: str
    :ivar kid: kid value.
    :vartype kid: str
    :ivar kty: kty value.
    :vartype kty: str
    :ivar x: x value.
    :vartype x: str
    :ivar y: y value.
    :vartype y: str
    """

    _attribute_map = {
        'crv': {'key': 'crv', 'type': 'str'},
        'kid': {'key': 'kid', 'type': 'str'},
        'kty': {'key': 'kty', 'type': 'str'},
        'x': {'key': 'x', 'type': 'str'},
        'y': {'key': 'y', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        crv: Optional[str] = None,
        kid: Optional[str] = None,
        kty: Optional[str] = None,
        x: Optional[str] = None,
        y: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword crv: crv value.
        :paramtype crv: str
        :keyword kid: kid value.
        :paramtype kid: str
        :keyword kty: kty value.
        :paramtype kty: str
        :keyword x: x value.
        :paramtype x: str
        :keyword y: y value.
        :paramtype y: str
        """
        super(JWKHeader, self).__init__(**kwargs)
        self.crv = crv
        self.kid = kid
        self.kty = kty
        self.x = x
        self.y = y


class Manifest(msrest.serialization.Model):
    """Returns the requested manifest file.

    :ivar schema_version: Schema version.
    :vartype schema_version: int
    """

    _attribute_map = {
        'schema_version': {'key': 'schemaVersion', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        schema_version: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword schema_version: Schema version.
        :paramtype schema_version: int
        """
        super(Manifest, self).__init__(**kwargs)
        self.schema_version = schema_version


class ManifestAttributesBase(msrest.serialization.Model):
    """Manifest details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar digest: Required. Manifest.
    :vartype digest: str
    :ivar size: Image size.
    :vartype size: long
    :ivar created_on: Required. Created time.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: Required. Last update time.
    :vartype last_updated_on: ~datetime.datetime
    :ivar architecture: CPU architecture. Known values are: "386", "amd64", "arm", "arm64", "mips",
     "mipsle", "mips64", "mips64le", "ppc64", "ppc64le", "riscv64", "s390x", "wasm".
    :vartype architecture: str or ~container_registry.models.ArtifactArchitecture
    :ivar operating_system: Operating system. Known values are: "aix", "android", "darwin",
     "dragonfly", "freebsd", "illumos", "ios", "js", "linux", "netbsd", "openbsd", "plan9",
     "solaris", "windows".
    :vartype operating_system: str or ~container_registry.models.ArtifactOperatingSystem
    :ivar related_artifacts: List of artifacts that are referenced by this manifest list, with
     information about the platform each supports.  This list will be empty if this is a leaf
     manifest and not a manifest list.
    :vartype related_artifacts: list[~container_registry.models.ArtifactManifestPlatform]
    :ivar tags: A set of tags. List of tags.
    :vartype tags: list[str]
    :ivar can_delete: Delete enabled.
    :vartype can_delete: bool
    :ivar can_write: Write enabled.
    :vartype can_write: bool
    :ivar can_list: List enabled.
    :vartype can_list: bool
    :ivar can_read: Read enabled.
    :vartype can_read: bool
    """

    _validation = {
        'digest': {'required': True, 'readonly': True},
        'size': {'readonly': True},
        'created_on': {'required': True, 'readonly': True},
        'last_updated_on': {'required': True, 'readonly': True},
        'architecture': {'readonly': True},
        'operating_system': {'readonly': True},
        'related_artifacts': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'digest': {'key': 'digest', 'type': 'str'},
        'size': {'key': 'imageSize', 'type': 'long'},
        'created_on': {'key': 'createdTime', 'type': 'iso-8601'},
        'last_updated_on': {'key': 'lastUpdateTime', 'type': 'iso-8601'},
        'architecture': {'key': 'architecture', 'type': 'str'},
        'operating_system': {'key': 'os', 'type': 'str'},
        'related_artifacts': {'key': 'references', 'type': '[ArtifactManifestPlatform]'},
        'tags': {'key': 'tags', 'type': '[str]'},
        'can_delete': {'key': 'changeableAttributes.deleteEnabled', 'type': 'bool'},
        'can_write': {'key': 'changeableAttributes.writeEnabled', 'type': 'bool'},
        'can_list': {'key': 'changeableAttributes.listEnabled', 'type': 'bool'},
        'can_read': {'key': 'changeableAttributes.readEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        can_delete: Optional[bool] = None,
        can_write: Optional[bool] = None,
        can_list: Optional[bool] = None,
        can_read: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword can_delete: Delete enabled.
        :paramtype can_delete: bool
        :keyword can_write: Write enabled.
        :paramtype can_write: bool
        :keyword can_list: List enabled.
        :paramtype can_list: bool
        :keyword can_read: Read enabled.
        :paramtype can_read: bool
        """
        super(ManifestAttributesBase, self).__init__(**kwargs)
        self.digest = None
        self.size = None
        self.created_on = None
        self.last_updated_on = None
        self.architecture = None
        self.operating_system = None
        self.related_artifacts = None
        self.tags = None
        self.can_delete = can_delete
        self.can_write = can_write
        self.can_list = can_list
        self.can_read = can_read


class ManifestAttributesManifest(msrest.serialization.Model):
    """List of manifest attributes.

    :ivar references: List of manifest attributes details.
    :vartype references: list[~container_registry.models.ArtifactManifestPlatform]
    """

    _attribute_map = {
        'references': {'key': 'references', 'type': '[ArtifactManifestPlatform]'},
    }

    def __init__(
        self,
        *,
        references: Optional[List["_models.ArtifactManifestPlatform"]] = None,
        **kwargs
    ):
        """
        :keyword references: List of manifest attributes details.
        :paramtype references: list[~container_registry.models.ArtifactManifestPlatform]
        """
        super(ManifestAttributesManifest, self).__init__(**kwargs)
        self.references = references


class ManifestList(Manifest):
    """Returns the requested Docker multi-arch-manifest file.

    :ivar schema_version: Schema version.
    :vartype schema_version: int
    :ivar media_type: Media type for this Manifest.
    :vartype media_type: str
    :ivar manifests: List of V2 image layer information.
    :vartype manifests: list[~container_registry.models.ManifestListAttributes]
    """

    _attribute_map = {
        'schema_version': {'key': 'schemaVersion', 'type': 'int'},
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'manifests': {'key': 'manifests', 'type': '[ManifestListAttributes]'},
    }

    def __init__(
        self,
        *,
        schema_version: Optional[int] = None,
        media_type: Optional[str] = None,
        manifests: Optional[List["_models.ManifestListAttributes"]] = None,
        **kwargs
    ):
        """
        :keyword schema_version: Schema version.
        :paramtype schema_version: int
        :keyword media_type: Media type for this Manifest.
        :paramtype media_type: str
        :keyword manifests: List of V2 image layer information.
        :paramtype manifests: list[~container_registry.models.ManifestListAttributes]
        """
        super(ManifestList, self).__init__(schema_version=schema_version, **kwargs)
        self.media_type = media_type
        self.manifests = manifests


class ManifestListAttributes(msrest.serialization.Model):
    """ManifestListAttributes.

    :ivar media_type: The MIME type of the referenced object. This will generally be
     application/vnd.docker.image.manifest.v2+json, but it could also be
     application/vnd.docker.image.manifest.v1+json.
    :vartype media_type: str
    :ivar size: The size in bytes of the object.
    :vartype size: long
    :ivar digest: The digest of the content, as defined by the Registry V2 HTTP API Specification.
    :vartype digest: str
    :ivar platform: The platform object describes the platform which the image in the manifest runs
     on. A full list of valid operating system and architecture values are listed in the Go language
     documentation for $GOOS and $GOARCH.
    :vartype platform: ~container_registry.models.Platform
    """

    _attribute_map = {
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'size': {'key': 'size', 'type': 'long'},
        'digest': {'key': 'digest', 'type': 'str'},
        'platform': {'key': 'platform', 'type': 'Platform'},
    }

    def __init__(
        self,
        *,
        media_type: Optional[str] = None,
        size: Optional[int] = None,
        digest: Optional[str] = None,
        platform: Optional["_models.Platform"] = None,
        **kwargs
    ):
        """
        :keyword media_type: The MIME type of the referenced object. This will generally be
         application/vnd.docker.image.manifest.v2+json, but it could also be
         application/vnd.docker.image.manifest.v1+json.
        :paramtype media_type: str
        :keyword size: The size in bytes of the object.
        :paramtype size: long
        :keyword digest: The digest of the content, as defined by the Registry V2 HTTP API
         Specification.
        :paramtype digest: str
        :keyword platform: The platform object describes the platform which the image in the manifest
         runs on. A full list of valid operating system and architecture values are listed in the Go
         language documentation for $GOOS and $GOARCH.
        :paramtype platform: ~container_registry.models.Platform
        """
        super(ManifestListAttributes, self).__init__(**kwargs)
        self.media_type = media_type
        self.size = size
        self.digest = digest
        self.platform = platform


class ManifestWrapper(Manifest):
    """Returns the requested manifest file.

    :ivar schema_version: Schema version.
    :vartype schema_version: int
    :ivar media_type: Media type for this Manifest.
    :vartype media_type: str
    :ivar manifests: (ManifestList, OCIIndex) List of V2 image layer information.
    :vartype manifests: list[~container_registry.models.ManifestListAttributes]
    :ivar config: (V2, OCI) Image config descriptor.
    :vartype config: ~container_registry.models.Descriptor
    :ivar layers: (V2, OCI) List of V2 image layer information.
    :vartype layers: list[~container_registry.models.Descriptor]
    :ivar annotations: (OCI, OCIIndex) Additional metadata.
    :vartype annotations: ~container_registry.models.Annotations
    :ivar architecture: (V1) CPU architecture.
    :vartype architecture: str
    :ivar name: (V1) Image name.
    :vartype name: str
    :ivar tag: (V1) Image tag.
    :vartype tag: str
    :ivar fs_layers: (V1) List of layer information.
    :vartype fs_layers: list[~container_registry.models.FsLayer]
    :ivar history: (V1) Image history.
    :vartype history: list[~container_registry.models.History]
    :ivar signatures: (V1) Image signature.
    :vartype signatures: list[~container_registry.models.ImageSignature]
    """

    _attribute_map = {
        'schema_version': {'key': 'schemaVersion', 'type': 'int'},
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'manifests': {'key': 'manifests', 'type': '[ManifestListAttributes]'},
        'config': {'key': 'config', 'type': 'Descriptor'},
        'layers': {'key': 'layers', 'type': '[Descriptor]'},
        'annotations': {'key': 'annotations', 'type': 'Annotations'},
        'architecture': {'key': 'architecture', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'fs_layers': {'key': 'fsLayers', 'type': '[FsLayer]'},
        'history': {'key': 'history', 'type': '[History]'},
        'signatures': {'key': 'signatures', 'type': '[ImageSignature]'},
    }

    def __init__(
        self,
        *,
        schema_version: Optional[int] = None,
        media_type: Optional[str] = None,
        manifests: Optional[List["_models.ManifestListAttributes"]] = None,
        config: Optional["_models.Descriptor"] = None,
        layers: Optional[List["_models.Descriptor"]] = None,
        annotations: Optional["_models.Annotations"] = None,
        architecture: Optional[str] = None,
        name: Optional[str] = None,
        tag: Optional[str] = None,
        fs_layers: Optional[List["_models.FsLayer"]] = None,
        history: Optional[List["_models.History"]] = None,
        signatures: Optional[List["_models.ImageSignature"]] = None,
        **kwargs
    ):
        """
        :keyword schema_version: Schema version.
        :paramtype schema_version: int
        :keyword media_type: Media type for this Manifest.
        :paramtype media_type: str
        :keyword manifests: (ManifestList, OCIIndex) List of V2 image layer information.
        :paramtype manifests: list[~container_registry.models.ManifestListAttributes]
        :keyword config: (V2, OCI) Image config descriptor.
        :paramtype config: ~container_registry.models.Descriptor
        :keyword layers: (V2, OCI) List of V2 image layer information.
        :paramtype layers: list[~container_registry.models.Descriptor]
        :keyword annotations: (OCI, OCIIndex) Additional metadata.
        :paramtype annotations: ~container_registry.models.Annotations
        :keyword architecture: (V1) CPU architecture.
        :paramtype architecture: str
        :keyword name: (V1) Image name.
        :paramtype name: str
        :keyword tag: (V1) Image tag.
        :paramtype tag: str
        :keyword fs_layers: (V1) List of layer information.
        :paramtype fs_layers: list[~container_registry.models.FsLayer]
        :keyword history: (V1) Image history.
        :paramtype history: list[~container_registry.models.History]
        :keyword signatures: (V1) Image signature.
        :paramtype signatures: list[~container_registry.models.ImageSignature]
        """
        super(ManifestWrapper, self).__init__(schema_version=schema_version, **kwargs)
        self.media_type = media_type
        self.manifests = manifests
        self.config = config
        self.layers = layers
        self.annotations = annotations
        self.architecture = architecture
        self.name = name
        self.tag = tag
        self.fs_layers = fs_layers
        self.history = history
        self.signatures = signatures


class ManifestWriteableProperties(msrest.serialization.Model):
    """Changeable attributes.

    :ivar can_delete: Delete enabled.
    :vartype can_delete: bool
    :ivar can_write: Write enabled.
    :vartype can_write: bool
    :ivar can_list: List enabled.
    :vartype can_list: bool
    :ivar can_read: Read enabled.
    :vartype can_read: bool
    """

    _attribute_map = {
        'can_delete': {'key': 'deleteEnabled', 'type': 'bool'},
        'can_write': {'key': 'writeEnabled', 'type': 'bool'},
        'can_list': {'key': 'listEnabled', 'type': 'bool'},
        'can_read': {'key': 'readEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        can_delete: Optional[bool] = None,
        can_write: Optional[bool] = None,
        can_list: Optional[bool] = None,
        can_read: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword can_delete: Delete enabled.
        :paramtype can_delete: bool
        :keyword can_write: Write enabled.
        :paramtype can_write: bool
        :keyword can_list: List enabled.
        :paramtype can_list: bool
        :keyword can_read: Read enabled.
        :paramtype can_read: bool
        """
        super(ManifestWriteableProperties, self).__init__(**kwargs)
        self.can_delete = can_delete
        self.can_write = can_write
        self.can_list = can_list
        self.can_read = can_read


class OCIIndex(Manifest):
    """Returns the requested OCI index file.

    :ivar schema_version: Schema version.
    :vartype schema_version: int
    :ivar manifests: List of OCI image layer information.
    :vartype manifests: list[~container_registry.models.ManifestListAttributes]
    :ivar annotations: Additional information provided through arbitrary metadata.
    :vartype annotations: ~container_registry.models.Annotations
    """

    _attribute_map = {
        'schema_version': {'key': 'schemaVersion', 'type': 'int'},
        'manifests': {'key': 'manifests', 'type': '[ManifestListAttributes]'},
        'annotations': {'key': 'annotations', 'type': 'Annotations'},
    }

    def __init__(
        self,
        *,
        schema_version: Optional[int] = None,
        manifests: Optional[List["_models.ManifestListAttributes"]] = None,
        annotations: Optional["_models.Annotations"] = None,
        **kwargs
    ):
        """
        :keyword schema_version: Schema version.
        :paramtype schema_version: int
        :keyword manifests: List of OCI image layer information.
        :paramtype manifests: list[~container_registry.models.ManifestListAttributes]
        :keyword annotations: Additional information provided through arbitrary metadata.
        :paramtype annotations: ~container_registry.models.Annotations
        """
        super(OCIIndex, self).__init__(schema_version=schema_version, **kwargs)
        self.manifests = manifests
        self.annotations = annotations


class OCIManifest(msrest.serialization.Model):
    """Returns the requested OCI Manifest file.

    :ivar config: V2 image config descriptor.
    :vartype config: ~container_registry.models.Descriptor
    :ivar layers: List of V2 image layer information.
    :vartype layers: list[~container_registry.models.Descriptor]
    :ivar annotations: Additional information provided through arbitrary metadata.
    :vartype annotations: ~container_registry.models.Annotations
    :ivar schema_version: Schema version.
    :vartype schema_version: int
    """

    _attribute_map = {
        'config': {'key': 'config', 'type': 'Descriptor'},
        'layers': {'key': 'layers', 'type': '[Descriptor]'},
        'annotations': {'key': 'annotations', 'type': 'Annotations'},
        'schema_version': {'key': 'schemaVersion', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        config: Optional["_models.Descriptor"] = None,
        layers: Optional[List["_models.Descriptor"]] = None,
        annotations: Optional["_models.Annotations"] = None,
        schema_version: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword config: V2 image config descriptor.
        :paramtype config: ~container_registry.models.Descriptor
        :keyword layers: List of V2 image layer information.
        :paramtype layers: list[~container_registry.models.Descriptor]
        :keyword annotations: Additional information provided through arbitrary metadata.
        :paramtype annotations: ~container_registry.models.Annotations
        :keyword schema_version: Schema version.
        :paramtype schema_version: int
        """
        super(OCIManifest, self).__init__(**kwargs)
        self.config = config
        self.layers = layers
        self.annotations = annotations
        self.schema_version = schema_version


class Paths108HwamOauth2ExchangePostRequestbodyContentApplicationXWwwFormUrlencodedSchema(msrest.serialization.Model):
    """Paths108HwamOauth2ExchangePostRequestbodyContentApplicationXWwwFormUrlencodedSchema.

    All required parameters must be populated in order to send to Azure.

    :ivar grant_type: Required. Can take a value of access_token_refresh_token, or access_token, or
     refresh_token. Known values are: "access_token_refresh_token", "access_token", "refresh_token".
    :vartype grant_type: str or ~container_registry.models.PostContentSchemaGrantType
    :ivar service: Required. Indicates the name of your Azure container registry.
    :vartype service: str
    :ivar tenant: AAD tenant associated to the AAD credentials.
    :vartype tenant: str
    :ivar refresh_token: AAD refresh token, mandatory when grant_type is access_token_refresh_token
     or refresh_token.
    :vartype refresh_token: str
    :ivar aad_access_token: AAD access token, mandatory when grant_type is
     access_token_refresh_token or access_token.
    :vartype aad_access_token: str
    """

    _validation = {
        'grant_type': {'required': True},
        'service': {'required': True},
    }

    _attribute_map = {
        'grant_type': {'key': 'grant_type', 'type': 'str'},
        'service': {'key': 'service', 'type': 'str'},
        'tenant': {'key': 'tenant', 'type': 'str'},
        'refresh_token': {'key': 'refresh_token', 'type': 'str'},
        'aad_access_token': {'key': 'access_token', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        grant_type: Union[str, "_models.PostContentSchemaGrantType"],
        service: str,
        tenant: Optional[str] = None,
        refresh_token: Optional[str] = None,
        aad_access_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword grant_type: Required. Can take a value of access_token_refresh_token, or access_token,
         or refresh_token. Known values are: "access_token_refresh_token", "access_token",
         "refresh_token".
        :paramtype grant_type: str or ~container_registry.models.PostContentSchemaGrantType
        :keyword service: Required. Indicates the name of your Azure container registry.
        :paramtype service: str
        :keyword tenant: AAD tenant associated to the AAD credentials.
        :paramtype tenant: str
        :keyword refresh_token: AAD refresh token, mandatory when grant_type is
         access_token_refresh_token or refresh_token.
        :paramtype refresh_token: str
        :keyword aad_access_token: AAD access token, mandatory when grant_type is
         access_token_refresh_token or access_token.
        :paramtype aad_access_token: str
        """
        super(Paths108HwamOauth2ExchangePostRequestbodyContentApplicationXWwwFormUrlencodedSchema, self).__init__(**kwargs)
        self.grant_type = grant_type
        self.service = service
        self.tenant = tenant
        self.refresh_token = refresh_token
        self.aad_access_token = aad_access_token


class PathsV3R3RxOauth2TokenPostRequestbodyContentApplicationXWwwFormUrlencodedSchema(msrest.serialization.Model):
    """PathsV3R3RxOauth2TokenPostRequestbodyContentApplicationXWwwFormUrlencodedSchema.

    All required parameters must be populated in order to send to Azure.

    :ivar service: Required. Indicates the name of your Azure container registry.
    :vartype service: str
    :ivar scope: Required. Which is expected to be a valid scope, and can be specified more than
     once for multiple scope requests. You obtained this from the Www-Authenticate response header
     from the challenge.
    :vartype scope: str
    :ivar acr_refresh_token: Required. Must be a valid ACR refresh token.
    :vartype acr_refresh_token: str
    :ivar grant_type: Required. Grant type is expected to be refresh_token. Known values are:
     "refresh_token", "password".
    :vartype grant_type: str or ~container_registry.models.TokenGrantType
    """

    _validation = {
        'service': {'required': True},
        'scope': {'required': True},
        'acr_refresh_token': {'required': True},
        'grant_type': {'required': True},
    }

    _attribute_map = {
        'service': {'key': 'service', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
        'acr_refresh_token': {'key': 'refresh_token', 'type': 'str'},
        'grant_type': {'key': 'grant_type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        service: str,
        scope: str,
        acr_refresh_token: str,
        grant_type: Union[str, "_models.TokenGrantType"] = "refresh_token",
        **kwargs
    ):
        """
        :keyword service: Required. Indicates the name of your Azure container registry.
        :paramtype service: str
        :keyword scope: Required. Which is expected to be a valid scope, and can be specified more than
         once for multiple scope requests. You obtained this from the Www-Authenticate response header
         from the challenge.
        :paramtype scope: str
        :keyword acr_refresh_token: Required. Must be a valid ACR refresh token.
        :paramtype acr_refresh_token: str
        :keyword grant_type: Required. Grant type is expected to be refresh_token. Known values are:
         "refresh_token", "password".
        :paramtype grant_type: str or ~container_registry.models.TokenGrantType
        """
        super(PathsV3R3RxOauth2TokenPostRequestbodyContentApplicationXWwwFormUrlencodedSchema, self).__init__(**kwargs)
        self.service = service
        self.scope = scope
        self.acr_refresh_token = acr_refresh_token
        self.grant_type = grant_type


class Platform(msrest.serialization.Model):
    """The platform object describes the platform which the image in the manifest runs on. A full list of valid operating system and architecture values are listed in the Go language documentation for $GOOS and $GOARCH.

    :ivar architecture: Specifies the CPU architecture, for example amd64 or ppc64le.
    :vartype architecture: str
    :ivar os: The os field specifies the operating system, for example linux or windows.
    :vartype os: str
    :ivar os_version: The optional os.version field specifies the operating system version, for
     example 10.0.10586.
    :vartype os_version: str
    :ivar os_features: The optional os.features field specifies an array of strings, each listing a
     required OS feature (for example on Windows win32k.
    :vartype os_features: list[str]
    :ivar variant: The optional variant field specifies a variant of the CPU, for example armv6l to
     specify a particular CPU variant of the ARM CPU.
    :vartype variant: str
    :ivar features: The optional features field specifies an array of strings, each listing a
     required CPU feature (for example sse4 or aes.
    :vartype features: list[str]
    """

    _attribute_map = {
        'architecture': {'key': 'architecture', 'type': 'str'},
        'os': {'key': 'os', 'type': 'str'},
        'os_version': {'key': 'os\\.version', 'type': 'str'},
        'os_features': {'key': 'os\\.features', 'type': '[str]'},
        'variant': {'key': 'variant', 'type': 'str'},
        'features': {'key': 'features', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        architecture: Optional[str] = None,
        os: Optional[str] = None,
        os_version: Optional[str] = None,
        os_features: Optional[List[str]] = None,
        variant: Optional[str] = None,
        features: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword architecture: Specifies the CPU architecture, for example amd64 or ppc64le.
        :paramtype architecture: str
        :keyword os: The os field specifies the operating system, for example linux or windows.
        :paramtype os: str
        :keyword os_version: The optional os.version field specifies the operating system version, for
         example 10.0.10586.
        :paramtype os_version: str
        :keyword os_features: The optional os.features field specifies an array of strings, each
         listing a required OS feature (for example on Windows win32k.
        :paramtype os_features: list[str]
        :keyword variant: The optional variant field specifies a variant of the CPU, for example armv6l
         to specify a particular CPU variant of the ARM CPU.
        :paramtype variant: str
        :keyword features: The optional features field specifies an array of strings, each listing a
         required CPU feature (for example sse4 or aes.
        :paramtype features: list[str]
        """
        super(Platform, self).__init__(**kwargs)
        self.architecture = architecture
        self.os = os
        self.os_version = os_version
        self.os_features = os_features
        self.variant = variant
        self.features = features


class Repositories(msrest.serialization.Model):
    """List of repositories.

    :ivar repositories: Repository names.
    :vartype repositories: list[str]
    :ivar link:
    :vartype link: str
    """

    _attribute_map = {
        'repositories': {'key': 'repositories', 'type': '[str]'},
        'link': {'key': 'link', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        repositories: Optional[List[str]] = None,
        link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword repositories: Repository names.
        :paramtype repositories: list[str]
        :keyword link:
        :paramtype link: str
        """
        super(Repositories, self).__init__(**kwargs)
        self.repositories = repositories
        self.link = link


class RepositoryTags(msrest.serialization.Model):
    """Result of the request to list tags of the image.

    :ivar name: Name of the image.
    :vartype name: str
    :ivar tags: A set of tags. List of tags.
    :vartype tags: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tags: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the image.
        :paramtype name: str
        :keyword tags: A set of tags. List of tags.
        :paramtype tags: list[str]
        """
        super(RepositoryTags, self).__init__(**kwargs)
        self.name = name
        self.tags = tags


class RepositoryWriteableProperties(msrest.serialization.Model):
    """Changeable attributes for Repository.

    :ivar can_delete: Delete enabled.
    :vartype can_delete: bool
    :ivar can_write: Write enabled.
    :vartype can_write: bool
    :ivar can_list: List enabled.
    :vartype can_list: bool
    :ivar can_read: Read enabled.
    :vartype can_read: bool
    """

    _attribute_map = {
        'can_delete': {'key': 'deleteEnabled', 'type': 'bool'},
        'can_write': {'key': 'writeEnabled', 'type': 'bool'},
        'can_list': {'key': 'listEnabled', 'type': 'bool'},
        'can_read': {'key': 'readEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        can_delete: Optional[bool] = None,
        can_write: Optional[bool] = None,
        can_list: Optional[bool] = None,
        can_read: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword can_delete: Delete enabled.
        :paramtype can_delete: bool
        :keyword can_write: Write enabled.
        :paramtype can_write: bool
        :keyword can_list: List enabled.
        :paramtype can_list: bool
        :keyword can_read: Read enabled.
        :paramtype can_read: bool
        """
        super(RepositoryWriteableProperties, self).__init__(**kwargs)
        self.can_delete = can_delete
        self.can_write = can_write
        self.can_list = can_list
        self.can_read = can_read


class TagAttributesBase(msrest.serialization.Model):
    """Tag attribute details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Tag name.
    :vartype name: str
    :ivar digest: Required. Tag digest.
    :vartype digest: str
    :ivar created_on: Required. Tag created time.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: Required. Tag last update time.
    :vartype last_updated_on: ~datetime.datetime
    :ivar can_delete: Delete enabled.
    :vartype can_delete: bool
    :ivar can_write: Write enabled.
    :vartype can_write: bool
    :ivar can_list: List enabled.
    :vartype can_list: bool
    :ivar can_read: Read enabled.
    :vartype can_read: bool
    """

    _validation = {
        'name': {'required': True, 'readonly': True},
        'digest': {'required': True, 'readonly': True},
        'created_on': {'required': True, 'readonly': True},
        'last_updated_on': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'digest': {'key': 'digest', 'type': 'str'},
        'created_on': {'key': 'createdTime', 'type': 'iso-8601'},
        'last_updated_on': {'key': 'lastUpdateTime', 'type': 'iso-8601'},
        'can_delete': {'key': 'changeableAttributes.deleteEnabled', 'type': 'bool'},
        'can_write': {'key': 'changeableAttributes.writeEnabled', 'type': 'bool'},
        'can_list': {'key': 'changeableAttributes.listEnabled', 'type': 'bool'},
        'can_read': {'key': 'changeableAttributes.readEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        can_delete: Optional[bool] = None,
        can_write: Optional[bool] = None,
        can_list: Optional[bool] = None,
        can_read: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword can_delete: Delete enabled.
        :paramtype can_delete: bool
        :keyword can_write: Write enabled.
        :paramtype can_write: bool
        :keyword can_list: List enabled.
        :paramtype can_list: bool
        :keyword can_read: Read enabled.
        :paramtype can_read: bool
        """
        super(TagAttributesBase, self).__init__(**kwargs)
        self.name = None
        self.digest = None
        self.created_on = None
        self.last_updated_on = None
        self.can_delete = can_delete
        self.can_write = can_write
        self.can_list = can_list
        self.can_read = can_read


class TagAttributesTag(msrest.serialization.Model):
    """Tag.

    :ivar signature_record: SignatureRecord value.
    :vartype signature_record: str
    """

    _attribute_map = {
        'signature_record': {'key': 'signatureRecord', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        signature_record: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword signature_record: SignatureRecord value.
        :paramtype signature_record: str
        """
        super(TagAttributesTag, self).__init__(**kwargs)
        self.signature_record = signature_record


class TagList(msrest.serialization.Model):
    """List of tag details.

    All required parameters must be populated in order to send to Azure.

    :ivar registry_login_server: Required. Registry login server name. This is likely to be similar
     to {registry-name}.azurecr.io.
    :vartype registry_login_server: str
    :ivar repository: Required. Image name.
    :vartype repository: str
    :ivar tag_attribute_bases: Required. List of tag attribute details.
    :vartype tag_attribute_bases: list[~container_registry.models.TagAttributesBase]
    :ivar link:
    :vartype link: str
    """

    _validation = {
        'registry_login_server': {'required': True},
        'repository': {'required': True},
        'tag_attribute_bases': {'required': True},
    }

    _attribute_map = {
        'registry_login_server': {'key': 'registry', 'type': 'str'},
        'repository': {'key': 'imageName', 'type': 'str'},
        'tag_attribute_bases': {'key': 'tags', 'type': '[TagAttributesBase]'},
        'link': {'key': 'link', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        registry_login_server: str,
        repository: str,
        tag_attribute_bases: List["_models.TagAttributesBase"],
        link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword registry_login_server: Required. Registry login server name. This is likely to be
         similar to {registry-name}.azurecr.io.
        :paramtype registry_login_server: str
        :keyword repository: Required. Image name.
        :paramtype repository: str
        :keyword tag_attribute_bases: Required. List of tag attribute details.
        :paramtype tag_attribute_bases: list[~container_registry.models.TagAttributesBase]
        :keyword link:
        :paramtype link: str
        """
        super(TagList, self).__init__(**kwargs)
        self.registry_login_server = registry_login_server
        self.repository = repository
        self.tag_attribute_bases = tag_attribute_bases
        self.link = link


class TagWriteableProperties(msrest.serialization.Model):
    """Changeable attributes.

    :ivar can_delete: Delete enabled.
    :vartype can_delete: bool
    :ivar can_write: Write enabled.
    :vartype can_write: bool
    :ivar can_list: List enabled.
    :vartype can_list: bool
    :ivar can_read: Read enabled.
    :vartype can_read: bool
    """

    _attribute_map = {
        'can_delete': {'key': 'deleteEnabled', 'type': 'bool'},
        'can_write': {'key': 'writeEnabled', 'type': 'bool'},
        'can_list': {'key': 'listEnabled', 'type': 'bool'},
        'can_read': {'key': 'readEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        can_delete: Optional[bool] = None,
        can_write: Optional[bool] = None,
        can_list: Optional[bool] = None,
        can_read: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword can_delete: Delete enabled.
        :paramtype can_delete: bool
        :keyword can_write: Write enabled.
        :paramtype can_write: bool
        :keyword can_list: List enabled.
        :paramtype can_list: bool
        :keyword can_read: Read enabled.
        :paramtype can_read: bool
        """
        super(TagWriteableProperties, self).__init__(**kwargs)
        self.can_delete = can_delete
        self.can_write = can_write
        self.can_list = can_list
        self.can_read = can_read


class V1Manifest(Manifest):
    """Returns the requested V1 manifest file.

    :ivar schema_version: Schema version.
    :vartype schema_version: int
    :ivar architecture: CPU architecture.
    :vartype architecture: str
    :ivar name: Image name.
    :vartype name: str
    :ivar tag: Image tag.
    :vartype tag: str
    :ivar fs_layers: List of layer information.
    :vartype fs_layers: list[~container_registry.models.FsLayer]
    :ivar history: Image history.
    :vartype history: list[~container_registry.models.History]
    :ivar signatures: Image signature.
    :vartype signatures: list[~container_registry.models.ImageSignature]
    """

    _attribute_map = {
        'schema_version': {'key': 'schemaVersion', 'type': 'int'},
        'architecture': {'key': 'architecture', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'fs_layers': {'key': 'fsLayers', 'type': '[FsLayer]'},
        'history': {'key': 'history', 'type': '[History]'},
        'signatures': {'key': 'signatures', 'type': '[ImageSignature]'},
    }

    def __init__(
        self,
        *,
        schema_version: Optional[int] = None,
        architecture: Optional[str] = None,
        name: Optional[str] = None,
        tag: Optional[str] = None,
        fs_layers: Optional[List["_models.FsLayer"]] = None,
        history: Optional[List["_models.History"]] = None,
        signatures: Optional[List["_models.ImageSignature"]] = None,
        **kwargs
    ):
        """
        :keyword schema_version: Schema version.
        :paramtype schema_version: int
        :keyword architecture: CPU architecture.
        :paramtype architecture: str
        :keyword name: Image name.
        :paramtype name: str
        :keyword tag: Image tag.
        :paramtype tag: str
        :keyword fs_layers: List of layer information.
        :paramtype fs_layers: list[~container_registry.models.FsLayer]
        :keyword history: Image history.
        :paramtype history: list[~container_registry.models.History]
        :keyword signatures: Image signature.
        :paramtype signatures: list[~container_registry.models.ImageSignature]
        """
        super(V1Manifest, self).__init__(schema_version=schema_version, **kwargs)
        self.architecture = architecture
        self.name = name
        self.tag = tag
        self.fs_layers = fs_layers
        self.history = history
        self.signatures = signatures


class V2Manifest(Manifest):
    """Returns the requested Docker V2 Manifest file.

    :ivar schema_version: Schema version.
    :vartype schema_version: int
    :ivar media_type: Media type for this Manifest.
    :vartype media_type: str
    :ivar config: V2 image config descriptor.
    :vartype config: ~container_registry.models.Descriptor
    :ivar layers: List of V2 image layer information.
    :vartype layers: list[~container_registry.models.Descriptor]
    """

    _attribute_map = {
        'schema_version': {'key': 'schemaVersion', 'type': 'int'},
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'config': {'key': 'config', 'type': 'Descriptor'},
        'layers': {'key': 'layers', 'type': '[Descriptor]'},
    }

    def __init__(
        self,
        *,
        schema_version: Optional[int] = None,
        media_type: Optional[str] = None,
        config: Optional["_models.Descriptor"] = None,
        layers: Optional[List["_models.Descriptor"]] = None,
        **kwargs
    ):
        """
        :keyword schema_version: Schema version.
        :paramtype schema_version: int
        :keyword media_type: Media type for this Manifest.
        :paramtype media_type: str
        :keyword config: V2 image config descriptor.
        :paramtype config: ~container_registry.models.Descriptor
        :keyword layers: List of V2 image layer information.
        :paramtype layers: list[~container_registry.models.Descriptor]
        """
        super(V2Manifest, self).__init__(schema_version=schema_version, **kwargs)
        self.media_type = media_type
        self.config = config
        self.layers = layers
