/*
* @license Apache-2.0
*
* Copyright (c) 2021 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

// TypeScript Version: 2.0

/* tslint:disable:max-line-length */
/* tslint:disable:max-file-line-count */

import MAX = require( './../../../unicode/max' );
import MAX_BMP = require( './../../../unicode/max-bmp' );

/**
* Interface describing the `unicode` namespace.
*/
interface Namespace {
	/**
	* Maximum Unicode code point.
	*
	* @example
	* var bool = ( ns.MAX === 1114111 );
	* // returns true
	*/
	MAX: typeof MAX;

	/**
	* Maximum Unicode code point in the Basic Multilingual Plane (BMP).
	*
	* @example
	* var bool = ( ns.MAX_BMP === 65535 );
	* // returns true
	*/
	MAX_BMP: typeof MAX_BMP;
}

/**
* Standard string unicode constants.
*/
declare var ns: Namespace;


// EXPORTS //

export = ns;
