#ifndef __RFCNB_H__
#define __RFCNB_H__

/* UNIX RFCNB (RFC1001/RFC1002) NetBIOS implementation
 *
 * Version 1.0
 * RFCNB Defines
 *
 * Copyright (C) Richard Sharpe 1996
 *
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* The Public API stuff */
#include "libntlmauth/rfcnb.h"

/* The internals */
#include "libntlmauth/smb-byteorder.h"

#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#ifdef RFCNB_PORT
#define RFCNB_Default_Port RFCNB_PORT
#else
#define RFCNB_Default_Port 139
#endif

#define RFCNB_MAX_STATS 1

/* Protocol defines we need */

#define RFCNB_SESSION_MESSAGE 0
#define RFCNB_SESSION_REQUEST 0x81
#define RFCNB_SESSION_ACK 0x82
#define RFCNB_SESSION_REJ 0x83
#define RFCNB_SESSION_RETARGET 0x84
#define RFCNB_SESSION_KEEP_ALIVE 0x85

/* Structures      */

typedef char RFCNB_Hdr[4];	/* The header is 4 bytes long with  */
/* char[0] as the type, char[1] the */
/* flags, and char[2..3] the length */

/* Macros to extract things from the header. These are for portability
 * between architecture types where we are worried about byte order     */

#define RFCNB_Pkt_Hdr_Len        4
#define RFCNB_Pkt_Sess_Len       72
#define RFCNB_Pkt_Retarg_Len     10
#define RFCNB_Pkt_Nack_Len       5
#define RFCNB_Pkt_Type_Offset    0
#define RFCNB_Pkt_Flags_Offset   1
#define RFCNB_Pkt_Len_Offset     2	/* Length is 2 bytes plus a flag bit */
#define RFCNB_Pkt_N1Len_Offset   4
#define RFCNB_Pkt_Called_Offset  5
#define RFCNB_Pkt_N2Len_Offset   38
#define RFCNB_Pkt_Calling_Offset 39
#define RFCNB_Pkt_Error_Offset   4
#define RFCNB_Pkt_IP_Offset      4
#define RFCNB_Pkt_Port_Offset    8

/* The next macro isolates the length of a packet, including the bit in the
 * flags                                                                   */

#define RFCNB_Pkt_Len(p)  (PVAL(p, 3) | (PVAL(p, 2) << 8) |     \
                          ((PVAL(p, RFCNB_Pkt_Flags_Offset) & 0x01) << 16))

#define RFCNB_Put_Pkt_Len(p, v) (p[1] = (((v) >> 16) & 1)); \
				(p[2] = (((v) >> 8) & 0xFF)); \
				(p[3] = ((v) & 0xFF));

#define RFCNB_Pkt_Type(p) (CVAL(p, RFCNB_Pkt_Type_Offset))

/*typedef struct RFCNB_Hdr {
 *
 * unsigned char type;
 * unsigned char flags;
 * int16 len;
 *
 * } RFCNB_Hdr;
 *
 * typedef struct RFCNB_Sess_Pkt {
 * unsigned char type;
 * unsigned char flags;
 * int16 length;
 * unsigned char n1_len;
 * char called_name[33];
 * unsigned char n2_len;
 * char calling_name[33];
 * } RFCNB_Sess_Pkt;
 *
 *
 * typedef struct RFCNB_Nack_Pkt {
 *
 * struct RFCNB_Hdr hdr;
 * unsigned char error;
 *
 * } RFCNB_Nack_Pkt;
 *
 * typedef struct RFCNB_Retarget_Pkt {
 *
 * struct RFCNB_Hdr hdr;
 * int dest_ip;
 * unsigned char port;
 *
 * } RFCNB_Redir_Pkt; */

/* Static variables */

/* Only declare this if not defined */

#ifndef RFCNB_ERRNO
extern int RFCNB_errno;
extern int RFCNB_saved_errno;	/* Save this from point of error */
#endif

/* I/O functions */
extern int RFCNB_Put_Pkt(RFCNB_Con *con, RFCNB_Pkt *pkt, int len);

extern int RFCNB_Get_Pkt(RFCNB_Con *con, RFCNB_Pkt *pkt, int len);

extern void RFCNB_Free_Pkt(RFCNB_Pkt *pkt);

/* Util functions */

void RFCNB_CvtPad_Name(char *name1, char *name2);

void RFCNB_AName_To_NBName(char *AName, char *NBName);

void RFCNB_NBName_To_AName(char *NBName, char *AName);

void RFCNB_Print_Hex(FILE * fd, RFCNB_Pkt *pkt, int Offset, int Len);

RFCNB_Pkt *RFCNB_Alloc_Pkt(int n);

void RFCNB_Print_Pkt(FILE * fd, char *dirn, RFCNB_Pkt *pkt, int len);

int RFCNB_Name_To_IP(char *host, struct in_addr *Dest_IP);

int RFCNB_Close(int socket);

int RFCNB_IP_Connect(struct in_addr Dest_IP, int port);

int RFCNB_Session_Req(RFCNB_Con *con,
                      char *Called_Name,
                      char *Calling_Name,
                      int * redirect,
                      struct in_addr *Dest_IP,
                      int *port);

#endif /* __RFCNB_H__ */
