/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Activity;
import android.view.View;
import android.widget.TextView;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.RobotiumUtils;
import com.jayway.android.robotium.solo.ViewFetcher;
import com.jayway.android.robotium.solo.Waiter;
import java.util.ArrayList;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Getter {
    private final ActivityUtils activityUtils;
    private final ViewFetcher viewFetcher;
    private final Waiter waiter;

    public Getter(ActivityUtils activityUtils, ViewFetcher viewFetcher, Waiter waiter) {
        this.activityUtils = activityUtils;
        this.viewFetcher = viewFetcher;
        this.waiter = waiter;
    }

    public <T extends View> T getView(Class<T> classToFilterBy, int index) {
        return this.waiter.waitForAndGetView(index, classToFilterBy);
    }

    public <T extends TextView> T getView(Class<T> classToFilterBy, String text, boolean onlyVisible) {
        this.waiter.waitForText(text, 0, 10000L, false, onlyVisible);
        ArrayList<T> views = this.viewFetcher.getCurrentViews(classToFilterBy);
        if (onlyVisible) {
            views = RobotiumUtils.removeInvisibleViews(views);
        }
        TextView viewToReturn = null;
        for (TextView view : views) {
            if (!((Object)view.getText()).toString().equals(text)) continue;
            viewToReturn = view;
        }
        if (viewToReturn == null) {
            Assert.assertTrue((String)("No " + classToFilterBy.getSimpleName() + " with text " + text + " is found!"), (boolean)false);
        }
        return (T)viewToReturn;
    }

    public View getView(int id) {
        Activity activity = this.activityUtils.getCurrentActivity(false);
        View view = activity.findViewById(id);
        if (view != null) {
            return view;
        }
        return this.waiter.waitForView(id);
    }
}

