#!/bin/bash

# dynamic link, no options

./configure
if [ $? -ne 0 ]
then
    echo "Configure failed"
    exit 1
fi

make
if [ $? -ne 0 ]
then
    echo "Make failed"
    exit 2
fi

MSGCOUNT=`./src/dc3dd --flags | grep -c "\<DEFAULT_BLOCKSIZE=32768\>"`
if [ $MSGCOUNT -ne 1 ]
then
    echo "DEFAULT_BLOCKSIZE=32768 flag line missing"
    exit 3
fi

LINECOUNT=`./src/dc3dd --flags | wc -l`
if [ $LINECOUNT -ne 3 ]
then
    echo "Flags line count wrong - should be 3"
    exit 3
fi


# dynamic link, options

make distclean
if [ $? -ne 0 ]
then
    echo "Make distclean failed"
    exit 2
fi

./configure CFLAGS="-O2 -DDEFAULT_HASH_MD5 -DDEFAULT_HASH_SHA1 -DDEFAULT_SIZEPROBE -DDEFAULT_PROGRESS -DDEFAULT_PROGRESSCOUNT=1000 -DDEFAULT_HASHCONV_AFTER"
if [ $? -ne 0 ]
then
    echo "Configure failed"
    exit 1
fi

make
if [ $? -ne 0 ]
then
    echo "Make failed"
    exit 2
fi

for a in DEFAULT_HASH_MD5 DEFAULT_HASH_SHA1 DEFAULT_SIZEPROBE DEFAULT_PROGRESS "DEFAULT_PROGRESSCOUNT=1000" DEFAULT_HASHCONV_AFTER "DEFAULT_BLOCKSIZE=32768"
do
    MSGCOUNT=`./src/dc3dd --flags | grep -c "\<$a\>"`
    if [ $MSGCOUNT -ne 1 ]
    then
        echo "$a flag line missing"
        exit 3
    fi
done

LINECOUNT=`./src/dc3dd --flags | wc -l`
if [ $LINECOUNT -ne 9 ]
then
    echo "Flags line count wrong - should be 8"
    exit 3
fi

# static link, options
make distclean
if [ $? -ne 0 ]
then
    echo "Make distclean failed"
    exit 2
fi

./configure CFLAGS="-O2 -DDEFAULT_HASH_MD5 -DDEFAULT_HASH_SHA1 -DDEFAULT_SIZEPROBE -DDEFAULT_PROGRESS -DDEFAULT_PROGRESSCOUNT=1000 -DDEFAULT_HASHCONV_AFTER -static"
if [ $? -ne 0 ]
then
    echo "Configure failed (static)"
    exit 1
fi

make
if [ $? -ne 0 ]
then
    echo "Make failed (static)"
    exit 2
fi

