/*
**	terminfo.h -- Definition of struct term
*/

#ifndef _TERMINFO_H
#define _TERMINFO_H

#ifndef CURSES
#    include <ncurses.h>
#endif

#	define CUR cur_term->


#define auto_left_margin               CUR Booleans[0]
#define auto_right_margin              CUR Booleans[1]
#define back_color_erase               CUR Booleans[2]
#define can_change                     CUR Booleans[3]
#define ceol_standout_glitch           CUR Booleans[4]
#define col_addr_glitch                CUR Booleans[5]
#define cpi_changes_res                CUR Booleans[6]
#define cr_cancels_micro_mode          CUR Booleans[7]
#define eat_newline_glitch             CUR Booleans[8]
#define erase_overstrike               CUR Booleans[9]
#define generic_type                   CUR Booleans[10]
#define hard_copy                      CUR Booleans[11]
#define hard_cursor                    CUR Booleans[12]
#define has_meta_key                   CUR Booleans[13]
#define has_print_wheel                CUR Booleans[14]
#define has_status_line                CUR Booleans[15]
#define hue_lightness_saturation       CUR Booleans[16]
#define insert_null_glitch             CUR Booleans[17]
#define lpi_changes_res                CUR Booleans[18]
#define memory_above                   CUR Booleans[19]
#define memory_below                   CUR Booleans[20]
#define move_insert_mode               CUR Booleans[21]
#define move_standout_mode             CUR Booleans[22]
#define needs_xon_xoff                 CUR Booleans[23]
#define no_esc_ctlc                    CUR Booleans[24]
#define no_pad_char                    CUR Booleans[25]
#define non_dest_scroll_region         CUR Booleans[26]
#define non_rev_rmcup                  CUR Booleans[27]
#define over_strike                    CUR Booleans[28]
#define prtr_silent                    CUR Booleans[29]
#define row_addr_glitch                CUR Booleans[30]
#define semi_auto_right_margin         CUR Booleans[31]
#define status_line_esc_ok             CUR Booleans[32]
#define dest_tabs_magic_smso           CUR Booleans[33]
#define tilde_glitch                   CUR Booleans[34]
#define transparent_underline          CUR Booleans[35]
#define xon_xoff                       CUR Booleans[36]
#define buffer_capacity                CUR Numbers[0]
#define columns                        CUR Numbers[1]
#define dot_vert_spacing               CUR Numbers[2]
#define dot_horz_spacing               CUR Numbers[3]
#define init_tabs                      CUR Numbers[4]
#define label_height                   CUR Numbers[5]
#define label_width                    CUR Numbers[6]
#define lines                          CUR Numbers[7]
#define lines_of_memory                CUR Numbers[8]
#define magic_cookie_glitch            CUR Numbers[9]
#define max_attributes                 CUR Numbers[10]
#define max_colors                     CUR Numbers[11]
#define max_micro_address              CUR Numbers[12]
#define max_micro_jump                 CUR Numbers[13]
#define max_pairs                      CUR Numbers[14]
#define maximum_windows                CUR Numbers[15]
#define micro_col_size                 CUR Numbers[16]
#define micro_line_size                CUR Numbers[17]
#define no_color_video                 CUR Numbers[18]
#define number_of_pins                 CUR Numbers[19]
#define num_labels                     CUR Numbers[20]
#define output_res_char                CUR Numbers[21]
#define output_res_line                CUR Numbers[22]
#define output_res_horz_inch           CUR Numbers[23]
#define output_res_vert_inch           CUR Numbers[24]
#define padding_baud_rate              CUR Numbers[25]
#define print_rate                     CUR Numbers[26]
#define virtual_terminal               CUR Numbers[27]
#define wide_char_size                 CUR Numbers[28]
#define width_status_line              CUR Numbers[29]
#define acs_chars                      CUR Strings[0]
#define back_tab                       CUR Strings[1]
#define bell                           CUR Strings[2]
#define carriage_return                CUR Strings[3]
#define change_char_pitch              CUR Strings[4]
#define change_line_pitch              CUR Strings[5]
#define change_res_horz                CUR Strings[6]
#define change_res_vert                CUR Strings[7]
#define change_scroll_region           CUR Strings[8]
#define char_padding                   CUR Strings[9]
#define char_set_names                 CUR Strings[10]
#define clear_all_tabs                 CUR Strings[11]
#define clear_margins                  CUR Strings[12]
#define clear_screen                   CUR Strings[13]
#define clr_bol                        CUR Strings[14]
#define clr_eol                        CUR Strings[15]
#define clr_eos                        CUR Strings[16]
#define column_address                 CUR Strings[17]
#define command_character              CUR Strings[18]
#define create_window                  CUR Strings[19]
#define cursor_address                 CUR Strings[20]
#define cursor_down                    CUR Strings[21]
#define cursor_home                    CUR Strings[22]
#define cursor_invisible               CUR Strings[23]
#define cursor_left                    CUR Strings[24]
#define cursor_mem_address             CUR Strings[25]
#define cursor_normal                  CUR Strings[26]
#define cursor_right                   CUR Strings[27]
#define cursor_to_ll                   CUR Strings[28]
#define cursor_up                      CUR Strings[29]
#define cursor_visible                 CUR Strings[30]
#define define_char                    CUR Strings[31]
#define delete_character               CUR Strings[32]
#define delete_line                    CUR Strings[33]
#define delete_phone                   CUR Strings[34]
#define dis_status_line                CUR Strings[35]
#define display_clock                  CUR Strings[36]
#define down_half_line                 CUR Strings[37]
#define ena_acs                        CUR Strings[38]
#define enter_alt_charset_mode         CUR Strings[39]
#define enter_am_mode                  CUR Strings[40]
#define enter_blink_mode               CUR Strings[41]
#define enter_bold_mode                CUR Strings[42]
#define enter_ca_mode                  CUR Strings[43]
#define enter_delete_mode              CUR Strings[44]
#define enter_dim_mode                 CUR Strings[45]
#define enter_doublewide_mode          CUR Strings[46]
#define enter_draft_quality            CUR Strings[47]
#define enter_insert_mode              CUR Strings[48]
#define enter_italics_mode             CUR Strings[49]
#define enter_leftward_mode            CUR Strings[50]
#define enter_micro_mode               CUR Strings[51]
#define enter_near_letter_quality      CUR Strings[52]
#define enter_normal_quality           CUR Strings[53]
#define enter_protected_mode           CUR Strings[54]
#define enter_reverse_mode             CUR Strings[55]
#define enter_secure_mode              CUR Strings[56]
#define enter_shadow_mode              CUR Strings[57]
#define enter_standout_mode            CUR Strings[58]
#define enter_subscript_mode           CUR Strings[59]
#define enter_superscript_mode         CUR Strings[60]
#define enter_underline_mode           CUR Strings[61]
#define enter_upward_mode              CUR Strings[62]
#define enter_xon_mode                 CUR Strings[63]
#define erase_chars                    CUR Strings[64]
#define exit_alt_charset_mode          CUR Strings[65]
#define exit_am_mode                   CUR Strings[66]
#define exit_attribute_mode            CUR Strings[67]
#define exit_ca_mode                   CUR Strings[68]
#define exit_delete_mode               CUR Strings[69]
#define exit_doublewide_mode           CUR Strings[70]
#define exit_insert_mode               CUR Strings[71]
#define exit_italics_mode              CUR Strings[72]
#define exit_leftward_mode             CUR Strings[73]
#define exit_micro_mode                CUR Strings[74]
#define exit_shadow_mode               CUR Strings[75]
#define exit_standout_mode             CUR Strings[76]
#define exit_subscript_mode            CUR Strings[77]
#define exit_superscript_mode          CUR Strings[78]
#define exit_underline_mode            CUR Strings[79]
#define exit_upward_mode               CUR Strings[80]
#define exit_xon_mode                  CUR Strings[81]
#define fixed_pause                    CUR Strings[82]
#define flash_hook                     CUR Strings[83]
#define flash_screen                   CUR Strings[84]
#define form_feed                      CUR Strings[85]
#define from_status_line               CUR Strings[86]
#define goto_window                    CUR Strings[87]
#define hangup                         CUR Strings[88]
#define init_1string                   CUR Strings[89]
#define init_2string                   CUR Strings[90]
#define init_3string                   CUR Strings[91]
#define init_file                      CUR Strings[92]
#define init_prog                      CUR Strings[93]
#define initialize_color               CUR Strings[94]
#define initialize_pair                CUR Strings[95]
#define insert_character               CUR Strings[96]
#define insert_line                    CUR Strings[97]
#define insert_padding                 CUR Strings[98]
#define key_a1                         CUR Strings[99]
#define key_a3                         CUR Strings[100]
#define key_b2                         CUR Strings[101]
#define key_backspace                  CUR Strings[102]
#define key_beg                        CUR Strings[103]
#define key_btab                       CUR Strings[104]
#define key_c1                         CUR Strings[105]
#define key_c3                         CUR Strings[106]
#define key_cancel                     CUR Strings[107]
#define key_catab                      CUR Strings[108]
#define key_clear                      CUR Strings[109]
#define key_close                      CUR Strings[110]
#define key_command                    CUR Strings[111]
#define key_copy                       CUR Strings[112]
#define key_create                     CUR Strings[113]
#define key_ctab                       CUR Strings[114]
#define key_dc                         CUR Strings[115]
#define key_dl                         CUR Strings[116]
#define key_down                       CUR Strings[117]
#define key_eic                        CUR Strings[118]
#define key_end                        CUR Strings[119]
#define key_enter                      CUR Strings[120]
#define key_eol                        CUR Strings[121]
#define key_eos                        CUR Strings[122]
#define key_exit                       CUR Strings[123]
#define key_f0                         CUR Strings[124]
#define key_f1                         CUR Strings[125]
#define key_f2                         CUR Strings[126]
#define key_f3                         CUR Strings[127]
#define key_f4                         CUR Strings[128]
#define key_f5                         CUR Strings[129]
#define key_f6                         CUR Strings[130]
#define key_f7                         CUR Strings[131]
#define key_f8                         CUR Strings[132]
#define key_f9                         CUR Strings[133]
#define key_f10                        CUR Strings[134]
#define key_f11                        CUR Strings[135]
#define key_f12                        CUR Strings[136]
#define key_f13                        CUR Strings[137]
#define key_f14                        CUR Strings[138]
#define key_f15                        CUR Strings[139]
#define key_f16                        CUR Strings[140]
#define key_f17                        CUR Strings[141]
#define key_f18                        CUR Strings[142]
#define key_f19                        CUR Strings[143]
#define key_f20                        CUR Strings[144]
#define key_f21                        CUR Strings[145]
#define key_f22                        CUR Strings[146]
#define key_f23                        CUR Strings[147]
#define key_f24                        CUR Strings[148]
#define key_f25                        CUR Strings[149]
#define key_f26                        CUR Strings[150]
#define key_f27                        CUR Strings[151]
#define key_f28                        CUR Strings[152]
#define key_f29                        CUR Strings[153]
#define key_f30                        CUR Strings[154]
#define key_f31                        CUR Strings[155]
#define key_f32                        CUR Strings[156]
#define key_f33                        CUR Strings[157]
#define key_f34                        CUR Strings[158]
#define key_f35                        CUR Strings[159]
#define key_f36                        CUR Strings[160]
#define key_f37                        CUR Strings[161]
#define key_f38                        CUR Strings[162]
#define key_f39                        CUR Strings[163]
#define key_f40                        CUR Strings[164]
#define key_f41                        CUR Strings[165]
#define key_f42                        CUR Strings[166]
#define key_f43                        CUR Strings[167]
#define key_f44                        CUR Strings[168]
#define key_f45                        CUR Strings[169]
#define key_f46                        CUR Strings[170]
#define key_f47                        CUR Strings[171]
#define key_f48                        CUR Strings[172]
#define key_f49                        CUR Strings[173]
#define key_f50                        CUR Strings[174]
#define key_f51                        CUR Strings[175]
#define key_f52                        CUR Strings[176]
#define key_f53                        CUR Strings[177]
#define key_f54                        CUR Strings[178]
#define key_f55                        CUR Strings[179]
#define key_f56                        CUR Strings[180]
#define key_f57                        CUR Strings[181]
#define key_f58                        CUR Strings[182]
#define key_f59                        CUR Strings[183]
#define key_f60                        CUR Strings[184]
#define key_f61                        CUR Strings[185]
#define key_f62                        CUR Strings[186]
#define key_f63                        CUR Strings[187]
#define key_find                       CUR Strings[188]
#define key_help                       CUR Strings[189]
#define key_home                       CUR Strings[190]
#define key_ic                         CUR Strings[191]
#define key_il                         CUR Strings[192]
#define key_left                       CUR Strings[193]
#define key_ll                         CUR Strings[194]
#define key_mark                       CUR Strings[195]
#define key_message                    CUR Strings[196]
#define key_move                       CUR Strings[197]
#define key_next                       CUR Strings[198]
#define key_npage                      CUR Strings[199]
#define key_open                       CUR Strings[200]
#define key_options                    CUR Strings[201]
#define key_ppage                      CUR Strings[202]
#define key_previous                   CUR Strings[203]
#define key_print                      CUR Strings[204]
#define key_redo                       CUR Strings[205]
#define key_reference                  CUR Strings[206]
#define key_refresh                    CUR Strings[207]
#define key_replace                    CUR Strings[208]
#define key_restart                    CUR Strings[209]
#define key_resume                     CUR Strings[210]
#define key_right                      CUR Strings[211]
#define key_save                       CUR Strings[212]
#define key_sbeg                       CUR Strings[213]
#define key_scancel                    CUR Strings[214]
#define key_scommand                   CUR Strings[215]
#define key_scopy                      CUR Strings[216]
#define key_screate                    CUR Strings[217]
#define key_sdc                        CUR Strings[218]
#define key_sdl                        CUR Strings[219]
#define key_select                     CUR Strings[220]
#define key_send                       CUR Strings[221]
#define key_seol                       CUR Strings[222]
#define key_sexit                      CUR Strings[223]
#define key_sf                         CUR Strings[224]
#define key_sfind                      CUR Strings[225]
#define key_shelp                      CUR Strings[226]
#define key_shome                      CUR Strings[227]
#define key_sic                        CUR Strings[228]
#define key_sleft                      CUR Strings[229]
#define key_smessage                   CUR Strings[230]
#define key_smove                      CUR Strings[231]
#define key_snext                      CUR Strings[232]
#define key_soptions                   CUR Strings[233]
#define key_sprevious                  CUR Strings[234]
#define key_sprint                     CUR Strings[235]
#define key_sr                         CUR Strings[236]
#define key_sredo                      CUR Strings[237]
#define key_sreplace                   CUR Strings[238]
#define key_sright                     CUR Strings[239]
#define key_srsume                     CUR Strings[240]
#define key_ssave                      CUR Strings[241]
#define key_ssuspend                   CUR Strings[242]
#define key_stab                       CUR Strings[243]
#define key_sundo                      CUR Strings[244]
#define key_suspend                    CUR Strings[245]
#define key_undo                       CUR Strings[246]
#define key_up                         CUR Strings[247]
#define keypad_local                   CUR Strings[248]
#define keypad_xmit                    CUR Strings[249]
#define lab_f0                         CUR Strings[250]
#define lab_f1                         CUR Strings[251]
#define lab_f2                         CUR Strings[252]
#define lab_f3                         CUR Strings[253]
#define lab_f4                         CUR Strings[254]
#define lab_f5                         CUR Strings[255]
#define lab_f6                         CUR Strings[256]
#define lab_f7                         CUR Strings[257]
#define lab_f8                         CUR Strings[258]
#define lab_f9                         CUR Strings[259]
#define lab_f10                        CUR Strings[260]
#define label_format                   CUR Strings[261]
#define label_off                      CUR Strings[262]
#define label_on                       CUR Strings[263]
#define meta_off                       CUR Strings[264]
#define meta_on                        CUR Strings[265]
#define micro_column_address           CUR Strings[266]
#define micro_down                     CUR Strings[267]
#define micro_left                     CUR Strings[268]
#define micro_right                    CUR Strings[269]
#define micro_row_address              CUR Strings[270]
#define micro_up                       CUR Strings[271]
#define newline                        CUR Strings[272]
#define order_of_pins                  CUR Strings[273]
#define orig_colors                    CUR Strings[274]
#define orig_pair                      CUR Strings[275]
#define pad_char                       CUR Strings[276]
#define parm_dch                       CUR Strings[277]
#define parm_delete_line               CUR Strings[278]
#define parm_down_cursor               CUR Strings[279]
#define parm_down_micro                CUR Strings[280]
#define parm_ich                       CUR Strings[281]
#define parm_index                     CUR Strings[282]
#define parm_insert_line               CUR Strings[283]
#define parm_left_cursor               CUR Strings[284]
#define parm_left_micro                CUR Strings[285]
#define parm_right_cursor              CUR Strings[286]
#define parm_right_micro               CUR Strings[287]
#define parm_rindex                    CUR Strings[288]
#define parm_up_cursor                 CUR Strings[289]
#define parm_up_micro                  CUR Strings[290]
#define pkey_key                       CUR Strings[291]
#define pkey_local                     CUR Strings[292]
#define pkey_xmit                      CUR Strings[293]
#define plab_norm                      CUR Strings[294]
#define print_screen                   CUR Strings[295]
#define prtr_non                       CUR Strings[296]
#define prtr_off                       CUR Strings[297]
#define prtr_on                        CUR Strings[298]
#define pulse                          CUR Strings[299]
#define quick_dial                     CUR Strings[300]
#define remove_clock                   CUR Strings[301]
#define repeat_char                    CUR Strings[302]
#define req_for_input                  CUR Strings[303]
#define reset_1string                  CUR Strings[304]
#define reset_2string                  CUR Strings[305]
#define reset_3string                  CUR Strings[306]
#define reset_file                     CUR Strings[307]
#define restore_cursor                 CUR Strings[308]
#define row_address                    CUR Strings[309]
#define save_cursor                    CUR Strings[310]
#define scroll_forward                 CUR Strings[311]
#define scroll_reverse                 CUR Strings[312]
#define select_char_set                CUR Strings[313]
#define set_attributes                 CUR Strings[314]
#define set_background                 CUR Strings[315]
#define set_bottom_margin              CUR Strings[316]
#define set_bottom_margin_parm         CUR Strings[317]
#define set_clock                      CUR Strings[318]
#define set_color_pair                 CUR Strings[319]
#define set_foreground                 CUR Strings[320]
#define set_left_margin                CUR Strings[321]
#define set_left_margin_parm           CUR Strings[322]
#define set_right_margin               CUR Strings[323]
#define set_right_margin_parm          CUR Strings[324]
#define set_tab                        CUR Strings[325]
#define set_top_margin                 CUR Strings[326]
#define set_top_margin_parm            CUR Strings[327]
#define set_window                     CUR Strings[328]
#define start_bit_image                CUR Strings[329]
#define start_char_set_def             CUR Strings[330]
#define stop_bit_image                 CUR Strings[331]
#define stop_char_set_def              CUR Strings[332]
#define subscript_characters           CUR Strings[333]
#define superscript_characters         CUR Strings[334]
#define tab                            CUR Strings[335]
#define these_cause_cr                 CUR Strings[336]
#define to_status_line                 CUR Strings[337]
#define tone                           CUR Strings[338]
#define underline_char                 CUR Strings[339]
#define up_half_line                   CUR Strings[340]
#define user0                          CUR Strings[341]
#define user1                          CUR Strings[342]
#define user2                          CUR Strings[343]
#define user3                          CUR Strings[344]
#define user4                          CUR Strings[345]
#define user5                          CUR Strings[346]
#define user6                          CUR Strings[347]
#define user7                          CUR Strings[348]
#define user8                          CUR Strings[349]
#define user9                          CUR Strings[350]
#define wait_tone                      CUR Strings[351]
#define xoff_character                 CUR Strings[352]
#define xon_character                  CUR Strings[353]
#define zero_motion                    CUR Strings[354]


typedef struct term
{
   char	 *term_names;	/* offset in str_table of terminal names */
   char	 *str_table;	/* pointer to string table */
   short Filedes;	/* file description being written to */
   SGTTY Ottyb,		/* original state of the terminal */
	 Nttyb;		/* current state of the terminal */

   char		 Booleans[37];
   short	 Numbers[30];
   char		 *Strings[355];
} TERMINAL;

TERMINAL	*cur_term;

#define BOOLCOUNT 37
#define NUMCOUNT  30
#define STRCOUNT  355

extern int read_entry(char *, TERMINAL*);
extern int must_swap();

#endif
