Release 2.03 (2025-12-16)
-------------------------

General changes:

- Improved C sources to be more Coccinelle friendly. (Ville Syrjälä)

- Improved documentation on freedesktop GitLab pages. (Pawel Sikora and
  Swati Sharma)

Library changes:

- Fixes for MEM_COPY instruction. (Balasubramani Vivekanandan)

- Added AMDGPU LLVM assembler utility for shader compilation. (Jesse Zhang)

- Added GFX1200 amdgpu family. (Jesse Zhang)

- Added support for basic-modeset for xe driver in kms_prime. (Santhosh Reddy
  Guddati)

- New Xe survivability test for Intel BMG GPU. (Sk Anirban)

- Added PCI ids for CRI and NovaLake-S. (Kamil Konieczny)

- Added Panthor driver in drmtest lib. (Daniel Almeida)

- Fixed device opening with IGT_FORCE_DRIVER (Kamil Konieczny)

- Corrected MOCS index for displayable surfaces. (Tvrtko Ursulin)

- Added Virtio-GPU driver in drmtest lib. (Mark Yacoub)

Test changes:

- New Xe multi queue test. (Niranjana Vishwanathapura)

- Improved Xe OA testing. (Ashutosh Dixit)

- Improved Xe EUdebug testing. (Andrzej Hajda, Dominik Karol Piątkowski,
  Jan Maslak, Mika Kuoppala)

- Added subtest for Intel dgfx Package G7 residency in kms_pm_rpm. (Mohammed
  Thasleem)

- New AMDGPU memory management test suite. (Jesse Zhang)

- New KMS color pipeline and LUT testing. (Alex Hung and Harry Wentland)

- Improved Intel xe_debugfs test. (Piotr Piórkowski)

- Improved Xe SRIOV testing. (Marcin Bernatowicz)

- New subtest for content protection with suspend resume HDCP-MST. (Jeevan B)

- Improved dmabuf test on slow platforms. (Janusz Krzysztofik)

- New Intel kms_sharpness_filter test. (Swati Sharma)

- New tests for Panthor. (Daniel Almeida and Boris Brezillon)

- Added support for MediaTek in few display tests. (Jason-JH Lin)

- New SRIOV test for VF access to VRAM via BAR. (Lukasz Laguna)

- Added timeslice preempt test in xe_exec_reset for validation of the restart
  paths in the DRM scheduler TDR (Timeout Detection and Recovery). (Matthew
  Brost)

Tools changes:

- Added iteration option in intel_gpu_top. (Simon Fairweather)

- Added Alderlake-P register definitions. (Naladala Ramanaidu)

- Improved devices filtering in lsgpu. (Zbigniew Kempczyński)

- Improved intel_vbt_decode and intel_display_poller. (Ville Syrjälä)

Scripts changes:

- New script for converting a 3D LUT data to igt_3dlut_t array. (Alex Hung)


And many other bug fixes, improvements, cleanups and new tests.


Release 2.02 (2025-09-26)
-------------------------

General changes:

- PNG images moved to new data/ directory. (Naladala Ramanaidu, Swati Sharma)

- Added default checkpatch config. (Peter Senna Tschudin)

Library changes:

- New VKMS driver in drmtest lib. (José Expósito)

- Added PCI ids for BMG and WildcatLake.(Ravi Kumar Vodapalli, Jani Nikula)

- Separation of Intel compute kernels for easy maintainance. (Zbigniew
  Kempczyński)

- Reduced logs for KMS tests with IGT_CI_RUN env var. (Pranay Samala)

- New ASIC-aware gfx hooks for amdgpu. (Vitaly Prosyak)

- Added SDMA support for user queues for amdgpu. (Jesse Zhang)

- Improved GTs id handling in Xe. (Matt Roper)

- New lib for Intel WA checks. (Mohammed Thasleem)

- New lib for directory traversal and file handling. (Peter Senna Tschudin)

- Added support for the device filters during device scan. (Soham Purkait)

Test changes:

- New tests for VKMS. (José Expósito, Louis Chauvet, Jim Shargo, Marius Vlad)

- Added madvise subtests for Xe system allocator. (Nishit Sharma)

- Improved Xe configfs testing. (Lucas De Marchi)

- Improved KMS HDR panel testing. (Chaitanya Kumar Borah)

- Added subtests for engine activity accuracy. (Soham Purkait, Riana Tauro)

- Improved Xe OA testing. (Ashutosh Dixit, Umesh Nerlige Ramappa, Sushma
  Venkatesh Reddy)

- New core and kms tests for sysfs and debugfs. (Peter Senna Tschudin)

- Improved Xe system allocator testing. (Matthew Brost)

- Improved Xe SRIOV testing. (Marcin Bernatowicz)

- Improved KMS async flips tests with async modifiers. (Santhosh Reddy Guddati)

- New multi-GPU test cases for amdgpu. (Jesse Zhang)

- Added subtest for async flips with DPMS. (Karthik B S)

- Added tests for MSM. (Rob Clark)

Tools changes:

- Improved intel_vbt_decode. (Jani Nikula)

- Added Xe support to intel_dp_compliance. (Disantkumar Mistry)

Runner changes:

- Relaxed timeout reduction on soft lockup. (Janusz Krzysztofik)

- Added a hook for kmemleak scan after the unbind operation. (Peter Senna
  Tschudin)

Scripts changes:

- Renamed blocklist verify script. (Kamil Konieczny)


And many other bug fixes, improvements, cleanups and new tests.


Release 2.01 (2025-06-27)
-------------------------

General changes:

- Bumped required meson version to 0.52.1 (Andrzej Hajda)

- Added man page for lsgpu. (Peter Senna Tschudin)

Devops changes:

- Improved GitLab CI pipeline. (Andrzej Hajda)

- Bumped Debian version to bullseye and Fedora to latest 42 (Andrzej Hajda)

- Removed MIPS testing (Ryszard Knop and Andrzej Hajda)

Library changes:

- Updated PCI ids for BMG/PTL. (Shekhar Chauhan and Kamil Konieczny)

- Preliminary enablement for Android compilation (Sapna Singh and Jeevaka
  Prabu Badrappan)

- Improved kernel module un/binding. (Lucas De Marchi and Francois Dugast)

- Added user mode queues UMQ support for amdgpu. (Sunil Khatri)

- Improved Intel GPGPU compute libs. (Francois Dugast and Zbigniew Kempczyński)

- New configfs library. (José Expósito, Jim Shargo, Marius Vlad, Riana Tauro)

- Added PTL support in Xe OA libs. (Sushma Venkatesh Reddy)

- Improved capturing logs for child processes. (Pawel Sikora)

Test changes:

- New test drm_virtgpu for VirtIO-GPU. (Dorinda Bassey)

- New Xe survivability mode testing. (Riana Tauro)

- New amdgpu tests for jpeg and vcn queues. (Ruili Ji)

- New Xe system allocator test. (Matthew Brost).

- Improved Xe fault injection. (Satyanarayana K V P)

- New Xe PXP test. (Daniele Ceraolo Spurio)

- Unified Intel sysfs and debugfs testing. (Peter Senna Tschudin)

- Improved chamelium color test. (Swati Sharma)

- Improved Xe OA testing. (Ashutosh Dixit, Sai Teja Pottumuttu and Umesh
  Nerlige Ramappa)

- Added dual display subtest in multi plane test. (Karthik B S)

Tools changes:

- New tool intel_hdcp for printing HDCP info on connected outputs. (Santhosh
  Reddy Guddati)

- Add support for gen10+ devices in intel_gtt (Tomita Moeko)

- Add support for Xe in intel_pm_rpm (Soham Purkait)

Runner changes:

- Use boottime for time checks. (Kamil Konieczny)

Benchmark changes:

- New Xe benchmarks. (Pravalika Gurram)


And many other bug fixes, improvements, cleanups and new tests.


Release 2.00 (2025-03-13)
-------------------------

General changes:

- Added Karthik B S as a new maintainer.

Library changes:

- Added GFX1153 to GFX1150 amdgpu family. (Tim Huang)

- Improved kernel module un/loading. (Lucas De Marchi)

- Added ftrace logs at test boundaries. (Umesh Nerlige Ramappa)

- Improved device scanning used in device filters. (Zbigniew Kempczyński)

- Add support to check joiner mode limit. (Jeevan B)

- Updated PCI ids for DG2/MTL/BMG/PTL. (Matt Atwood)

- Added PTL opencl kernels. (Janga Rahul Kumar and Priyanka Dandamudi)

- Extended GPGPU compute square kernel for PTL. (Sai Gowtham Ch)

- Using Long Running mode for GPGPU compute with Xe. (Francois Dugast)

- Make running under Valgrind quiet. (Tvrtko Ursulin)

Runner changes:

- Added igt_runner cmdline to results. (Lucas De Marchi)

- Added printing GPU related facts. (Peter Senna Tschudin)

- Added kmemleak scans. (Peter Senna Tschudin)

- Parse results more persistently. (Kamil Konieczny)

Test changes:

- Improved Xe EUdebug tests. (Dominik Grzegorzek)

- Improved support for 3d testing on VMs for vmwgfx. (Maaz Mombasawala)

- Improved Xe debugfs testing. (Pravalika Gurram)

- Improved amdgpu PCI unplug test. (Vitaly Prosyak)

- Added support for page queues in amdgpu tests. (Jesse Zhang)

- New short hibernate subtest in Intel KMS ccs. (Juha-Pekka Heikkila)

- Renamed test i915_pipe_stress into kms_pipe_stress and added
  support for Xe in it. (Swati Sharma)

- New test for devcoredump for Xe. (Zhanjun Dong)

- New DP link training validation of both UHBR and non-UHBR link
  rates over SST and MST configurations. (Kunal Joshi)

- New test for Frame Buffer Compression (FBC) with dirty rectangles which
  allows FBC to recompress a subsection of a frame. (Santhosh Reddy Guddati)

- New test for EU stall sampling for Xe. (Harish Chegondi)

- New test for eudebug/SR-IOV exclusion for Xe. (Christoph Manszewski)

- New test for PMU (Performance Monitoring Unit) for Xe. (Vinay Belgaumkar
  and Riana Tauro)

- New test for SRIOV auto-provisioning for Xe. (Marcin Bernatowicz)

- New equal-throughput validation for VFs in SRIOV. (Marcin Bernatowicz)

- Improved test documentation. (Katarzyna Piecielska and Swati Sharma)

- Improved Xe OA test. (Umesh Nerlige Ramappa, Sai Teja Pottumuttu and
  Ashutosh Dixit)

Tools and scripts changes:

- New tool for measuring display memory bandwidth utilization (Ville Syrjälä)

- New igt_facts tool for displaying GPU related info. (Peter Senna Tschudin)

- Power tool renamed to igt_power (Kamil Konieczny)

- New --pci-slot option in intel_reg for multi-GPU configs. (Łukasz Łaguna
  and Kamil Konieczny)

- Added kmemleak option to run-tests.sh script. (Peter Senna Tschudin)

And many other bug fixes, improvements, cleanups and new tests.


Release 1.30 (2024-12-13)
-------------------------

General changes:

- New meson options xe_eudebug and vmtb.

Library changes:

- Added PantherLake (PTL) support, unified PCI IDs into one
  common header pciids.h (Ngai-Mint Kwan)

- Added BMG support for OA (Observability Architecture) for Xe driver.
  (José Roberto de Souza)

- Added support for Xe3 platforms in GPGPU shader. (Andrzej Hajda)

- Added 6k resolution support for a single CRTC. (Jeevan B)

- Added support for MTL platform in GPGPU compute. (Nishit Sharma)

Runner changes:

- Set option PRUNE_KEEP_ALL as default. (Kamil Konieczny)

- Allow to dynamically ignore dmesg warn messages when generating
  results, usefull when driver is using kernel fault injection.
  (Kamil Konieczny).

Test changes:

- Added sanity checks for KMS properties. (Dmitry Baryshkov, Maxime Ripard)

- Improved GPGPU tests for i915 and Xe. (Zbigniew Kempczyński)

- New SRIOV test for Functional Level Reset (FLR) for Xe. (Marcin Bernatowicz)

- Added test that draws triangle without using 3d commands for vmwgfx.
  (Maaz Mombasawala)

- Added subtest for fallback for DP connector. (Kunal Joshi)

- Added async flips suspend resume subtest. (Santhosh Reddy Guddati)

- New test for error handling of Xe at probe time. (Francois Dugast)

- Added testing SIZE_HINTS property in KMS cursor test. (Ville Syrjälä)

- Added KMS testing for ultrajoiner. (Karthik B S)

- New test for TLB invalidation in Xe. (Sai Gowtham Ch)

- New test for timeslice duration in Xe. (Sai Gowtham Ch)

- Display brightness test during DPMS on and off. (Mohammed Thasleem)

- New tests for EU debugging for Xe. (Dominik Grzegorzek, Mika Kuoppala,
  Christoph Manszewski, Karolina Stolarek, Maciej Patelczyk, Pawel Sikora,
  Andrzej Hajda, Dominik Karol Piątkowski, Jonathan Cavitt et al)

Tools changes:

- New power tool for power/energy measurement. (Ville Syrjälä)

- New VM Testbench (VMTB) - SR-IOV Virtual Machine testing tool.
  (Adam Miszczak)

- Fixes in amd_hdmi_compliance. (Stylon Wang and Wayne Lin)

- Fixes in intel_reg. (Lucas De Marchi)

And many other bug fixes, improvements, cleanups and new tests.


Release 1.29 (2024-09-04)
-------------------------

General changes:

- Added gcc warns: dangling-pointer, int-conversion (Bhanuprakash Modem)

- More guidelines in CONTRIBUTING. (Louis Chauvet, Kamil Konieczny)

- Reorganized Tests: Moved all vendor specific tests to their own dir
  (Bhanuprakash Modem)

- Fix musl/uclibc build (Bernd Kuhls, Stefano Ragni)

Benchmarks changes:

- New KMS framebuffer stress benchmark. (Arthur Grillo)

- Added basic Xe support in gem_wsim. (Marcin Bernatowicz)

Documentation changes:

- Add documentation about cross-builds. (Mauro Carvalho Chehab)

- Improve tests documentation. (Katarzyna Piecielska)

Library changes:

- Add Battlemage (BMG) support in xe_pciids.h (Andrzej Hajda)

- Add amdgpu GFX1152, GFX1150 and gfx12. (Jesse Zhang and Tim Huang)

- Added inline support for iga64 assembly in GPGPU shader. (Andrzej Hajda)

- Improved KUnit support. (Janusz Krzysztofik)

- Enable igt run on security enhanced distros (like Gentoo/Hardened)
  (Matt Turner)

- Use blitter as a default for all KMS tests. (Juha-Pekka Heikkila and
  Bhanuprakash Modem)

- Increased MAX supported pipes to 16 (Pipe-A to Pipe-P) (Vignesh Raman)

- Added generic way to reset sysfs/debugfs attrs to default values upon
  exit. (Ville Syrjälä)

Runner changes:

- Added hook scripts to igt_runner. (Gustavo Sousa)

Test changes:

- Added support for Xe in KMS tests. (Swati Sharma, Bhanuprakash Modem et al)

- Added new subtests and improvements to VRR. (Bhanuprakash Modem, Jeevan B,
  Manasi Navare, Sean Paul et al)

- Added new subtests to force joiner. (Kunal Joshi)

- Added fbdev tests to Xe. (Bhanuprakash Modem)

- Added amdgpu fuzzing tests. (Vitaly Prosyak)

- Added syncobj_eventfd test. (Simon Ser)

- Added basic Single-Root IO Virtualization (SRIOV) test. (Katarzyna Dec et al)

- Added prime test for vmwgfx. (Zack Rusin)

- Improved core_getversion. (Rob Clark, Helen Koike, Kamil Konieczny)

- Improved kms_atomic on non-mutable planes. (Melissa Wen)

- Added and improved Xe tests. (Rodrigo Vivi, Matthew Auld, Zbigniew Kempczyński,
  Francois Dugast, Nirmoy Das, Lucas De Marchi, Janga Rahul Kumar et al)

Tools and scripts changes:

- New Xe perf/OA tools. (Ashutosh Dixit)

- New intel_tiling_detect tool. (Zbigniew Kempczyński)

- New option in lsgpu for printing GPU on PCI bus, working also
  in case when no gpu driver is loaded. (Zbigniew Kempczyński)

- Added sysfs profiling knob to gputop. (Adrián Larumbe)

- Support for Xe in gputop. (Lucas De Marchi)

- Improved generating test lists at compilation time.(Mauro Carvalho Chehab)

- Improved code coverage. (Mauro Carvalho Chehab)

- Improved intel_vbt_decode and other intel tools. (Ville Syrjälä,
  Lucas De Marchi, Jani Nikula, Tvrtko Ursulin, Gustavo Sousa et al)


And many other bug fixes, improvements, cleanups and new tests.


Release 1.28 (2023-09-13)
-------------------------

General changes:

- New meson options testplan, sphinx and xe_driver. (Mauro Carvalho Chehab)

Library changes:

- Add amdgpu GFX1036, GFX1037 chips. (Jesse Zhang)

- Add xe_pciids.h with Lunar Lake (LNL) support. (Lucas De Marchi)

- Use the new procps library libproc2. (Craig Small)

- Add helper for srandom seed initialization. (Łukasz Łaguna)

- Support for vmwgfx driver. (Maaz Mombasawala, Roye Eshed, Zack Rusin)

- i915_pciids.h updated to include Pontevecchio (PVC) platform.
  (Niranjana Vishwanathapura)

- Add OAM formats and support for media engines in perf tests.
  (Umesh Nerlige Ramappa)

- Support for Xe driver. (Matthew Brost, Mauro Carvalho Chehab, Rodrigo Vivi,
  Jason Ekstrand, Francois Dugast, Philippe Lecluse, Zbigniew Kempczyński,
  Maarten Lankhorst, Juha-Pekka Heikkila, Bhanuprakash Modem et al)

Runner changes:

- igt_runner can now dump GPU state on timeout. (Chris Wilson)

- igt_runner will now use proper 'abort' as result instead of pseudoresult.
  (Petri Latvala)

Tools changes:

- New vendor agnostic gputop tool. (Tvrtko Ursulin)

- New tool to dump Intel GuC/HuC CSS header. (Lucas De Marchi)

- Improve tools intel_watermark, intel_vbt_decode, intel_reg. (Ville Syrjälä)

Documentation changes:

- New way for documenting tests will allow to generate documentation and
  testlists during build, see README.md and test_documentation.md. This
  is mandatory for Intel (both i915 and xe) and kms tests. (Mauro Carvalho
  Chehab)

Test changes:

- Move intel specific tests to new directory. (Bhanuprakash Modem)

- Ported and refactored drmlib security tests in amdgpu. (Vitaly Prosyak)

- Switch DRM selftests to KUnit. (Isabella Basso, Dominik Karol Piątkowski,
  Mauro Carvalho Chehab)

- Enabled MeteorLake aux ccs tests. (Juha-Pekka Heikkila)

- Exercise oversized object detection for Xe. (Priyanka Dandamudi)

- Enable validation for VDSC output formats. (Swati Sharma)

- Add support for Bigjoiner / 8K mode. (Bhanuprakash Modem)

- Use intel_cmds_info library. (Karolina Stolarek)

- Use Intel kernel gpu command definitions. (Zbigniew Kempczyński)

- Add a basic perf_pmu test. (Riana Tauro)

- Add test for V3D's Wait BO IOCTL. (Maíra Canal)

- Add i915_power test for power measurement. (Ashutosh Dixit)

- Remove sysfs_clients. (Lucas De Marchi)


And many other bug fixes, improvements, cleanups and new tests.


Release 1.27.1 (2023-01-18)
-------------------------

- Removed gcc option -fcommon from meson.build and fix broken
  build on Linux RedHat platform. (Zbigniew Kempczyński)

- Updated CONTRIBUTING guidelines for interface deprecation. (Petri Latvala)

- Fixed one additional test bug (Zbigniew Kempczyński)

Release 1.27 (2023-01-12)
-------------------------

- Support for Intel discrete graphics and other new platforms (Andrzej
  Turko, Matt Roper, Clint Taylor, Tejas Upadhyay, et al)

- Support for MSM driver. (Mark Yacoub, Rob Clark)

- Support for SRIOV device selection. (Łukasz Łaguna)

- Tiled display emulation support with chamelium. (Kunal Joshi)

- Support for Chamelium v3. (Mark Yacoub)

- Initial FreeBSD support. (Jake Freeland)

- Structured communication from tests to igt_runner. (Petri Latvala)

- Removed last remaining uses of libdrm_intel in tests and
  tools. (Zbigniew Kempczyński)

- Automatic kernel code coverage collection during testing. (Mauro
  Carvalho Chehab)


And many other bug fixes, improvements, cleanups and new tests.


Release 1.26 (2021-04-23)
-------------------------

- Autotools support has been entirely dropped in favor of only meson. (Arkadiusz Hiler)

- Tests can now signal that the whole test round should be aborted. (Arkadiusz Hiler)

- Various robustness improvements for Chamelium use. (Arkadiusz Hiler,
  Kunal Joshi, Imre Deak, et al)

- Device filtering improvements for multi-device use. (Arkadiusz Hiler)

- Device filtering for various Intel tools like intel_gpu_top. (Ayaz A Siddiqui)

- Overhauled kernel parameter handling. (Jani Nikula)

- Introduced an i915 batchbuffer facility. (Zbigniew Kempczyński)

- Improvements for testing nouveau. (Lyude Paul)

- More readable and useful output for lsgpu and other tools that list
  devices. (Tvrtko Ursulin)

- intel_gpu_top can now show per-client busyness stats. (Tvrtko Ursulin)

- igt_runner can now limit the disk space used by a single test. (Petri Latvala)


And many other bug fixes, improvements, cleanups and new tests.


Release 1.25 (2020-03-20)
-------------------------

- Meson build options have been renamed. Please check the news options in
  meson_options.txt and make sure you don't get any warnings when configuring
  the project. (Simon Ser)

- Compile-testing CI for MIPS. (Guillaume Tucker)

- Various igt_runner reliability improvements (Petri Latvala & Arkadiusz Hiler)

- Switched GEM tests to engine discovery. (Tvrtko Ursulin et al)

- Subtests can now be documented and their descriptions are available in
  generated HTML docs and on the command line via --describe. Documenting new
  tests is mandatory. (Arkadiusz Hiler)

- Unified library for EDID creation (Simon Ser)

- Chamelium port auto-discovery (Simon Ser)

- Tigerlake support (Lucas De Marchi)

- Cometlake support (Anusha Srivatsa)

- Add kernel selftest wrapper for dmabuf (Chris Wilson)

- Bumped required meson version to 0.47.2 (Arkadiusz Hiler)

- Rewritten README to be more friendly (Arkadiusz Hiler)

- Introduced dynamic subsubtests for getting partial result for
  runtime-dependant features (Petri Latvala)

- IGT can now run on the selected GPU via --device and lsgpu tool (Zbigniew
  Kempczyński)

- Reduced runtime of many many tests (Chris Wilson et al)


And many other bug fixes, improvements, cleanups and new tests.


Release 1.24 (2019-06-20)
-------------------------

- Bumped required meson version to 0.47. (Arkadiusz Hiler)

- All the meson build options that used auto, true and false are now first
  class 'feature' options taking auto, enabled and disabled. (Arkadiusz Hiler)

- Piglit as the primary test executor replaced by mostly drop-in
  compatible igt_runner. (Petri Latvala)

- Stack traces now contain source file names and line numbers, using
  libdw. (Maarten Lankhorst)

- Pixman dependency is now mandatory. (Maxime Ripard)

- The project has moved to gitlab, and uses gitlab's CI to build test
  and sanity test each commit on various distributions and
  architectures. (Arkadiusz Hiler et al)

- Shader debugger removed due to lack of use and accumulation of
  bitrot. (Arkadiusz Hiler)

- Added support for testing DP/HDMI audio with the Chamelium device,
  dropping the audio tests that required exotic custom hardware to
  execute. (Simon Ser)

- Autotools support dropped for various parts of IGT (assembler,
  documentation, etc). (Daniel Vetter)

- intel-gpu-top can now output data to stdout or a log file for
  noninteractive use. (Tvrtko Ursulin)


And many other bug fixes, improvements, cleanups and new tests.


Release 1.23 (2018-07-18)
-------------------------

General changes:

- Bumped used C standard to gnu11. (Lucas De Marchi)

- Bumped required meson version to 0.44. (Petri Latvala)

- Introduced meson options for explicit control over optional dependencies.
  (Petri Latvala)

- Added a meson option to set runpath for the installed executables.
  (Petri Latvala)

- GLib is now a mandatory dependency. (Petri Latvala)

- Added testlists for the vc4 driver. (Maxime Ripard)

- The project has now finalized its name change and is now IGT GPU Tools,
  docs and install paths are now "igt-gpu-tools". (Arkadiusz Hiler)

- Added a blacklist for the Intel CI. (Petri Latvala)


Library changes:

- i915_pciids.h updated to include KBL, ICL, WHL and AML.
  (José Roberto de Souza, Paulo Zanoni)

- Overhaul of gpu_cmds, gpgpu_fill, media_fill and rendercopy.
  (Katarzyna Dec, Lukasz Kalamarz)

- Added igt_matrix and igt_color_encoding helper libraries. (Ville Syrjälä)

- IGT now shows the kernel stack trace when reporting a GPU hang. (Chris Wilson)

- Added Icelake platform support. (Arkadiusz Hiler, Paulo Zanoni)


Tools changes:

- intel-gpu-top was rewritten to be safe to use. (Tvrtko Ursulin)


Documentation changes:

- Documented commit rights in CONTRIBUTING. (Daniel Vetter)


Test changes:

- kms_prs_sink_crc was renamed to kms_psr. (Dhinakaran Pandiyan)

- kms_frontbuffer_tracking no longer tests sink crc. (Dhinakaran Pandiyan)

- drm_vma_limiter is no more. (Chris Wilson)


And many other bug fixes, improvements, cleanups and new tests.


Release 1.22 (2018-03-09)
-------------------------

General changes:

- Libudev has been made a mandatory dependency. (Antonio Argenziano)

- Documentation changed to refer to the new igt-dev mailing
  list. (Rhys Kidd)

Library changes:

- Refactored timer usage for smaller code size. (Chris Wilson)

- Various fixes to support planar framebuffers. (Maarten Lankhorst)

- Added support for fetching the most recent CRC without waiting for a
  vblank, along with flushing the queue of already collected
  CRCs. (Maarten Lankhorst)

- Added a helper to mark BOs purgeable on vc4. (Boris Brezillon)

- Moved handling of a "cork" BO into lib from various tests.
  (Daniele Ceraolo Spurio)

- Added support for looping over physical i915 engines, as opposed to
  uABI engines that can alias. (Chris Wilson)

- Added an accelerated method for reading from WC buffers.
  (Chris Wilson)

Tools changes:

- Improved intel_vbt_decode output, updated the data from current
  kernel. (Jani Nikula)

- intel_reg can now read/write registers using a given engine.
  (Mika Kuoppala)

- Aubdump can now simulate enhanced execlist submission, for
  gen11+. (Scott D Phillips)





And many other bug fixes, improvements, cleanups and new tests.

Release 1.21 (2018-01-16)
-------------------------

Library changes:

- Added helpers for using DRM syncobj. (Jason Ekstrand)

- Refactored several i915 helpers into library functions.
  (Michał Winiarski)

- Improved the GPU quiescing code to more thoroughly flush old data
  and pending work. (Chris Wilson)

- Reworked DRM property handling to be more suitable for
  atomic commits. (Maarten Lankhorst)

- Removed support for legacy CRC API. The generic API has been
  available since kernel 4.10. (Maarten Lankhorst)

- Opening a DRM device now automatically loads its module. (Chris Wilson)

- Imported the drm-uapi headers as copies instead of using what's
  installed in the system. (Eric Anholt)

- Moved the perf code to its own library from
  intel-gpu-overlay. (Tvrtko Ursulin)

- Removed Android support due to lack of use and
  maintenance. (Arkadiusz Hiler)

- Upgraded meson to official production status, automake is still kept
  around for now.

Tools changes:

- Improved the output of intel_vbt_decode. (Jani Nikula)

- intel_error_decode now prints user buffers if they contain debug
  logs. (Chris Wilson)

- Improved the output of intel_watermark. (Ville Syrjälä,
  Dhinakaran Pandiyan)

- Aubdump can now simulate execlist submission, converting from ring
  buffer submission method. (Scott D Phillips)

- intel-gpu-overlay can now show data from perf PMU. (Tvrtko Ursulin,
  Chris Wilson)

- intel-gpu-overlay now parses tracepoint locations from
  sysfs. (Lionel Landwerlin)

Documentation changes:

- Documentation can now be built with Meson. (Daniel Vetter)


And many other bug fixes, improvements, cleanups and new tests.

Release 1.20 (2017-10-03)
-------------------------

Library changes:

- Added helpers for launching external processes and capturing their
  outputs. (Abdiel Janulgue)

- Increased max pipe count to 6 to support AMD GPUs. (Leo (Sunpeng) Li)

- Various improvements for Chamelium support. (Paul Kocialkowski)

- Added Coffeelake platform support. (Rodrigo Vivi, Anusha Srivatsa)

- Added Cannonlake platform support. (Rodrigo Vivi)

- Added support for audio testing. (Paul Kocialkowski)

- Added preliminary meson build system support. (Daniel Vetter, et al)
  -- Autotools remains the supported build system for now.

Tools changes:

- Refactored video bios data to use definitions copied from the
  kernel. (Jani Nikula)

Documentation changes:

- Added user and developer documentation about Chamelium support to
  aid deploying the platform. (Paul Kocialkowski)

- Added documentation about the required hardware setup for audio
  testing. (Paul Kocialkowski)

Tests changes:

- Converted remaining shell-script tests to C code (Abdiel Janulgue)

- Multiple new tests.


And many other bug fixes and improvements.

Release 1.19 (2017-06-09)
-------------------------

Library changes:

- Changed debugfs handlers to open files for the DRM device in use,
  for setups with more than one DRM device. (Tomeu Vizoso)

- Added support for 4K and audio HDMI EDID injection. (Abdiel
  Janulgue, Marius Vlad)

- Added support for AMDGPU devices. (Chris Wilson)

Tools changes:

- intel_error_decode now automatically opens a pager. (Chris Wilson)

- intel_error_decode now dumps the GuC firmware logs if available.
  (Chris Wilson)

Benchmark changes:

- gem_wsim: New benchmark that simulates command submission
  workloads. (Tvrtko Ursulin)

Scripts changes:

- trace.pl: New tool to parse i915 tracepoints for performance
  analysis. (Tvrtko Ursulin)

- media-bench.pl: New tool to programmatically analyze simulated media
  workloads using gem_wsim to find the optimal load balancing
  strategy. (Tvrtko Ursulin)

Test changes:

- Imported amdgpu tests from libdrm. (Chris Wilson)

- Multiple other new tests.


And many other bug fixes and improvements.

Release 1.18 (2017-03-13)
-------------------------

Library changes:

- Various changes to library functions so that they don't assume Intel
  hardware. (Lyude)

- Added helper functions for managing synchronization primitives.
  (Robert Foss)

- Added support for the new generic CRC capture kernel ABI. (Tomeu
  Vizoso)

- Added Geminilake platform support. (Ander Conselvan de Oliveira)

- Added helpers for sysfs hotplug events. (Lyude)

- Added support for hotplug testing with the Chamelium device (Lyude)

Tools changes:

- intel_dp_compliance: New tool for running automated DisplayPort
  compliance tests. (Manasi Navare)

- Renamed intel_bios_reader to intel_vbt_decode. (Jani Nikula)

- intel_gvtg_test: New tool for setting up GVT-g guests based on
  KVMGT. (Terrence Xu)

Test changes:

- Multiple new tests.


And many other bug fixes and improvements.

Release 1.17 (2016-12-02)
-------------------------

Library changes:

- Added an iterator that generate primes for creating input data that
  should not fall into any patterns that may be optimised by the
  drivers. (Chris Wilson)

- Crashes in fixture blocks now print a stacktrace. (Marius Vlad)

- Added support for various system suspend/resume options. (Imre Deak)

- Added linked list helpers from the Wayland project. (Lyude)

- Added a generic dummy workload helper for submitting GPU workloads
  that consume exactly a specified amount of time. (Abdiel Janulgue)

- Added C functions for driver loading/unloading, pkill and lsof, for
  converting shell script tests to C code. (Marius Vlad)

Tools changes:

- intel_reg: Add Kabylake support. (Jani Nikula)

- intel_bios_reader: Also dump PSR info. (Ville Syrjälä)

- intel_guc_logger: New tool for capturing logs from the GuC
  firmware. (Akash Goel)

- intel_aubdump: Added commandline option to stream the dump to
  another process. (Lionel Landwerlin)

- intel_aubdump: Annotate the dump with the application name and the
  used PCI ID. (Jason Ekstrand)

Benchmark changes:

- gem_latency: Added support for measuring fence wakeup latencies. (Chris Wilson)

- prime_lookup: New microbenchmark for stressing prime_fd_to_handle
  and prime_handle_to_fd. (Chris Wilson)

Test changes:

- Multiple new tests.

- Added an explicit list of tests used for Intel CI. (Petri Latvala)

- Converted multiple shell script tests to C. (Marius Vlad)


And many other bug fixes and improvements.

Release 1.16 (2016-09-02)
-------------------------

- Build automatically tests required when issueing a make check, Tests/subtests
that receive a crash signal should print a backtrace when i-g-t is built with
libunwind support (Marius Vlad)

- lib/igt_kms: Force connector probing on first use (Chris Wilson)

- vc4: Add a test for BO lookup failure error path (Eric Anholt)

- tests/gem_mocs_settings: Remove direct register tests,
and added RC6 tests (Peter Antoine)

- Check for libdrm_intel and build if present, Add stubs for intel_bufmgr
(Robert Foss)

- igt/gem_mmap_gtt: Add a test to detect non-WC access (Chris Wilson)

- Various documentation improvements (Daniel Vetter)

- Added new tests: tests/kms_rmfb and tests/kms_atomic_transition, a test for
fastboot, tests/kms_panel_fitting, and a test that only tries to set the
current property values back, tests/kms_properties. Various improvements to
tests/kms_cursor_legacy (Maarten Lankhorst)

- lib/igt_kms: Use pipes for committing, not outputs and assign pipe properties
in pipe init and many other improvements (Maarten Lankhorst)

- tests/gem_workarounds: read test added as a basic test, fix assertion of num
of regs (Mika Kuoppala)

- Various improvements to tools/intel_bios_reader and tools/intel_reg (Ville
Syrjälä)

- lib: Add x86 cpuid based feature detection (Chris Wilson)

- demos/intel_sprite_on: Instead of looping until the first disconnected port
is found, now go through all possible connectors, drawing the sprite on any
connected display. (Jim Bride)

- Multiple improvements to lib/igt_kms (Robert Foss)

- lib/igt_aux: Framework for measuring latency in raising signals (Chris
Wilson)

- Various modifications to intel_chipset: Replace lookup of GT size with
computation, remove unused PCI_CHIP ids, converting platforms names using
device info (Chris Wilson)

- tests/kms_chv_cursor_fail: Run the tests with fewer steps
(Maarten Lankhorst)

- lib/intel_chipset: Add more Kabylake PCI IDs and removed PCI IDs that are no
longer listed as Kabylake (Rodrigo Vivi)

- Basic framework for GVT-g testing has landed (Chris Wilson)

- Various improvements to tests/kms_flip (Ville Syrjälä)

- igt/kms_cursor_legacy: Add a rudimentary test to detect stalled cursors,
detect pageflip errors and check that cursor updates do not stall flips
(Chris Wilson)

- vGEM support: lib and added tests/vgem_basic, tests/vgem_slow and
tests/vgem_reload_basic (Chris Wilson)

- Various fixes to tests/kms_frontbuffer_tracking: prefer BLT drawing, recreate
FBS at every subtest and properly handle mixing GTT and WC mmaps (Paulo Zanoni)

- Replace drv_missed_irq_hang script with a C-equivalent: tests/drv_missed_irq
(Chris Wilson)

- Added a test case for polling dma-buf fences: tests/prime_busy (Chris Wilson)

- lib/igt_gt: Omit illegal instruction on gen8+ and time
constrains on hang detection (igt/gem_reset_stats) (Mika Kuoppala)

- Added tests/kms_invalid_dotclock, a test that makes sure every modeset gets
rejected by the kernel if the requested dotclock is beyond the hardware
capabilities (Ville Syrjälä)

- tests/gem_stolen: Verify contents of stolen-backed objects across
hibernation, fix for no_mmap subtest and check for available stolen memory size
(Ankitprasad Sharma)

- tests/core_prop_blob: Add invalid tests to set fb props (Daniel Vetter)

- Many more fixes and improvements.

Release 1.15 (2016-05-31)
-------------------------

- New KMS test: tests/kms_cursor_legacy (Stress legacy cursor ioctl)
(Chris Wilson)

- Several GEM tests have been removed from BAT: tests/gem_exec_whisper,
tests/gem_sync (dropped individual engines), test/gem_cs_prefetch (replaced
by test/gem_exec_gttfill), tests/gem_ctx_param_basic (got relabeled
to tests/gem_ctx_param) (Chris Wilson)

- build: Skip configure step if is NOCONFIGURE set (Tomeu Vizoso)

- tools/intel_bios_reader: Added options for dumping individual panels, specific
section, hex format and other various fixes (Jani Nikula)

- build: Add optional --enable-werror
(hard-fail in case of compiler warnings) (Marius Vlad)

- New KMS test: tests/prime_mmap_kms (show case dma-buf new API
and processes restrictions) (Tiago Vignatti)

- Several tests have gained to ability to be run on different platforms
than Intel: tests/testdisplay (Tomeu Vizoso), tests/kms_panel_fitting
(Robert Foss), tests/kms_flip_event_leak, tests/kms_flip (Tomeu Vizoso).

- compute exitcode first: In the case of running multiple subtests which all
happen to be skipped, igt_exitcode is 0, but the final exit code will be 77.
(Chris Wilson)

- Shorten tests/kms_flip test (Tvrtko Ursulin)

- Half the timeout for suspend to RAM and a third for suspend to disk
(Marius Vlad)

- lib: Pass format instead of bpp to create_bo_for_fb (Ville Syrjälä)

- Removed from tests/test-list.txt, tests/gem_concurrent_all and added
tests/test-list-full.txt that contains all the tests. This will speed
up considerably piglit when starting tests. (Gabriel Feceoru)

- piglit changed its behaviour to prevent overwriting the results. A fairly new
version of piglit is required to run i-g-t tests. (Gabriel Feceoru)

- lib: Replace drmIoctl() with a layer of indirection (Chris Wilson)

- Adding missing Broxton PCI IDs (Rodrigo Vivi)

- Added COMMIT_ATOMIC (lib/igt_kms, w/ tests/kms_rotation_crc).
Requires nuclear_pageflip parameter turned on in the i915 driver.
(Mayuresh Gharpure, Pratik Vishwakarma)

- man/: rewrite manual pages in reStructuredText (Jani Nikula)

- tests/drv_module_reload_basic: perform fault injection (Chris Wilson)
with various improvements (Imre Deak)

- Removed tests/gem_multi_bsd_sync_loop which was superseded by
tests/gem_ring_sync_loop and tests/gem_dummy_reloc_loop by
tests/gem_exec_reloc (Chris Wilson)

- New GEM tests: tests/gem_exec_whisper, tests/gem_exec_store,
test/gem_exec_gttfill, tests/gem_exec_suspend, tests/gem_exec_flush
(Chris Wilson)

- New benchmarks: benchmarks/gem_syslatency, benchmarks/gem_exec_fault
(Chris Wilson)

- tests/gem_exec_nop included in BAT (Chris Wilson)

- tests/pm_rpm: Fix crash on machines that lack LLC (David Weinehall)

- lib/igt_fb: Fix domain tracking for GTT cairo surfaces (Chris Wilson)

- Add igt_subtest_group to allow igt_fixture for only a subset of subtests
without skipping/failing all subsequent subtests. (Daniel Vetter)

- Many more fixes and improvements.

Release 1.14 (2016-03-01)
-------------------------

- New test: gem_create validate parameters for GEM_CREATE ioctl
(Ankitprasad Sharma)

- New test: gem_softpin exercise the userptr ioctl to create shared
buffers between CPU and GPU (Vinay Belgaumkar)

- New tests: prime_mmap_coherency/kms_mmap_write_crc cache coherency
tests (Tiago Vignatti)

- New test: prime_mmap mmap() on dma-buf fds (Rob Bradford)

- New test: gem_exec_reloc sanity check of execbuf-ioctl relocations (Chris
Wilson)

- New test: gem_exec_basic sanity check of execbuf-ioctl rings (Chris Wilson)

- improved igt_hang_ring() infrastructure for generic hang injection support in
the core library (Chris Wilson)

- new igt_pm library to collect power management testing helpers (David
Weinehall)

- lig/igt_vc4: VC4 support library (Eric Anholt)

- kms_frontbuffer_tracking: included in BAT (Paulo Zanoni)

- kms_psr_sink_crc: Add BAT test for PSR active (Rodrigo Vivi)

- gem_wait: test superseded by gem_latency in benchmarks (Chris Wilson)

- igt_core: Fix logging to display extended line (Derek Morton)

- igt_core: Expand --run-subtest functionality (Derek Morton)

- kms_force_connector_basic: various fixes and included in BAT set (Daniel
Vetter)

- Many other improvements and bug fixes.

Release 1.13 (2015-12-02)
-------------------------

- New test: kms_atomic tests atomic mode setting (Daniel Stone)

- New test: core_prop_blob tests blob properties (Daniel Stone)

- New test: gem_request_retire targets request retirement code paths
  (Tvrtko Ursulin)

- New test: core_setmaster_vs_auth checks that drop/setMaster correctly
  transfer master state (Thomas Hellstrom/Daniel Vetter)

- Wildcard characters are now accepted when using the --run-subtest command
  line option to specify multiple subtests to run. (Thomas Wood)

- Add support for Broxton in intel_audio_dump (Han Lu)

- Added Kabylake support (Rodrigo Vivi/Wayne Boyer)

- Many other bug fixes and improvements

Release 1.12 (2015-09-11)
-------------------------

- Various new tests and tools

- New statistical analysis functions. (Damien Lespiau)

- New benchmark tests. (Chris Wilson)

- Old register tools that were superseded by intel_reg have been removed.

- Various tests have been marked "basic", to indicate they are suitable for
  use in basic acceptance testing. (Jesse Barnes)

- Per-ring gem_storedw_loop tests combined into a single test with subtests.
  (Jesse Barnes)

- New "aubdump" tool, used to launch an application and capture rendering to
  an AUB file. (Kristian Høgsberg Kristensen)

- Cherryview support added to intel_display_poller. (Ville Syrjälä)

- Skylake and Broadwell support added to gem_gpgpu_fill tests.
  (Dominik Zeromski)

- Support for running core drm tests on any platform. (Micah Fedke)

- Many other bug fixes

Release 1.11 (2015-06-11)
-------------------------

- Various new tests and tools

- Single combined test list (supported by piglit since commit 8a122bb)

- Optional dependency on libunwind to provide automatic stack traces on test
  failures. (Thomas Wood)

- Add optional default debug and optimisation flags for tests to enable better
  stack traces and debugging. (Thomas Wood)

- Test programs are now installed into libexec. This is useful when building a
  complete software stack for a DUT from scratch. (Building and installing
  tests can still be disabled by the --disable-tests configure flag.)
  (Joonas Lahtinen)

- New tool to decode watermark registers (Ville Syrjälä)

- Timeout mechanism now reports test as failed

- Introduce intel_reg as the one Intel graphics register multitool to replace
  intel_reg_read, intel_reg_write, intel_iosf_sb_read, intel_iosf_sb_write,
  intel_vga_read, intel_vga_write, intel_reg_dumper, intel_reg_snapshot,
  and quick_dump.py. (Jani Nikula)

- Add functions to manipulate i915.ko parameters and ensure features are enabled
  for testing. (Paulo Zanoni)

Release 1.10 (2015-03-12)
-------------------------

- New frequency manipulation tool (intel_gpu_frequency)

- Adjustments for the Solaris port (Alan Coopersmith).

- Remove tests/NAMING-CONVENTION since it's all in the docbook now, to avoid
  divergent conventions.

- New CRITICAL log level for really serious stuff (Thomas Wood).

- Interactive test mode can now be enabled by the shared cmdline option
  --interactive-debug=$var (Rodrigo Vivi).

- Improved logging to kmsg to better line up test runs with kernel messages
  (Chris Wilson).

- Record all log levels (including disabled levels) in a ringbuffer and dump
  that on test failures for quicker diagnostics of automated test run results
  (Thomas Wood).

- A lot of small polish all over the test library.

- Piles of new testcases and improvements to existing ones as usual.

Release 1.9 (2014-12-12)
------------------------

- New test cases added: drm_import_export, gem_gpgpu_fill, gem_ppgtt,
  gem_tiled_wb, kms_pwrite_crc.

- New helper for interactive progress indicators (see igt_print_activity and
  igt_progress), which can be disabled by setting the log-level to warn (Thomas
  and Daniel).

- Basic skl support: pci ids, rendercopy & mediafill (Damien, Zhao Yakui).

- chv support for the iosf sideband tools and a few other improvements (Ville).

- Fence register support for intel_reg_dumper on bdw+ (Rodrigo).

- Support for skl in quick_dump (Damien).

- Golden state generation infrastructure (Mika).

- New skl watermark tool (Damien).

- New EDID test block that includes multiple display modes (Thomas).

- Individual test documentation available in generated documentation and from
  the test binaries (Thomas).

- New logging domains and log filtering (Thomas).

- Various API documentation fixes and improvements (Thomas).

Release 1.8 (2014-09-08)
------------------------

- Added lib/igt.cocci semantic patch to catch often-seen patterns and convert
  them to igt macros/infrastructure.

- Improvements to the documentation build systems (Thomas).

- Small fixes and improvements to the igt infrastructure and helpers all over.

- As usual piles of new tests.

- Improved plane/pipe handling in the igt_kms library (Damien).

- Unified option parsing between simple tests and tests with subtests (Thomas).
  This will allow us to merge the different Makefile targets once test runners
  are converted.

- New commit functions for igt_kms to support the new universal planes
  interfaces (Matt Roper).

- Polish the debug output when test requirements aren't met a bit and inject the
  program name/subtest in dmesg for easier backtrace/oom debugging (Chris).

- A bit of polish for the framebuffer helper functions (Damien).

- Robuster option parsing helpers, they now check for conflicts when merging
  different option lists (Thomas).

- MIPI DSI vbt support in intel_bios_read (Gaurav K Singh).

- Clarify the split between low-level helpers and the high-level library in
  igt_kms a bit by renaming some functions and improving and extending the api
  documentation.

- Helper to restore the vt mode, useful to test lastclose/fbdev emulation
  behaviour (Thomas).

- Refactor the support for 64bit relocs. By specifying the number of relocations
  explicit a lot of the gen8 checks can be removed from simple testcases which
  only use the blitter (Chris).

Release 1.7 (2014-06-09)
------------------------

- Piles of API documentation for the core i-g-t testing libraries.

- Improved igt loggin, now also with igt_vlog (for va_args printf-style
  logging).

- Polish for the igt_debugfs library.

- Split out igt_fb library from igt_kms, cleanup of the igt_kms functions.

- Android porting patches (Tim Gore, Tvrtko Ursulin).

- Piles more tests as usual.

- Support for building libcairo based tests on Android. Set ANDROID_HAS_CAIRO=1
  in the build enviroment when you have this (Tim Gore).

- Timeout support in igt_aux, see igt_set_timeout (Thomas).

- Documentation for the testrunner interface like exit codes, subtest
  enumeration and log output. Should help other people to run the tests in their
  own framework.

- Make swig an optional dependency (Damien).

- Helpers for runtime pm tests in igt_aux.

Release 1.6 (2014-03-13)
------------------------

- Changes to support Broadwell in the test suite. (Ben, Damien, et al.)

- Updated (now working again!) Android support from Oscar Mateo.

- Test coverage through i-g-t is now officially an integral part of any drm/i915
  feature work and also for bugfixes. For more details see:

  http://blog.ffwll.ch/2013/11/testing-requirements-for-drmi915.html

- Fix the gen4asm build dependency handling, now that the assembler is included in
  i-g-t (Ben).

- Improve the cairo object lifetime management of the kmstest helpers (Chris).

- Allow register access to succeed if i915 is loaded but debugfs isn't found
  (i.e. nomodeset is used)

- New kernel modesetting helper library for simpler testcases (Damien).

- New structure logging support for tests. Message at the WARN level be
  reflected in the piglit result, also included igt_warn_on macros to simplify
  test asserts which should just result in warnings, but not in a test abort.

- Broadwell support for intel_audio_dump (Mengdong Lin).

- API documentation support (Thomas)

Release 1.5 (2013-11-06)
------------------------

- Some polishing of the test infrastructure, for details see:

  http://blog.ffwll.ch/2013/09/more-drmi915-testsuite-infrastructure.html

- Haswell support for the DPF tool (tools/intel_l3_parity) and other
  improvements (Ben).

- Stereo/3D support in testdisplay (Damien).

- Support for gen7 gpu perf counters in tools/intel_perf_counters (Kenneth).

- Improvements to the VBT decoder (Jani).

- New tool to read legacy VGA registers (Ville).

- New helpers in the test library to help deal with debugfs files and the new
  display pipe CRC support (Damien).

- Introduction of a proper naming convention for all the testcases, see
  tests/NAMING-CONVENTION.

- As usual tons of new testcases and improvements and bugfixes to existing ones.

- The testsuite framework itself has gained some regression tests which can be
  run at compile-time with "make check".

- New helpers for the drop_cache kernel interface and use drop_caches(RETIRE) to
  really make sure the gpu is idle in testcases (Oscar Mateo).

Release 1.4 (2013-09-16)
------------------------

- Integration of the gen4+ assembler (Damien).

- Start of a new performance analysis tool from Chris Wilson with front-ends for
  both X11 and plain kms. This uses the perf subsystem and the gpu performance
  counter kernel patches from Chris.

- New register dumper quick_dump from Ben, with lots of work from Damien. This
  will superseed intel_reg_dumper for newer platforms (which are not yet
  released) since it will allow us to automatically generate register dumps from
  the internal xml register specifications.

- Tools to access the pletoria of new indirect register access functions on
  newer platforms.

- Framebuffer contents dumper to debug some of the nastier corruption issues.
  The advantage here is that this bypasses any userspace drivers and so avoids
  that the corruptions get magically fixed when taking an X screenshot.

- Tons of new testcases. Including subtests we are now at roughly 450 tests!

- Improvements to the test framework infrastructure. See
  http://blog.ffwll.ch/2013/08/recent-drmi915-testsuite-improvements.html
  for an overview.

Release 1.3 (2012-08-27)
------------------------

- massive improvements to the testsuite
- dpf tool for handling l3 remapping on gen7 (Ben)
- robustify against wc gtt mappings (Chris)
- improvements to the reg_dumper and register read/write tools
- haswell support

Release 1.2 (2012-02-09)
------------------------

- intel_audio_dump improvements (Wu Fengguang)
- buildsystem improvements (Gaetan Nadon)
- solaris support (Alan Coopersmith)
- massive refactoring of testcases and rendercpy extraction
- new tests
- fixed up intel_reg_read/write for platforms needing forcewake (needs a
  kernel patch which from 3.3 to work on ivb - Ben Widawsky)

Release 1.1 (2011-12-24)
------------------------

Improved testsuite, usable for kernel regression testing!

Release 1.0 (2009-04-27)
------------------------

Initial release:
- miscellaneous userland tools that don't really fit into the 2D driver tree
- standalone regression tests for the DRM (make check)
- microbenchmarks of the DRM for kernel performance regression testing
