/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.SunJSSE_i;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

final class RawDSA
extends Signature {
    private DSAParams a;
    private BigInteger b;
    private BigInteger c;
    private BigInteger d;
    private BigInteger e;
    private BigInteger f;
    private int[] g;
    private byte[] h;
    private int[] i;
    private SecureRandom j;
    private byte[] k = new byte[20];
    private int l = 0;
    private static final int m = 1518500249;
    private static final int n = 1859775393;
    private static final int o = -1894007588;
    private static final int p = -899497514;

    private RawDSA() {
        super("RawDSA");
    }

    public static Signature getInstance() throws NoSuchAlgorithmException {
        try {
            return SunJSSE_i.b("RawDSA");
        }
        catch (Exception exception) {
            return new RawDSA();
        }
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("not a DSA private key: " + privateKey);
        }
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
        this.f = dSAPrivateKey.getX();
        this.a(dSAPrivateKey.getParams());
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("not a DSA public key: " + publicKey);
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        this.e = dSAPublicKey.getY();
        this.a(dSAPublicKey.getParams());
    }

    private void a(DSAParams dSAParams) {
        this.b(dSAParams);
    }

    protected byte[] engineSign() throws SignatureException {
        BigInteger bigInteger = this.a(this.c);
        BigInteger bigInteger2 = this.a(this.b, this.c, this.d, bigInteger);
        BigInteger bigInteger3 = this.b(this.f, this.c, bigInteger2, bigInteger);
        try {
            DerOutputStream derOutputStream = new DerOutputStream(100);
            derOutputStream.putInteger(bigInteger2);
            derOutputStream.putInteger(bigInteger3);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new SignatureException("error encoding signature");
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        Object object;
        Object object2;
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        try {
            object2 = new DerInputStream(byArray);
            object = ((DerInputStream)object2).getSequence(2);
            bigInteger = object[0].getBigInteger();
            bigInteger2 = object[1].getBigInteger();
        }
        catch (IOException iOException) {
            throw new SignatureException("invalid encoding for signature");
        }
        object2 = this.c(this.b, this.c, this.d, bigInteger2);
        object = this.a(this.e, this.b, this.c, this.d, (BigInteger)object2, bigInteger);
        return ((BigInteger)object).equals(bigInteger);
    }

    BigInteger a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        BigInteger bigInteger5 = bigInteger3.modPow(bigInteger4, bigInteger);
        return bigInteger5.remainder(bigInteger2);
    }

    BigInteger b(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        BigInteger bigInteger5 = new BigInteger(1, this.k);
        BigInteger bigInteger6 = bigInteger4.modInverse(bigInteger2);
        BigInteger bigInteger7 = bigInteger.multiply(bigInteger3);
        bigInteger7 = bigInteger5.add(bigInteger7);
        bigInteger7 = bigInteger6.multiply(bigInteger7);
        return bigInteger7.remainder(bigInteger2);
    }

    BigInteger c(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        return bigInteger4.modInverse(bigInteger2);
    }

    BigInteger a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6) {
        BigInteger bigInteger7 = new BigInteger(1, this.k);
        bigInteger7 = bigInteger7.multiply(bigInteger5);
        BigInteger bigInteger8 = bigInteger7.remainder(bigInteger3);
        BigInteger bigInteger9 = bigInteger6.multiply(bigInteger5).remainder(bigInteger3);
        BigInteger bigInteger10 = bigInteger4.modPow(bigInteger8, bigInteger2);
        BigInteger bigInteger11 = bigInteger.modPow(bigInteger9, bigInteger2);
        BigInteger bigInteger12 = bigInteger10.multiply(bigInteger11);
        BigInteger bigInteger13 = bigInteger12.remainder(bigInteger2);
        return bigInteger13.remainder(bigInteger3);
    }

    BigInteger a(BigInteger bigInteger) {
        int[] nArray;
        BigInteger bigInteger2 = null;
        if (this.g != null && this.b(this.g, this.i) != 0 && (bigInteger2 = this.a(this.g, bigInteger)).signum() > 0 && bigInteger2.compareTo(bigInteger) < 0) {
            this.i = new int[this.g.length];
            System.arraycopy(this.g, 0, this.i, 0, this.g.length);
            return bigInteger2;
        }
        SecureRandom secureRandom = this.a();
        do {
            nArray = new int[5];
            int n = 0;
            while (n < 5) {
                nArray[n] = secureRandom.nextInt();
                ++n;
            }
        } while ((bigInteger2 = this.a(nArray, bigInteger)).signum() <= 0 || bigInteger2.compareTo(bigInteger) >= 0);
        this.i = new int[nArray.length];
        System.arraycopy(nArray, 0, this.i, 0, nArray.length);
        return bigInteger2;
    }

    private SecureRandom a() {
        if (this.j == null) {
            this.j = this.appRandom != null ? this.appRandom : new SecureRandom();
        }
        return this.j;
    }

    private int b(int[] nArray, int[] nArray2) {
        if (nArray == null && nArray == null || nArray == null && nArray2 != null || nArray != null && nArray2 == null || nArray.length != nArray2.length) {
            return 1;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != nArray2[n]) {
                return 1;
            }
            ++n;
        }
        return 0;
    }

    BigInteger a(int[] nArray, BigInteger bigInteger) {
        int[] nArray2 = new int[]{-271733879, -1732584194, 271733878, -1009589776, 1732584193};
        int[] nArray3 = RawDSA.a(nArray, nArray2);
        byte[] byArray = new byte[nArray3.length * 4];
        int n = 0;
        while (n < nArray3.length) {
            int n2 = nArray3[n];
            int n3 = 0;
            while (n3 < 4) {
                byArray[n * 4 + n3] = (byte)(n2 >>> 24 - n3 * 8);
                ++n3;
            }
            ++n;
        }
        BigInteger bigInteger2 = new BigInteger(1, byArray).mod(bigInteger);
        return bigInteger2;
    }

    static int[] a(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[80];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        int n = 0;
        int n2 = 16;
        while (n2 <= 79) {
            n = nArray3[n2 - 3] ^ nArray3[n2 - 8] ^ nArray3[n2 - 14] ^ nArray3[n2 - 16];
            nArray3[n2] = n << 1 | n >>> 31;
            ++n2;
        }
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        int n5 = nArray2[2];
        int n6 = nArray2[3];
        int n7 = nArray2[4];
        int n8 = 0;
        while (n8 < 20) {
            n = (n3 << 5 | n3 >>> 27) + (n4 & n5 | ~n4 & n6) + n7 + nArray3[n8] + 1518500249;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n3;
            n3 = n;
            ++n8;
        }
        int n9 = 20;
        while (n9 < 40) {
            n = (n3 << 5 | n3 >>> 27) + (n4 ^ n5 ^ n6) + n7 + nArray3[n9] + 1859775393;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n3;
            n3 = n;
            ++n9;
        }
        int n10 = 40;
        while (n10 < 60) {
            n = (n3 << 5 | n3 >>> 27) + (n4 & n5 | n4 & n6 | n5 & n6) + n7 + nArray3[n10] + -1894007588;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n3;
            n3 = n;
            ++n10;
        }
        int n11 = 60;
        while (n11 < 80) {
            n = (n3 << 5 | n3 >>> 27) + (n4 ^ n5 ^ n6) + n7 + nArray3[n11] + -899497514;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n3;
            n3 = n;
            ++n11;
        }
        int[] nArray4 = new int[]{nArray2[0] + n3, nArray2[1] + n4, nArray2[2] + n5, nArray2[3] + n6, nArray2[4] + n7};
        return nArray4;
    }

    protected void engineSetParameter(String string, Object object) {
        if (string.equals("KSEED")) {
            if (!(object instanceof byte[])) {
                throw new InvalidParameterException("Kseed not a byte array");
            }
        } else {
            throw new InvalidParameterException("invalid parameter");
        }
        this.g = this.a((byte[])object);
        this.h = (byte[])object;
    }

    protected Object engineGetParameter(String string) {
        if (string.equals("KSEED")) {
            return this.h;
        }
        return null;
    }

    private void b(DSAParams dSAParams) {
        this.a = dSAParams;
        this.b = dSAParams.getP();
        this.c = dSAParams.getQ();
        this.d = dSAParams.getG();
    }

    private void a(DSAParameterSpec dSAParameterSpec) {
        this.b = dSAParameterSpec.getP();
        this.c = dSAParameterSpec.getQ();
        this.d = dSAParameterSpec.getG();
    }

    protected void engineUpdate(byte by) {
        if (this.l == this.k.length) {
            throw new IllegalArgumentException("SHA1 digest too long");
        }
        this.k[this.l++] = by;
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (n2 > this.k.length - this.l) {
            throw new IllegalArgumentException("SHA1 digest too long");
        }
        System.arraycopy(byArray, n, this.k, this.l, n2);
        this.l += n2;
    }

    public String toString() {
        String string = "RawDSA Signature";
        if (this.b != null && this.c != null && this.d != null) {
            string = string + "\n\tp: " + this.b.toString(16);
            string = string + "\n\tq: " + this.c.toString(16);
            string = string + "\n\tg: " + this.d.toString(16);
        } else {
            string = string + "\n\t P, Q or G not initialized.";
        }
        if (this.e != null) {
            string = string + "\n\ty: " + this.e.toString(16);
        }
        if (this.e == null && this.f == null) {
            string = string + "\n\tUNINIIALIZED";
        }
        return string;
    }

    private int[] a(byte[] byArray) {
        byte[] byArray2;
        int n = 0;
        int n2 = byArray.length % 4;
        switch (n2) {
            case 3: {
                byArray2 = new byte[byArray.length + 1];
                break;
            }
            case 2: {
                byArray2 = new byte[byArray.length + 2];
                break;
            }
            case 1: {
                byArray2 = new byte[byArray.length + 3];
                break;
            }
            default: {
                byArray2 = new byte[byArray.length + 0];
            }
        }
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int[] nArray = new int[byArray2.length / 4];
        int n3 = 0;
        while (n3 < byArray2.length) {
            nArray[n] = byArray2[n3 + 3] & 0xFF;
            int n4 = n;
            nArray[n4] = nArray[n4] | byArray2[n3 + 2] << 8 & 0xFF00;
            int n5 = n;
            nArray[n5] = nArray[n5] | byArray2[n3 + 1] << 16 & 0xFF0000;
            int n6 = n++;
            nArray[n6] = nArray[n6] | byArray2[n3 + 0] << 24 & 0xFF000000;
            n3 += 4;
        }
        return nArray;
    }
}

