/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsILocalFile.idl
 */

#ifndef __gen_nsILocalFile_h__
#define __gen_nsILocalFile_h__


#ifndef __gen_nsIFile_h__
#include "nsIFile.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
#include "prio.h"
#include "prlink.h"
#include <stdio.h>

/* starting interface:    nsILocalFile */
#define NS_ILOCALFILE_IID_STR "aa610f20-a889-11d3-8c81-000064657374"

#define NS_ILOCALFILE_IID \
  {0xaa610f20, 0xa889, 0x11d3, \
    { 0x8c, 0x81, 0x00, 0x00, 0x64, 0x65, 0x73, 0x74 }}

class NS_NO_VTABLE nsILocalFile : public nsIFile {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ILOCALFILE_IID)

  /**
     * initWithPath
     *
     * This function will initialize the nsILocalFile object.  Any
     * internal state information will be reset.  
     *
     *  NOTE:  This function has a known bug on the macintosh and
     *         other OSes which do not represent file locations 
     *         as pathes.  If you do use this function, be very
     *         aware of this problem as bugs.
     *
     *   @param filePath       
     *          A string which specifies a full file path to a 
     *          location.  Relative paths will be treated as an
     *          error (NS_ERROR_FILE_UNRECOGNIZED_PATH).  This
     *          path must in native.
     */
  /* void initWithPath ([const] in string filePath); */
  NS_IMETHOD InitWithPath(const char *filePath) = 0;

  /* void initWithUnicodePath ([const] in wstring filePath); */
  NS_IMETHOD InitWithUnicodePath(const PRUnichar *filePath) = 0;

  /**
     * followLinks
     *
     *    This attribute will determine if the nsLocalFile will auto
     *    resolve symbolic links.  By default, this value will be false
     *    on all non unix systems.  On unix, this attribute is effectively
     *    a noop.  
     *
     *    Be aware that changing this attribute from true to false after
     *    the nsILocalFile has been initialized may lead to errors.  This
     *    could happen if there were resolved symlink in the initialized
     *    path.  For example if you had /a/b/c where |b| was a symlink, 
     *    and you change this attribute to false, the next usage would 
     *    mostlikely fail.
     */
  /* attribute PRBool followLinks; */
  NS_IMETHOD GetFollowLinks(PRBool *aFollowLinks) = 0;
  NS_IMETHOD SetFollowLinks(PRBool aFollowLinks) = 0;

  /* [noscript] PRFileDescStar openNSPRFileDesc (in long flags, in long mode); */
  NS_IMETHOD OpenNSPRFileDesc(PRInt32 flags, PRInt32 mode, PRFileDesc * *_retval) = 0;

  /* [noscript] FILE openANSIFileDesc (in string mode); */
  NS_IMETHOD OpenANSIFileDesc(const char *mode, FILE * *_retval) = 0;

  /* [noscript] PRLibraryStar load (); */
  NS_IMETHOD Load(PRLibrary * *_retval) = 0;

  /* readonly attribute PRInt64 diskSpaceAvailable; */
  NS_IMETHOD GetDiskSpaceAvailable(PRInt64 *aDiskSpaceAvailable) = 0;

  /**
     * appendRelativePath
     *
     * Append a relative path to the current path of the nsILocalFile object.
     *
     * @param relativeFilePath
     *        relativeFilePath is a native relative path. For security reasons,
     *        this cannot contain ..	or cannot start with a directory separator
     */
  /* void appendRelativePath ([const] in string relativeFilePath); */
  NS_IMETHOD AppendRelativePath(const char *relativeFilePath) = 0;

  /* void appendRelativeUnicodePath ([const] in wstring relativeFilePath); */
  NS_IMETHOD AppendRelativeUnicodePath(const PRUnichar *relativeFilePath) = 0;

  /**
     *   Accessor to a null terminated string which will specify
     *   the file in a persistent manner for disk storage.
     */
  /* attribute string persistentDescriptor; */
  NS_IMETHOD GetPersistentDescriptor(char * *aPersistentDescriptor) = 0;
  NS_IMETHOD SetPersistentDescriptor(const char * aPersistentDescriptor) = 0;

  /** 
	 * reveal --> Ask the operating system to open the folder which contains
	 * this file or folder. This routine only works on platforms which 
	 * support the ability to open a folder...
	*/
  /* void reveal (); */
  NS_IMETHOD Reveal(void) = 0;

  /** 
	 * launch --> Ask the operating system to attempt to open the file. 
     * this really just simulates "double clicking" the file on your platform.
	 * This routine only works on platforms which support this functionality.
	 */
  /* void launch (); */
  NS_IMETHOD Launch(void) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSILOCALFILE \
  NS_IMETHOD InitWithPath(const char *filePath); \
  NS_IMETHOD InitWithUnicodePath(const PRUnichar *filePath); \
  NS_IMETHOD GetFollowLinks(PRBool *aFollowLinks); \
  NS_IMETHOD SetFollowLinks(PRBool aFollowLinks); \
  NS_IMETHOD OpenNSPRFileDesc(PRInt32 flags, PRInt32 mode, PRFileDesc * *_retval); \
  NS_IMETHOD OpenANSIFileDesc(const char *mode, FILE * *_retval); \
  NS_IMETHOD Load(PRLibrary * *_retval); \
  NS_IMETHOD GetDiskSpaceAvailable(PRInt64 *aDiskSpaceAvailable); \
  NS_IMETHOD AppendRelativePath(const char *relativeFilePath); \
  NS_IMETHOD AppendRelativeUnicodePath(const PRUnichar *relativeFilePath); \
  NS_IMETHOD GetPersistentDescriptor(char * *aPersistentDescriptor); \
  NS_IMETHOD SetPersistentDescriptor(const char * aPersistentDescriptor); \
  NS_IMETHOD Reveal(void); \
  NS_IMETHOD Launch(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSILOCALFILE(_to) \
  NS_IMETHOD InitWithPath(const char *filePath) { return _to ## InitWithPath(filePath); } \
  NS_IMETHOD InitWithUnicodePath(const PRUnichar *filePath) { return _to ## InitWithUnicodePath(filePath); } \
  NS_IMETHOD GetFollowLinks(PRBool *aFollowLinks) { return _to ## GetFollowLinks(aFollowLinks); } \
  NS_IMETHOD SetFollowLinks(PRBool aFollowLinks) { return _to ## SetFollowLinks(aFollowLinks); } \
  NS_IMETHOD OpenNSPRFileDesc(PRInt32 flags, PRInt32 mode, PRFileDesc * *_retval) { return _to ## OpenNSPRFileDesc(flags, mode, _retval); } \
  NS_IMETHOD OpenANSIFileDesc(const char *mode, FILE * *_retval) { return _to ## OpenANSIFileDesc(mode, _retval); } \
  NS_IMETHOD Load(PRLibrary * *_retval) { return _to ## Load(_retval); } \
  NS_IMETHOD GetDiskSpaceAvailable(PRInt64 *aDiskSpaceAvailable) { return _to ## GetDiskSpaceAvailable(aDiskSpaceAvailable); } \
  NS_IMETHOD AppendRelativePath(const char *relativeFilePath) { return _to ## AppendRelativePath(relativeFilePath); } \
  NS_IMETHOD AppendRelativeUnicodePath(const PRUnichar *relativeFilePath) { return _to ## AppendRelativeUnicodePath(relativeFilePath); } \
  NS_IMETHOD GetPersistentDescriptor(char * *aPersistentDescriptor) { return _to ## GetPersistentDescriptor(aPersistentDescriptor); } \
  NS_IMETHOD SetPersistentDescriptor(const char * aPersistentDescriptor) { return _to ## SetPersistentDescriptor(aPersistentDescriptor); } \
  NS_IMETHOD Reveal(void) { return _to ## Reveal(); } \
  NS_IMETHOD Launch(void) { return _to ## Launch(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSILOCALFILE(_to) \
  NS_IMETHOD InitWithPath(const char *filePath) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> InitWithPath(filePath); } \
  NS_IMETHOD InitWithUnicodePath(const PRUnichar *filePath) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> InitWithUnicodePath(filePath); } \
  NS_IMETHOD GetFollowLinks(PRBool *aFollowLinks) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetFollowLinks(aFollowLinks); } \
  NS_IMETHOD SetFollowLinks(PRBool aFollowLinks) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetFollowLinks(aFollowLinks); } \
  NS_IMETHOD OpenNSPRFileDesc(PRInt32 flags, PRInt32 mode, PRFileDesc * *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> OpenNSPRFileDesc(flags, mode, _retval); } \
  NS_IMETHOD OpenANSIFileDesc(const char *mode, FILE * *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> OpenANSIFileDesc(mode, _retval); } \
  NS_IMETHOD Load(PRLibrary * *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Load(_retval); } \
  NS_IMETHOD GetDiskSpaceAvailable(PRInt64 *aDiskSpaceAvailable) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetDiskSpaceAvailable(aDiskSpaceAvailable); } \
  NS_IMETHOD AppendRelativePath(const char *relativeFilePath) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> AppendRelativePath(relativeFilePath); } \
  NS_IMETHOD AppendRelativeUnicodePath(const PRUnichar *relativeFilePath) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> AppendRelativeUnicodePath(relativeFilePath); } \
  NS_IMETHOD GetPersistentDescriptor(char * *aPersistentDescriptor) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetPersistentDescriptor(aPersistentDescriptor); } \
  NS_IMETHOD SetPersistentDescriptor(const char * aPersistentDescriptor) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetPersistentDescriptor(aPersistentDescriptor); } \
  NS_IMETHOD Reveal(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Reveal(); } \
  NS_IMETHOD Launch(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Launch(); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsLocalFile : public nsILocalFile
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSILOCALFILE

  nsLocalFile();
  virtual ~nsLocalFile();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsLocalFile, nsILocalFile)

nsLocalFile::nsLocalFile()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsLocalFile::~nsLocalFile()
{
  /* destructor code */
}

/* void initWithPath ([const] in string filePath); */
NS_IMETHODIMP nsLocalFile::InitWithPath(const char *filePath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void initWithUnicodePath ([const] in wstring filePath); */
NS_IMETHODIMP nsLocalFile::InitWithUnicodePath(const PRUnichar *filePath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute PRBool followLinks; */
NS_IMETHODIMP nsLocalFile::GetFollowLinks(PRBool *aFollowLinks)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsLocalFile::SetFollowLinks(PRBool aFollowLinks)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] PRFileDescStar openNSPRFileDesc (in long flags, in long mode); */
NS_IMETHODIMP nsLocalFile::OpenNSPRFileDesc(PRInt32 flags, PRInt32 mode, PRFileDesc * *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] FILE openANSIFileDesc (in string mode); */
NS_IMETHODIMP nsLocalFile::OpenANSIFileDesc(const char *mode, FILE * *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] PRLibraryStar load (); */
NS_IMETHODIMP nsLocalFile::Load(PRLibrary * *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute PRInt64 diskSpaceAvailable; */
NS_IMETHODIMP nsLocalFile::GetDiskSpaceAvailable(PRInt64 *aDiskSpaceAvailable)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void appendRelativePath ([const] in string relativeFilePath); */
NS_IMETHODIMP nsLocalFile::AppendRelativePath(const char *relativeFilePath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void appendRelativeUnicodePath ([const] in wstring relativeFilePath); */
NS_IMETHODIMP nsLocalFile::AppendRelativeUnicodePath(const PRUnichar *relativeFilePath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string persistentDescriptor; */
NS_IMETHODIMP nsLocalFile::GetPersistentDescriptor(char * *aPersistentDescriptor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsLocalFile::SetPersistentDescriptor(const char * aPersistentDescriptor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void reveal (); */
NS_IMETHODIMP nsLocalFile::Reveal()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void launch (); */
NS_IMETHODIMP nsLocalFile::Launch()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

#define NS_LOCAL_FILE_CONTRACTID "@mozilla.org/file/local;1"
#define NS_LOCAL_FILE_CLASSNAME "Local File Specification"
extern "C" NS_EXPORT nsresult
NS_NewLocalFile(const char* path, PRBool followLinks, nsILocalFile* *result);
extern "C" NS_EXPORT nsresult
NS_NewUnicodeLocalFile(const PRUnichar* path, PRBool followLinks, nsILocalFile* *result);

#endif /* __gen_nsILocalFile_h__ */
