/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIFileStreams.idl
 */

#ifndef __gen_nsIFileStreams_h__
#define __gen_nsIFileStreams_h__


#ifndef __gen_nsIInputStream_h__
#include "nsIInputStream.h"
#endif

#ifndef __gen_nsIOutputStream_h__
#include "nsIOutputStream.h"
#endif

#ifndef __gen_nsILocalFile_h__
#include "nsILocalFile.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsIFileInputStream */
#define NS_IFILEINPUTSTREAM_IID_STR "e3d56a20-c7ec-11d3-8cda-0060b0fc14a3"

#define NS_IFILEINPUTSTREAM_IID \
  {0xe3d56a20, 0xc7ec, 0x11d3, \
    { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 }}

class NS_NO_VTABLE nsIFileInputStream : public nsIInputStream {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IFILEINPUTSTREAM_IID)

  /* void init (in nsIFile file, in long ioFlags, in long perm); */
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIFILEINPUTSTREAM \
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIFILEINPUTSTREAM(_to) \
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm) { return _to ## Init(file, ioFlags, perm); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIFILEINPUTSTREAM(_to) \
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Init(file, ioFlags, perm); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsFileInputStream : public nsIFileInputStream
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIFILEINPUTSTREAM

  nsFileInputStream();
  virtual ~nsFileInputStream();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsFileInputStream, nsIFileInputStream)

nsFileInputStream::nsFileInputStream()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsFileInputStream::~nsFileInputStream()
{
  /* destructor code */
}

/* void init (in nsIFile file, in long ioFlags, in long perm); */
NS_IMETHODIMP nsFileInputStream::Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIFileOutputStream */
#define NS_IFILEOUTPUTSTREAM_IID_STR "e6f68040-c7ec-11d3-8cda-0060b0fc14a3"

#define NS_IFILEOUTPUTSTREAM_IID \
  {0xe6f68040, 0xc7ec, 0x11d3, \
    { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 }}

class NS_NO_VTABLE nsIFileOutputStream : public nsIOutputStream {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IFILEOUTPUTSTREAM_IID)

  /* void init (in nsIFile file, in long ioFlags, in long perm); */
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIFILEOUTPUTSTREAM \
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIFILEOUTPUTSTREAM(_to) \
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm) { return _to ## Init(file, ioFlags, perm); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIFILEOUTPUTSTREAM(_to) \
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Init(file, ioFlags, perm); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsFileOutputStream : public nsIFileOutputStream
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIFILEOUTPUTSTREAM

  nsFileOutputStream();
  virtual ~nsFileOutputStream();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsFileOutputStream, nsIFileOutputStream)

nsFileOutputStream::nsFileOutputStream()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsFileOutputStream::~nsFileOutputStream()
{
  /* destructor code */
}

/* void init (in nsIFile file, in long ioFlags, in long perm); */
NS_IMETHODIMP nsFileOutputStream::Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsISeekableStream */
#define NS_ISEEKABLESTREAM_IID_STR "e9de5df0-c7ec-11d3-8cda-0060b0fc14a3"

#define NS_ISEEKABLESTREAM_IID \
  {0xe9de5df0, 0xc7ec, 0x11d3, \
    { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 }}

class NS_NO_VTABLE nsISeekableStream : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ISEEKABLESTREAM_IID)

  enum { NS_SEEK_SET = 0 };

  enum { NS_SEEK_CUR = 1 };

  enum { NS_SEEK_END = 2 };

  /* void seek (in long whence, in long offset); */
  NS_IMETHOD Seek(PRInt32 whence, PRInt32 offset) = 0;

  /* unsigned long tell (); */
  NS_IMETHOD Tell(PRUint32 *_retval) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISEEKABLESTREAM \
  NS_IMETHOD Seek(PRInt32 whence, PRInt32 offset); \
  NS_IMETHOD Tell(PRUint32 *_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISEEKABLESTREAM(_to) \
  NS_IMETHOD Seek(PRInt32 whence, PRInt32 offset) { return _to ## Seek(whence, offset); } \
  NS_IMETHOD Tell(PRUint32 *_retval) { return _to ## Tell(_retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISEEKABLESTREAM(_to) \
  NS_IMETHOD Seek(PRInt32 whence, PRInt32 offset) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Seek(whence, offset); } \
  NS_IMETHOD Tell(PRUint32 *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Tell(_retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsSeekableStream : public nsISeekableStream
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISEEKABLESTREAM

  nsSeekableStream();
  virtual ~nsSeekableStream();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsSeekableStream, nsISeekableStream)

nsSeekableStream::nsSeekableStream()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsSeekableStream::~nsSeekableStream()
{
  /* destructor code */
}

/* void seek (in long whence, in long offset); */
NS_IMETHODIMP nsSeekableStream::Seek(PRInt32 whence, PRInt32 offset)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* unsigned long tell (); */
NS_IMETHODIMP nsSeekableStream::Tell(PRUint32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIBufferedInputStream */
#define NS_IBUFFEREDINPUTSTREAM_IID_STR "616f5b48-da09-11d3-8cda-0060b0fc14a3"

#define NS_IBUFFEREDINPUTSTREAM_IID \
  {0x616f5b48, 0xda09, 0x11d3, \
    { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 }}

class NS_NO_VTABLE nsIBufferedInputStream : public nsIInputStream {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IBUFFEREDINPUTSTREAM_IID)

  /* void init (in nsIInputStream fillFromStream, in unsigned long bufferSize); */
  NS_IMETHOD Init(nsIInputStream *fillFromStream, PRUint32 bufferSize) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIBUFFEREDINPUTSTREAM \
  NS_IMETHOD Init(nsIInputStream *fillFromStream, PRUint32 bufferSize); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIBUFFEREDINPUTSTREAM(_to) \
  NS_IMETHOD Init(nsIInputStream *fillFromStream, PRUint32 bufferSize) { return _to ## Init(fillFromStream, bufferSize); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIBUFFEREDINPUTSTREAM(_to) \
  NS_IMETHOD Init(nsIInputStream *fillFromStream, PRUint32 bufferSize) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Init(fillFromStream, bufferSize); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsBufferedInputStream : public nsIBufferedInputStream
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIBUFFEREDINPUTSTREAM

  nsBufferedInputStream();
  virtual ~nsBufferedInputStream();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsBufferedInputStream, nsIBufferedInputStream)

nsBufferedInputStream::nsBufferedInputStream()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsBufferedInputStream::~nsBufferedInputStream()
{
  /* destructor code */
}

/* void init (in nsIInputStream fillFromStream, in unsigned long bufferSize); */
NS_IMETHODIMP nsBufferedInputStream::Init(nsIInputStream *fillFromStream, PRUint32 bufferSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIBufferedOutputStream */
#define NS_IBUFFEREDOUTPUTSTREAM_IID_STR "6476378a-da09-11d3-8cda-0060b0fc14a3"

#define NS_IBUFFEREDOUTPUTSTREAM_IID \
  {0x6476378a, 0xda09, 0x11d3, \
    { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 }}

class NS_NO_VTABLE nsIBufferedOutputStream : public nsIOutputStream {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IBUFFEREDOUTPUTSTREAM_IID)

  /* void init (in nsIOutputStream sinkToStream, in unsigned long bufferSize); */
  NS_IMETHOD Init(nsIOutputStream *sinkToStream, PRUint32 bufferSize) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIBUFFEREDOUTPUTSTREAM \
  NS_IMETHOD Init(nsIOutputStream *sinkToStream, PRUint32 bufferSize); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIBUFFEREDOUTPUTSTREAM(_to) \
  NS_IMETHOD Init(nsIOutputStream *sinkToStream, PRUint32 bufferSize) { return _to ## Init(sinkToStream, bufferSize); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIBUFFEREDOUTPUTSTREAM(_to) \
  NS_IMETHOD Init(nsIOutputStream *sinkToStream, PRUint32 bufferSize) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Init(sinkToStream, bufferSize); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsBufferedOutputStream : public nsIBufferedOutputStream
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIBUFFEREDOUTPUTSTREAM

  nsBufferedOutputStream();
  virtual ~nsBufferedOutputStream();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsBufferedOutputStream, nsIBufferedOutputStream)

nsBufferedOutputStream::nsBufferedOutputStream()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsBufferedOutputStream::~nsBufferedOutputStream()
{
  /* destructor code */
}

/* void init (in nsIOutputStream sinkToStream, in unsigned long bufferSize); */
NS_IMETHODIMP nsBufferedOutputStream::Init(nsIOutputStream *sinkToStream, PRUint32 bufferSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

////////////////////////////////////////////////////////////////////////////////
#define NS_LOCALFILEINPUTSTREAM_CLASSNAME "Local File Input Stream"
#define NS_LOCALFILEINPUTSTREAM_CONTRACTID "@mozilla.org/network/file-input-stream;1"
#define NS_LOCALFILEINPUTSTREAM_CID                  \
{ /* be9a53ae-c7e9-11d3-8cda-0060b0fc14a3 */         \
    0xbe9a53ae,                                      \
    0xc7e9,                                          \
    0x11d3,                                          \
    {0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3} \
}
#define NS_LOCALFILEOUTPUTSTREAM_CLASSNAME "Local File Output Stream"
#define NS_LOCALFILEOUTPUTSTREAM_CONTRACTID "@mozilla.org/network/file-output-stream;1"
#define NS_LOCALFILEOUTPUTSTREAM_CID                 \
{ /* c272fee0-c7e9-11d3-8cda-0060b0fc14a3 */         \
    0xc272fee0,                                      \
    0xc7e9,                                          \
    0x11d3,                                          \
    {0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3} \
}
////////////////////////////////////////////////////////////////////////////////
#define NS_BUFFEREDINPUTSTREAM_CLASSNAME "Buffered Input Stream"
#define NS_BUFFEREDINPUTSTREAM_CONTRACTID "@mozilla.org/network/buffered-input-stream;1"
#define NS_BUFFEREDINPUTSTREAM_CID                   \
{ /* 9226888e-da08-11d3-8cda-0060b0fc14a3 */         \
    0x9226888e,                                      \
    0xda08,                                          \
    0x11d3,                                          \
    {0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3} \
}
#define NS_BUFFEREDOUTPUTSTREAM_CLASSNAME "Buffered Output Stream"
#define NS_BUFFEREDOUTPUTSTREAM_CONTRACTID "@mozilla.org/network/buffered-output-stream;1"
#define NS_BUFFEREDOUTPUTSTREAM_CID                  \
{ /* 9868b4ce-da08-11d3-8cda-0060b0fc14a3 */         \
    0x9868b4ce,                                      \
    0xda08,                                          \
    0x11d3,                                          \
    {0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3} \
}
////////////////////////////////////////////////////////////////////////////////
// move to nsNetUtil.h later...
#include "nsILoadGroup.h"
#include "nsIInterfaceRequestor.h"
#include "nsCOMPtr.h"
#include "nsIServiceManager.h"
#include "nsIFileChannel.h"
#include "nsILocalFile.h"
#include "nsIInputStream.h"
#include "nsIOutputStream.h"
#include "prio.h"       // for read/write flags, permissions, etc.
// This will QI the file argument to an nsILocalFile in the Init method.
inline nsresult
NS_NewLocalFileChannel(nsIFileChannel **result,
                       nsIFile* file,
                       PRInt32 ioFlags = -1,
                       PRInt32 perm = -1)
{
    nsresult rv;
    nsCOMPtr<nsIFileChannel> channel;
    static NS_DEFINE_CID(kLocalFileChannelCID, NS_LOCALFILECHANNEL_CID);
    rv = nsComponentManager::CreateInstance(kLocalFileChannelCID,
                                            nsnull, 
                                            NS_GET_IID(nsIFileChannel),
                                            getter_AddRefs(channel));
    if (NS_FAILED(rv)) return rv;
    rv = channel->Init(file, ioFlags, perm);
    if (NS_FAILED(rv)) return rv;
    *result = channel;
    NS_ADDREF(*result);
    return NS_OK;
}
// This will QI the file argument to an nsILocalFile in the Init method.
inline nsresult
NS_NewLocalFileInputStream(nsIInputStream* *result,
                           nsIFile* file, 
                           PRInt32 ioFlags = -1,
                           PRInt32 perm = -1)
{
    nsresult rv;
    nsCOMPtr<nsIFileInputStream> in;
    static NS_DEFINE_CID(kLocalFileInputStreamCID, NS_LOCALFILEINPUTSTREAM_CID);
    rv = nsComponentManager::CreateInstance(kLocalFileInputStreamCID,
                                            nsnull, 
                                            NS_GET_IID(nsIFileInputStream),
                                            getter_AddRefs(in));
    if (NS_FAILED(rv)) return rv;
    rv = in->Init(file, ioFlags, perm);
    if (NS_FAILED(rv)) return rv;
    *result = in;
    NS_ADDREF(*result);
    return NS_OK;
}
// This will QI the file argument to an nsILocalFile in the Init method.
inline nsresult
NS_NewLocalFileOutputStream(nsIOutputStream* *result,
                            nsIFile* file,
                            PRInt32 ioFlags = -1,
                            PRInt32 perm = -1)
{
    nsresult rv;
    nsCOMPtr<nsIFileOutputStream> out;
    static NS_DEFINE_CID(kLocalFileOutputStreamCID, NS_LOCALFILEOUTPUTSTREAM_CID);
    rv = nsComponentManager::CreateInstance(kLocalFileOutputStreamCID,
                                            nsnull, 
                                            NS_GET_IID(nsIFileOutputStream),
                                            getter_AddRefs(out));
    if (NS_FAILED(rv)) return rv;
    rv = out->Init(file, ioFlags, perm);
    if (NS_FAILED(rv)) return rv;
    *result = out;
    NS_ADDREF(*result);
    return NS_OK;
}
////////////////////////////////////////////////////////////////////////////////
inline nsresult
NS_NewBufferedInputStream(nsIInputStream* *result,
                          nsIInputStream* str,
                          PRUint32 bufferSize)
{
    nsresult rv;
    nsCOMPtr<nsIBufferedInputStream> in;
    static NS_DEFINE_CID(kBufferedInputStreamCID, NS_BUFFEREDINPUTSTREAM_CID);
    rv = nsComponentManager::CreateInstance(kBufferedInputStreamCID,
                                            nsnull, 
                                            NS_GET_IID(nsIBufferedInputStream),
                                            getter_AddRefs(in));
    if (NS_FAILED(rv)) return rv;
    rv = in->Init(str, bufferSize);
    if (NS_FAILED(rv)) return rv;
    *result = in;
    NS_ADDREF(*result);
    return NS_OK;
}
inline nsresult
NS_NewBufferedOutputStream(nsIOutputStream* *result,
                           nsIOutputStream* str,
                           PRUint32 bufferSize)
{
    nsresult rv;
    nsCOMPtr<nsIBufferedOutputStream> out;
    static NS_DEFINE_CID(kBufferedOutputStreamCID, NS_BUFFEREDOUTPUTSTREAM_CID);
    rv = nsComponentManager::CreateInstance(kBufferedOutputStreamCID,
                                            nsnull, 
                                            NS_GET_IID(nsIBufferedOutputStream),
                                            getter_AddRefs(out));
    if (NS_FAILED(rv)) return rv;
    rv = out->Init(str, bufferSize);
    if (NS_FAILED(rv)) return rv;
    *result = out;
    NS_ADDREF(*result);
    return NS_OK;
}

#endif /* __gen_nsIFileStreams_h__ */
