/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import sun.awt.DebugHelper;
import sun.awt.PlatformFont;
import sun.awt.image.ImageRepresentation;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MToolkit;
import sun.awt.motif.X11FontMetrics;
import sun.awt.motif.X11GIFAcceleratorLoops;
import sun.awt.motif.X11Image;
import sun.awt.motif.X11OneBitMono;
import sun.java2d.DeviceClipping;
import sun.java2d.OutputManager;
import sun.java2d.SunGraphics2D;
import sun.java2d.loops.DrawString;
import sun.java2d.loops.GraphicsPrimitiveMgr;
import sun.java2d.loops.GraphicsPrimitives;
import sun.java2d.loops.ImageData;
import sun.java2d.loops.RasterOutputManager;
import sun.java2d.pipe.LineStylePipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.SimpleRenderPipe;
import sun.java2d.pipe.SpanIterator;
import sun.java2d.pipe.TextPipe;
import sun.java2d.pipe.TranslateablePipe;

public class X11Graphics
extends SunGraphics2D
implements PixelDrawPipe,
PixelFillPipe,
TranslateablePipe,
LineStylePipe,
SimpleRenderPipe,
TextPipe,
DeviceClipping {
    private static final DebugHelper dbg = DebugHelper.create(class$sun$awt$motif$X11Graphics == null ? (class$sun$awt$motif$X11Graphics = X11Graphics.class$("sun.awt.motif.X11Graphics")) : class$sun$awt$motif$X11Graphics);
    static String myDevID = "X11Graphics";
    static String myDevIDMono = "X11MonoPixmap";
    long pData;
    MComponentPeer peer;
    private ImageData cachedID;
    private ImageData cachedMonoID;
    private boolean disposed = false;
    private static boolean usesPlatformFont;
    private Throwable constructionStackTrace;
    private int serialNum = -1;
    static /* synthetic */ Class class$sun$awt$motif$X11Graphics;

    private native void createFromComponent(MComponentPeer var1);

    private native void createFromGraphics(X11Graphics var1);

    private native void pSetFont(Font var1);

    private native void pSetForeground(Color var1);

    private static native void cacheInit();

    X11Graphics(MComponentPeer mComponentPeer) {
        this.peer = mComponentPeer;
        int[] nArray = new int[]{0};
        this.drawStringClass = (DrawString)GraphicsPrimitiveMgr.locate(DrawString.getMethodSignature(), nArray, myDevIDMono);
        this.createFromComponent(mComponentPeer);
        this.backgroundColor = mComponentPeer.target.getBackground();
        Dimension dimension = mComponentPeer.target.getSize();
        this.setDevClip(0, 0, dimension.width, dimension.height);
        this.serialNum = mComponentPeer.serialNum;
    }

    public Object clone() {
        X11Graphics x11Graphics = (X11Graphics)super.clone();
        x11Graphics.pData = 0L;
        x11Graphics.createFromGraphics(this);
        return x11Graphics;
    }

    public ColorModel getDeviceColorModel() {
        return this.peer.getColorModel();
    }

    public void validatePipe() {
        RasterOutputManager.getManager().validatePipe(this);
    }

    public Rectangle getCompBounds() {
        if (this.serialNum != this.peer.serialNum) {
            Dimension dimension = this.peer.target.getSize();
            this.setDevClip(0, 0, dimension.width, dimension.height);
            this.serialNum = this.peer.serialNum;
        }
        return super.getCompBounds();
    }

    public native void setOrigin(int var1, int var2);

    public void setLineAttrs(float f, float f2, float[] fArray, float f3, int n, int n2) {
        int n3;
        byte[] byArray;
        int n4 = Math.round(f2 * f);
        int n5 = 0;
        if (fArray != null) {
            int n6 = fArray.length;
            byArray = new byte[n6];
            float f4 = 0.0f;
            do {
                int n7 = 0;
                while (n7 < n6) {
                    f4 += fArray[n7] * f;
                    while (f4 > 0.5f) {
                        int n8;
                        int n9;
                        int n10 = n9 = f4 > 255.0f ? 2 : 1;
                        if (n5 + n9 >= byArray.length) {
                            byte[] byArray2 = new byte[byArray.length * 2];
                            System.arraycopy(byArray, 0, byArray2, 0, n5);
                            byArray = byArray2;
                        }
                        int n11 = n8 = f4 > 255.0f ? 255 : Math.round(f4);
                        if (n8 == 0) break;
                        byArray[n5++] = (byte)n8;
                        if (f4 > 255.0f) {
                            byArray[n5++] = 0;
                        }
                        f4 -= (float)n8;
                    }
                    ++n7;
                }
            } while (Math.abs(f4) > 0.1f && n5 < 100);
            n3 = Math.round(f3 * f);
        } else {
            byArray = null;
            n3 = 0;
        }
        if (n4 == 1 && byArray == null) {
            n4 = 0;
        }
        this.setLineAttrs(n4, n, n2, byArray, n5, n3);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        GraphicsConfiguration graphicsConfiguration;
        if (this.peer != null && (graphicsConfiguration = this.peer.getGraphicsConfiguration()) != null) {
            return graphicsConfiguration;
        }
        return MToolkit.config;
    }

    public OutputManager getOutputManager() {
        return RasterOutputManager.getManager();
    }

    protected native void disposeImpl();

    public final void dispose() {
        boolean bl = false;
        if (!this.disposed) {
            X11Graphics x11Graphics = this;
            synchronized (x11Graphics) {
                if (!this.disposed) {
                    bl = true;
                    this.disposed = true;
                }
            }
        }
        if (bl) {
            this.disposeImpl();
        }
    }

    public void finalize() {
        this.dispose();
    }

    public void setFont(Font font) {
        if (font != null && this.font != font) {
            super.setFont(font);
            this.pSetFont(font);
        }
    }

    public FontMetrics getFontMetrics(Font font) {
        if (this.textpipe == SunGraphics2D.invalidpipe) {
            this.validatePipe();
        }
        if (this.textpipe == this && usesPlatformFont) {
            return X11FontMetrics.getFontMetrics(font);
        }
        return super.getFontMetrics(font);
    }

    public void setColor(Color color) {
        if (color != null) {
            super.setColor(color);
            this.pSetForeground(color);
        }
    }

    public void setPaint(Paint paint) {
        super.setPaint(paint);
        if (paint instanceof Color) {
            this.pSetForeground((Color)paint);
        }
    }

    public native void pSetPaintMode();

    public native void pSetXORMode(Color var1);

    public void setPaintMode() {
        super.setPaintMode();
        this.pSetPaintMode();
    }

    public void setXORMode(Color color) {
        super.setXORMode(color);
        this.pSetXORMode(color);
    }

    public native void changeClip(int var1, int var2, int var3, int var4, boolean var5);

    public native void removeClip();

    public native void setLineAttrs(int var1, int var2, int var3, byte[] var4, int var5, int var6);

    public native void devClearRect(int var1, int var2, int var3, int var4);

    public void clearRect(int n, int n2, int n3, int n4) {
        if (this.fillpipe == SunGraphics2D.invalidpipe) {
            this.validatePipe();
        }
        if (this.fillpipe == this) {
            this.devClearRect(n, n2, n3, n4);
        } else {
            super.clearRect(n, n2, n3, n4);
        }
    }

    public native void devFillRect(int var1, int var2, int var3, int var4);

    public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.devFillRect(n, n2, n3, n4);
    }

    public native void devDrawRect(int var1, int var2, int var3, int var4);

    public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.devDrawRect(n, n2, n3, n4);
    }

    public Object drawStringPlatform(SunGraphics2D sunGraphics2D, String string, float f, float f2, Object object) {
        PlatformFont platformFont = (PlatformFont)this.font.getPeer();
        if (platformFont.mightHaveMultiFontMetrics()) {
            this.drawMFChars(string.toCharArray(), 0, string.length(), (int)f, (int)f2, this.font);
        } else {
            this.drawStringWidth(string, (int)f, (int)f2);
        }
        return null;
    }

    public Object drawGlyphVectorPlatform(SunGraphics2D sunGraphics2D, GlyphVector glyphVector, float f, float f2, Object object) {
        return super.drawGlyphVector(sunGraphics2D, glyphVector, f, f2, object);
    }

    public Object drawCharsPlatform(SunGraphics2D sunGraphics2D, char[] cArray, int n, int n2, int n3, int n4, Object object) {
        PlatformFont platformFont = (PlatformFont)this.font.getPeer();
        if (platformFont.mightHaveMultiFontMetrics()) {
            this.drawMFChars(cArray, n, n2, n3, n4, this.font);
        } else {
            this.drawSFChars(cArray, n, n2, n3, n4);
        }
        return null;
    }

    public Object drawBytesPlatform(SunGraphics2D sunGraphics2D, byte[] byArray, int n, int n2, int n3, int n4, Object object) {
        this.devDrawBytes(byArray, n, n2, n3, n4);
        return null;
    }

    private native void drawSFChars(char[] var1, int var2, int var3, int var4, int var5);

    private native void drawMFChars(char[] var1, int var2, int var3, int var4, int var5, Font var6);

    public native void devDrawBytes(byte[] var1, int var2, int var3, int var4, int var5);

    public native int drawStringWidth(String var1, int var2, int var3);

    public native void devDrawLine(int var1, int var2, int var3, int var4);

    public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.devDrawLine(n, n2, n3, n4);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        if (image instanceof BufferedImage) {
            return super.drawImage((BufferedImage)image, n, n2, n3, n4, null, imageObserver);
        }
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep();
        return imageRepresentation.drawToBufImage(this, (sun.awt.image.Image)image, n, n2, n3, n4, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        if (image instanceof BufferedImage) {
            super.drawImage((BufferedImage)image, n, n2, color, imageObserver);
            return true;
        }
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep();
        return imageRepresentation.drawToBufImage(this, (sun.awt.image.Image)image, n, n2, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        if (image instanceof BufferedImage) {
            return super.drawImage((BufferedImage)image, n, n2, n3, n4, color, imageObserver);
        }
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep();
        return imageRepresentation.drawToBufImage(this, (sun.awt.image.Image)image, n, n2, n3, n4, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (image instanceof BufferedImage) {
            return super.drawImage((BufferedImage)image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
        }
        if (n == n3 || n2 == n4) {
            return true;
        }
        if (n5 == n7 || n6 == n8) {
            return true;
        }
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep();
        return imageRepresentation.drawToBufImage(this, (sun.awt.image.Image)image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        if (image instanceof BufferedImage) {
            super.drawImage((BufferedImage)image, affineTransform, 0, 0, null, imageObserver);
            return true;
        }
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError() && imageObserver != null) {
            imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            return false;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep();
        return imageRepresentation.drawToBufImage(this, (sun.awt.image.Image)image, affineTransform, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (image instanceof BufferedImage) {
            return super.drawImage((BufferedImage)image, n, n2, null, imageObserver);
        }
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep();
        return imageRepresentation.drawToBufImage(this, (sun.awt.image.Image)image, n, n2, null, imageObserver);
    }

    public native void devCopyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.fillpipe == SunGraphics2D.invalidpipe) {
            this.validatePipe();
        }
        if (this.fillpipe == this) {
            this.devCopyArea(n, n2, n3, n4, n5, n6);
        } else {
            super.copyArea(n, n2, n3, n4, n5, n6);
        }
    }

    public native void devDrawRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public void drawRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.devDrawRoundRect(n, n2, n3, n4, n5, n6);
    }

    public native void devFillRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public void fillRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.devFillRoundRect(n, n2, n3, n4, n5, n6);
    }

    private native void devDrawPoly(int[] var1, int[] var2, int var3, boolean var4);

    public void drawPolys(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int[] nArray3, int n, boolean bl) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray3[n2];
            this.devDrawPoly(nArray, nArray2, n3, bl);
            System.arraycopy(nArray, n3, nArray, 0, nArray.length - n3);
            System.arraycopy(nArray2, n3, nArray2, 0, nArray2.length - n3);
            ++n2;
        }
    }

    public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.devDrawPoly(nArray, nArray2, n, false);
    }

    public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.devDrawPoly(nArray, nArray2, n, true);
    }

    public native void devFillPolygon(int[] var1, int[] var2, int var3, boolean var4);

    public void fillPolys(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int[] nArray3, int n, boolean bl) {
        int n2;
        if (n < 1) {
            return;
        }
        if (n > 1) {
            Polygon polygon = new Polygon();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n) {
                n2 = nArray3[n6];
                if (n2 < 2) {
                    n3 += n2;
                } else {
                    polygon.addPoint(0, 0);
                    int n7 = nArray[n3];
                    int n8 = nArray2[n3];
                    int n9 = 0;
                    while (n9 < n2) {
                        n4 = nArray[n3];
                        n5 = nArray2[n3];
                        polygon.addPoint(n4, n5);
                        ++n3;
                        ++n9;
                    }
                    if (n4 != n7 || n5 != n8) {
                        polygon.addPoint(n7, n8);
                    }
                    polygon.addPoint(0, 0);
                }
                ++n6;
            }
            nArray = polygon.xpoints;
            nArray2 = polygon.ypoints;
            n2 = polygon.npoints;
        } else {
            n2 = nArray3[0];
        }
        this.devFillPolygon(nArray, nArray2, n2, bl);
    }

    public native void devFillSpans(SpanIterator var1, long var2);

    public void fillSpans(SunGraphics2D sunGraphics2D, SpanIterator spanIterator) {
        this.devFillSpans(spanIterator, spanIterator.getNativeIterator());
    }

    public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.devFillPolygon(nArray, nArray2, n, true);
    }

    public native void devDrawOval(int var1, int var2, int var3, int var4);

    public void drawOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.devDrawOval(n, n2, n3, n4);
    }

    public native void devFillOval(int var1, int var2, int var3, int var4);

    public void fillOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.devFillOval(n, n2, n3, n4);
    }

    public native void devDrawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public void drawArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.devDrawArc(n, n2, n3, n4, n5, n6);
    }

    public native void devFillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public void fillArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.devFillArc(n, n2, n3, n4, n5, n6);
    }

    public String toString() {
        return this.getClass().getName();
    }

    public String getDevID() {
        return myDevID;
    }

    private native int X11getMonoImageData(ImageData var1);

    private native int X11putMonoImageData(ImageData var1);

    public ImageData getMonoImageData(int n, int n2, int n3, int n4) {
        ImageData imageData = this.cachedMonoID;
        if (null == imageData || imageData.amILocked()) {
            imageData = new ImageData();
            imageData.setColorModel(null);
        }
        int n5 = n / 8 * 8;
        int n6 = n3 + (n - n5);
        imageData.setViewArea(n5, n2, n6, n4);
        imageData.setLockMethod(3);
        imageData.incLockCount();
        int n7 = this.X11getMonoImageData(imageData);
        if (n7 == 1) {
            this.cachedMonoID = imageData;
            return imageData;
        }
        return null;
    }

    public int putMonoImageData(ImageData imageData) {
        int n = 5;
        if (null != imageData) {
            n = 6;
            if (imageData.amILocked() && 2 == (n = this.X11putMonoImageData(imageData))) {
                imageData.decLockCount();
            }
        }
        return n;
    }

    private native int X11LockViewResources(ImageData var1);

    private native int X11UnLockViewResources(ImageData var1);

    public ImageData lock(int n, int n2, int n3, int n4, int n5) {
        ImageData imageData = this.cachedID;
        if (null == imageData || imageData.amILocked()) {
            imageData = new ImageData();
            imageData.setColorModel(this.getDeviceColorModel());
        }
        imageData.setViewArea(n, n2, n3, n4);
        imageData.setLockMethod(n5);
        imageData.incLockCount();
        int n6 = this.X11LockViewResources(imageData);
        if (1 == n6) {
            this.cachedID = imageData;
            return imageData;
        }
        return null;
    }

    public int unlock(ImageData imageData) {
        int n = 5;
        if (null != imageData) {
            n = 6;
            if (imageData.amILocked() && 2 == (n = this.X11UnLockViewResources(imageData))) {
                imageData.decLockCount();
            }
        }
        return n;
    }

    public Object drawString(SunGraphics2D sunGraphics2D, String string, float f, float f2, Object object) {
        if (usesPlatformFont) {
            return this.drawStringPlatform(sunGraphics2D, string, f, f2, object);
        }
        X11TextCachedState x11TextCachedState = null;
        if (object != null && object instanceof X11TextCachedState) {
            x11TextCachedState = (X11TextCachedState)object;
        }
        if (x11TextCachedState == null) {
            x11TextCachedState = new X11TextCachedState(sunGraphics2D);
        }
        X11Graphics x11Graphics = (X11Graphics)sunGraphics2D;
        if (!sunGraphics2D.simpleText) {
            if (object instanceof X11TextCachedState) {
                object = null;
            }
            System.out.println("not simple text");
            return super.drawString(sunGraphics2D, string, f, f2, object);
        }
        if (x11TextCachedState.frc.isAntiAliased() || x11TextCachedState.frc.usesFractionalMetrics()) {
            if (object instanceof X11TextCachedState) {
                object = null;
            }
            System.out.println("isAntialias||usesFractionalMetrics");
            return super.drawString(sunGraphics2D, string, f, f2, object);
        }
        DrawString drawString = x11Graphics.drawStringClass;
        Rectangle rectangle = this.getBoundingRect(sunGraphics2D, string, x11TextCachedState.theFont, x11TextCachedState.frc, f, f2);
        ImageData imageData = x11Graphics.getMonoImageData(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        try {
            double[] dArray = x11TextCachedState.getOrigin(f, f2);
            f = (float)dArray[0];
            f2 = (float)dArray[1];
            drawString.DrawString(imageData, string, f, f2, x11TextCachedState.theColor, x11TextCachedState.theFont, x11TextCachedState.matrix, false, x11TextCachedState.frc.usesFractionalMetrics());
        }
        catch (Exception exception) {
            // empty catch block
        }
        x11Graphics.putMonoImageData(imageData);
        return x11TextCachedState;
    }

    public Object drawGlyphVector(SunGraphics2D sunGraphics2D, GlyphVector glyphVector, float f, float f2, Object object) {
        if (usesPlatformFont) {
            return this.drawGlyphVectorPlatform(sunGraphics2D, glyphVector, f, f2, object);
        }
        return super.drawGlyphVector(sunGraphics2D, glyphVector, f, f2, object);
    }

    public Object drawChars(SunGraphics2D sunGraphics2D, char[] cArray, int n, int n2, int n3, int n4, Object object) {
        if (usesPlatformFont) {
            return this.drawCharsPlatform(sunGraphics2D, cArray, n, n2, n3, n4, object);
        }
        return this.drawString(sunGraphics2D, new String(cArray, n, n2), n3, n4, object);
    }

    public Object drawBytes(SunGraphics2D sunGraphics2D, byte[] byArray, int n, int n2, int n3, int n4, Object object) {
        if (usesPlatformFont) {
            return this.drawBytesPlatform(sunGraphics2D, byArray, n, n2, n3, n4, object);
        }
        return this.drawString(sunGraphics2D, new String(byArray, 0, n, n2), n3, n4, object);
    }

    private Rectangle getBoundingRect(SunGraphics2D sunGraphics2D, String string, Font font, FontRenderContext fontRenderContext, double d, double d2) {
        Rectangle2D rectangle2D = font.getMaxCharBounds(fontRenderContext);
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        double d3 = rectangle2D.getWidth() * (double)string.length();
        double d4 = rectangle2D.getHeight() + (double)lineMetrics.getDescent();
        double d5 = d;
        double d6 = d2 - (double)lineMetrics.getAscent();
        if (sunGraphics2D.transformState != 0) {
            double[] dArray = new double[]{d5, d6, d5 + d3, d6, d5, d6 + d4, d5 + d3, d6 + d4};
            double[] dArray2 = new double[8];
            sunGraphics2D.transform.transform(dArray, 0, dArray2, 0, 4);
            int n = Integer.MAX_VALUE;
            int n2 = Integer.MAX_VALUE;
            int n3 = Integer.MIN_VALUE;
            int n4 = Integer.MIN_VALUE;
            int n5 = 0;
            while (n5 < 8) {
                if (dArray2[n5] < (double)n) {
                    n = (int)dArray2[n5];
                }
                if (dArray2[n5] > (double)n3) {
                    n3 = (int)dArray2[n5];
                }
                if (dArray2[n5 + 1] < (double)n2) {
                    n2 = (int)dArray2[n5 + 1];
                }
                if (dArray2[n5 + 1] > (double)n4) {
                    n4 = (int)dArray2[n5 + 1];
                }
                n5 += 2;
            }
            return new Rectangle(n, n2, n3 - n, n4 - n2);
        }
        return new Rectangle((int)d5, (int)d6, (int)d3, (int)d4);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        MToolkit mToolkit = (MToolkit)Toolkit.getDefaultToolkit();
        X11Graphics.cacheInit();
        RasterOutputManager rasterOutputManager = RasterOutputManager.getManager();
        GraphicsPrimitiveMgr.register((GraphicsPrimitives)new X11GIFAcceleratorLoops(), myDevID);
        GraphicsPrimitiveMgr.register((GraphicsPrimitives)new X11OneBitMono(), myDevIDMono);
        usesPlatformFont = RasterOutputManager.usesPlatformFont();
    }

    class X11TextCachedState {
        double[] matrix;
        double[] devTX;
        Font theFont;
        Color theColor;
        FontRenderContext frc;
        SunGraphics2D the2D;

        X11TextCachedState(SunGraphics2D sunGraphics2D) {
            this.the2D = sunGraphics2D;
            this.theFont = this.the2D.getFont();
            float f = this.theFont.getSize2D();
            this.frc = this.the2D.getFontRenderContext();
            AffineTransform affineTransform = this.frc.getTransform();
            affineTransform.scale(f, f);
            affineTransform.preConcatenate(this.theFont.getTransform());
            affineTransform.preConcatenate(this.the2D.transform);
            this.matrix = new double[6];
            affineTransform.getMatrix(this.matrix);
            this.devTX = new double[6];
            this.the2D.transform.getMatrix(this.devTX);
            this.theColor = this.the2D.getColor();
        }

        double[] getOrigin(float f, float f2) {
            double[] dArray = new double[]{f, f2};
            this.the2D.transform.deltaTransform(dArray, 0, dArray, 0, 1);
            dArray[0] = dArray[0] + this.matrix[4];
            dArray[1] = dArray[1] + this.matrix[5];
            return dArray;
        }
    }
}

