/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import sun.awt.X11GraphicsConfig;

public class X11GraphicsDevice
extends GraphicsDevice {
    int screen;
    GraphicsConfiguration[] configs;
    GraphicsConfiguration defaultConfig;

    public X11GraphicsDevice(int n) {
        this.screen = n;
    }

    public int getScreen() {
        return this.screen;
    }

    public native int getDisplay();

    public int getType() {
        return 0;
    }

    public String getIDstring() {
        return ":0." + this.screen;
    }

    public GraphicsConfiguration[] getConfigurations() {
        GraphicsConfiguration[] graphicsConfigurationArray = this.configs;
        if (graphicsConfigurationArray == null) {
            int n = 0;
            int n2 = this.getNumConfigs(this.screen);
            graphicsConfigurationArray = new GraphicsConfiguration[n2];
            if (this.defaultConfig != null) {
                graphicsConfigurationArray[0] = this.defaultConfig;
                ++n;
            }
            while (n < n2) {
                int n3 = this.getConfigVisualId(n, this.screen);
                graphicsConfigurationArray[n] = X11GraphicsConfig.getConfig(this, n3);
                ++n;
            }
            this.configs = graphicsConfigurationArray;
        }
        return graphicsConfigurationArray;
    }

    private native int getNumConfigs(int var1);

    private native int getConfigVisualId(int var1, int var2);

    public GraphicsConfiguration getDefaultConfiguration() {
        if (this.defaultConfig == null) {
            int n = this.getConfigVisualId(0, this.screen);
            this.defaultConfig = X11GraphicsConfig.getConfig(this, n);
        }
        return this.defaultConfig;
    }

    public String toString() {
        return "X11GraphicsDevice[screen=" + this.screen + "]";
    }
}

