/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

class UNIXProcess
extends Process {
    static Hashtable subprocs = null;
    private boolean isalive = false;
    private int exit_code = 0;
    private FileDescriptor stdin_fd;
    private FileDescriptor stdout_fd;
    private FileDescriptor stderr_fd;
    private FileDescriptor sync_fd;
    int pid;
    private OutputStream stdin_stream;
    private InputStream raw_stdout;
    private InputStream raw_stderr;
    private ProcessInputStream piped_stdout_in;
    private ProcessInputStream piped_stderr_in;
    private PipedOutputStream piped_stdout_out;
    private PipedOutputStream piped_stderr_out;
    private int numReaders;

    UNIXProcess() {
    }

    static native void initLockObject();

    private native int forkAndExec(String[] var1, String[] var2, String var3, FileDescriptor var4, FileDescriptor var5, FileDescriptor var6, FileDescriptor var7) throws IOException;

    private static void deadChild(int n, int n2) {
        UNIXProcess uNIXProcess = (UNIXProcess)subprocs.get(new Integer(n));
        if (uNIXProcess != null) {
            UNIXProcess uNIXProcess2 = uNIXProcess;
            synchronized (uNIXProcess2) {
                uNIXProcess.isalive = false;
                subprocs.remove(new Integer(n));
                uNIXProcess.exit_code = n2;
                uNIXProcess.notifyAll();
            }
        }
    }

    synchronized int getNumReaders() throws InterruptedException {
        return this.numReaders;
    }

    synchronized void decrNumReaders() {
        if (--this.numReaders <= 0) {
            try {
                this.stdin_stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.raw_stdout.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.raw_stderr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.notifyAll();
    }

    UNIXProcess(String[] stringArray, String[] stringArray2) throws IOException {
        this(stringArray, stringArray2, null);
    }

    UNIXProcess(String[] stringArray, String[] stringArray2, String string) throws IOException {
        this.stdin_fd = new FileDescriptor();
        this.stdout_fd = new FileDescriptor();
        this.stderr_fd = new FileDescriptor();
        this.sync_fd = new FileDescriptor();
        this.pid = this.forkAndExec(stringArray, stringArray2, string, this.stdin_fd, this.stdout_fd, this.stderr_fd, this.sync_fd);
        this.isalive = true;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                UNIXProcess.this.stdin_stream = new BufferedOutputStream(new FileOutputStream(UNIXProcess.this.stdin_fd));
                UNIXProcess.this.raw_stdout = new FileInputStream(UNIXProcess.this.stdout_fd);
                UNIXProcess.this.raw_stderr = new FileInputStream(UNIXProcess.this.stderr_fd);
                return null;
            }
        });
        this.piped_stdout_out = new PipedOutputStream();
        this.piped_stderr_out = new PipedOutputStream();
        this.piped_stdout_in = new ProcessInputStream(this, this.piped_stdout_out, this.raw_stdout);
        this.piped_stderr_in = new ProcessInputStream(this, this.piped_stderr_out, this.raw_stderr);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread thread = new Thread(UNIXProcess.this.piped_stdout_in, "stdout reader pid=" + UNIXProcess.this.pid);
                thread.setDaemon(true);
                Thread thread2 = new Thread(UNIXProcess.this.piped_stderr_in, "stderr reader pid=" + UNIXProcess.this.pid);
                thread2.setDaemon(true);
                thread.start();
                thread2.start();
                return null;
            }
        });
        this.numReaders = 2;
        subprocs.put(new Integer(this.pid), this);
        FileOutputStream fileOutputStream = (FileOutputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new FileOutputStream(UNIXProcess.this.sync_fd);
            }
        });
        fileOutputStream.write(65);
        fileOutputStream.close();
    }

    public OutputStream getOutputStream() {
        return this.stdin_stream;
    }

    public InputStream getInputStream() {
        return this.piped_stdout_in;
    }

    public InputStream getErrorStream() {
        return this.piped_stderr_in;
    }

    public synchronized int waitFor() throws InterruptedException {
        while (this.isalive) {
            this.wait();
        }
        return this.exit_code;
    }

    public synchronized int exitValue() {
        if (this.isalive) {
            throw new IllegalThreadStateException("process hasn't exited");
        }
        return this.exit_code;
    }

    public native void destroy();

    static {
        subprocs = new Hashtable();
        UNIXProcess.initLockObject();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread thread = new Thread(new UNIXProcessReaper(), "process reaper");
                thread.setDaemon(true);
                thread.start();
                thread = new Thread(new UNIXProcessForker(), "process forker");
                thread.setDaemon(true);
                thread.start();
                return null;
            }
        });
    }
}

