/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayOutputStream;

public class BitArray {
    private byte[] repn;
    private int length;
    private static final int BITS_PER_UNIT = 8;
    private static final byte[][] NYBBLE = new byte[][]{{48, 48, 48, 48}, {48, 48, 48, 49}, {48, 48, 49, 48}, {48, 48, 49, 49}, {48, 49, 48, 48}, {48, 49, 48, 49}, {48, 49, 49, 48}, {48, 49, 49, 49}, {49, 48, 48, 48}, {49, 48, 48, 49}, {49, 48, 49, 48}, {49, 48, 49, 49}, {49, 49, 48, 48}, {49, 49, 48, 49}, {49, 49, 49, 48}, {49, 49, 49, 49}};
    private static final int BYTES_PER_LINE = 8;

    private static int subscript(int n) {
        return n / 8;
    }

    private static int position(int n) {
        return 1 << 7 - n % 8;
    }

    public BitArray(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Negative length for BitArray");
        }
        this.length = n;
        this.repn = new byte[(n + 8 - 1) / 8];
    }

    public BitArray(int n, byte[] byArray) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Negative length for BitArray");
        }
        if (byArray.length * 8 < n) {
            throw new IllegalArgumentException("Byte array too short to represent bit array of given length");
        }
        this.length = n;
        int n2 = (n + 8 - 1) / 8;
        int n3 = n2 * 8 - n;
        byte by = (byte)(255 << n3);
        this.repn = new byte[n2];
        System.arraycopy(byArray, 0, this.repn, 0, n2);
        this.repn[this.repn.length - 1] = (byte)(this.repn[this.repn.length - 1] & by);
    }

    public BitArray(boolean[] blArray) {
        this.length = blArray.length;
        this.repn = new byte[(this.length + 7) / 8];
        int n = 0;
        while (n < this.length) {
            this.set(n, blArray[n]);
            ++n;
        }
    }

    private BitArray(BitArray bitArray) {
        this.length = bitArray.length;
        this.repn = (byte[])bitArray.repn.clone();
    }

    public boolean get(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(n));
        }
        return (this.repn[BitArray.subscript(n)] & BitArray.position(n)) != 0;
    }

    public void set(int n, boolean bl) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(n));
        }
        int n2 = BitArray.subscript(n);
        int n3 = BitArray.position(n);
        if (bl) {
            int n4 = n2;
            this.repn[n4] = (byte)(this.repn[n4] | n3);
        } else {
            int n5 = n2;
            this.repn[n5] = (byte)(this.repn[n5] & ~n3);
        }
    }

    public int length() {
        return this.length;
    }

    public byte[] toByteArray() {
        return (byte[])this.repn.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof BitArray)) {
            return false;
        }
        BitArray bitArray = (BitArray)object;
        if (bitArray.length != this.length) {
            return false;
        }
        int n = 0;
        while (n < this.repn.length) {
            if (this.repn[n] != bitArray.repn[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean[] toBooleanArray() {
        boolean[] blArray = new boolean[this.length];
        int n = 0;
        while (n < this.length) {
            blArray[n] = this.get(n);
            ++n;
        }
        return blArray;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.repn.length) {
            n = 31 * n + this.repn[n2];
            ++n2;
        }
        return n ^ this.length;
    }

    public Object clone() {
        return new BitArray(this);
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < this.repn.length - 1) {
            byteArrayOutputStream.write(NYBBLE[this.repn[n] >> 4 & 0xF], 0, 4);
            byteArrayOutputStream.write(NYBBLE[this.repn[n] & 0xF], 0, 4);
            if (n % 8 == 7) {
                byteArrayOutputStream.write(10);
            } else {
                byteArrayOutputStream.write(32);
            }
            ++n;
        }
        int n2 = 8 * (this.repn.length - 1);
        while (n2 < this.length) {
            byteArrayOutputStream.write(this.get(n2) ? 49 : 48);
            ++n2;
        }
        return new String(byteArrayOutputStream.toByteArray());
    }
}

