/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.rmi.dgc.DGC;
import java.rmi.dgc.Lease;
import java.rmi.dgc.VMID;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.RMIThreadAction;
import sun.rmi.transport.Target;
import sun.security.action.GetLongAction;
import sun.security.action.GetPropertyAction;

final class DGCImpl
implements DGC {
    static int logLevel = LogStream.parseLevel(DGCImpl.getLogLevel());
    private static final long leaseValue = DGCImpl.getLong("java.rmi.dgc.leaseValue", 600000L);
    private static final long leaseCheckInterval = DGCImpl.getLong("sun.rmi.dgc.checkInterval", 300000L);
    private static ObjID dgcID;
    private static DGCImpl dgc;
    private Hashtable leaseTable = new Hashtable();
    private Thread checker = null;

    private static String getLogLevel() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.dgc.logLevel"));
    }

    private static long getLong(String string, long l) {
        return (Long)AccessController.doPrivileged(new GetLongAction(string, l));
    }

    static DGCImpl getDGCImpl() {
        return dgc;
    }

    private DGCImpl() {
    }

    public Lease dirty(ObjID[] objIDArray, long l, Lease lease) {
        Object object;
        VMID vMID = lease.getVMID();
        long l2 = leaseValue;
        if (logLevel >= 20) {
            LogStream.log("dgc").println("DGCImpl.dirty: vmid = " + vMID);
        }
        if (vMID == null) {
            vMID = new VMID();
            if (logLevel >= 10) {
                try {
                    object = RemoteServer.getClientHost();
                }
                catch (ServerNotActiveException serverNotActiveException) {
                    object = "<unknown host>";
                }
                LogStream.log("dgc").println("DGCImpl.dirty: assigning vmid " + vMID + " to client " + (String)object);
            }
        }
        lease = new Lease(vMID, l2);
        object = this.leaseTable;
        synchronized (object) {
            LeaseInfo leaseInfo = (LeaseInfo)this.leaseTable.get(vMID);
            if (leaseInfo == null) {
                this.leaseTable.put(vMID, new LeaseInfo(vMID, l2));
                if (this.checker == null) {
                    this.checker = (Thread)AccessController.doPrivileged(new RMIThreadAction(new LeaseChecker(), "LeaseChecker", true));
                    this.checker.start();
                }
            } else {
                leaseInfo.renew(l2);
            }
        }
        int n = 0;
        while (n < objIDArray.length) {
            if (logLevel >= 20) {
                LogStream.log("dgc").println("DGCImpl.dirty: id = " + objIDArray[n] + ", vmid = " + vMID + ", duration = " + l2);
            }
            ObjectTable.referenced(objIDArray[n], l, vMID);
            ++n;
        }
        return lease;
    }

    public void clean(ObjID[] objIDArray, long l, VMID vMID, boolean bl) {
        int n = 0;
        while (n < objIDArray.length) {
            if (logLevel >= 20) {
                LogStream.log("dgc").println("DGCImpl.clean: id = " + objIDArray[n] + ", vmid = " + vMID + ", strong = " + bl);
            }
            ObjectTable.unreferenced(objIDArray[n], l, vMID, bl);
            ++n;
        }
    }

    void registerTarget(VMID vMID, Target target) {
        Hashtable hashtable = this.leaseTable;
        synchronized (hashtable) {
            LeaseInfo leaseInfo = (LeaseInfo)this.leaseTable.get(vMID);
            if (leaseInfo == null) {
                target.vmidDead(vMID);
            } else {
                Vector vector = leaseInfo.notifyList;
                synchronized (vector) {
                    if (!leaseInfo.notifyList.contains(target)) {
                        leaseInfo.notifyList.addElement(target);
                    }
                }
            }
        }
    }

    void unregisterTarget(VMID vMID, Target target) {
        Hashtable hashtable = this.leaseTable;
        synchronized (hashtable) {
            LeaseInfo leaseInfo = (LeaseInfo)this.leaseTable.get(vMID);
            if (leaseInfo != null) {
                Vector vector = leaseInfo.notifyList;
                synchronized (vector) {
                    leaseInfo.notifyList.removeElement(target);
                }
            }
        }
    }

    private boolean checkLeases() {
        long l = System.currentTimeMillis();
        Enumeration enumeration = null;
        LeaseInfo leaseInfo = null;
        boolean bl = false;
        Vector vector = new Vector(5);
        Hashtable hashtable = this.leaseTable;
        synchronized (hashtable) {
            enumeration = this.leaseTable.elements();
            while (enumeration.hasMoreElements()) {
                leaseInfo = (LeaseInfo)enumeration.nextElement();
                if (!leaseInfo.expired(l)) continue;
                vector.add(leaseInfo);
                this.leaseTable.remove(leaseInfo.vmid);
            }
            if (this.leaseTable.isEmpty()) {
                this.checker = null;
                bl = false;
            } else {
                bl = true;
            }
        }
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            leaseInfo = (LeaseInfo)enumeration2.nextElement();
            Vector vector2 = leaseInfo.notifyList;
            synchronized (vector2) {
                enumeration = leaseInfo.notifyList.elements();
                while (enumeration.hasMoreElements()) {
                    Target target = (Target)enumeration.nextElement();
                    target.vmidDead(leaseInfo.vmid);
                }
            }
        }
        return bl;
    }

    static ObjID getID() {
        return dgcID;
    }

    static {
        try {
            dgc = new DGCImpl();
            dgcID = new ObjID(2);
            LiveRef liveRef = new LiveRef(dgcID, 0);
            UnicastServerRef unicastServerRef = new UnicastServerRef(liveRef);
            RemoteStub remoteStub = unicastServerRef.setSkeleton(dgc);
            Target target = new Target(dgc, unicastServerRef, remoteStub, dgcID, true);
            ObjectTable.putTarget(target);
        }
        catch (Exception exception) {
            System.out.println("couldn't init remote garbage collector");
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private static class LeaseInfo {
        VMID vmid;
        long expiration;
        Vector notifyList = new Vector();

        LeaseInfo(VMID vMID, long l) {
            this.vmid = vMID;
            this.expiration = System.currentTimeMillis() + l;
        }

        synchronized void renew(long l) {
            long l2 = System.currentTimeMillis() + l;
            if (l2 > this.expiration) {
                this.expiration = l2;
            }
        }

        boolean expired(long l) {
            if (this.expiration < l) {
                if (logLevel >= 10) {
                    LogStream.log("dgc").println("LeaseInfo.expired: " + this.vmid);
                }
                return true;
            }
            return false;
        }
    }

    private class LeaseChecker
    implements Runnable {
        private LeaseChecker() {
        }

        public void run() {
            do {
                try {
                    Thread.sleep(leaseCheckInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (DGCImpl.this.checkLeases());
        }
    }
}

