/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.CompositeContext;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import sun.java2d.SunGraphics2D;
import sun.java2d.loops.RasterOutputManager;
import sun.java2d.pipe.CompositePipe;

public class GeneralCompositePipe
implements CompositePipe {
    public Object startSequence(SunGraphics2D sunGraphics2D, Shape shape, Rectangle rectangle, int[] nArray) {
        RenderingHints renderingHints = sunGraphics2D.getRenderingHints();
        ColorModel colorModel = sunGraphics2D.getDeviceColorModel();
        PaintContext paintContext = sunGraphics2D.paint.createContext(colorModel, rectangle, shape.getBounds2D(), sunGraphics2D.cloneTransform(), renderingHints);
        CompositeContext compositeContext = sunGraphics2D.composite.createContext(paintContext.getColorModel(), colorModel, renderingHints);
        return new TileContext(sunGraphics2D, paintContext, compositeContext, colorModel);
    }

    public boolean needTile(Object object, int n, int n2, int n3, int n4) {
        return true;
    }

    public void renderPathTile(Object object, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
        TileContext tileContext = (TileContext)object;
        PaintContext paintContext = tileContext.paintCtxt;
        CompositeContext compositeContext = tileContext.compCtxt;
        SunGraphics2D sunGraphics2D = tileContext.sunG2D;
        Raster raster = paintContext.getRaster(n3, n4, n5, n6);
        ColorModel colorModel = paintContext.getColorModel();
        RasterOutputManager rasterOutputManager = (RasterOutputManager)sunGraphics2D.getOutputManager();
        tileContext.pipeState = rasterOutputManager.compositePaintLoop(sunGraphics2D, byArray, n, n2, n3, n4, n5, n6, colorModel, raster, tileContext.pipeState);
    }

    public void skipTile(Object object, int n, int n2) {
    }

    public void endSequence(Object object) {
        TileContext tileContext = (TileContext)object;
        if (tileContext.paintCtxt != null) {
            tileContext.paintCtxt.dispose();
        }
        if (tileContext.compCtxt != null) {
            tileContext.compCtxt.dispose();
        }
    }

    class TileContext {
        SunGraphics2D sunG2D;
        PaintContext paintCtxt;
        CompositeContext compCtxt;
        ColorModel compModel;
        Object pipeState;

        public TileContext(SunGraphics2D sunGraphics2D, PaintContext paintContext, CompositeContext compositeContext, ColorModel colorModel) {
            this.sunG2D = sunGraphics2D;
            this.paintCtxt = paintContext;
            this.compCtxt = compositeContext;
            this.compModel = colorModel;
        }
    }
}

