/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.GapVector;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class GapContent
extends GapVector
implements AbstractDocument.Content,
Serializable {
    private static final char[] empty = new char[0];
    private transient MarkVector marks;
    private transient MarkData search;
    private transient int unusedMarks;

    public GapContent() {
        this(10);
    }

    public GapContent(int n) {
        super(Math.max(n, 2));
        char[] cArray = new char[]{'\n'};
        this.replace(0, 0, cArray, cArray.length);
        this.marks = new MarkVector();
        this.search = new MarkData(0);
    }

    protected Object allocateArray(int n) {
        return new char[n];
    }

    protected int getArrayLength() {
        char[] cArray = (char[])this.getArray();
        return cArray.length;
    }

    public int length() {
        int n = this.getArrayLength() - (this.getGapEnd() - this.getGapStart());
        return n;
    }

    public UndoableEdit insertString(int n, String string) throws BadLocationException {
        if (n >= this.length()) {
            throw new BadLocationException("Invalid insert", this.length());
        }
        char[] cArray = string.toCharArray();
        this.replace(n, 0, cArray, cArray.length);
        return new InsertUndo(n, string.length());
    }

    public UndoableEdit remove(int n, int n2) throws BadLocationException {
        if (n + n2 >= this.length()) {
            throw new BadLocationException("Invalid remove", this.length() + 1);
        }
        String string = this.getString(n, n2);
        RemoveUndo removeUndo = new RemoveUndo(n, string);
        this.replace(n, n2, empty, 0);
        return removeUndo;
    }

    public String getString(int n, int n2) throws BadLocationException {
        Segment segment = new Segment();
        this.getChars(n, n2, segment);
        return new String(segment.array, segment.offset, segment.count);
    }

    public void getChars(int n, int n2, Segment segment) throws BadLocationException {
        int n3 = n + n2;
        if (n < 0 || n3 < 0) {
            throw new BadLocationException("Invalid location", -1);
        }
        if (n3 > this.length() || n > this.length()) {
            throw new BadLocationException("Invalid location", this.length() + 1);
        }
        int n4 = this.getGapStart();
        int n5 = this.getGapEnd();
        char[] cArray = (char[])this.getArray();
        if (n + n2 <= n4) {
            segment.array = cArray;
            segment.offset = n;
        } else if (n >= n4) {
            segment.array = cArray;
            segment.offset = n5 + n - n4;
        } else {
            segment.array = new char[n2];
            segment.offset = 0;
            int n6 = n4 - n;
            System.arraycopy(cArray, n, segment.array, 0, n6);
            System.arraycopy(cArray, n5, segment.array, n6, n2 - n6);
        }
        segment.count = n2;
    }

    public Position createPosition(int n) throws BadLocationException {
        if (this.unusedMarks > Math.max(5, this.marks.size() / 10)) {
            this.removeUnusedMarks();
        }
        int n2 = this.getGapStart();
        int n3 = this.getGapEnd();
        int n4 = n < n2 ? n : n + (n3 - n2);
        MarkData markData = new MarkData(n4);
        int n5 = this.findSortIndex(markData);
        this.marks.insertElementAt(markData, n5);
        return new StickyPosition(markData);
    }

    protected void shiftEnd(int n) {
        int n2 = this.getGapEnd();
        super.shiftEnd(n);
        int n3 = this.getGapEnd() - n2;
        int n4 = this.findMarkAdjustIndex(n2);
        int n5 = this.marks.size();
        int n6 = n4;
        while (n6 < n5) {
            MarkData markData = this.marks.elementAt(n6);
            markData.index += n3;
            ++n6;
        }
    }

    protected void shiftGap(int n) {
        int n2 = this.getGapStart();
        int n3 = n - n2;
        int n4 = this.getGapEnd();
        int n5 = n4 + n3;
        int n6 = n4 - n2;
        super.shiftGap(n);
        if (n3 > 0) {
            int n7 = this.findMarkAdjustIndex(n2);
            int n8 = this.marks.size();
            int n9 = n7;
            while (n9 < n8) {
                MarkData markData = this.marks.elementAt(n9);
                if (markData.index < n5) {
                    markData.index -= n6;
                    ++n9;
                    continue;
                }
                break;
            }
        } else if (n3 < 0) {
            int n10 = this.findMarkAdjustIndex(n);
            int n11 = this.marks.size();
            int n12 = n10;
            while (n12 < n11) {
                MarkData markData = this.marks.elementAt(n12);
                if (markData.index < n4) {
                    markData.index += n6;
                    ++n12;
                    continue;
                }
                break;
            }
        }
        this.resetMarksAtZero();
    }

    protected void resetMarksAtZero() {
        if (this.marks != null && this.getGapStart() == 0) {
            int n = this.getGapEnd();
            int n2 = 0;
            int n3 = this.marks.size();
            while (n2 < n3) {
                MarkData markData = this.marks.elementAt(n2);
                if (markData.index > n) break;
                markData.index = 0;
                ++n2;
            }
        }
    }

    protected void shiftGapStartDown(int n) {
        int n2 = this.findMarkAdjustIndex(n);
        int n3 = this.marks.size();
        int n4 = this.getGapStart();
        int n5 = this.getGapEnd();
        int n6 = n2;
        while (n6 < n3) {
            MarkData markData = this.marks.elementAt(n6);
            if (markData.index > n4) break;
            markData.index = n5;
            ++n6;
        }
        super.shiftGapStartDown(n);
        this.resetMarksAtZero();
    }

    protected void shiftGapEndUp(int n) {
        int n2 = this.findMarkAdjustIndex(this.getGapEnd());
        int n3 = this.marks.size();
        int n4 = n2;
        while (n4 < n3) {
            MarkData markData = this.marks.elementAt(n4);
            if (markData.index >= n) break;
            markData.index = n;
            ++n4;
        }
        super.shiftGapEndUp(n);
        this.resetMarksAtZero();
    }

    final int compare(MarkData markData, MarkData markData2) {
        if (markData.index < markData2.index) {
            return -1;
        }
        if (markData.index > markData2.index) {
            return 1;
        }
        return 0;
    }

    final int findMarkAdjustIndex(int n) {
        this.search.index = Math.max(n, 1);
        int n2 = this.findSortIndex(this.search);
        int n3 = n2 - 1;
        while (n3 >= 0) {
            MarkData markData = this.marks.elementAt(n3);
            if (markData.index != this.search.index) break;
            --n2;
            --n3;
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    final int findSortIndex(MarkData var1_1) {
        var2_2 = 0;
        var3_3 = this.marks.size() - 1;
        var4_4 = 0;
        if (var3_3 == -1) {
            return 0;
        }
        var5_5 = 0;
        var6_6 = this.marks.elementAt(var3_3);
        var5_5 = this.compare(var1_1, var6_6);
        if (var5_5 <= 0) ** GOTO lbl20
        return var3_3 + 1;
lbl-1000:
        // 1 sources

        {
            var4_4 = var2_2 + (var3_3 - var2_2) / 2;
            var7_7 = this.marks.elementAt(var4_4);
            var5_5 = this.compare(var1_1, var7_7);
            if (var5_5 == 0) {
                return var4_4;
            }
            if (var5_5 < 0) {
                var3_3 = var4_4 - 1;
                continue;
            }
            var2_2 = var4_4 + 1;
lbl20:
            // 3 sources

            ** while (var2_2 <= var3_3)
        }
lbl21:
        // 1 sources

        return var5_5 < 0 ? var4_4 : var4_4 + 1;
    }

    final void removeUnusedMarks() {
        int n = this.marks.size();
        MarkVector markVector = new MarkVector(n);
        int n2 = 0;
        while (n2 < n) {
            MarkData markData = this.marks.elementAt(n2);
            if (!markData.unused) {
                markVector.addElement(markData);
            }
            ++n2;
        }
        this.marks = markVector;
        this.unusedMarks = 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.marks = new MarkVector();
        this.search = new MarkData(0);
    }

    protected Vector getPositionsInRange(Vector vector, int n, int n2) {
        int n3;
        int n4;
        int n5 = n + n2;
        int n6 = this.getGapStart();
        int n7 = this.getGapEnd();
        if (n < n6) {
            n4 = n == 0 ? 0 : this.findMarkAdjustIndex(n);
            n3 = n5 >= n6 ? this.findMarkAdjustIndex(n5 + (n7 - n6) + 1) : this.findMarkAdjustIndex(n5 + 1);
        } else {
            n4 = this.findMarkAdjustIndex(n + (n7 - n6));
            n3 = this.findMarkAdjustIndex(n5 + (n7 - n6) + 1);
        }
        Vector vector2 = vector == null ? new Vector(Math.max(1, n3 - n4)) : vector;
        int n8 = n4;
        while (n8 < n3) {
            vector2.addElement(new UndoPosRef(this.marks.elementAt(n8)));
            ++n8;
        }
        return vector2;
    }

    protected void updateUndoPositions(Vector vector, int n, int n2) {
        Object[] objectArray;
        int n3 = n + n2;
        int n4 = this.getGapEnd();
        int n5 = this.findMarkAdjustIndex(n4 + 1);
        int n6 = n != 0 ? this.findMarkAdjustIndex(n4) : 0;
        int n7 = vector.size() - 1;
        while (n7 >= 0) {
            objectArray = (Object[])vector.elementAt(n7);
            objectArray.resetLocation(n3, n4);
            --n7;
        }
        if (n6 < n5) {
            objectArray = new Object[n5 - n6];
            int n8 = 0;
            if (n == 0) {
                MarkData markData;
                int n9 = n6;
                while (n9 < n5) {
                    markData = this.marks.elementAt(n9);
                    if (markData.index == 0) {
                        objectArray[n8++] = markData;
                    }
                    ++n9;
                }
                n9 = n6;
                while (n9 < n5) {
                    markData = this.marks.elementAt(n9);
                    if (markData.index != 0) {
                        objectArray[n8++] = markData;
                    }
                    ++n9;
                }
            } else {
                MarkData markData;
                int n10 = n6;
                while (n10 < n5) {
                    markData = this.marks.elementAt(n10);
                    if (markData.index != n4) {
                        objectArray[n8++] = markData;
                    }
                    ++n10;
                }
                n10 = n6;
                while (n10 < n5) {
                    markData = this.marks.elementAt(n10);
                    if (markData.index == n4) {
                        objectArray[n8++] = markData;
                    }
                    ++n10;
                }
            }
            this.marks.replaceRange(n6, n5, objectArray);
        }
    }

    class RemoveUndo
    extends AbstractUndoableEdit {
        protected int offset;
        protected int length;
        protected String string;
        protected Vector posRefs;

        protected RemoveUndo(int n, String string) {
            this.offset = n;
            this.string = string;
            this.length = string.length();
            this.posRefs = GapContent.this.getPositionsInRange(null, n, this.length);
        }

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                GapContent.this.insertString(this.offset, this.string);
                if (this.posRefs != null) {
                    GapContent.this.updateUndoPositions(this.posRefs, this.offset, this.length);
                    this.posRefs = null;
                }
                this.string = null;
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            try {
                this.string = GapContent.this.getString(this.offset, this.length);
                this.posRefs = GapContent.this.getPositionsInRange(null, this.offset, this.length);
                GapContent.this.remove(this.offset, this.length);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    class InsertUndo
    extends AbstractUndoableEdit {
        protected int offset;
        protected int length;
        protected String string;
        protected Vector posRefs;

        protected InsertUndo(int n, int n2) {
            this.offset = n;
            this.length = n2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                this.posRefs = GapContent.this.getPositionsInRange(null, this.offset, this.length);
                this.string = GapContent.this.getString(this.offset, this.length);
                GapContent.this.remove(this.offset, this.length);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            try {
                GapContent.this.insertString(this.offset, this.string);
                this.string = null;
                if (this.posRefs != null) {
                    GapContent.this.updateUndoPositions(this.posRefs, this.offset, this.length);
                    this.posRefs = null;
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    final class UndoPosRef {
        protected int undoLocation;
        protected MarkData rec;

        UndoPosRef(MarkData markData) {
            this.rec = markData;
            this.undoLocation = markData.getOffset();
        }

        protected void resetLocation(int n, int n2) {
            this.rec.index = this.undoLocation != n ? this.undoLocation : n2;
        }
    }

    static class MarkVector
    extends GapVector {
        static MarkData[] oneMark = new MarkData[1];

        MarkVector() {
        }

        MarkVector(int n) {
            super(n);
        }

        protected Object allocateArray(int n) {
            return new MarkData[n];
        }

        protected int getArrayLength() {
            MarkData[] markDataArray = (MarkData[])this.getArray();
            return markDataArray.length;
        }

        public int size() {
            int n = this.getArrayLength() - (this.getGapEnd() - this.getGapStart());
            return n;
        }

        public void insertElementAt(MarkData markData, int n) {
            MarkVector.oneMark[0] = markData;
            this.replace(n, 0, oneMark, 1);
        }

        public void addElement(MarkData markData) {
            this.insertElementAt(markData, this.size());
        }

        public MarkData elementAt(int n) {
            int n2 = this.getGapStart();
            int n3 = this.getGapEnd();
            MarkData[] markDataArray = (MarkData[])this.getArray();
            if (n < n2) {
                return markDataArray[n];
            }
            return markDataArray[n += n3 - n2];
        }

        /*
         * Unable to fully structure code
         */
        protected void replaceRange(int var1_1, int var2_2, Object[] var3_3) {
            block4: {
                block3: {
                    var4_4 = this.getGapStart();
                    var5_5 = this.getGapEnd();
                    var6_6 = var1_1;
                    var7_7 = 0;
                    var8_8 = (Object[])this.getArray();
                    if (var1_1 < var4_4) break block3;
                    var6_6 += var5_5 - var4_4;
                    var2_2 += var5_5 - var4_4;
                    break block4;
                }
                if (var2_2 < var4_4) ** GOTO lbl19
                var2_2 += var5_5 - var4_4;
                while (var6_6 < var4_4) {
                    var8_8[var6_6++] = var3_3[var7_7++];
                }
                var6_6 = var5_5;
                break block4;
lbl-1000:
                // 1 sources

                {
                    var8_8[var6_6++] = var3_3[var7_7++];
lbl19:
                    // 2 sources

                    ** while (var6_6 < var2_2)
                }
            }
            while (var6_6 < var2_2) {
                var8_8[var6_6++] = var3_3[var7_7++];
            }
        }
    }

    final class StickyPosition
    implements Position {
        MarkData mark;

        StickyPosition(MarkData markData) {
            this.mark = markData;
        }

        public final int getOffset() {
            return this.mark.getOffset();
        }

        protected void finalize() throws Throwable {
            this.mark.dispose();
        }

        public String toString() {
            return Integer.toString(this.getOffset());
        }
    }

    final class MarkData {
        int index;
        boolean unused;

        MarkData(int n) {
            this.index = n;
        }

        public final int getOffset() {
            int n = GapContent.this.getGapStart();
            int n2 = GapContent.this.getGapEnd();
            int n3 = this.index < n ? this.index : this.index - (n2 - n);
            return Math.max(n3, 0);
        }

        public final void dispose() {
            this.unused = true;
            GapContent.this.unusedMarks += 1;
        }
    }
}

